/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule;

import com.n2bb.AlertsModule.AlertData;
import com.n2bb.AlertsModule.AlertHistory;
import com.n2bb.AlertsModule.AlertHistoryFilter;
import com.n2bb.AlertsModule.AlertName;
import com.n2bb.AlertsModule.AlertPOA;
import com.n2bb.AlertsModule.BadValue;
import com.n2bb.AlertsModule.DuplicateAlert;
import com.n2bb.AlertsModule.DuplicateAlertName;
import com.n2bb.AlertsModule.InUse;
import com.n2bb.AlertsModule.NotFound;
import com.n2bb.AlertsModule.SNMPTrap;
import com.n2bb.AlertsModule.UnspecifiedException;
import com.n2bb.AlertsModule.containers.AlertContainer;
import com.n2bb.AlertsModule.containers.LogAlertContainer;
import com.n2bb.AlertsModule.db.AlertHistPersist;
import com.n2bb.AlertsModule.db.AlertsPersist;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Alerts_impl
extends AlertPOA {
    private static final String N2BB_RESERVED = "N2_RSVD";
    private Logger n2bbLog = Logger.getLogger(Alerts_impl.class);
    private static Alerts_impl instance = null;
    private Vector alertNames = null;
    private Vector alerts = null;
    private Vector eventAlerts = null;

    private Alerts_impl() throws Exception {
        this.n2bbLog.debug((Object)"enter");
        this.alertNames = AlertsPersist.getInstance().getAlertNames();
        this.n2bbLog.info((Object)"loading central logger alerts");
        this.alerts = AlertsPersist.getInstance().getAlerts("LOG");
        this.n2bbLog.info((Object)"loading event alerts");
        this.eventAlerts = AlertsPersist.getInstance().getAlerts("EVENT");
    }

    public static Alerts_impl getInstance() throws Exception {
        if (instance == null) {
            instance = new Alerts_impl();
        }
        return instance;
    }

    public Vector getLogAlerts() {
        return this.alerts;
    }

    public Vector getEventAlerts() {
        return this.eventAlerts;
    }

    private void validatePattern(String type) throws BadValue {
        this.n2bbLog.debug((Object)("enter - pattern to compile... " + type));
        try {
            Pattern.compile(type);
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new BadValue("bad regex pattern", "bad regex pattern");
        }
    }

    public AlertData[] listAlerts() throws NotFound {
        this.n2bbLog.debug((Object)"enter");
        if (this.alerts.size() == 0) {
            throw new NotFound("No alerts in system.", "No alerts in system.", "");
        }
        Vector<AlertData> alertsNoReserve = new Vector<AlertData>();
        for (int i = 0; i < this.alerts.size(); ++i) {
            AlertData ad = ((AlertContainer)this.alerts.get(i)).getAlertData();
            if (ad.identifier.startsWith(N2BB_RESERVED)) continue;
            alertsNoReserve.add(ad);
        }
        AlertData[] adl = new AlertData[alertsNoReserve.size()];
        adl = alertsNoReserve.toArray(adl);
        return adl;
    }

    public AlertData getAlertDetail(String identifier) throws NotFound {
        this.n2bbLog.debug((Object)"enter");
        if (identifier.startsWith(N2BB_RESERVED)) {
            throw new NotFound("Alert Not Found", "Alert Not Found", identifier);
        }
        for (int i = 0; i < this.alerts.size(); ++i) {
            AlertData ad = ((AlertContainer)this.alerts.get(i)).getAlertData();
            if (!ad.identifier.equals(identifier)) continue;
            return ad;
        }
        throw new NotFound("Alert Not Found", "Alert Not Found", identifier);
    }

    public synchronized void defineAlertConfiguration(AlertData newAlert) throws BadValue, DuplicateAlert, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        if (newAlert.identifier.startsWith(N2BB_RESERVED)) {
            throw new BadValue("Illegal value in alert definition", "Illegal value in alert definition");
        }
        AlertData alert = null;
        try {
            alert = this.getAlertDetail(newAlert.identifier);
            this.n2bbLog.error((Object)"duplicate alert identifier");
            throw new DuplicateAlert("duplicate alert identifier", "pick a new identifier", newAlert);
        }
        catch (NotFound nf) {
            AlertName an = null;
            try {
                an = this.getAlertName(newAlert.name.name);
            }
            catch (NotFound e) {
                throw new BadValue("Alert name not found", "Alert name not found");
            }
            newAlert.name.type = an.type;
            if (newAlert.threshold.count <= 0 || newAlert.frequency.count <= 0 || newAlert.threshold.seconds <= 0) {
                this.n2bbLog.error((Object)("bad value - threshold.count... " + newAlert.threshold.count + " frequency.count... " + newAlert.frequency.count + " threshold.seconds... " + newAlert.threshold.seconds));
                throw new BadValue("Illegal value in alert definition", "Illegal value in alert definition");
            }
            try {
                AlertsPersist.getInstance().writeAlert(newAlert);
            }
            catch (Exception e) {
                this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                throw new UnspecifiedException(e.getMessage(), e.getMessage());
            }
            this.alerts.add(new LogAlertContainer(newAlert));
            return;
        }
    }

    public synchronized void updateAlertConfiguration(AlertData updatedAlert) throws BadValue, NotFound, UnspecifiedException {
        this.deleteAlertConfiguration(updatedAlert.identifier);
        try {
            this.defineAlertConfiguration(updatedAlert);
        }
        catch (DuplicateAlert e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
    }

    public synchronized void deleteAlertConfiguration(String identifier) throws NotFound, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        AlertData alert = null;
        alert = this.getAlertDetail(identifier);
        try {
            AlertsPersist.getInstance().deleteAlert(identifier);
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
        for (int i = 0; i < this.alerts.size(); ++i) {
            alert = ((AlertContainer)this.alerts.get(i)).getAlertData();
            if (!alert.identifier.equals(identifier)) continue;
            this.alerts.remove(i);
            break;
        }
    }

    public SNMPTrap[] getSNMPTraps() throws NotFound {
        this.n2bbLog.debug((Object)"enter");
        return null;
    }

    public AlertName[] getAlertNames() throws NotFound {
        this.n2bbLog.debug((Object)"enter");
        if (this.alertNames.size() == 0) {
            throw new NotFound("No alert names in system.", "No alert names in system.", "");
        }
        Vector<AlertName> alertNamesNoReserve = new Vector<AlertName>();
        for (int i = 0; i < this.alertNames.size(); ++i) {
            AlertName an = (AlertName)this.alertNames.get(i);
            if (an.name.startsWith(N2BB_RESERVED)) continue;
            alertNamesNoReserve.add(an);
        }
        AlertName[] anl = new AlertName[alertNamesNoReserve.size()];
        anl = alertNamesNoReserve.toArray(anl);
        return anl;
    }

    public AlertName getAlertName(String name) throws NotFound {
        this.n2bbLog.debug((Object)"enter");
        for (int i = 0; i < this.alertNames.size(); ++i) {
            AlertName an = (AlertName)this.alertNames.get(i);
            if (!an.name.equals(name)) continue;
            return an;
        }
        throw new NotFound("Alert Name Not Found", "Alert Name Not Found", name);
    }

    public synchronized void defineAlertName(AlertName newAlertName) throws BadValue, DuplicateAlertName, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        AlertName an = null;
        try {
            an = this.getAlertName(newAlertName.name);
            this.n2bbLog.error((Object)"duplicate alert name");
            throw new DuplicateAlertName("duplicate alert name", "pick a new name", an);
        }
        catch (NotFound nf) {
            this.validatePattern(newAlertName.type);
            try {
                AlertsPersist.getInstance().writeAlertName(newAlertName);
            }
            catch (Exception e) {
                this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                throw new UnspecifiedException(e.getMessage(), e.getMessage());
            }
            this.alertNames.add(newAlertName);
            return;
        }
    }

    public synchronized void updateAlertName(AlertName updatedAlertName) throws NotFound, BadValue, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        AlertName an = this.getAlertName(updatedAlertName.name);
        this.validatePattern(updatedAlertName.type);
        try {
            AlertsPersist.getInstance().updateAlertName(updatedAlertName);
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
        AlertContainer ac = null;
        AlertData ad = null;
        for (int i = 0; i < this.alerts.size(); ++i) {
            ac = (AlertContainer)this.alerts.get(i);
            if (!ac.getAlertData().name.name.equals(updatedAlertName.name)) continue;
            ad = ac.getAlertData();
            ad.name.type = updatedAlertName.type;
            ac.setAlertData(ad);
        }
        an.type = updatedAlertName.type;
    }

    public synchronized void deleteAlertName(String name) throws NotFound, InUse, UnspecifiedException {
        int i;
        this.n2bbLog.debug((Object)"enter");
        AlertName an = this.getAlertName(name);
        AlertData ad = null;
        for (i = 0; i < this.alerts.size(); ++i) {
            ad = ((AlertContainer)this.alerts.get(i)).getAlertData();
            if (!ad.name.name.equals(name)) continue;
            throw new InUse("Alert name is assigned to an alert", "Alert name is assigned to an alert");
        }
        try {
            AlertsPersist.getInstance().deleteAlertName(name);
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
        for (i = 0; i < this.alertNames.size(); ++i) {
            an = (AlertName)this.alertNames.get(i);
            if (!an.name.equals(name)) continue;
            this.alertNames.remove(i);
            break;
        }
    }

    public String[] getAlertHistoryNames() throws NotFound, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        String[] names = null;
        try {
            names = AlertHistPersist.getInstance().getAlertNames();
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
        if (names == null || names.length == 0) {
            throw new NotFound("No alert history names in system.", "No alert history names in system.", "");
        }
        return names;
    }

    public String[] getAlertHistoryIdentifiers() throws NotFound, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        String[] ids = null;
        try {
            ids = AlertHistPersist.getInstance().getIdentifiers();
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
        if (ids == null || ids.length == 0) {
            throw new NotFound("No alert history ids in system.", "No alert history ids in system.", "");
        }
        return ids;
    }

    public AlertHistory[] getAlertHistory() throws NotFound, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        AlertHistory[] alerthistory = null;
        try {
            alerthistory = AlertHistPersist.getInstance().getAlertHistory();
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
        if (alerthistory == null || alerthistory.length == 0) {
            throw new NotFound("No alert history in system.", "No alert history in system.", "");
        }
        return alerthistory;
    }

    public AlertHistory[] getAlertHistoryWithFilter(AlertHistoryFilter ahf) throws NotFound, UnspecifiedException {
        this.n2bbLog.debug((Object)"enter");
        Date start = null;
        if (ahf.start >= 0L) {
            start = new Date(ahf.start);
        }
        Date end = null;
        if (ahf.end >= 0L) {
            end = new Date(ahf.end);
        }
        String identifier = null;
        if (!ahf.identifier.equals("")) {
            identifier = ahf.identifier;
        }
        String name = null;
        if (!ahf.name.equals("")) {
            name = ahf.name;
        }
        String action = null;
        if (!ahf.action.equals("")) {
            action = ahf.action;
        }
        AlertHistory[] alerthistory = null;
        try {
            alerthistory = AlertHistPersist.getInstance().getAlertHistory(start, end, identifier, name, action);
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new UnspecifiedException(e.getMessage(), e.getMessage());
        }
        if (alerthistory == null || alerthistory.length == 0) {
            throw new NotFound("No alert history in system.", "No alert history in system.", "");
        }
        this.n2bbLog.debug((Object)("alert history size... " + alerthistory.length));
        return alerthistory;
    }
}

