/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.util;

import com.n2bb.AlertsModule.util.MessageQueue;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.log4j.Logger;

public class UDPListener
extends Thread {
    private static Logger logger = Logger.getLogger(UDPListener.class);
    private DatagramSocket dataSocket;
    private int packetLength = 2048;
    private MessageQueue mq;

    public UDPListener(int aPort, MessageQueue msgQ, int rcvBufferSize) throws Exception {
        logger.info((Object)("requesting socket receive buffer size... " + rcvBufferSize));
        this.mq = msgQ;
        this.dataSocket = new DatagramSocket(aPort);
        this.dataSocket.setReceiveBufferSize(rcvBufferSize);
        logger.info((Object)("obtained socket receive buffer size..." + this.dataSocket.getReceiveBufferSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.info((Object)"thread running");
        try {
            try {
                DatagramPacket dataPacket = new DatagramPacket(new byte[this.packetLength], this.packetLength);
                while (true) {
                    this.dataSocket.receive(dataPacket);
                    int l = dataPacket.getLength();
                    byte[] b = new byte[l];
                    System.arraycopy(dataPacket.getData(), 0, b, 0, l);
                    Object[] obj = new Object[]{new Long(System.currentTimeMillis()), new String(b)};
                    this.mq.addMessage(obj);
                    dataPacket.setLength(this.packetLength);
                }
            }
            catch (Exception e) {
                logger.fatal((Object)("thread dying - " + e.getMessage()), (Throwable)e);
                this.dataSocket.close();
            }
        }
        catch (Throwable throwable) {
            this.dataSocket.close();
            throw throwable;
        }
    }
}

