/*
 * Decompiled with CFR 0.152.
 */
package database.org.openorb.notify.persistence;

import database.org.openorb.notify.persistence.ProxySupplierBase;
import database.org.openorb.notify.persistence.ProxySupplierBaseRef;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.ProxySupplier;
import org.openorb.notify.persistence.ProxySupplierHome;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.database.DatabaseCatalogBase;
import org.openorb.pss.connector.database.DatabaseUtil;
import org.openorb.pss.connector.database.NotFoundException;
import org.openorb.pss.connector.database.PersistentObject;
import org.openorb.pss.connector.database.PersistentObjectHome;

public class ProxySupplierHomeBase
extends LocalObject
implements ProxySupplierHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;
    private static final String[] _home_members = new String[]{"filters", "mapping_filters", "next_filter_id", "event_types", "id", "admin_id", "type", "connected_consumer", "is_connected", "qos_properties"};

    public java.lang.Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
        }
        StorageObject obj = null;
        try {
            obj = ((DatabaseCatalogBase)this._catalog).incarnate((StorageHomeBase)this, short_pid, "PSDL:openorb.org/notify/persistence/ProxySupplierBase:1.0");
        }
        catch (NotFoundException ex) {
            throw new NotFound();
        }
        this.register_type_incarnation(obj);
        return obj;
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public ProxySupplierBase _create(ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types, int id, int admin_id, ProxyType type, Object connected_consumer, boolean is_connected, Property[] qos_properties) {
        ProxySupplierBase obj = (ProxySupplierBase)((DatabaseCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/ProxySupplierBase:1.0");
        this.register_type_incarnation(obj);
        obj.filters(filters);
        obj.mapping_filters(mapping_filters);
        obj.next_filter_id(next_filter_id);
        obj.event_types(event_types);
        obj.id(id);
        obj.admin_id(admin_id);
        obj.type(type);
        obj.connected_consumer(connected_consumer);
        obj.is_connected(is_connected);
        obj.qos_properties(qos_properties);
        return obj;
    }

    public ProxySupplierBase _create() {
        ProxySupplierBase obj = (ProxySupplierBase)((DatabaseCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/ProxySupplierBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public ProxySupplierBaseRef _create(ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types, int id, int admin_id, ProxyType type, Object connected_consumer, boolean is_connected, Property[] qos_properties, YieldRef yr) {
        ProxySupplierBase obj = this._create(filters, mapping_filters, next_filter_id, event_types, id, admin_id, type, connected_consumer, is_connected, qos_properties);
        return new ProxySupplierBaseRef(obj.get_pid(), this._catalog);
    }

    public ProxySupplierBaseRef _create(YieldRef yr) {
        ProxySupplierBase obj = this._create();
        return new ProxySupplierBaseRef(obj.get_pid(), this._catalog);
    }

    public ProxySupplier create(int id, int admin_id, ProxyType type, Object connected_consumer, boolean is_connected, Property[] qos_properties, ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types) {
        ProxySupplierBase obj = (ProxySupplierBase)((DatabaseCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/ProxySupplierBase:1.0");
        this.register_type_incarnation(obj);
        obj.id(id);
        obj.admin_id(admin_id);
        obj.type(type);
        obj.connected_consumer(connected_consumer);
        obj.is_connected(is_connected);
        obj.qos_properties(qos_properties);
        obj.filters(filters);
        obj.mapping_filters(mapping_filters);
        obj.next_filter_id(next_filter_id);
        obj.event_types(event_types);
        return obj;
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObject create_object() {
        return ((DatabaseCatalogBase)this._catalog).create_empty_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/ProxySupplierBase:1.0");
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new ProxySupplierBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public String[] getHomeMembers() {
        return _home_members;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((DatabaseCatalogBase)this._catalog).remove(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((DatabaseCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public void refresh(PersistentObject storage_type) {
        try {
            InputStream[] input = ((DatabaseCatalogBase)this._catalog).read(this._pid, storage_type.getPID(), _home_members.length);
            storage_type.read(input);
        }
        catch (NotFoundException ex) {
            throw new PERSIST_STORE(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public void refreshAll() {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                this.refresh((PersistentObject)it.next());
            }
        }
    }

    public void flush(PersistentObject storage_type) {
        if (this._catalog.access_mode() != 1) {
            throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
        }
        OutputStream[] output = DatabaseUtil.outputArray((int)_home_members.length);
        storage_type.write(output);
        ((DatabaseCatalogBase)this._catalog).write(this._pid, storage_type.getPID(), output);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(java.lang.Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

