/*
 * Decompiled with CFR 0.152.
 */
package database.org.openorb.notify.persistence;

import database.org.openorb.notify.persistence.SupplierAdminBase;
import database.org.openorb.notify.persistence.SupplierAdminBaseRef;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.notify.persistence.SupplierAdmin;
import org.openorb.notify.persistence.SupplierAdminHome;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.database.DatabaseCatalogBase;
import org.openorb.pss.connector.database.DatabaseUtil;
import org.openorb.pss.connector.database.NotFoundException;
import org.openorb.pss.connector.database.PersistentObject;
import org.openorb.pss.connector.database.PersistentObjectHome;

public class SupplierAdminHomeBase
extends LocalObject
implements SupplierAdminHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;
    private static final String[] _home_members = new String[]{"filters", "mapping_filters", "next_filter_id", "event_types", "id", "channel_id", "filter_operator", "qos_properties", "pull_consumers", "push_consumers", "next_pull_consumer_id", "next_push_consumer_id"};

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
        }
        StorageObject obj = null;
        try {
            obj = ((DatabaseCatalogBase)this._catalog).incarnate((StorageHomeBase)this, short_pid, "PSDL:openorb.org/notify/persistence/SupplierAdminBase:1.0");
        }
        catch (NotFoundException ex) {
            throw new NotFound();
        }
        this.register_type_incarnation(obj);
        return obj;
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public SupplierAdminBase _create(ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types, int id, int channel_id, InterFilterGroupOperator filter_operator, Property[] qos_properties, ConnectionInfo[] pull_consumers, ConnectionInfo[] push_consumers, int next_pull_consumer_id, int next_push_consumer_id) {
        SupplierAdminBase obj = (SupplierAdminBase)((DatabaseCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/SupplierAdminBase:1.0");
        this.register_type_incarnation(obj);
        obj.filters(filters);
        obj.mapping_filters(mapping_filters);
        obj.next_filter_id(next_filter_id);
        obj.event_types(event_types);
        obj.id(id);
        obj.channel_id(channel_id);
        obj.filter_operator(filter_operator);
        obj.qos_properties(qos_properties);
        obj.pull_consumers(pull_consumers);
        obj.push_consumers(push_consumers);
        obj.next_pull_consumer_id(next_pull_consumer_id);
        obj.next_push_consumer_id(next_push_consumer_id);
        return obj;
    }

    public SupplierAdminBase _create() {
        SupplierAdminBase obj = (SupplierAdminBase)((DatabaseCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/SupplierAdminBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public SupplierAdminBaseRef _create(ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types, int id, int channel_id, InterFilterGroupOperator filter_operator, Property[] qos_properties, ConnectionInfo[] pull_consumers, ConnectionInfo[] push_consumers, int next_pull_consumer_id, int next_push_consumer_id, YieldRef yr) {
        SupplierAdminBase obj = this._create(filters, mapping_filters, next_filter_id, event_types, id, channel_id, filter_operator, qos_properties, pull_consumers, push_consumers, next_pull_consumer_id, next_push_consumer_id);
        return new SupplierAdminBaseRef(obj.get_pid(), this._catalog);
    }

    public SupplierAdminBaseRef _create(YieldRef yr) {
        SupplierAdminBase obj = this._create();
        return new SupplierAdminBaseRef(obj.get_pid(), this._catalog);
    }

    public SupplierAdmin create(int id, int channel_id, InterFilterGroupOperator filter_operator, Property[] qos_properties, ConnectionInfo[] pull_consumers, ConnectionInfo[] push_consumers, int next_pull_consumer_id, int next_push_consumer_id, ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types) {
        SupplierAdminBase obj = (SupplierAdminBase)((DatabaseCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/SupplierAdminBase:1.0");
        this.register_type_incarnation(obj);
        obj.id(id);
        obj.channel_id(channel_id);
        obj.filter_operator(filter_operator);
        obj.qos_properties(qos_properties);
        obj.pull_consumers(pull_consumers);
        obj.push_consumers(push_consumers);
        obj.next_pull_consumer_id(next_pull_consumer_id);
        obj.next_push_consumer_id(next_push_consumer_id);
        obj.filters(filters);
        obj.mapping_filters(mapping_filters);
        obj.next_filter_id(next_filter_id);
        obj.event_types(event_types);
        return obj;
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObject create_object() {
        return ((DatabaseCatalogBase)this._catalog).create_empty_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/SupplierAdminBase:1.0");
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new SupplierAdminBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public String[] getHomeMembers() {
        return _home_members;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((DatabaseCatalogBase)this._catalog).remove(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((DatabaseCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public void refresh(PersistentObject storage_type) {
        try {
            InputStream[] input = ((DatabaseCatalogBase)this._catalog).read(this._pid, storage_type.getPID(), _home_members.length);
            storage_type.read(input);
        }
        catch (NotFoundException ex) {
            throw new PERSIST_STORE(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public void refreshAll() {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                this.refresh((PersistentObject)it.next());
            }
        }
    }

    public void flush(PersistentObject storage_type) {
        if (this._catalog.access_mode() != 1) {
            throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
        }
        OutputStream[] output = DatabaseUtil.outputArray((int)_home_members.length);
        storage_type.write(output);
        ((DatabaseCatalogBase)this._catalog).write(this._pid, storage_type.getPID(), output);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

