/*
 * Decompiled with CFR 0.152.
 */
package file.org.openorb.notify.persistence;

import file.org.openorb.notify.persistence.EventQueueBase;
import file.org.openorb.notify.persistence.EventQueueBaseRef;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.notify.persistence.EventQueue;
import org.openorb.notify.persistence.EventQueueHome;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileCatalogBase;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;

public class EventQueueHomeBase
extends LocalObject
implements EventQueueHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
        }
        StorageObject obj = null;
        try {
            obj = ((FileCatalogBase)this._catalog).incarnate((StorageHomeBase)this, short_pid, "PSDL:openorb.org/notify/persistence/EventQueueBase:1.0");
        }
        catch (NotFoundException ex) {
            throw new NotFound();
        }
        this.register_type_incarnation(obj);
        return obj;
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public EventQueueBase _create(byte[][] event_pids) {
        EventQueueBase obj = (EventQueueBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventQueueBase:1.0");
        this.register_type_incarnation(obj);
        obj.event_pids(event_pids);
        return obj;
    }

    public EventQueueBase _create() {
        EventQueueBase obj = (EventQueueBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventQueueBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public EventQueueBaseRef _create(byte[][] event_pids, YieldRef yr) {
        EventQueueBase obj = this._create(event_pids);
        return new EventQueueBaseRef(obj.get_pid(), this._catalog);
    }

    public EventQueueBaseRef _create(YieldRef yr) {
        EventQueueBase obj = this._create();
        return new EventQueueBaseRef(obj.get_pid(), this._catalog);
    }

    public EventQueue create(byte[][] event_pids) {
        EventQueueBase obj = (EventQueueBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventQueueBase:1.0");
        this.register_type_incarnation(obj);
        obj.event_pids(event_pids);
        return obj;
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new EventQueueBaseRef(pid, this._catalog);
    }

    public StorageObject create_object() {
        return ((FileCatalogBase)this._catalog).create_empty_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventQueueBase:1.0");
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((FileCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((FileCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public void refresh(PersistentObject storage_type) {
        try {
            InputStream input = ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID());
            storage_type.read(input);
        }
        catch (NotFoundException ex) {
            throw new PersistenceException(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public void refreshAll() {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                this.refresh((PersistentObject)it.next());
            }
        }
    }

    public void flush(PersistentObject storage_type) {
        if (this._catalog.access_mode() != 1) {
            throw new PersistenceException("Bad access mode.", 6, CompletionStatus.COMPLETED_NO);
        }
        OutputStream output = ((FileCatalogBase)this._catalog).create_new_entry(this._pid, storage_type.getPID());
        storage_type.write(output);
        ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID(), output);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

