/*
 * Decompiled with CFR 0.152.
 */
package memory.org.openorb.notify.persistence;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import memory.org.openorb.notify.persistence.FilterBase;
import memory.org.openorb.notify.persistence.FilterBaseRef;
import org.omg.CORBA.LocalObject;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.Filter;
import org.openorb.notify.persistence.FilterHome;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.NotFoundException;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;

public class FilterHomeBase
extends LocalObject
implements FilterHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
            throw new NotFound();
        }
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public FilterBase _create(String constraint_grammar, ConstraintInfo[] constraints, int next_constraint_id, ReferenceInfo[] callbacks, int next_callback_id, EventTypeInfo[] event_types) {
        FilterBase obj = (FilterBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/FilterBase:1.0");
        this.register_type_incarnation(obj);
        obj.constraint_grammar(constraint_grammar);
        obj.constraints(constraints);
        obj.next_constraint_id(next_constraint_id);
        obj.callbacks(callbacks);
        obj.next_callback_id(next_callback_id);
        obj.event_types(event_types);
        return obj;
    }

    public FilterBase _create() {
        FilterBase obj = (FilterBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/FilterBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public FilterBaseRef _create(String constraint_grammar, ConstraintInfo[] constraints, int next_constraint_id, ReferenceInfo[] callbacks, int next_callback_id, EventTypeInfo[] event_types, YieldRef yr) {
        FilterBase obj = this._create(constraint_grammar, constraints, next_constraint_id, callbacks, next_callback_id, event_types);
        return new FilterBaseRef(obj.get_pid(), this._catalog);
    }

    public FilterBaseRef _create(YieldRef yr) {
        FilterBase obj = this._create();
        return new FilterBaseRef(obj.get_pid(), this._catalog);
    }

    public Filter create(String constraint_grammar, ConstraintInfo[] constraints, int next_constraint_id, ReferenceInfo[] callbacks, int next_callback_id, EventTypeInfo[] event_types) {
        FilterBase obj = (FilterBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/FilterBase:1.0");
        this.register_type_incarnation(obj);
        obj.constraint_grammar(constraint_grammar);
        obj.constraints(constraints);
        obj.next_constraint_id(next_constraint_id);
        obj.callbacks(callbacks);
        obj.next_callback_id(next_callback_id);
        obj.event_types(event_types);
        return obj;
    }

    public Object[] get_incarnations() {
        return this._incarnations.toArray();
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new FilterBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((MemoryCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((MemoryCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

