/*
 * Decompiled with CFR 0.152.
 */
package memory.org.openorb.notify.persistence;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import memory.org.openorb.notify.persistence.ProxyConsumerBase;
import memory.org.openorb.notify.persistence.ProxyConsumerBaseRef;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.ProxyConsumer;
import org.openorb.notify.persistence.ProxyConsumerHome;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.NotFoundException;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;

public class ProxyConsumerHomeBase
extends LocalObject
implements ProxyConsumerHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public java.lang.Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
            throw new NotFound();
        }
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public ProxyConsumerBase _create(ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types, int id, int admin_id, ProxyType type, Object connected_supplier, boolean is_connected, Property[] qos_properties) {
        ProxyConsumerBase obj = (ProxyConsumerBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/ProxyConsumerBase:1.0");
        this.register_type_incarnation(obj);
        obj.filters(filters);
        obj.mapping_filters(mapping_filters);
        obj.next_filter_id(next_filter_id);
        obj.event_types(event_types);
        obj.id(id);
        obj.admin_id(admin_id);
        obj.type(type);
        obj.connected_supplier(connected_supplier);
        obj.is_connected(is_connected);
        obj.qos_properties(qos_properties);
        return obj;
    }

    public ProxyConsumerBase _create() {
        ProxyConsumerBase obj = (ProxyConsumerBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/ProxyConsumerBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public ProxyConsumerBaseRef _create(ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types, int id, int admin_id, ProxyType type, Object connected_supplier, boolean is_connected, Property[] qos_properties, YieldRef yr) {
        ProxyConsumerBase obj = this._create(filters, mapping_filters, next_filter_id, event_types, id, admin_id, type, connected_supplier, is_connected, qos_properties);
        return new ProxyConsumerBaseRef(obj.get_pid(), this._catalog);
    }

    public ProxyConsumerBaseRef _create(YieldRef yr) {
        ProxyConsumerBase obj = this._create();
        return new ProxyConsumerBaseRef(obj.get_pid(), this._catalog);
    }

    public ProxyConsumer create(int id, int admin_id, ProxyType type, Object connected_supplier, boolean is_connected, Property[] qos_properties, ReferenceInfo[] filters, ReferenceInfo[] mapping_filters, int next_filter_id, EventTypeInfo[] event_types) {
        ProxyConsumerBase obj = (ProxyConsumerBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/ProxyConsumerBase:1.0");
        this.register_type_incarnation(obj);
        obj.id(id);
        obj.admin_id(admin_id);
        obj.type(type);
        obj.connected_supplier(connected_supplier);
        obj.is_connected(is_connected);
        obj.qos_properties(qos_properties);
        obj.filters(filters);
        obj.mapping_filters(mapping_filters);
        obj.next_filter_id(next_filter_id);
        obj.event_types(event_types);
        return obj;
    }

    public java.lang.Object[] get_incarnations() {
        return this._incarnations.toArray();
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new ProxyConsumerBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((MemoryCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((MemoryCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(java.lang.Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

