/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import java.util.ArrayList;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public final class PropertiesValidator {
    private PropertiesValidator() {
    }

    public static void checkAdminProperties(Property[] admin, ORB orb) throws UnsupportedAdmin {
        ArrayList<PropertyError> err = new ArrayList<PropertyError>();
        int i = 0;
        while (i < admin.length) {
            Property p = admin[i];
            if (!PropertiesValidator.isAdminProperty(p.name)) {
                QoSError_code errorCode = PropertiesValidator.isQoSProperty(p.name) ? QoSError_code.BAD_TYPE : QoSError_code.BAD_PROPERTY;
                PropertyRange range = new PropertyRange(orb.create_any(), orb.create_any());
                err.add(new PropertyError(errorCode, p.name, range));
            }
            ++i;
        }
        if (err.size() == 0) {
            return;
        }
        PropertyError[] errArray = new PropertyError[err.size()];
        err.toArray(errArray);
        throw new UnsupportedAdmin(errArray);
    }

    public static Property[] validateAdminProperties(Property[] admin, ORB orb) {
        Property[] defaultAdmin = new Property[4];
        Any any = orb.create_any();
        any.insert_long(0);
        defaultAdmin[0] = new Property("MaxQueueLength", any);
        any = orb.create_any();
        any.insert_long(0);
        defaultAdmin[1] = new Property("MaxConsumers", any);
        any = orb.create_any();
        any.insert_long(0);
        defaultAdmin[2] = new Property("MaxSuppliers", any);
        any = orb.create_any();
        any.insert_boolean(false);
        defaultAdmin[3] = new Property("RejectNewEvents", any);
        int i = 0;
        while (i < admin.length) {
            if (admin[i].name.equals("MaxQueueLength")) {
                defaultAdmin[0].value = admin[i].value;
            }
            if (admin[i].name.equals("MaxConsumers")) {
                defaultAdmin[1].value = admin[i].value;
            }
            if (admin[i].name.equals("MaxSuppliers")) {
                defaultAdmin[2].value = admin[i].value;
            }
            if (admin[i].name.equals("RejectNewEvents")) {
                defaultAdmin[3].value = admin[i].value;
            }
            ++i;
        }
        return defaultAdmin;
    }

    public static void checkQoSProperties(Property[] qos, ORB orb) throws UnsupportedQoS {
        ArrayList<PropertyError> err = new ArrayList<PropertyError>();
        int i = 0;
        while (i < qos.length) {
            Property p = qos[i];
            if (!PropertiesValidator.isQoSProperty(p.name)) {
                QoSError_code errorCode = PropertiesValidator.isAdminProperty(p.name) ? QoSError_code.BAD_TYPE : QoSError_code.BAD_PROPERTY;
                PropertyRange range = new PropertyRange(orb.create_any(), orb.create_any());
                err.add(new PropertyError(errorCode, p.name, range));
            }
            ++i;
        }
        if (err.size() == 0) {
            return;
        }
        PropertyError[] errArray = new PropertyError[err.size()];
        err.toArray(errArray);
        throw new UnsupportedQoS(errArray);
    }

    public static Property[] validateQoSProperties(Property[] qos, ORB orb) {
        Property[] defaultQoS = new Property[13];
        Any any = orb.create_any();
        any.insert_short((short)0);
        defaultQoS[0] = new Property("EventReliability", any);
        any = orb.create_any();
        any.insert_short((short)0);
        defaultQoS[1] = new Property("ConnectionReliability", any);
        any = orb.create_any();
        any.insert_short((short)0);
        defaultQoS[2] = new Property("Priority", any);
        any = orb.create_any();
        UtcTHelper.insert(any, new UtcT(0L, 0, 0, 0));
        defaultQoS[3] = new Property("StartTime", any);
        any = orb.create_any();
        UtcTHelper.insert(any, new UtcT(0L, 0, 0, 0));
        defaultQoS[4] = new Property("StopTime", any);
        any = orb.create_any();
        TimeTHelper.insert(any, 0L);
        defaultQoS[5] = new Property("Timeout", any);
        any = orb.create_any();
        any.insert_boolean(true);
        defaultQoS[6] = new Property("StartTimeSupported", any);
        any = orb.create_any();
        any.insert_boolean(true);
        defaultQoS[7] = new Property("StopTimeSupported", any);
        any = orb.create_any();
        any.insert_long(0);
        defaultQoS[8] = new Property("MaxEventsPerConsumer", any);
        any = orb.create_any();
        any.insert_short((short)2);
        defaultQoS[9] = new Property("OrderPolicy", any);
        any = orb.create_any();
        any.insert_short((short)0);
        defaultQoS[10] = new Property("DiscardPolicy", any);
        any = orb.create_any();
        any.insert_long(1);
        defaultQoS[11] = new Property("MaximumBatchSize", any);
        any = orb.create_any();
        TimeTHelper.insert(any, 0L);
        defaultQoS[12] = new Property("PacingInterval", any);
        int i = 0;
        while (i < qos.length) {
            if (qos[i].name.equals("EventReliability")) {
                defaultQoS[0].value = qos[i].value;
            }
            if (qos[i].name.equals("ConnectionReliability")) {
                defaultQoS[1].value = qos[i].value;
            }
            if (qos[i].name.equals("Priority")) {
                defaultQoS[2].value = qos[i].value;
            }
            if (qos[i].name.equals("StartTime")) {
                defaultQoS[3].value = qos[i].value;
            }
            if (qos[i].name.equals("StopTime")) {
                defaultQoS[4].value = qos[i].value;
            }
            if (qos[i].name.equals("Timeout")) {
                defaultQoS[5].value = qos[i].value;
            }
            if (qos[i].name.equals("StartTimeSupported")) {
                defaultQoS[6].value = qos[i].value;
            }
            if (qos[i].name.equals("StopTimeSupported")) {
                defaultQoS[7].value = qos[i].value;
            }
            if (qos[i].name.equals("MaxEventsPerConsumer")) {
                defaultQoS[8].value = qos[i].value;
            }
            if (qos[i].name.equals("OrderPolicy")) {
                defaultQoS[9].value = qos[i].value;
            }
            if (qos[i].name.equals("DiscardPolicy")) {
                defaultQoS[10].value = qos[i].value;
            }
            if (qos[i].name.equals("MaximumBatchSize")) {
                defaultQoS[11].value = qos[i].value;
            }
            if (qos[i].name.equals("PacingInterval")) {
                defaultQoS[12].value = qos[i].value;
            }
            ++i;
        }
        return defaultQoS;
    }

    public static boolean isAdminProperty(String name) {
        return name.equals("MaxQueueLength") || name.equals("MaxConsumers") || name.equals("MaxSuppliers") || name.equals("RejectNewEvents");
    }

    public static boolean isQoSProperty(String name) {
        return name.equals("EventReliability") || name.equals("ConnectionReliability") || name.equals("Priority") || name.equals("StartTime") || name.equals("StopTime") || name.equals("Timeout") || name.equals("OrderPolicy") || name.equals("DiscardPolicy") || name.equals("MaximumBatchSize") || name.equals("PacingInterval") || name.equals("StartTimeSupported") || name.equals("StopTimeSupported") || name.equals("MaxEventsPerConsumer");
    }

    public static void displayAdminProperties(String target, Property[] admin) {
        int i = 0;
        while (i < admin.length) {
            if (admin[i].name.equals("MaxQueueLength")) {
                System.out.println(target + " MaxQueueLength        = " + admin[i].value.extract_long());
            }
            if (admin[i].name.equals("MaxConsumers")) {
                System.out.println(target + " MaxConsumers          = " + admin[i].value.extract_long());
            }
            if (admin[i].name.equals("MaxSuppliers")) {
                System.out.println(target + " MaxSuppliers          = " + admin[i].value.extract_long());
            }
            if (admin[i].name.equals("RejectNewEvents")) {
                System.out.println(target + " RejectNewEvents       = " + admin[i].value.extract_boolean());
            }
            ++i;
        }
    }

    public static void displayQoSProperties(String target, Property[] qos) {
        int i = 0;
        while (i < qos.length) {
            if (qos[i].name.equals("EventReliability")) {
                switch (qos[i].value.extract_short()) {
                    case 0: {
                        System.out.println(target + " EventReliability      = BestEffort");
                        break;
                    }
                    case 1: {
                        System.out.println(target + " EventReliability      = Persistent");
                        break;
                    }
                    default: {
                        System.out.println(target + " EventReliability      = Unknown");
                    }
                }
            }
            if (qos[i].name.equals("ConnectionReliability")) {
                switch (qos[i].value.extract_short()) {
                    case 0: {
                        System.out.println(target + " ConnectionReliability = BestEffort");
                        break;
                    }
                    case 1: {
                        System.out.println(target + " ConnectionReliability = Persistent");
                        break;
                    }
                    default: {
                        System.out.println(target + " ConnectionReliability = Unknown");
                    }
                }
            }
            if (qos[i].name.equals("Priority")) {
                switch (qos[i].value.extract_short()) {
                    case -32767: {
                        System.out.println(target + " Priority              = LowestPriority");
                        break;
                    }
                    case 32767: {
                        System.out.println(target + " Priority              = HighestPriority");
                        break;
                    }
                    case 0: {
                        System.out.println(target + " Priority              = DefaultPriority");
                        break;
                    }
                    default: {
                        System.out.println(target + " Priority              = Unknown");
                    }
                }
            }
            if (qos[i].name.equals("StartTime")) {
                System.out.println(target + " StartTime             = " + UtcTHelper.extract(qos[i].value));
            }
            if (qos[i].name.equals("StopTime")) {
                System.out.println(target + " StopTime              = " + UtcTHelper.extract(qos[i].value));
            }
            if (qos[i].name.equals("Timeout")) {
                System.out.println(target + " Timeout               = " + TimeTHelper.extract(qos[i].value));
            }
            if (qos[i].name.equals("StartTimeSupported")) {
                System.out.println(target + " StartTimeSupported    = " + qos[i].value.extract_boolean());
            }
            if (qos[i].name.equals("StopTimeSupported")) {
                System.out.println(target + " StopTimeSupported     = " + qos[i].value.extract_boolean());
            }
            if (qos[i].name.equals("MaxEventsPerConsumer")) {
                System.out.println(target + " MaxEventsPerConsumer  = " + qos[i].value.extract_long());
            }
            if (qos[i].name.equals("OrderPolicy")) {
                switch (qos[i].value.extract_short()) {
                    case 0: {
                        System.out.println(target + " OrderPolicy           = AnyOrder");
                        break;
                    }
                    case 1: {
                        System.out.println(target + " OrderPolicy           = FifoOrder");
                        break;
                    }
                    case 2: {
                        System.out.println(target + " OrderPolicy           = PriorityOrder");
                        break;
                    }
                    case 3: {
                        System.out.println(target + " OrderPolicy           = DeadlineOrder");
                        break;
                    }
                    default: {
                        System.out.println(target + " OrderPolicy           = Unknown");
                    }
                }
            }
            if (qos[i].name.equals("DiscardPolicy")) {
                switch (qos[i].value.extract_short()) {
                    case 0: {
                        System.out.println(target + " DiscardPolicy         = AnyOrder");
                        break;
                    }
                    case 1: {
                        System.out.println(target + " DiscardPolicy         = FifoOrder");
                        break;
                    }
                    case 2: {
                        System.out.println(target + " DiscardPolicy         = PriorityOrder");
                        break;
                    }
                    case 3: {
                        System.out.println(target + " DiscardPolicy         = DeadlineOrder");
                        break;
                    }
                    case 4: {
                        System.out.println(target + " DiscardPolicy         = LifoOrder");
                        break;
                    }
                    default: {
                        System.out.println(target + " DiscardPolicy         = Unknown");
                    }
                }
            }
            if (qos[i].name.equals("MaximumBatchSize")) {
                System.out.println(target + " MaximumBatchSize      = " + qos[i].value.extract_long());
            }
            if (qos[i].name.equals("PacingInterval")) {
                System.out.println(target + " PacingInterval        = " + TimeTHelper.extract(qos[i].value));
            }
            ++i;
        }
    }
}

