/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.omg.CORBA.ORB;
import org.openorb.notify.Configurator;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.ServiceContext;
import org.openorb.util.service.ServerBase;

public class Server
extends ServerBase {
    private Logger m_logKitLogger;

    public static void main(String[] args) {
        Server srv = new Server();
        Properties props = new Properties();
        ((Hashtable)props).put("ImportModule.notify", "${openorb.home}config/notify.xml#notify");
        srv.init(args, props);
        srv.run();
    }

    protected org.openorb.util.service.ServiceContext createServiceContext() {
        return new ServiceContext();
    }

    protected void preInitService(org.openorb.util.service.ServiceContext context, Parameters params) {
        PropertiesRepository props = null;
        ORB orb = this.getORB();
        if (!(orb instanceof org.openorb.orb.core.ORB)) {
            throw new RuntimeException("Service currently requires OpenORB");
        }
        org.openorb.orb.core.ORB openORB = (org.openorb.orb.core.ORB)orb;
        props = Configurator.configurePropertiesRepository(openORB);
        context.put("PROPERTIES", props);
        if (props != null && this.m_logKitLogger != null) {
            this.configureLogging(this.m_logKitLogger, props, params);
        }
    }

    protected void configureLogger(Object logger, Parameters svc_params) {
        if (logger instanceof Logger) {
            this.m_logKitLogger = (Logger)logger;
        }
        super.configureLogger(logger, svc_params);
    }

    private void configureLogging(Logger logger, PropertiesRepository props, Parameters svcParams) {
        if (svcParams.isParameter("d")) {
            return;
        }
        Server.setPriority(logger, (String)props.getProperty("LogPriorityLevel"));
        String level = (String)props.getProperty("LogPriorityLevelRecovery");
        if (level.length() > 0) {
            Server.setPriority(logger.getChildLogger("Recovery"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelEventChannel")).length() > 0) {
            Server.setPriority(logger.getChildLogger("EventChannel"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelChannel")).length() > 0) {
            Server.setPriority(logger.getChildLogger("Channel"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelSupplierAdmin")).length() > 0) {
            Server.setPriority(logger.getChildLogger("SupplierAdmin"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelConsumerAdmin")).length() > 0) {
            Server.setPriority(logger.getChildLogger("ConsumerAdmin"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelSupplierProxy")).length() > 0) {
            Server.setPriority(logger.getChildLogger("SupplierProxy"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelConsumerProxy")).length() > 0) {
            Server.setPriority(logger.getChildLogger("ConsumerProxy"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelThread")).length() > 0) {
            Server.setPriority(logger.getChildLogger("Thread"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelQueue")).length() > 0) {
            Server.setPriority(logger.getChildLogger("Queue"), level);
        }
        if ((level = (String)props.getProperty("LogPriorityLevelFilter")).length() > 0) {
            Server.setPriority(logger.getChildLogger("Filter"), level);
        }
        if (((Boolean)props.getProperty("LogEventQueue")).booleanValue()) {
            Server.setPriority(logger.getChildLogger("Queue"), "debug");
        }
        if (((Boolean)props.getProperty("LogFilterEvaluation")).booleanValue()) {
            Server.setPriority(logger.getChildLogger("Filter"), "debug");
        }
    }

    private static void setPriority(Logger logger, String priority) {
        if (logger == null) {
            return;
        }
        if (priority.equalsIgnoreCase("debug")) {
            logger.setPriority(Priority.DEBUG);
        } else if (priority.equalsIgnoreCase("warn")) {
            logger.setPriority(Priority.WARN);
        } else if (priority.equalsIgnoreCase("info")) {
            logger.setPriority(Priority.INFO);
        } else if (priority.equalsIgnoreCase("error")) {
            logger.setPriority(Priority.ERROR);
        } else {
            logger.setPriority(Priority.FATAL_ERROR);
        }
    }
}

