/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import java.util.Arrays;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CosNotification.EventType;
import org.openorb.notify.persistence.EventTypeInfo;

public final class Util {
    private Util() {
    }

    public static int getMatchingEventTypeIndex(EventType eventType, EventType[] collection) {
        int i = 0;
        while (i < collection.length) {
            if (eventType.domain_name.equals(collection[i].domain_name) && eventType.type_name.equals(collection[i].type_name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static EventTypeInfo getMatchingEventTypeInfo(EventType eventType, EventTypeInfo[] collection) {
        int i = 0;
        while (i < collection.length) {
            if (eventType.domain_name.equals(collection[i].event_type.domain_name) && eventType.type_name.equals(collection[i].event_type.type_name)) {
                return collection[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isMatchingEventType(EventType eventType, EventType[] collection) {
        int i = 0;
        while (i < collection.length) {
            if (eventType.domain_name.equals(collection[i].domain_name) && eventType.type_name.equals(collection[i].type_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static EventTypeInfo[] addRemoveEventTypes(EventTypeInfo[] collection, EventType[] toAdd, EventType[] toRemove) {
        return Util.addEventTypes(Util.removeEventTypes(collection, toRemove), toAdd);
    }

    private static EventTypeInfo[] removeEventTypes(EventTypeInfo[] collection, EventType[] toRemove) {
        if (toRemove.length == 0) {
            return collection;
        }
        if (collection.length == 0) {
            return collection;
        }
        Vector<EventTypeInfo> result = new Vector<EventTypeInfo>();
        int i = 0;
        while (i < collection.length) {
            if (Util.getMatchingEventTypeIndex(collection[i].event_type, toRemove) < 0) {
                result.add(collection[i]);
            } else {
                --collection[i].nb;
                if (collection[i].nb > 0) {
                    result.add(collection[i]);
                }
            }
            ++i;
        }
        EventTypeInfo[] retVal = new EventTypeInfo[result.size()];
        result.toArray(retVal);
        return retVal;
    }

    private static EventTypeInfo[] addEventTypes(EventTypeInfo[] collection, EventType[] toAdd) {
        if (toAdd.length == 0) {
            return collection;
        }
        Vector<EventTypeInfo> result = new Vector<EventTypeInfo>();
        if (collection != null && collection.length > 0) {
            result.addAll(Arrays.asList(collection));
        }
        int i = 0;
        while (i < toAdd.length) {
            EventTypeInfo info = Util.getMatchingEventTypeInfo(toAdd[i], collection);
            if (info == null) {
                result.add(new EventTypeInfo(toAdd[i], 1));
            } else {
                ++info.nb;
            }
            ++i;
        }
        EventTypeInfo[] retVal = new EventTypeInfo[result.size()];
        result.toArray(retVal);
        return retVal;
    }

    public static void sleep(long time, Logger logger) {
        Thread thread;
        block2: {
            thread = Thread.currentThread();
            logger.debug(thread.getName() + " sleeping for " + time + "...");
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.info(thread.getName() + " Interrupted.");
            }
        }
        logger.debug(thread.getName() + " woke up.");
    }
}

