/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.filter;

import org.omg.CosTime.ComparisonType;
import org.omg.CosTime.TimeComparison;
import org.omg.CosTime.TimeService;
import org.omg.CosTime.TimeUnavailable;
import org.omg.CosTime.UTO;
import org.omg.TimeBase.UtcT;

public class TimeFilter {
    private TimeService m_timeSource;

    public TimeFilter(TimeService timeSource) {
        this.m_timeSource = timeSource;
    }

    public boolean checkStartTime(UtcT startTime) {
        try {
            UTO timeComparator = this.m_timeSource.uto_from_utc(startTime);
            TimeComparison result = timeComparator.compare_time(ComparisonType.MidC, this.m_timeSource.universal_time());
            return result != TimeComparison.TCGreaterThan;
        }
        catch (TimeUnavailable ex) {
            return true;
        }
    }

    public boolean checkStopTime(UtcT stopTime) {
        try {
            UTO timeComparator = this.m_timeSource.uto_from_utc(stopTime);
            TimeComparison result = timeComparator.compare_time(ComparisonType.MidC, this.m_timeSource.universal_time());
            return result == TimeComparison.TCLessThan;
        }
        catch (TimeUnavailable ex) {
            return true;
        }
    }
}

