/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.ProxyPullSupplier;
import org.omg.CosEventChannelAdmin.ProxyPullSupplierHelper;
import org.omg.CosEventChannelAdmin.ProxyPushSupplier;
import org.omg.CosEventChannelAdmin.ProxyPushSupplierHelper;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminPOA;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.ProxySupplierHelper;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPullSupplierHelper;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierHelper;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullSupplierHelper;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.notify.ConsumerAdminManagement;
import org.openorb.notify.EventDispatcher;
import org.openorb.notify.Logger;
import org.openorb.notify.PersistenceManagement;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.Util;
import org.openorb.notify.impl.EventChannelImpl;
import org.openorb.notify.impl.ProxyPullSupplierImpl;
import org.openorb.notify.impl.ProxyPushSupplierImpl;
import org.openorb.notify.impl.SequenceProxyPullSupplierImpl;
import org.openorb.notify.impl.SequenceProxyPushSupplierImpl;
import org.openorb.notify.impl.StructuredProxyPullSupplierImpl;
import org.openorb.notify.impl.StructuredProxyPushSupplierImpl;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.ConsumerAdmin;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.notify.queue.EventQueueFactory;
import org.openorb.notify.queue.EventQueueReceiver;
import org.openorb.notify.queue.FilterableEventQueue;
import org.openorb.util.NumberCache;

public class ConsumerAdminImpl
extends ConsumerAdminPOA
implements EventDispatcher,
ConsumerAdminManagement,
PersistenceManagement {
    private final ORB m_orb;
    private final POA m_poa;
    private final ConsumerAdmin m_pssConsumerAdmin;
    private final EventChannelImpl m_channel;
    private final FilterableEventQueue m_queue;
    private final EventQueueReceiver m_receiver;
    private final PropertiesRepository m_propertiesRepository;
    private final Map m_undeliveredEventsMap = new HashMap();
    private final Logger m_logger;
    private boolean m_destroyed;

    public ConsumerAdminImpl(EventChannelImpl channel, ORB orb, POA poa, InterFilterGroupOperator operator, int consumerAdminId, int channelId, Property[] qosProperties, Logger logger) {
        this(orb, poa, logger, channel, qosProperties, operator, consumerAdminId, channelId, new PropertiesRepository(qosProperties));
    }

    private ConsumerAdminImpl(ORB orb, POA poa, Logger logger, EventChannelImpl channel, Property[] qosProperties, InterFilterGroupOperator operator, int consumerAdminId, int channelId, PropertiesRepository propertiesRepository) {
        this(orb, poa, logger, channel, ConsumerAdminImpl.createConsumerAdmin(propertiesRepository, operator, consumerAdminId, channelId, qosProperties), propertiesRepository);
    }

    public ConsumerAdminImpl(EventChannelImpl channel, ConsumerAdmin pssConsumerAdmin, POA poa, Logger logger) {
        this(channel._orb(), poa, logger, channel, pssConsumerAdmin, new PropertiesRepository(pssConsumerAdmin.qos_properties()));
    }

    private ConsumerAdminImpl(ORB orb, POA poa, Logger logger, EventChannelImpl channel, ConsumerAdmin pssConsumerAdmin, PropertiesRepository propertiesRepository) {
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_logger = logger;
        this.m_propertiesRepository = propertiesRepository;
        this.m_channel = channel;
        this.m_pssConsumerAdmin = pssConsumerAdmin;
        this.m_queue = this.configureQueue();
        this.m_receiver = this.configureReceiver();
    }

    private static ConsumerAdmin createConsumerAdmin(PropertiesRepository propertiesRepository, InterFilterGroupOperator operator, int consumerAdminId, int channelId, Property[] qosProperties) {
        ConnectionInfo[] connectionInfo = new ConnectionInfo[]{};
        ReferenceInfo[] referenceInfo = new ReferenceInfo[]{};
        EventTypeInfo[] eventTypeInfo = new EventTypeInfo[]{};
        return PersistenceRepository.getConsumerAdminHome(propertiesRepository.isConnectionReliable()).create(consumerAdminId, channelId, operator, qosProperties, connectionInfo, connectionInfo, 0, 0, referenceInfo, referenceInfo, 0, eventTypeInfo);
    }

    private FilterableEventQueue configureQueue() {
        return EventQueueFactory.createAdminQueue("[CA] " + this.getId(), this.m_propertiesRepository, this.m_channel.isEventQueueLogged(), this.m_channel.isFilterEvaluationLogged(), this.getLogger().getChildLogger("queue"));
    }

    private EventQueueReceiver configureReceiver() {
        EventQueueReceiver receiver = new EventQueueReceiver("[CA] " + this.getId(), this.m_queue, this.getLogger());
        if (this.m_channel.isConsumerAdminMaxPerformance()) {
            receiver.startThread();
        }
        return receiver;
    }

    public int MyID() {
        this.getLogger().debug("MyID");
        return this.m_pssConsumerAdmin.id();
    }

    public EventChannel MyChannel() {
        this.getLogger().debug("MyChannel");
        return this.m_channel._this();
    }

    public InterFilterGroupOperator MyOperator() {
        this.getLogger().debug("MyOperator");
        return this.m_pssConsumerAdmin.filter_operator();
    }

    public MappingFilter priority_filter() {
        this.getLogger().debug("priority_filter");
        throw new NO_IMPLEMENT();
    }

    public void priority_filter(MappingFilter value) {
        this.getLogger().debug("priority_filter");
        throw new NO_IMPLEMENT();
    }

    public MappingFilter lifetime_filter() {
        this.getLogger().debug("lifetime_filter");
        throw new NO_IMPLEMENT();
    }

    public void lifetime_filter(MappingFilter value) {
        this.getLogger().debug("lifetime_filter");
        throw new NO_IMPLEMENT();
    }

    private int[] extractIds(ConnectionInfo[] connections) {
        int idCount = 0;
        int i = 0;
        while (i < connections.length) {
            if (-1 != connections[i].id) {
                ++idCount;
            }
            ++i;
        }
        int[] ids = new int[idCount];
        int i2 = 0;
        int j = 0;
        while (i2 < connections.length) {
            if (-1 != connections[i2].id) {
                ids[j++] = connections[i2].id;
            }
            ++i2;
        }
        return ids;
    }

    public int[] pull_suppliers() {
        this.getLogger().debug("pull_suppliers");
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            int[] nArray = this.extractIds(this.m_pssConsumerAdmin.pull_suppliers());
            return nArray;
        }
    }

    public int[] push_suppliers() {
        this.getLogger().debug("push_suppliers");
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            int[] nArray = this.extractIds(this.m_pssConsumerAdmin.push_suppliers());
            return nArray;
        }
    }

    public ProxySupplier get_proxy_supplier(int proxyId) throws ProxyNotFound {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get_proxy_supplier: proxy_id=" + proxyId);
        }
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            if (proxyId < 0) {
                throw new ProxyNotFound();
            }
            ProxySupplier pullSupplier = this.findProxySupplier(this.m_pssConsumerAdmin.pull_suppliers(), proxyId);
            if (null != pullSupplier) {
                ProxySupplier proxySupplier = pullSupplier;
                return proxySupplier;
            }
            ProxySupplier pushSupplier = this.findProxySupplier(this.m_pssConsumerAdmin.push_suppliers(), proxyId);
            if (null != pushSupplier) {
                ProxySupplier proxySupplier = pushSupplier;
                return proxySupplier;
            }
            throw new ProxyNotFound();
        }
    }

    private ProxySupplier findProxySupplier(ConnectionInfo[] suppliers, int id) {
        int i = 0;
        while (i < suppliers.length) {
            if (id == suppliers[i].id) {
                return ProxySupplierHelper.narrow(suppliers[i].reference);
            }
            ++i;
        }
        return null;
    }

    public ProxySupplier obtain_notification_pull_supplier(ClientType ctype, IntHolder proxy_id) throws AdminLimitExceeded {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("obtain_notification_pull_supplier: proxy_id=" + proxy_id);
        }
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            Servant newPullSupplier;
            switch (ctype.value()) {
                case 1: {
                    proxy_id.value = this.m_pssConsumerAdmin.next_pull_supplier_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " StructuredPullSupplier created with id " + proxy_id.value + ".");
                    }
                    newPullSupplier = new StructuredProxyPullSupplierImpl(this, proxy_id.value, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 2: {
                    proxy_id.value = this.m_pssConsumerAdmin.next_pull_supplier_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " SequencePullSupplier created with id " + proxy_id.value + ".");
                    }
                    newPullSupplier = new SequenceProxyPullSupplierImpl(this, proxy_id.value, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 0: {
                    proxy_id.value = this.m_pssConsumerAdmin.next_pull_supplier_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " AnyPullSupplier created with id " + proxy_id.value + ".");
                    }
                    newPullSupplier = new ProxyPullSupplierImpl(this, proxy_id.value, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
                    break;
                }
                default: {
                    this.getLogger().debug(this.getId() + " PullSupplier was not created due to unsupported type.");
                    throw new BAD_PARAM();
                }
            }
            try {
                byte[] pid = ((PersistenceManagement)newPullSupplier).getPid();
                this.m_poa.activate_object_with_id(pid, newPullSupplier);
                this.reportProxyCreated();
                this.m_channel.reportSupplierConnection();
                ConnectionInfo[] suppliers = this.m_pssConsumerAdmin.pull_suppliers();
                ConnectionInfo[] newSuppliers = new ConnectionInfo[suppliers.length + 1];
                System.arraycopy(suppliers, 0, newSuppliers, 0, suppliers.length);
                newSuppliers[suppliers.length] = new ConnectionInfo(proxy_id.value, pid, this.m_poa.id_to_reference(pid));
                this.m_pssConsumerAdmin.next_pull_supplier_id(proxy_id.value + 1);
                this.m_pssConsumerAdmin.pull_suppliers(newSuppliers);
                this.m_receiver.addDispatcher((EventDispatcher)newPullSupplier);
                ProxySupplier proxySupplier = ProxySupplierHelper.narrow(this.m_poa.id_to_reference(pid));
                return proxySupplier;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxySupplier suppliers = null;
                return suppliers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public ProxySupplier obtain_notification_push_supplier(ClientType ctype, IntHolder proxy_id) throws AdminLimitExceeded {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("obtain_notification_pull_supplier: proxy_id=" + proxy_id);
        }
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            Servant newPushSupplier;
            switch (ctype.value()) {
                case 1: {
                    proxy_id.value = this.m_pssConsumerAdmin.next_push_supplier_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " StructuredPushSupplier created with id " + proxy_id.value + ".");
                    }
                    newPushSupplier = new StructuredProxyPushSupplierImpl(this, proxy_id.value, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 2: {
                    proxy_id.value = this.m_pssConsumerAdmin.next_push_supplier_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " SequencePushSupplier created with id " + proxy_id.value + ".");
                    }
                    newPushSupplier = new SequenceProxyPushSupplierImpl(this, proxy_id.value, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 0: {
                    proxy_id.value = this.m_pssConsumerAdmin.next_push_supplier_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " AnyPushSupplier created with id " + proxy_id.value + ".");
                    }
                    newPushSupplier = new ProxyPushSupplierImpl(this, proxy_id.value, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
                    break;
                }
                default: {
                    this.getLogger().info(this.getId() + " PushSupplier was not created due to unsupported type.");
                    throw new BAD_PARAM();
                }
            }
            try {
                byte[] pid = ((PersistenceManagement)newPushSupplier).getPid();
                this.m_poa.activate_object_with_id(pid, newPushSupplier);
                this.reportProxyCreated();
                this.m_channel.reportSupplierConnection();
                ConnectionInfo[] suppliers = this.m_pssConsumerAdmin.push_suppliers();
                ConnectionInfo[] newSuppliers = new ConnectionInfo[suppliers.length + 1];
                System.arraycopy(suppliers, 0, newSuppliers, 0, suppliers.length);
                newSuppliers[suppliers.length] = new ConnectionInfo(proxy_id.value, pid, this.m_poa.id_to_reference(pid));
                this.m_pssConsumerAdmin.next_push_supplier_id(proxy_id.value + 1);
                this.m_pssConsumerAdmin.push_suppliers(newSuppliers);
                this.m_receiver.addDispatcher((EventDispatcher)newPushSupplier);
                ProxySupplier proxySupplier = ProxySupplierHelper.narrow(this.m_poa.id_to_reference(pid));
                return proxySupplier;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxySupplier suppliers = null;
                return suppliers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public synchronized void destroy() {
        if (this.m_destroyed) {
            return;
        }
        this.m_destroyed = true;
        this.getLogger().info("destroy");
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + "Disconnecting proxies.");
        }
        this.disconnectPushSuppliers();
        this.disconnectPullSuppliers();
        this.m_receiver.stopThread();
        this.m_channel.reportConsumerAdminDestruction(this.m_pssConsumerAdmin.get_pid());
        try {
            this.m_poa.deactivate_object(this.getPid());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_pssConsumerAdmin.destroy_object();
    }

    private void disconnectPullSuppliers() {
        ConnectionInfo[] suppliers = this.m_pssConsumerAdmin.pull_suppliers();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting pull proxies.");
        }
        int i = 0;
        while (i < suppliers.length) {
            ConnectionInfo supplier = suppliers[i];
            if (supplier.reference._is_a(StructuredProxyPullSupplierHelper.id())) {
                StructuredProxyPullSupplierHelper.narrow(supplier.reference).disconnect_structured_pull_supplier();
            } else if (supplier.reference._is_a(SequenceProxyPullSupplierHelper.id())) {
                SequenceProxyPullSupplierHelper.narrow(supplier.reference).disconnect_sequence_pull_supplier();
            } else if (supplier.reference._is_a(ProxyPullSupplierHelper.id())) {
                ProxyPullSupplierHelper.narrow(supplier.reference).disconnect_pull_supplier();
            }
            ++i;
        }
    }

    private void disconnectPushSuppliers() {
        ConnectionInfo[] suppliers = this.m_pssConsumerAdmin.push_suppliers();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting push proxies.");
        }
        int i = 0;
        while (i < suppliers.length) {
            ConnectionInfo supplier = suppliers[i];
            if (supplier.reference._is_a(StructuredProxyPushSupplierHelper.id())) {
                StructuredProxyPushSupplierHelper.narrow(supplier.reference).disconnect_structured_push_supplier();
            } else if (supplier.reference._is_a(SequenceProxyPushSupplierHelper.id())) {
                SequenceProxyPushSupplierHelper.narrow(supplier.reference).disconnect_sequence_push_supplier();
            } else if (supplier.reference._is_a(ProxyPullSupplierHelper.id())) {
                ProxyPushSupplierHelper.narrow(supplier.reference).disconnect_push_supplier();
            }
            ++i;
        }
    }

    public Property[] get_qos() {
        this.getLogger().debug("get_qos");
        return this.m_pssConsumerAdmin.qos_properties();
    }

    public void set_qos(Property[] qos) throws UnsupportedQoS {
        this.getLogger().debug("set_qos");
        throw new NO_IMPLEMENT();
    }

    public void validate_qos(Property[] required_qos, NamedPropertyRangeSeqHolder available_qos) throws UnsupportedQoS {
        this.getLogger().debug("validate_qos");
        throw new NO_IMPLEMENT();
    }

    public void subscription_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        this.getLogger().debug("subscription_change");
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Event types subscribe modified.");
        }
        EventTypeInfo[] eventTypesToUse = Util.addRemoveEventTypes(this.m_pssConsumerAdmin.event_types(), added, removed);
        this.m_pssConsumerAdmin.event_types(eventTypesToUse);
    }

    public synchronized int add_filter(Filter new_filter) {
        this.getLogger().debug("add_filter");
        if (null == new_filter) {
            return -1;
        }
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            ReferenceInfo[] filters = this.m_pssConsumerAdmin.filters();
            if (this.m_queue.addFilter(new_filter)) {
                ReferenceInfo[] newFilters = new ReferenceInfo[filters.length + 1];
                System.arraycopy(filters, 0, newFilters, 0, filters.length);
                int filterId = this.m_pssConsumerAdmin.next_filter_id();
                newFilters[filters.length] = new ReferenceInfo(filterId, new_filter);
                this.m_pssConsumerAdmin.next_filter_id(filterId + 1);
                this.m_pssConsumerAdmin.filters(newFilters);
                int n = filterId;
                return n;
            }
            int i = 0;
            while (i < filters.length) {
                if (filters[i].reference.equals(new_filter)) {
                    int n = filters[i].id;
                    return n;
                }
                ++i;
            }
            int n = -1;
            return n;
        }
    }

    public synchronized void remove_filter(int filterId) throws FilterNotFound {
        this.getLogger().debug("remove_filter");
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            ReferenceInfo[] filters = this.m_pssConsumerAdmin.filters();
            if (0 == filters.length) {
                throw new FilterNotFound();
            }
            int i = 0;
            while (i < filters.length) {
                if (filterId == filters[i].id) {
                    ReferenceInfo[] newFilters = new ReferenceInfo[filters.length - 1];
                    System.arraycopy(filters, 0, newFilters, 0, i);
                    System.arraycopy(filters, i + 1, newFilters, i, newFilters.length - i);
                    this.m_pssConsumerAdmin.filters(newFilters);
                    this.m_queue.removeFilter(FilterHelper.narrow(filters[i].reference));
                    return;
                }
                ++i;
            }
            throw new FilterNotFound();
        }
    }

    public Filter get_filter(int filterId) throws FilterNotFound {
        this.getLogger().debug("get_filter");
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            ReferenceInfo[] filters = this.m_pssConsumerAdmin.filters();
            int i = 0;
            while (i < filters.length) {
                if (filterId == filters[i].id) {
                    Filter filter = FilterHelper.narrow(filters[i].reference);
                    return filter;
                }
                ++i;
            }
            throw new FilterNotFound();
        }
    }

    public int[] get_all_filters() {
        this.getLogger().debug("get_all_filters");
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            ReferenceInfo[] filters = this.m_pssConsumerAdmin.filters();
            int[] result = new int[filters.length];
            int i = 0;
            while (i < result.length) {
                result[i] = filters[i].id;
                ++i;
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public void remove_all_filters() {
        this.getLogger().debug("remove_all_filters");
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            this.m_queue.removeAllFilters();
            this.m_pssConsumerAdmin.filters(new ReferenceInfo[0]);
        }
    }

    public ProxyPushSupplier obtain_push_supplier() {
        this.getLogger().debug("obtain_push_supplier");
        int id = -1;
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getId() + " EventAnyPushSupplier created with id " + -1 + ".");
            }
            ProxyPushSupplierImpl newPushSupplier = new ProxyPushSupplierImpl(this, -1, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
            try {
                this.m_poa.activate_object_with_id(newPushSupplier.getPid(), (Servant)newPushSupplier);
                this.reportProxyCreated();
                ConnectionInfo[] suppliers = this.m_pssConsumerAdmin.push_suppliers();
                ConnectionInfo[] newSuppliers = new ConnectionInfo[suppliers.length + 1];
                System.arraycopy(suppliers, 0, newSuppliers, 0, suppliers.length);
                newSuppliers[suppliers.length] = new ConnectionInfo(-1, newPushSupplier.getPid(), this.m_poa.id_to_reference(newPushSupplier.getPid()));
                this.m_pssConsumerAdmin.push_suppliers(newSuppliers);
                this.m_receiver.addDispatcher(newPushSupplier);
                ProxyPushSupplier proxyPushSupplier = ProxyPushSupplierHelper.narrow(this.m_poa.id_to_reference(newPushSupplier.getPid()));
                return proxyPushSupplier;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxyPushSupplier newSuppliers = null;
                return newSuppliers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public ProxyPullSupplier obtain_pull_supplier() {
        this.getLogger().debug("obtain_pull_supplier");
        int id = -1;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getId() + " EventAnyPullSupplier created with id " + -1 + ".");
        }
        ConsumerAdmin consumerAdmin = this.m_pssConsumerAdmin;
        synchronized (consumerAdmin) {
            ProxyPullSupplierImpl newPullSupplier = new ProxyPullSupplierImpl(this, -1, this.MyID(), this.m_pssConsumerAdmin.qos_properties(), this.m_logger);
            try {
                this.m_poa.activate_object_with_id(newPullSupplier.getPid(), (Servant)newPullSupplier);
                this.reportProxyCreated();
                ConnectionInfo[] suppliers = this.m_pssConsumerAdmin.pull_suppliers();
                ConnectionInfo[] newSuppliers = new ConnectionInfo[suppliers.length + 1];
                System.arraycopy(suppliers, 0, newSuppliers, 0, suppliers.length);
                newSuppliers[suppliers.length] = new ConnectionInfo(-1, newPullSupplier.getPid(), this.m_poa.id_to_reference(newPullSupplier.getPid()));
                this.m_pssConsumerAdmin.pull_suppliers(newSuppliers);
                this.m_receiver.addDispatcher(newPullSupplier);
                ProxyPullSupplier proxyPullSupplier = ProxyPullSupplierHelper.narrow(this.m_poa.id_to_reference(newPullSupplier.getPid()));
                return proxyPullSupplier;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxyPullSupplier newSuppliers = null;
                return newSuppliers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public void dispatchEvent(Object event) {
        this.m_receiver.pushEvent(event);
    }

    public String getId() {
        return this.m_channel.getId() + "[" + this.m_pssConsumerAdmin.id() + "]";
    }

    public void proxySupplierRecovered(int id, Servant proxySupplier) {
        this.m_receiver.addDispatcher((EventDispatcher)proxySupplier);
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public POA getPOA() {
        return this.m_poa;
    }

    public void reportConsumerConnection() {
        this.m_channel.reportConsumerConnection();
    }

    public boolean canConnectConsumer() {
        return this.m_channel.canConnectConsumer();
    }

    private int findIndex(ConnectionInfo[] info, byte[] pid) {
        int i = 0;
        while (i < info.length) {
            if (Arrays.equals(info[i].pid, pid)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ConnectionInfo[] removeIndex(ConnectionInfo[] info, int index) {
        ConnectionInfo[] newInfo = new ConnectionInfo[info.length - 1];
        System.arraycopy(info, 0, newInfo, 0, index);
        System.arraycopy(info, index + 1, newInfo, index, newInfo.length - index);
        return newInfo;
    }

    public void reportPullConsumerDisconnection(byte[] proxyPid) {
        ConnectionInfo[] suppliers;
        int index;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting pull proxy.");
        }
        if (-1 == (index = this.findIndex(suppliers = this.m_pssConsumerAdmin.pull_suppliers(), proxyPid))) {
            return;
        }
        try {
            this.m_receiver.removeDispatcher((EventDispatcher)this.m_poa.id_to_servant(suppliers[index].pid));
        }
        catch (ObjectNotActive ex) {
            this.getLogger().error(this.getId() + " Error while removing dispatcher.", ex);
        }
        catch (WrongPolicy ex) {
            this.getLogger().error(this.getId() + " Error while removing dispatcher.", ex);
        }
        this.m_pssConsumerAdmin.pull_suppliers(this.removeIndex(suppliers, index));
        this.m_channel.reportConsumerDisconnection();
    }

    public void reportPushConsumerDisconnection(byte[] proxyPid) {
        ConnectionInfo[] suppliers;
        int index;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting push proxy.");
        }
        if (-1 == (index = this.findIndex(suppliers = this.m_pssConsumerAdmin.push_suppliers(), proxyPid))) {
            return;
        }
        try {
            this.m_receiver.removeDispatcher((EventDispatcher)this.m_poa.id_to_servant(suppliers[index].pid));
        }
        catch (ObjectNotActive ex) {
            this.getLogger().error(this.getId() + " Error while removing dispatcher.", ex);
        }
        catch (WrongPolicy ex) {
            this.getLogger().error(this.getId() + " Error while removing dispatcher.", ex);
        }
        this.m_pssConsumerAdmin.push_suppliers(this.removeIndex(suppliers, index));
        this.m_channel.reportConsumerDisconnection();
    }

    public synchronized void reportEventDelivery(int proxyId, int eventPid) {
        Integer eventPidInteger;
        Integer deliveriesForEvent;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " event " + eventPid + " has been processed by proxy " + proxyId + ".");
        }
        deliveriesForEvent = (deliveriesForEvent = (Integer)this.m_undeliveredEventsMap.get(eventPidInteger = NumberCache.getInteger((int)eventPid))) == null ? NumberCache.getInteger((int)1) : NumberCache.getInteger((int)(deliveriesForEvent + 1));
        this.m_undeliveredEventsMap.put(eventPidInteger, deliveriesForEvent);
        if (deliveriesForEvent >= this.m_pssConsumerAdmin.pull_suppliers().length + this.m_pssConsumerAdmin.push_suppliers().length) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getId() + " event " + eventPid + " has been processed by all proxies.");
            }
            this.m_undeliveredEventsMap.remove(eventPidInteger);
            this.m_channel.reportEventDelivery(this.m_pssConsumerAdmin.id(), eventPid);
        }
    }

    private synchronized void reportProxyCreated() {
        Iterator it = this.m_undeliveredEventsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Integer i = (Integer)entry.getValue();
            entry.setValue(NumberCache.getInteger((int)(i + 1)));
        }
    }

    public boolean isEventQueueLogged() {
        return this.m_channel.isEventQueueLogged();
    }

    public boolean isFilterEvaluationLogged() {
        return this.m_channel.isFilterEvaluationLogged();
    }

    public boolean isQueueMaxPerformance() {
        return this.m_channel.isQueueMaxPerformance();
    }

    public boolean isProxyMaxPerformance() {
        return this.m_channel.isConsumerProxyMaxPerformance();
    }

    public Object getNotifyProperty(String key) {
        return this.m_channel.getNotifyProperty(key);
    }

    public byte[] getPid() {
        return this.m_pssConsumerAdmin.get_pid();
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger.getCAdminLogger();
    }
}

