/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.impl;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactoryPOA;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.notify.impl.FilterImpl;
import org.openorb.util.ExceptionTool;

public class FilterFactoryImpl
extends FilterFactoryPOA {
    private ORB m_orb;
    private POA m_poa;
    private Logger m_logger;

    public FilterFactoryImpl(ORB orb, POA poa, Logger logger) {
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_logger = logger;
    }

    public Filter create_filter(String constraint_grammar) throws InvalidGrammar {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("create_filter: grammar=" + constraint_grammar);
        }
        if (!constraint_grammar.equals("EXTENDED_TCL")) {
            throw new InvalidGrammar("Only EXTENDED_TCL supported");
        }
        try {
            FilterImpl newFilter = new FilterImpl(constraint_grammar, this.m_orb, this.m_poa, this.m_logger);
            this.m_poa.activate_object_with_id(newFilter.getPid(), (Servant)newFilter);
            return FilterHelper.narrow(this.m_poa.id_to_reference(newFilter.getPid()));
        }
        catch (NoClassDefFoundError e) {
            String msg = "EvaluatorUtility could not be found";
            this.getLogger().error("EvaluatorUtility could not be found", e);
            throw ExceptionTool.initCause((SystemException)new INTERNAL("EvaluatorUtility could not be found"), (Throwable)e);
        }
        catch (Throwable e) {
            String msg = "Unexpected exception.";
            this.getLogger().error("Unexpected exception.", e);
            throw ExceptionTool.initCause((SystemException)new INTERNAL("Unexpected exception."), (Throwable)e);
        }
    }

    public MappingFilter create_mapping_filter(String constraint_grammar, Any default_value) throws InvalidGrammar {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("create_mapping_filter: grammar=" + constraint_grammar);
        }
        throw new NO_IMPLEMENT();
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

