/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyFilter.CallbackNotFound;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.FilterPOA;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.constraint.InvalidValue;
import org.openorb.notify.FilterManagement;
import org.openorb.notify.PersistenceManagement;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.filter.FilterConstraint;
import org.openorb.notify.filter.FilterEvaluator;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.Filter;
import org.openorb.notify.persistence.ReferenceInfo;

public class FilterImpl
extends FilterPOA
implements FilterManagement,
PersistenceManagement {
    private Filter m_pssFilter;
    private Hashtable m_constraints;
    private Hashtable m_parsedConstraints;
    private ORB m_orb;
    private POA m_poa;
    private Logger m_logger;

    public FilterImpl(String constraintGrammar, ORB orb, POA poa, Logger logger) {
        this.m_pssFilter = PersistenceRepository.getFilterHome(true).create(constraintGrammar, new ConstraintInfo[0], 0, new ReferenceInfo[0], 0, new EventTypeInfo[0]);
        this.m_constraints = new Hashtable();
        this.m_parsedConstraints = new Hashtable();
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_logger = logger;
    }

    public FilterImpl(Filter pssFilter, ORB orb, POA poa, Logger logger) {
        this.m_pssFilter = pssFilter;
        this.m_constraints = new Hashtable();
        this.m_parsedConstraints = new Hashtable();
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_logger = logger;
        ConstraintInfo[] constraint_list = this.m_pssFilter.constraints();
        int i = 0;
        while (i < constraint_list.length) {
            try {
                FilterConstraint parsed = FilterEvaluator.createFilterConstraint(constraint_list[i].constraint_expression.constraint_expr, this.m_orb);
                this.m_constraints.put(new Long(constraint_list[i].constraint_id), constraint_list[i]);
                this.m_parsedConstraints.put(new Long(constraint_list[i].constraint_id), parsed);
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception for constraint: " + constraint_list[i].constraint_expression.constraint_expr, ex);
            }
            ++i;
        }
    }

    public String constraint_grammar() {
        return this.m_pssFilter.constraint_grammar();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized ConstraintInfo[] add_constraints(ConstraintExp[] constraint_list) throws InvalidConstraint {
        var2_2 = this.m_parsedConstraints;
        synchronized (var2_2) {
            result = new ConstraintInfo[constraint_list.length];
            i = 0;
            while (i < constraint_list.length) {
                block7: {
                    try {
                        parsed = FilterEvaluator.createFilterConstraint(constraint_list[i].constraint_expr, this.m_orb);
                        result[i] = new ConstraintInfo(constraint_list[i], this.m_pssFilter.next_constraint_id());
                        this.m_constraints.put(new Long(this.m_pssFilter.next_constraint_id()), constraint_list[i]);
                        this.m_parsedConstraints.put(new Long(this.m_pssFilter.next_constraint_id()), parsed);
                        this.m_pssFilter.next_constraint_id(this.m_pssFilter.next_constraint_id() + 1);
                        break block7;
                    }
                    catch (Exception ex) {
                        this.getLogger().info("Error evaluating constraint: " + constraint_list[i].constraint_expr, ex);
                        j = 0;
                        ** while (j < i)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.m_pssFilter.next_constraint_id(this.m_pssFilter.next_constraint_id() - 1);
                        this.m_constraints.remove(new Long(this.m_pssFilter.next_constraint_id()));
                        this.m_parsedConstraints.remove(new Long(this.m_pssFilter.next_constraint_id()));
                        ++j;
                        continue;
                    }
lbl27:
                    // 1 sources

                    throw new InvalidConstraint(constraint_list[i]);
                }
                ++i;
            }
            this.saveConstraintsState();
            var5_5 = result;
            return var5_5;
        }
    }

    public synchronized void modify_constraints(int[] del_list, ConstraintInfo[] modify_list) throws InvalidConstraint, ConstraintNotFound {
        Hashtable hashtable = this.m_constraints;
        synchronized (hashtable) {
            FilterConstraint[] modifiedConstraints = new FilterConstraint[modify_list.length];
            int i = 0;
            while (i < del_list.length) {
                if (this.m_constraints.get(new Long(del_list[i])) == null) {
                    throw new ConstraintNotFound(del_list[i]);
                }
                ++i;
            }
            i = 0;
            while (i < modify_list.length) {
                if (this.m_constraints.get(new Long(modify_list[i].constraint_id)) == null) {
                    throw new ConstraintNotFound(modify_list[i].constraint_id);
                }
                try {
                    modifiedConstraints[i] = FilterEvaluator.createFilterConstraint(modify_list[i].constraint_expression.constraint_expr, this.m_orb);
                }
                catch (Exception ex) {
                    this.getLogger().info("Error evaluating constraint: " + modify_list[i].constraint_expression, ex);
                    throw new InvalidConstraint(modify_list[i].constraint_expression);
                }
                ++i;
            }
            i = 0;
            while (i < del_list.length) {
                this.m_constraints.remove(new Long(del_list[i]));
                this.m_parsedConstraints.remove(new Long(del_list[i]));
                ++i;
            }
            i = 0;
            while (i < modify_list.length) {
                this.m_constraints.put(new Long(modify_list[i].constraint_id), modify_list[i].constraint_expression);
                this.m_parsedConstraints.put(new Long(modify_list[i].constraint_id), modifiedConstraints[i]);
                ++i;
            }
            this.saveConstraintsState();
        }
    }

    public ConstraintInfo[] get_constraints(int[] id_list) throws ConstraintNotFound {
        ConstraintInfo[] constraintsInfo = new ConstraintInfo[id_list.length];
        int i = 0;
        while (i < id_list.length) {
            ConstraintExp expression = (ConstraintExp)this.m_constraints.get(new Long(id_list[i]));
            if (expression == null) {
                throw new ConstraintNotFound(id_list[i]);
            }
            constraintsInfo[i] = new ConstraintInfo(expression, id_list[i]);
            ++i;
        }
        return constraintsInfo;
    }

    public ConstraintInfo[] get_all_constraints() {
        ConstraintInfo[] constraintsInfo = new ConstraintInfo[this.m_constraints.size()];
        int i = 0;
        Enumeration e = this.m_constraints.keys();
        while (e.hasMoreElements()) {
            Long key = (Long)e.nextElement();
            constraintsInfo[i++] = new ConstraintInfo((ConstraintExp)this.m_constraints.get(key), key.intValue());
        }
        return constraintsInfo;
    }

    public void remove_all_constraints() {
        Hashtable hashtable = this.m_parsedConstraints;
        synchronized (hashtable) {
            this.m_constraints.clear();
            this.m_parsedConstraints.clear();
            this.saveConstraintsState();
        }
    }

    public void destroy() {
        try {
            this.m_poa.deactivate_object(this.m_poa.servant_to_id((Servant)this));
        }
        catch (UserException ex) {
            throw new BAD_INV_ORDER(ex.toString());
        }
    }

    public boolean match(Any filterable_data) throws UnsupportedFilterableData {
        try {
            Enumeration e = this.m_parsedConstraints.keys();
            while (e.hasMoreElements()) {
                FilterConstraint parsedConstraint;
                Long key = (Long)e.nextElement();
                ConstraintExp constraint = (ConstraintExp)this.m_constraints.get(key);
                if (!this.matchEventTypes("", "%ANY", constraint.event_types) || !(parsedConstraint = (FilterConstraint)this.m_parsedConstraints.get(key)).evaluate(filterable_data)) continue;
                return true;
            }
            return false;
        }
        catch (InvalidValue ex) {
            throw new UnsupportedFilterableData();
        }
    }

    public boolean match_structured(StructuredEvent filterable_data) throws UnsupportedFilterableData {
        Any any = this.m_orb.create_any();
        StructuredEventHelper.insert(any, filterable_data);
        try {
            Enumeration e = this.m_parsedConstraints.keys();
            while (e.hasMoreElements()) {
                FilterConstraint parsedConstraint;
                Long key = (Long)e.nextElement();
                ConstraintExp constraint = (ConstraintExp)this.m_constraints.get(key);
                if (!this.matchEventTypes(filterable_data.header.fixed_header.event_type.domain_name, filterable_data.header.fixed_header.event_type.type_name, constraint.event_types) || !(parsedConstraint = (FilterConstraint)this.m_parsedConstraints.get(key)).evaluate(any)) continue;
                return true;
            }
            return false;
        }
        catch (InvalidValue ex) {
            throw new UnsupportedFilterableData();
        }
    }

    public boolean match_typed(Property[] filterable_data) throws UnsupportedFilterableData {
        try {
            Enumeration e = this.m_parsedConstraints.keys();
            while (e.hasMoreElements()) {
                FilterConstraint parsedConstraint;
                Long key = (Long)e.nextElement();
                ConstraintExp constraint = (ConstraintExp)this.m_constraints.get(key);
                if (!this.matchEventTypes("", "%TYPED", constraint.event_types) || !(parsedConstraint = (FilterConstraint)this.m_parsedConstraints.get(key)).evaluate(filterable_data)) continue;
                return true;
            }
            return false;
        }
        catch (InvalidValue ex) {
            throw new UnsupportedFilterableData();
        }
    }

    public int attach_callback(NotifySubscribe callback) {
        Filter filter = this.m_pssFilter;
        synchronized (filter) {
            ReferenceInfo[] callbacks = this.m_pssFilter.callbacks();
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i].reference.equals(callback)) {
                    int n = callbacks[i].id;
                    return n;
                }
                ++i;
            }
            ReferenceInfo[] new_callbacks = new ReferenceInfo[callbacks.length + 1];
            int i2 = 0;
            while (i2 < callbacks.length) {
                new_callbacks[i2] = callbacks[i2];
                ++i2;
            }
            int callbackId = this.m_pssFilter.next_callback_id();
            new_callbacks[callbacks.length] = new ReferenceInfo(callbackId, callback);
            this.m_pssFilter.next_callback_id(callbackId + 1);
            int n = callbackId;
            return n;
        }
    }

    public void detach_callback(int callback) throws CallbackNotFound {
        Filter filter = this.m_pssFilter;
        synchronized (filter) {
            ReferenceInfo[] callbacks = this.m_pssFilter.callbacks();
            ReferenceInfo[] new_callbacks = new ReferenceInfo[callbacks.length - 1];
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i].id == callback) {
                    int j = i;
                    while (j < new_callbacks.length) {
                        new_callbacks[j] = callbacks[j + 1];
                        ++j;
                    }
                    this.m_pssFilter.callbacks(new_callbacks);
                    return;
                }
                new_callbacks[i] = callbacks[i];
                ++i;
            }
            throw new CallbackNotFound();
        }
    }

    public int[] get_callbacks() {
        Filter filter = this.m_pssFilter;
        synchronized (filter) {
            ReferenceInfo[] callbacks = this.m_pssFilter.callbacks();
            int[] result = new int[callbacks.length];
            int i = 0;
            while (i < result.length) {
                result[i] = callbacks[i].id;
                ++i;
            }
            int[] nArray = result;
            return nArray;
        }
    }

    private boolean matchEventTypes(String domainName, String typeName, EventType[] eventTypes) {
        if (eventTypes.length == 0) {
            return true;
        }
        int i = 0;
        while (i < eventTypes.length) {
            boolean matchDomain = false;
            boolean matchType = false;
            if (!matchDomain) {
                matchDomain = eventTypes[i].domain_name.equals("*") || eventTypes[i].domain_name.equals("") ? true : this.matchStrings(domainName, eventTypes[i].domain_name);
            }
            if (!matchType) {
                matchType = eventTypes[i].type_name.equals("%ALL") || eventTypes[i].type_name.equals("*") || eventTypes[i].type_name.equals("") ? true : this.matchStrings(typeName, eventTypes[i].type_name);
            }
            if (matchDomain && matchType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matchStrings(String source, String target) {
        return source.trim().equals(target);
    }

    private void saveConstraintsState() {
        ConstraintInfo[] constraintsInfo = new ConstraintInfo[this.m_constraints.size()];
        int i = 0;
        Enumeration e = this.m_constraints.keys();
        while (e.hasMoreElements()) {
            Long key = (Long)e.nextElement();
            constraintsInfo[i++] = new ConstraintInfo((ConstraintExp)this.m_constraints.get(key), key.intValue());
        }
        this.m_pssFilter.constraints(constraintsInfo);
    }

    public byte[] getPid() {
        return this.m_pssFilter.get_pid();
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

