/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.impl;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierPOA;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.CosNotifyComm.SequencePushConsumerHelper;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.openorb.notify.ConsumerAdapter;
import org.openorb.notify.ConsumerProxyManagement;
import org.openorb.notify.EventDispatcher;
import org.openorb.notify.EventTranslator;
import org.openorb.notify.Logger;
import org.openorb.notify.PersistenceManagement;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.Util;
import org.openorb.notify.impl.ConsumerAdminImpl;
import org.openorb.notify.persistence.Event;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.ProxySupplier;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.notify.queue.EventQueueFactory;
import org.openorb.notify.queue.FilterableEventQueue;
import org.openorb.notify.queue.Pusher;

public class SequenceProxyPushSupplierImpl
extends SequenceProxyPushSupplierPOA
implements EventDispatcher,
ConsumerProxyManagement,
PersistenceManagement {
    private ProxySupplier m_pssProxySupplier;
    private ConsumerAdminImpl m_consumerAdmin;
    private FilterableEventQueue m_queue;
    private Pusher m_pusher;
    private PropertiesRepository m_propertiesRepository;
    private Logger m_logger;

    public SequenceProxyPushSupplierImpl(ConsumerAdminImpl consumerAdmin, int pushSupplierId, int adminId, Property[] qosProperties, Logger logger) {
        this.m_propertiesRepository = new PropertiesRepository(qosProperties);
        this.m_pssProxySupplier = PersistenceRepository.getProxySupplierHome(this.m_propertiesRepository.isConnectionReliable()).create(pushSupplierId, adminId, ProxyType.PUSH_SEQUENCE, null, false, qosProperties, new ReferenceInfo[0], new ReferenceInfo[2], 0, new EventTypeInfo[0]);
        this.m_consumerAdmin = consumerAdmin;
        this.m_logger = logger;
        this.configureQueue();
        this.configurePusher();
    }

    public SequenceProxyPushSupplierImpl(ConsumerAdminImpl consumerAdmin, ProxySupplier pssProxySupplier, Logger logger) {
        this.m_consumerAdmin = consumerAdmin;
        this.m_pssProxySupplier = pssProxySupplier;
        this.m_propertiesRepository = new PropertiesRepository(pssProxySupplier.qos_properties());
        this.m_logger = logger;
        this.configureQueue();
        this.configurePusher();
        this.recoverConnections();
    }

    private void recoverConnections() {
        if (this.m_pssProxySupplier.connected_consumer() != null) {
            SequencePushConsumer consumer = SequencePushConsumerHelper.narrow(this.m_pssProxySupplier.connected_consumer());
            this.m_pusher.setConsumer(new SequenceConsumerAdapter(consumer, this.m_consumerAdmin.getORB()));
            this.m_pusher.setPropertiesRepository(this.m_propertiesRepository);
            if (this.m_pssProxySupplier.is_connected()) {
                this.m_pusher.setConnectionActive(true);
            }
        }
        ReferenceInfo[] filters = this.m_pssProxySupplier.filters();
        int i = 0;
        while (i < filters.length) {
            this.m_queue.addFilter(FilterHelper.narrow(filters[i].reference));
            ++i;
        }
    }

    private void configureQueue() {
        this.m_queue = EventQueueFactory.createSupplierProxyQueue("[S SEQPUSH] " + this.getId(), this.m_propertiesRepository, this.m_consumerAdmin.isEventQueueLogged(), this.m_consumerAdmin.isFilterEvaluationLogged(), this.getLogger().getChildLogger("queue"));
    }

    private void configurePusher() {
        this.m_pusher = new Pusher("[S SEQPUSH] " + this.getId(), this.m_queue, this, this.m_consumerAdmin._orb(), this.getLogger());
        this.m_pusher.setPropertiesRepository(this.m_propertiesRepository);
        if (this.m_consumerAdmin.isProxyMaxPerformance()) {
            this.m_pusher.startThread();
        }
    }

    public void connect_sequence_push_consumer(SequencePushConsumer push_consumer) throws AlreadyConnected, TypeError {
        if (this.m_pssProxySupplier.connected_consumer() != null) {
            throw new AlreadyConnected();
        }
        if (push_consumer == null) {
            throw new BAD_PARAM();
        }
        this.m_pssProxySupplier.connected_consumer(push_consumer);
        this.m_pssProxySupplier.is_connected(true);
        this.m_pusher.setConsumer(new SequenceConsumerAdapter(push_consumer, this.m_consumerAdmin.getORB()));
        this.m_pusher.setConnectionActive(true);
    }

    public void suspend_connection() throws ConnectionAlreadyInactive, NotConnected {
        if (this.m_pssProxySupplier.connected_consumer() == null) {
            throw new NotConnected();
        }
        if (!this.m_pssProxySupplier.is_connected()) {
            throw new ConnectionAlreadyInactive();
        }
        this.m_pssProxySupplier.is_connected(false);
        this.m_pusher.setConnectionActive(false);
    }

    public void resume_connection() throws ConnectionAlreadyActive, NotConnected {
        if (this.m_pssProxySupplier.connected_consumer() == null) {
            throw new NotConnected();
        }
        if (this.m_pssProxySupplier.is_connected()) {
            throw new ConnectionAlreadyActive();
        }
        this.m_pssProxySupplier.is_connected(true);
        this.m_pusher.setConnectionActive(true);
    }

    public ProxyType MyType() {
        return this.m_pssProxySupplier.type();
    }

    public ConsumerAdmin MyAdmin() {
        return this.m_consumerAdmin._this();
    }

    public MappingFilter priority_filter() {
        try {
            return MappingFilterHelper.narrow(this.m_pssProxySupplier.mapping_filters()[1].reference);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public void priority_filter(MappingFilter value) {
        ProxySupplier proxySupplier = this.m_pssProxySupplier;
        synchronized (proxySupplier) {
            ReferenceInfo[] mapping_filters = this.m_pssProxySupplier.mapping_filters();
            if (mapping_filters[1] == null) {
                mapping_filters[1] = new ReferenceInfo();
            }
            mapping_filters[1].id = 1;
            mapping_filters[1].reference = value;
            this.m_pssProxySupplier.mapping_filters(mapping_filters);
        }
    }

    public MappingFilter lifetime_filter() {
        try {
            return MappingFilterHelper.narrow(this.m_pssProxySupplier.mapping_filters()[0].reference);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public void lifetime_filter(MappingFilter value) {
        ProxySupplier proxySupplier = this.m_pssProxySupplier;
        synchronized (proxySupplier) {
            ReferenceInfo[] mapping_filters = this.m_pssProxySupplier.mapping_filters();
            if (mapping_filters[0] == null) {
                mapping_filters[0] = new ReferenceInfo();
            }
            mapping_filters[0].id = 0;
            mapping_filters[0].reference = value;
            this.m_pssProxySupplier.mapping_filters(mapping_filters);
        }
    }

    public EventType[] obtain_offered_types(ObtainInfoMode mode) {
        throw new NO_IMPLEMENT();
    }

    public void validate_event_qos(Property[] required_qos, NamedPropertyRangeSeqHolder available_qos) throws UnsupportedQoS {
        throw new NO_IMPLEMENT();
    }

    public void disconnect_sequence_push_supplier() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getId() + "Proxy disconnected and destroyed.");
        }
        this.m_pusher.finishWorkAndStopThread();
        this.m_consumerAdmin.reportPushConsumerDisconnection(this.m_pssProxySupplier.get_pid());
        try {
            this.m_consumerAdmin.getPOA().deactivate_object(this.getPid());
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy wrongPolicy) {
            // empty catch block
        }
        this.m_pssProxySupplier.destroy_object();
    }

    public void subscription_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Event types subscribe modified.");
        }
        EventTypeInfo[] eventTypes = this.m_pssProxySupplier.event_types();
        EventType[] validatedAdd = new EventType[]{};
        EventType[] validatedRemove = new EventType[]{};
        EventTypeInfo[] addedEventTypes = new EventTypeInfo[eventTypes.length + validatedAdd.length];
        int i = 0;
        while (i < eventTypes.length) {
            addedEventTypes[i] = eventTypes[i];
            ++i;
        }
        int i2 = eventTypes.length;
        while (i2 < validatedAdd.length) {
            addedEventTypes[i2] = new EventTypeInfo(validatedAdd[i2], 1);
            ++i2;
        }
        EventTypeInfo[] removedEventTypes = new EventTypeInfo[addedEventTypes.length - validatedRemove.length];
        int j = 0;
        int i3 = 0;
        while (i3 < addedEventTypes.length) {
            if (!Util.isMatchingEventType(addedEventTypes[i3].event_type, validatedRemove)) {
                removedEventTypes[j++] = addedEventTypes[i3];
            }
            ++i3;
        }
        this.m_pssProxySupplier.event_types(removedEventTypes);
    }

    public Property[] get_qos() {
        return this.m_pssProxySupplier.qos_properties();
    }

    public void set_qos(Property[] qos) throws UnsupportedQoS {
        this.m_pssProxySupplier.qos_properties(qos);
    }

    public void validate_qos(Property[] required_qos, NamedPropertyRangeSeqHolder available_qos) throws UnsupportedQoS {
        throw new NO_IMPLEMENT();
    }

    public synchronized int add_filter(Filter new_filter) {
        if (new_filter == null) {
            return -1;
        }
        ProxySupplier proxySupplier = this.m_pssProxySupplier;
        synchronized (proxySupplier) {
            ReferenceInfo[] filters = this.m_pssProxySupplier.filters();
            if (this.m_queue.addFilter(new_filter)) {
                ReferenceInfo[] new_filters = new ReferenceInfo[filters.length + 1];
                int i = 0;
                while (i < filters.length) {
                    new_filters[i] = filters[i];
                    ++i;
                }
                int filterId = this.m_pssProxySupplier.next_filter_id();
                new_filters[filters.length] = new ReferenceInfo(filterId, new_filter);
                this.m_pssProxySupplier.next_filter_id(filterId + 1);
                this.m_pssProxySupplier.filters(new_filters);
                int n = filterId;
                return n;
            }
            int i = 0;
            while (i < filters.length) {
                if (filters[i].reference.equals(new_filter)) {
                    int n = filters[i].id;
                    return n;
                }
                ++i;
            }
            int n = -1;
            return n;
        }
    }

    public synchronized void remove_filter(int filter) throws FilterNotFound {
        ProxySupplier proxySupplier = this.m_pssProxySupplier;
        synchronized (proxySupplier) {
            ReferenceInfo[] filters = this.m_pssProxySupplier.filters();
            ReferenceInfo[] new_filters = new ReferenceInfo[filters.length - 1];
            int i = 0;
            while (i < filters.length) {
                if (filters[i].id == filter) {
                    int j = i;
                    while (j < new_filters.length) {
                        new_filters[j] = filters[j + 1];
                        ++j;
                    }
                    this.m_pssProxySupplier.filters(new_filters);
                    this.m_queue.removeFilter(FilterHelper.narrow(filters[i].reference));
                    return;
                }
                new_filters[i] = filters[i];
                ++i;
            }
            throw new FilterNotFound();
        }
    }

    public Filter get_filter(int filter) throws FilterNotFound {
        ProxySupplier proxySupplier = this.m_pssProxySupplier;
        synchronized (proxySupplier) {
            ReferenceInfo[] filters = this.m_pssProxySupplier.filters();
            int i = 0;
            while (i < filters.length) {
                if (filters[i].id == filter) {
                    Filter filter2 = FilterHelper.narrow(filters[i].reference);
                    return filter2;
                }
                ++i;
            }
            throw new FilterNotFound();
        }
    }

    public int[] get_all_filters() {
        ProxySupplier proxySupplier = this.m_pssProxySupplier;
        synchronized (proxySupplier) {
            ReferenceInfo[] filters = this.m_pssProxySupplier.filters();
            int[] result = new int[filters.length];
            int i = 0;
            while (i < result.length) {
                result[i] = filters[i].id;
                ++i;
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public void remove_all_filters() {
        ProxySupplier proxySupplier = this.m_pssProxySupplier;
        synchronized (proxySupplier) {
            this.m_queue.removeAllFilters();
            this.m_pssProxySupplier.filters(new ReferenceInfo[0]);
        }
    }

    public void dispatchEvent(Object event) {
        if (this.m_pssProxySupplier.connected_consumer() != null) {
            this.m_pusher.pushEvent(event);
        } else {
            this.reportEventDelivery(event.hashCode());
        }
    }

    public String getId() {
        return this.m_consumerAdmin.getId() + "[" + this.m_pssProxySupplier.id() + "]";
    }

    public void reportEventDelivery(int eventPid) {
        this.m_consumerAdmin.reportEventDelivery(this.m_pssProxySupplier.id(), eventPid);
    }

    public void reportClientDisconnection() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Client sent an unexpected Disconnected exception.");
        }
        this.disconnect_sequence_push_supplier();
    }

    public byte[] getPid() {
        return this.m_pssProxySupplier.get_pid();
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger.getSProxyLogger();
    }

    private static final class SequenceConsumerAdapter
    implements ConsumerAdapter {
        private SequencePushConsumer m_underlying;
        private ORB m_orb;

        private SequenceConsumerAdapter(SequencePushConsumer consumer, ORB orb) {
            this.m_underlying = consumer;
            this.m_orb = orb;
        }

        public void push(Event event) throws Disconnected {
            StructuredEvent[] batch = new StructuredEvent[1];
            switch (event.event_type()) {
                case 0: {
                    batch[0] = event.event_data().structured_event();
                    break;
                }
                case 1: {
                    batch[0] = EventTranslator.translateAnyToStructured(event.event_data().any_event());
                    break;
                }
                default: {
                    batch[0] = EventTranslator.translateTypedToStructured(event.event_data().typed_event(), this.m_orb);
                }
            }
            this.m_underlying.push_structured_events(batch);
        }

        public void disconnect() {
            this.m_underlying.disconnect_sequence_push_consumer();
        }
    }
}

