/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.impl;

import java.util.Arrays;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.ProxyPullConsumer;
import org.omg.CosEventChannelAdmin.ProxyPullConsumerHelper;
import org.omg.CosEventChannelAdmin.ProxyPushConsumer;
import org.omg.CosEventChannelAdmin.ProxyPushConsumerHelper;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.ProxyConsumerHelper;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPullConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushConsumerHelper;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerHelper;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdminPOA;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.notify.EventReceiver;
import org.openorb.notify.Logger;
import org.openorb.notify.PersistenceManagement;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.SupplierAdminManagement;
import org.openorb.notify.Util;
import org.openorb.notify.impl.EventChannelImpl;
import org.openorb.notify.impl.ProxyPullConsumerImpl;
import org.openorb.notify.impl.ProxyPushConsumerImpl;
import org.openorb.notify.impl.SequenceProxyPullConsumerImpl;
import org.openorb.notify.impl.SequenceProxyPushConsumerImpl;
import org.openorb.notify.impl.StructuredProxyPullConsumerImpl;
import org.openorb.notify.impl.StructuredProxyPushConsumerImpl;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.notify.persistence.SupplierAdmin;
import org.openorb.notify.queue.EventQueueDispatcher;
import org.openorb.notify.queue.EventQueueFactory;
import org.openorb.notify.queue.FilterableEventQueue;

public class SupplierAdminImpl
extends SupplierAdminPOA
implements EventReceiver,
SupplierAdminManagement,
PersistenceManagement {
    private final ORB m_orb;
    private final POA m_poa;
    private final SupplierAdmin m_pssSupplierAdmin;
    private final EventChannelImpl m_channel;
    private final FilterableEventQueue m_queue;
    private final EventQueueDispatcher m_dispatcher;
    private final PropertiesRepository m_propertiesRepository;
    private final Logger m_logger;
    private boolean m_destroyed;

    public SupplierAdminImpl(EventChannelImpl channel, ORB orb, POA poa, InterFilterGroupOperator operator, int adminId, int channelId, Property[] qosProperties, Logger logger) {
        this(orb, poa, logger, channel, qosProperties, operator, adminId, channelId, new PropertiesRepository(qosProperties));
    }

    private SupplierAdminImpl(ORB orb, POA poa, Logger logger, EventChannelImpl channel, Property[] qosProperties, InterFilterGroupOperator operator, int adminId, int channelId, PropertiesRepository propertiesRepository) {
        this(orb, poa, logger, channel, SupplierAdminImpl.createSupplierAdmin(propertiesRepository, operator, adminId, channelId, qosProperties), propertiesRepository);
    }

    public SupplierAdminImpl(EventChannelImpl channel, SupplierAdmin pssSupplierAdmin, POA poa, Logger logger) {
        this(channel._orb(), poa, logger, channel, pssSupplierAdmin, new PropertiesRepository(pssSupplierAdmin.qos_properties()));
    }

    private SupplierAdminImpl(ORB orb, POA poa, Logger logger, EventChannelImpl channel, SupplierAdmin pssSupplierAdmin, PropertiesRepository propertiesRepository) {
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_logger = logger;
        this.m_propertiesRepository = propertiesRepository;
        this.m_channel = channel;
        this.m_pssSupplierAdmin = pssSupplierAdmin;
        this.m_queue = this.configureQueue();
        this.m_dispatcher = this.configureDispatcher();
    }

    private static SupplierAdmin createSupplierAdmin(PropertiesRepository propertiesRepository, InterFilterGroupOperator operator, int supplierAdminId, int channelId, Property[] qosProperties) {
        ConnectionInfo[] connectionInfo = new ConnectionInfo[]{};
        ReferenceInfo[] referenceInfo = new ReferenceInfo[]{};
        EventTypeInfo[] eventTypeInfo = new EventTypeInfo[]{};
        return PersistenceRepository.getSupplierAdminHome(propertiesRepository.isConnectionReliable()).create(supplierAdminId, channelId, operator, qosProperties, connectionInfo, connectionInfo, 0, 0, referenceInfo, referenceInfo, 0, eventTypeInfo);
    }

    private FilterableEventQueue configureQueue() {
        return EventQueueFactory.createAdminQueue("[SA] " + this.getId(), this.m_propertiesRepository, this.m_channel.isEventQueueLogged(), this.m_channel.isFilterEvaluationLogged(), this.getLogger().getChildLogger("queue"));
    }

    private EventQueueDispatcher configureDispatcher() {
        EventQueueDispatcher dispatcher = new EventQueueDispatcher("[SA] " + this.getId(), this.m_queue, this.m_channel, this.getLogger());
        if (this.m_channel.isSupplierAdminMaxPerformance()) {
            dispatcher.startThread();
        }
        return dispatcher;
    }

    public int MyID() {
        return this.m_pssSupplierAdmin.id();
    }

    public EventChannel MyChannel() {
        return this.m_channel._this();
    }

    public InterFilterGroupOperator MyOperator() {
        return this.m_pssSupplierAdmin.filter_operator();
    }

    private int[] extractIds(ConnectionInfo[] connections) {
        int idCount = 0;
        int i = 0;
        while (i < connections.length) {
            if (-1 != connections[i].id) {
                ++idCount;
            }
            ++i;
        }
        int[] ids = new int[idCount];
        int i2 = 0;
        int j = 0;
        while (i2 < connections.length) {
            if (-1 != connections[i2].id) {
                ids[j++] = connections[i2].id;
            }
            ++i2;
        }
        return ids;
    }

    public int[] pull_consumers() {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            int[] nArray = this.extractIds(this.m_pssSupplierAdmin.pull_consumers());
            return nArray;
        }
    }

    public int[] push_consumers() {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            int[] nArray = this.extractIds(this.m_pssSupplierAdmin.push_consumers());
            return nArray;
        }
    }

    public ProxyConsumer get_proxy_consumer(int proxyId) throws ProxyNotFound {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            if (proxyId < 0) {
                throw new ProxyNotFound();
            }
            ConnectionInfo[] pullConsumers = this.m_pssSupplierAdmin.pull_consumers();
            int i = 0;
            while (i < pullConsumers.length) {
                if (proxyId == pullConsumers[i].id) {
                    ProxyConsumer proxyConsumer = ProxyConsumerHelper.narrow(pullConsumers[i].reference);
                    return proxyConsumer;
                }
                ++i;
            }
            ConnectionInfo[] pushConsumers = this.m_pssSupplierAdmin.push_consumers();
            int i2 = 0;
            while (i2 < pushConsumers.length) {
                if (proxyId == pushConsumers[i2].id) {
                    ProxyConsumer proxyConsumer = ProxyConsumerHelper.narrow(pushConsumers[i2].reference);
                    return proxyConsumer;
                }
                ++i2;
            }
            throw new ProxyNotFound();
        }
    }

    public ProxyConsumer obtain_notification_pull_consumer(ClientType ctype, IntHolder proxy_id) throws AdminLimitExceeded {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            Servant newPullConsumer;
            switch (ctype.value()) {
                case 1: {
                    proxy_id.value = this.m_pssSupplierAdmin.next_pull_consumer_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " StructuredPullConsumer created with id " + proxy_id.value + ".");
                    }
                    newPullConsumer = new StructuredProxyPullConsumerImpl(this, proxy_id.value, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 2: {
                    proxy_id.value = this.m_pssSupplierAdmin.next_pull_consumer_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " SequencePullConsumer created with id " + proxy_id.value + ".");
                    }
                    newPullConsumer = new SequenceProxyPullConsumerImpl(this, proxy_id.value, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 0: {
                    proxy_id.value = this.m_pssSupplierAdmin.next_pull_consumer_id();
                    this.getLogger().debug(this.getId() + " AnyPullConsumer created with id " + proxy_id.value + ".");
                    newPullConsumer = new ProxyPullConsumerImpl(this, proxy_id.value, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
                    break;
                }
                default: {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " PullConsumer was not created due to unsupported type.");
                    }
                    throw new AdminLimitExceeded();
                }
            }
            try {
                byte[] pid = ((PersistenceManagement)newPullConsumer).getPid();
                this.m_poa.activate_object_with_id(pid, newPullConsumer);
                this.reportSupplierConnection();
                ConnectionInfo[] consumers = this.m_pssSupplierAdmin.pull_consumers();
                ConnectionInfo[] newConsumers = new ConnectionInfo[consumers.length + 1];
                System.arraycopy(consumers, 0, newConsumers, 0, consumers.length);
                newConsumers[consumers.length] = new ConnectionInfo(proxy_id.value, pid, this.m_poa.id_to_reference(pid));
                this.m_pssSupplierAdmin.next_pull_consumer_id(proxy_id.value + 1);
                this.m_pssSupplierAdmin.pull_consumers(newConsumers);
                ProxyConsumer proxyConsumer = ProxyConsumerHelper.narrow(this.m_poa.id_to_reference(pid));
                return proxyConsumer;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxyConsumer consumers = null;
                return consumers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public ProxyConsumer obtain_notification_push_consumer(ClientType ctype, IntHolder proxy_id) throws AdminLimitExceeded {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            Servant newPushConsumer;
            switch (ctype.value()) {
                case 1: {
                    proxy_id.value = this.m_pssSupplierAdmin.next_push_consumer_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " StructuredPushConsumer created with id " + proxy_id.value + ".");
                    }
                    newPushConsumer = new StructuredProxyPushConsumerImpl(this, proxy_id.value, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 2: {
                    proxy_id.value = this.m_pssSupplierAdmin.next_push_consumer_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " SequencePushConsumer created with id " + proxy_id.value + ".");
                    }
                    newPushConsumer = new SequenceProxyPushConsumerImpl(this, proxy_id.value, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
                    break;
                }
                case 0: {
                    proxy_id.value = this.m_pssSupplierAdmin.next_push_consumer_id();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " AnyPushConsumer created with id " + proxy_id.value + ".");
                    }
                    newPushConsumer = new ProxyPushConsumerImpl(this, proxy_id.value, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
                    break;
                }
                default: {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.getId() + " PushConsumer was not created due to unsupported type.");
                    }
                    throw new AdminLimitExceeded();
                }
            }
            try {
                byte[] pid = ((PersistenceManagement)newPushConsumer).getPid();
                this.m_poa.activate_object_with_id(pid, newPushConsumer);
                this.reportSupplierConnection();
                ConnectionInfo[] consumers = this.m_pssSupplierAdmin.push_consumers();
                ConnectionInfo[] newConsumers = new ConnectionInfo[consumers.length + 1];
                System.arraycopy(consumers, 0, newConsumers, 0, consumers.length);
                newConsumers[consumers.length] = new ConnectionInfo(proxy_id.value, pid, this.m_poa.id_to_reference(pid));
                this.m_pssSupplierAdmin.next_push_consumer_id(proxy_id.value + 1);
                this.m_pssSupplierAdmin.push_consumers(newConsumers);
                ProxyConsumer proxyConsumer = ProxyConsumerHelper.narrow(this.m_poa.id_to_reference(pid));
                return proxyConsumer;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxyConsumer consumers = null;
                return consumers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public synchronized void destroy() {
        if (this.m_destroyed) {
            return;
        }
        this.m_destroyed = true;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting proxies.");
        }
        this.disconnectPullConsumers();
        this.disconnectPushConsumers();
        this.m_dispatcher.stopThread();
        this.m_channel.reportSupplierAdminDestruction(this.m_pssSupplierAdmin.get_pid());
        try {
            this.m_poa.deactivate_object(this.getPid());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_pssSupplierAdmin.destroy_object();
    }

    private void disconnectPullConsumers() {
        ConnectionInfo[] consumers = this.m_pssSupplierAdmin.pull_consumers();
        int i = 0;
        while (i < consumers.length) {
            ConnectionInfo consumer = consumers[i];
            try {
                if (consumer.reference._is_a(StructuredProxyPullConsumerHelper.id())) {
                    StructuredProxyPullConsumerHelper.narrow(consumer.reference).disconnect_structured_pull_consumer();
                } else if (consumer.reference._is_a(SequenceProxyPullConsumerHelper.id())) {
                    SequenceProxyPullConsumerHelper.narrow(consumer.reference).disconnect_sequence_pull_consumer();
                } else if (consumer.reference._is_a(ProxyPullConsumerHelper.id())) {
                    ProxyPullConsumerHelper.narrow(consumer.reference).disconnect_pull_consumer();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
    }

    private void disconnectPushConsumers() {
        ConnectionInfo[] consumers = this.m_pssSupplierAdmin.push_consumers();
        int i = 0;
        while (i < consumers.length) {
            ConnectionInfo consumer = consumers[i];
            try {
                if (consumer.reference._is_a(StructuredProxyPushConsumerHelper.id())) {
                    StructuredProxyPushConsumerHelper.narrow(consumer.reference).disconnect_structured_push_consumer();
                } else if (consumer.reference._is_a(SequenceProxyPushConsumerHelper.id())) {
                    SequenceProxyPushConsumerHelper.narrow(consumer.reference).disconnect_sequence_push_consumer();
                } else if (consumer.reference._is_a(ProxyPullConsumerHelper.id())) {
                    ProxyPushConsumerHelper.narrow(consumer.reference).disconnect_push_consumer();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
    }

    public Property[] get_qos() {
        return this.m_pssSupplierAdmin.qos_properties();
    }

    public void set_qos(Property[] qos) throws UnsupportedQoS {
        throw new NO_IMPLEMENT();
    }

    public void validate_qos(Property[] required_qos, NamedPropertyRangeSeqHolder available_qos) throws UnsupportedQoS {
        throw new NO_IMPLEMENT();
    }

    public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Event types publish modified.");
        }
        EventTypeInfo[] typesToUse = Util.addRemoveEventTypes(this.m_pssSupplierAdmin.event_types(), added, removed);
        this.m_pssSupplierAdmin.event_types(typesToUse);
    }

    public int add_filter(Filter new_filter) {
        if (null == new_filter) {
            return -1;
        }
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            ReferenceInfo[] filters = this.m_pssSupplierAdmin.filters();
            if (this.m_queue.addFilter(new_filter)) {
                ReferenceInfo[] newFilters = new ReferenceInfo[filters.length + 1];
                System.arraycopy(filters, 0, newFilters, 0, filters.length);
                int filterId = this.m_pssSupplierAdmin.next_filter_id();
                newFilters[filters.length] = new ReferenceInfo(filterId, new_filter);
                this.m_pssSupplierAdmin.next_filter_id(filterId + 1);
                this.m_pssSupplierAdmin.filters(newFilters);
                int n = filterId;
                return n;
            }
            int i = 0;
            while (i < filters.length) {
                if (filters[i].reference.equals(new_filter)) {
                    int n = filters[i].id;
                    return n;
                }
                ++i;
            }
            int n = -1;
            return n;
        }
    }

    public void remove_filter(int filterId) throws FilterNotFound {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            ReferenceInfo[] filters = this.m_pssSupplierAdmin.filters();
            if (0 == filters.length) {
                throw new FilterNotFound();
            }
            int i = 0;
            while (i < filters.length) {
                if (filterId == filters[i].id) {
                    ReferenceInfo[] newFilters = new ReferenceInfo[filters.length - 1];
                    System.arraycopy(filters, 0, newFilters, 0, i);
                    System.arraycopy(filters, i + 1, newFilters, i, newFilters.length - i);
                    this.m_pssSupplierAdmin.filters(newFilters);
                    this.m_queue.removeFilter(FilterHelper.narrow(filters[i].reference));
                    return;
                }
                ++i;
            }
            throw new FilterNotFound();
        }
    }

    public Filter get_filter(int filterId) throws FilterNotFound {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            ReferenceInfo[] filters = this.m_pssSupplierAdmin.filters();
            int i = 0;
            while (i < filters.length) {
                if (filterId == filters[i].id) {
                    Filter filter = FilterHelper.narrow(filters[i].reference);
                    return filter;
                }
                ++i;
            }
            throw new FilterNotFound();
        }
    }

    public int[] get_all_filters() {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            ReferenceInfo[] filters = this.m_pssSupplierAdmin.filters();
            int[] result = new int[filters.length];
            int i = 0;
            while (i < result.length) {
                result[i] = filters[i].id;
                ++i;
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public void remove_all_filters() {
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            this.m_queue.removeAllFilters();
            this.m_pssSupplierAdmin.filters(new ReferenceInfo[0]);
        }
    }

    public ProxyPushConsumer obtain_push_consumer() {
        int id = -1;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getId() + " EventAnyPushConsumer created with id " + -1 + ".");
        }
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            ProxyPushConsumerImpl newPushConsumer = new ProxyPushConsumerImpl(this, -1, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
            try {
                this.m_poa.activate_object_with_id(newPushConsumer.getPid(), (Servant)newPushConsumer);
                ConnectionInfo[] consumers = this.m_pssSupplierAdmin.push_consumers();
                ConnectionInfo[] newConsumers = new ConnectionInfo[consumers.length + 1];
                System.arraycopy(consumers, 0, newConsumers, 0, consumers.length);
                newConsumers[consumers.length] = new ConnectionInfo(-1, newPushConsumer.getPid(), this.m_poa.id_to_reference(newPushConsumer.getPid()));
                this.m_pssSupplierAdmin.push_consumers(newConsumers);
                ProxyPushConsumer proxyPushConsumer = ProxyPushConsumerHelper.narrow(this.m_poa.id_to_reference(newPushConsumer.getPid()));
                return proxyPushConsumer;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxyPushConsumer newConsumers = null;
                return newConsumers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public ProxyPullConsumer obtain_pull_consumer() {
        int id = -1;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getId() + " EventAnyPullConsumer created with id " + -1 + ".");
        }
        SupplierAdmin supplierAdmin = this.m_pssSupplierAdmin;
        synchronized (supplierAdmin) {
            ProxyPullConsumerImpl newPullConsumer = new ProxyPullConsumerImpl(this, -1, this.MyID(), this.m_pssSupplierAdmin.qos_properties(), this.m_logger);
            try {
                this.m_poa.activate_object_with_id(newPullConsumer.getPid(), (Servant)newPullConsumer);
                ConnectionInfo[] consumers = this.m_pssSupplierAdmin.pull_consumers();
                ConnectionInfo[] newConsumers = new ConnectionInfo[consumers.length + 1];
                System.arraycopy(consumers, 0, newConsumers, 0, consumers.length);
                newConsumers[consumers.length] = new ConnectionInfo(-1, newPullConsumer.getPid(), this.m_poa.id_to_reference(newPullConsumer.getPid()));
                this.m_pssSupplierAdmin.pull_consumers(newConsumers);
                ProxyPullConsumer proxyPullConsumer = ProxyPullConsumerHelper.narrow(this.m_poa.id_to_reference(newPullConsumer.getPid()));
                return proxyPullConsumer;
            }
            catch (Exception ex) {
                this.getLogger().error("Unexpected exception.", ex);
                ProxyPullConsumer newConsumers = null;
                return newConsumers;
            }
            catch (Error ex) {
                this.getLogger().error("Unexpected error - rethrowing.", ex);
                throw ex;
            }
        }
    }

    public void receiveEvent(Object event) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getId() + " Event received from proxy.");
        }
        this.m_dispatcher.pushEvent(event);
    }

    public String getId() {
        return this.m_channel.getId() + "[" + this.m_pssSupplierAdmin.id() + "]";
    }

    public POA getPOA() {
        return this.m_poa;
    }

    public void reportSupplierConnection() {
        this.m_channel.reportSupplierConnection();
    }

    public boolean canConnectSupplier() {
        return this.m_channel.canConnectSupplier();
    }

    private int findIndex(ConnectionInfo[] info, byte[] pid) {
        int i = 0;
        while (i < info.length) {
            if (Arrays.equals(info[i].pid, pid)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ConnectionInfo[] removeIndex(ConnectionInfo[] info, int index) {
        ConnectionInfo[] newInfo = new ConnectionInfo[info.length - 1];
        System.arraycopy(info, 0, newInfo, 0, index);
        System.arraycopy(info, index + 1, newInfo, index, newInfo.length - index);
        return newInfo;
    }

    public void reportPullSupplierDisconnection(byte[] proxyPid) {
        ConnectionInfo[] consumers;
        int index;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting pull proxy.");
        }
        if (-1 == (index = this.findIndex(consumers = this.m_pssSupplierAdmin.pull_consumers(), proxyPid))) {
            return;
        }
        this.m_pssSupplierAdmin.pull_consumers(this.removeIndex(consumers, index));
        this.m_channel.reportSupplierDisconnection();
    }

    public void reportPushSupplierDisconnection(byte[] proxyPid) {
        ConnectionInfo[] consumers;
        int index;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.getId() + " Disconnecting push proxy.");
        }
        if (-1 == (index = this.findIndex(consumers = this.m_pssSupplierAdmin.push_consumers(), proxyPid))) {
            return;
        }
        this.m_pssSupplierAdmin.push_consumers(this.removeIndex(consumers, index));
        this.m_channel.reportSupplierDisconnection();
    }

    public boolean canDispatchNewEvent() {
        return this.m_channel.canDispatchNewEvent();
    }

    public boolean isEventQueueLogged() {
        return this.m_channel.isEventQueueLogged();
    }

    public boolean isFilterEvaluationLogged() {
        return this.m_channel.isFilterEvaluationLogged();
    }

    public boolean isQueueMaxPerformance() {
        return this.m_channel.isQueueMaxPerformance();
    }

    public boolean isProxyMaxPerformance() {
        return this.m_channel.isSupplierProxyMaxPerformance();
    }

    public Object getNotifyProperty(String key) {
        return this.m_channel.getNotifyProperty(key);
    }

    public byte[] getPid() {
        return this.m_pssSupplierAdmin.get_pid();
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger.getSAdminLogger();
    }
}

