/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import java.util.Vector;
import memory.org.openorb.notify.persistence.EventBase;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.persistence.Event;
import org.openorb.notify.persistence.EventData;
import org.openorb.notify.persistence.EventHome;
import org.openorb.notify.queue.DefaultEventQueue;
import org.openorb.notify.queue.FilterableEventQueue;

public class ConsumerProxyQueue
extends DefaultEventQueue
implements FilterableEventQueue {
    private EventHome m_pssEventHome;
    private Vector m_filters = new Vector();
    private String m_id;
    private boolean m_isPerformance;
    private Short m_priority;
    private Long m_deadline;
    private boolean m_isEventsLogged = false;
    private boolean m_isFiltersEvaluationLogged = false;
    private final Logger m_logger;
    private final Logger m_filterLogger;

    public ConsumerProxyQueue(String id, int orderPolicy, boolean isPersistent, short priority, long deadline, boolean isPerformance, Logger logger) {
        super(orderPolicy);
        this.m_pssEventHome = PersistenceRepository.getEventHome(isPersistent);
        this.m_id = id;
        this.m_isPerformance = isPerformance;
        this.m_priority = new Short(priority);
        this.m_deadline = new Long(deadline);
        this.m_logger = logger;
        this.m_filterLogger = this.m_logger.getChildLogger("filter");
        String orderString = "FifoOrder";
        if (orderPolicy == 2) {
            orderString = "PriorityOrder";
        } else if (orderPolicy == 3) {
            orderString = "DeadlineOrder";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.m_id + " Queue created with order " + orderString + ".");
        }
    }

    void setEventLogged(boolean isEventsLogged) {
        this.m_isEventsLogged = isEventsLogged;
    }

    void setFiltersEvaluationLogged(boolean isFiltersEvaluationLogged) {
        this.m_isFiltersEvaluationLogged = isFiltersEvaluationLogged;
    }

    public boolean pushEvent(Object event) {
        if (event instanceof Any) {
            return this.persistAndPushEvent((Any)event);
        }
        if (event instanceof StructuredEvent) {
            return this.persistAndPushEvent((StructuredEvent)event);
        }
        if (event instanceof Property[]) {
            return this.persistAndPushEvent((Property[])event);
        }
        return false;
    }

    public Object pullEvent() {
        Object event = super.pullEvent();
        if (this.m_isEventsLogged && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.m_id + " Event transmitted to supplier admin (queue size=" + super.getQueueSize() + ").");
        }
        if (event instanceof EventBase) {
            ((EventBase)event).destroy_object();
        } else if (event instanceof file.org.openorb.notify.persistence.EventBase) {
            ((EventBase)event).destroy_object();
        } else if (event instanceof database.org.openorb.notify.persistence.EventBase) {
            ((EventBase)event).destroy_object();
        }
        return event;
    }

    public synchronized boolean persistAndPushEvent(Any event) {
        if (this.filterAndPushEvent(event)) {
            EventData data = new EventData();
            data.any_event(event);
            Event pssEvent = PersistenceRepository.getEventHome(false).create((short)1, this.m_priority, this.m_deadline, data);
            if (this.m_isPerformance) {
                super.pushEvent(pssEvent, this.m_priority, this.m_deadline);
            } else {
                super.pushEvent(new String(pssEvent.get_short_pid()), this.m_priority, this.m_deadline);
            }
            if (this.m_isEventsLogged && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.m_id + " Any event received from supplier (queue size=" + super.getQueueSize() + ").");
            }
            return true;
        }
        return false;
    }

    public synchronized boolean persistAndPushEvent(StructuredEvent event) {
        if (this.filterAndPushEvent(event)) {
            EventData data = new EventData();
            data.structured_event(event);
            Event pssEvent = PersistenceRepository.getEventHome(false).create((short)0, this.m_priority, this.m_deadline, data);
            if (this.m_isPerformance) {
                super.pushEvent(pssEvent, this.m_priority, this.m_deadline);
            } else {
                super.pushEvent(new String(pssEvent.get_short_pid()), this.m_priority, this.m_deadline);
            }
            if (this.m_isEventsLogged && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.m_id + " Structured event received from supplier (queue size=" + super.getQueueSize() + ").");
            }
            return true;
        }
        return false;
    }

    public synchronized boolean persistAndPushEvent(Property[] event) {
        if (this.filterAndPushEvent(event)) {
            EventData data = new EventData();
            data.typed_event(event);
            Event pssEvent = PersistenceRepository.getEventHome(false).create((short)2, this.m_priority, this.m_deadline, data);
            if (this.m_isPerformance) {
                super.pushEvent(pssEvent, this.m_priority, this.m_deadline);
            } else {
                super.pushEvent(new String(pssEvent.get_short_pid()), this.m_priority, this.m_deadline);
            }
            if (this.m_isEventsLogged && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.m_id + " Typed event received from supplier (queue size=" + super.getQueueSize() + ").");
            }
            return true;
        }
        return false;
    }

    private synchronized boolean filterAndPushEvent(Any event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getFilterLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
                if (i == 0) {
                    this.getFilterLogger().debug(this.m_id + " No filters set. Returned TRUE.");
                } else {
                    this.getFilterLogger().debug(this.m_id + " Filter matching for event returned TRUE.");
                }
            }
            return true;
        }
        if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
            this.getFilterLogger().debug(this.m_id + " Filter matching for event returned FALSE.");
        }
        return false;
    }

    private synchronized boolean filterAndPushEvent(StructuredEvent event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match_structured(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getFilterLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
                if (i == 0) {
                    this.getFilterLogger().debug(this.m_id + " No filters set. Returned TRUE.");
                } else {
                    this.getFilterLogger().debug(this.m_id + " Filter matching for event returned TRUE.");
                }
            }
            return true;
        }
        if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
            this.getFilterLogger().debug(this.m_id + " Filter matching for event returned FALSE.");
        }
        return false;
    }

    private synchronized boolean filterAndPushEvent(Property[] event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match_typed(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getFilterLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
                if (i == 0) {
                    this.getFilterLogger().debug(this.m_id + " No filters set. Returned TRUE.");
                } else {
                    this.getFilterLogger().debug(this.m_id + " Filter matching for event returned TRUE.");
                }
            }
            return true;
        }
        if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
            this.getFilterLogger().debug(this.m_id + " Filter matching for event returned FALSE.");
        }
        return false;
    }

    public boolean addFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            if (this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.addElement(filter);
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " Filter added.");
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean updateFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            if (!this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.addElement(filter);
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " Filter updated.");
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean removeFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            if (!this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.remove(filter);
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " Filter removed.");
            }
            boolean bl = true;
            return bl;
        }
    }

    public void removeAllFilters() {
        Vector vector = this.m_filters;
        synchronized (vector) {
            this.m_filters.clear();
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " All filters removed.");
            }
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private Logger getFilterLogger() {
        return this.m_filterLogger;
    }
}

