/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import org.openorb.notify.queue.DeadlineOrderer;
import org.openorb.notify.queue.EventQueue;
import org.openorb.notify.queue.FifoOrderer;
import org.openorb.notify.queue.Orderer;
import org.openorb.notify.queue.PriorityOrderer;

public class DefaultEventQueue
implements EventQueue {
    private Orderer m_orderer;

    public DefaultEventQueue() {
        this.setOrderPolicy(1);
    }

    public DefaultEventQueue(int orderPolicy) {
        this.setOrderPolicy(orderPolicy);
    }

    public void setOrderPolicy(int orderPolicy) {
        switch (orderPolicy) {
            case 2: {
                this.m_orderer = new PriorityOrderer();
                break;
            }
            case 3: {
                this.m_orderer = new DeadlineOrderer();
                break;
            }
            default: {
                this.m_orderer = new FifoOrderer();
            }
        }
    }

    public boolean pushEvent(Object event) {
        this.m_orderer.pushEvent(event, new Short(0), new Long(0L));
        return true;
    }

    public boolean pushEvent(Object event, Short priorityKey, Long deadlineKey) {
        this.m_orderer.pushEvent(event, priorityKey, deadlineKey);
        return true;
    }

    public Object pullEvent() {
        return this.m_orderer.pullEvent();
    }

    public int getQueueSize() {
        return this.m_orderer.getQueueSize();
    }

    public boolean isEmpty() {
        return this.m_orderer.getQueueSize() == 0;
    }
}

