/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.openorb.notify.queue.DefaultEventQueue;
import org.openorb.notify.queue.FilterableEventQueue;

public class DefaultFilterableEventQueue
extends DefaultEventQueue
implements FilterableEventQueue {
    private Vector m_filters = new Vector();
    private String m_id = "NotInUse";
    private final Logger m_logger;

    public DefaultFilterableEventQueue(Logger logger) {
        this.m_logger = logger;
    }

    public DefaultFilterableEventQueue(int orderPolicy, Logger logger) {
        super(orderPolicy);
        this.m_logger = logger;
    }

    public boolean addFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            if (this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.addElement(filter);
            boolean bl = true;
            return bl;
        }
    }

    public boolean updateFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            if (!this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.addElement(filter);
            boolean bl = true;
            return bl;
        }
    }

    public boolean removeFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            boolean bl = this.m_filters.remove(filter);
            return bl;
        }
    }

    public void removeAllFilters() {
        Vector vector = this.m_filters;
        synchronized (vector) {
            this.m_filters.clear();
        }
    }

    public boolean pushEvent(Object event) {
        if (event instanceof Any) {
            return this.filterAndPushEvent((Any)event);
        }
        if (event instanceof StructuredEvent) {
            return this.filterAndPushEvent((StructuredEvent)event);
        }
        if (event instanceof Property[]) {
            return this.filterAndPushEvent((Property[])event);
        }
        return false;
    }

    public synchronized boolean filterAndPushEvent(Any event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            super.pushEvent(event, null, null);
            return true;
        }
        return false;
    }

    public synchronized boolean filterAndPushEvent(StructuredEvent event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match_structured(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            super.pushEvent(event, null, null);
            return true;
        }
        return false;
    }

    public synchronized boolean filterAndPushEvent(Property[] event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match_typed(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            super.pushEvent(event, null, null);
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

