/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.openorb.notify.persistence.Event;
import org.openorb.notify.queue.EventQueue;

public class EventQueueFilter
extends Thread {
    private Vector m_filters = new Vector();
    private EventQueue m_queue;

    public EventQueueFilter(EventQueue queue) {
        super("EventQueueFilter");
        this.m_queue = queue;
    }

    public boolean addFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            if (this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.addElement(filter);
            boolean bl = true;
            return bl;
        }
    }

    public boolean updateFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            if (!this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.addElement(filter);
            boolean bl = true;
            return bl;
        }
    }

    public boolean removeFilter(Filter filter) {
        Vector vector = this.m_filters;
        synchronized (vector) {
            boolean bl = this.m_filters.remove(filter);
            return bl;
        }
    }

    public void removeAllFilters() {
        Vector vector = this.m_filters;
        synchronized (vector) {
            this.m_filters.clear();
        }
    }

    public boolean filterEvent(Event event) {
        switch (event.event_type()) {
            case 0: {
                return this.filterStructuredEvent(event.event_data().structured_event());
            }
            case 1: {
                return this.filterAnyEvent(event.event_data().any_event());
            }
        }
        return this.filterTypedEvent(event.event_data().typed_event());
    }

    public void run() {
        while (true) {
            Event event;
            if (!this.m_queue.isEmpty() && this.filterEvent(event = (Event)this.m_queue.pullEvent())) {
                this.m_queue.pushEvent(event, null, null);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
    }

    private boolean filterAnyEvent(Any event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData unsupportedFilterableData) {
                // empty catch block
            }
            ++i;
        }
        return i != this.m_filters.size() || i == 0;
    }

    private boolean filterStructuredEvent(StructuredEvent event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match_structured(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData unsupportedFilterableData) {
                // empty catch block
            }
            ++i;
        }
        return i != this.m_filters.size() || i == 0;
    }

    private boolean filterTypedEvent(Property[] event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.elementAt(i)).match_typed(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData unsupportedFilterableData) {
                // empty catch block
            }
            ++i;
        }
        return i != this.m_filters.size() || i == 0;
    }
}

