/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.apache.avalon.framework.logger.Logger;
import org.openorb.notify.EventDispatcher;
import org.openorb.notify.NotifyThread;
import org.openorb.notify.queue.EventQueue;

public class EventQueueReceiver
extends NotifyThread {
    private final EventQueue m_queue;
    private final Object m_dispatcherLock = new byte[0];
    private ArrayList m_dispatchers = new ArrayList();

    public EventQueueReceiver(String id, EventQueue queue, Logger logger) {
        super(id, logger.getChildLogger("thread"));
        this.m_queue = queue;
    }

    public void addDispatcher(EventDispatcher newDispatcher) {
        Object object = this.m_dispatcherLock;
        synchronized (object) {
            ArrayList tmp = (ArrayList)this.m_dispatchers.clone();
            tmp.add(newDispatcher);
            this.m_dispatchers = tmp;
        }
    }

    public void removeDispatcher(EventDispatcher oldDispatcher) {
        Object object = this.m_dispatcherLock;
        synchronized (object) {
            ArrayList tmp = (ArrayList)this.m_dispatchers.clone();
            ((AbstractCollection)tmp).remove(oldDispatcher);
            this.m_dispatchers = tmp;
        }
    }

    public void pushEvent(Object event) {
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            this.m_queue.pushEvent(event);
        }
        if (this.isRunning()) {
            this.notifyThread();
        } else {
            this.doDelivery();
        }
    }

    private void doDelivery() {
        ArrayList dispatchList;
        Object event;
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            if (this.isRunning() && this.m_queue.isEmpty()) {
                try {
                    this.m_queue.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.m_queue.isEmpty()) {
                return;
            }
            event = this.m_queue.pullEvent();
        }
        if (null == event) {
            return;
        }
        Object object = this.m_dispatcherLock;
        synchronized (object) {
            dispatchList = this.m_dispatchers;
        }
        int size = dispatchList.size();
        int i = 0;
        while (i < size) {
            ((EventDispatcher)dispatchList.get(i)).dispatchEvent(event);
            ++i;
        }
    }

    public void run() {
        while (this.isRunning()) {
            this.doDelivery();
        }
    }

    private void notifyThread() {
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            this.m_queue.notify();
        }
    }

    public void stopThread() {
        super.stopThread();
        this.notifyThread();
    }
}

