/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openorb.notify.queue.ComparatorElement;
import org.openorb.notify.queue.Orderer;
import org.openorb.notify.queue.PriorityComparator;

public class PriorityOrderer
implements Orderer {
    private final Map m_priorityMap = new HashMap();
    private final SortedSet m_queueSet = new TreeSet(new PriorityComparator());
    private final List m_queue0 = new ArrayList();
    private volatile int m_queueSize;

    public PriorityOrderer() {
        Short key0 = new Short(0);
        this.m_priorityMap.put(key0, this.m_queue0);
        this.m_queueSet.add(new ComparatorElement(key0, this.m_queue0));
    }

    public void pushEvent(Object event, Short priorityKey, Long timeoutKey) {
        Map map = this.m_priorityMap;
        synchronized (map) {
            List<Object> queue;
            if (priorityKey == 0) {
                queue = this.m_queue0;
            } else {
                queue = (List)this.m_priorityMap.get(priorityKey);
                if (queue == null) {
                    queue = new ArrayList<Object>();
                    this.m_priorityMap.put(priorityKey, queue);
                    this.m_queueSet.add(new ComparatorElement(priorityKey, queue));
                }
            }
            queue.add(event);
            ++this.m_queueSize;
        }
    }

    public Object pullEvent() {
        Map map = this.m_priorityMap;
        synchronized (map) {
            if (this.m_queueSize == 0) {
                Object var2_2 = null;
                return var2_2;
            }
            Iterator iter = this.m_queueSet.iterator();
            while (iter.hasNext()) {
                ComparatorElement elem = (ComparatorElement)iter.next();
                Short priority = (Short)elem.getKey();
                List queue = (List)elem.getContents();
                if (queue.size() == 0) continue;
                --this.m_queueSize;
                Object e = queue.remove(0);
                return e;
            }
        }
        return null;
    }

    public int getQueueSize() {
        return this.m_queueSize;
    }
}

