/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orb.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.configuration.CascadingConfiguration;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.PortableInterceptor.ORBInitializer;
import org.openorb.orb.config.Configurator;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.Property;
import org.openorb.orb.config.PropertyNotFoundException;
import org.openorb.orb.core.ORB;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.core.dynany.DynAnyFactoryImpl;
import org.openorb.orb.core.typecode.TypeCodeFactoryImpl;
import org.openorb.orb.pi.FeatureInitializer;
import org.openorb.orb.pi.ORBInitInfo;
import org.openorb.orb.policy.ORBPolicyManagerImpl;
import org.openorb.orb.policy.OpenORBPolicyFactoryImpl;
import org.openorb.orb.policy.PolicyCurrentImpl;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;
import org.xml.sax.SAXException;

public class DefaultLoader
implements ORBLoader,
Disposable {
    private static final String ORB_SINGLETON_CLASS_KEY = "org.omg.CORBA.ORBSingletonClass";
    private static final String ORB_SINGLETON_KEY = "org.openorb.orb.core.ORBSingleton";
    private static Properties s_defaultProperties;
    private static Configuration s_defaults;
    private Logger m_logger;
    private Configuration m_config;
    private Context m_context;
    private Hashtable m_table = new Hashtable();
    private org.openorb.orb.config.Properties m_properties;
    private File m_base;
    private ORB m_orb;
    private ORBInitInfo m_init_info;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$openorb$orb$core$ORB;
    static /* synthetic */ Class array$Lorg$omg$PortableInterceptor$ORBInitializer;
    static /* synthetic */ Class array$Lorg$openorb$orb$pi$FeatureInitializer;
    static /* synthetic */ Class class$org$apache$orb$config$DefaultLoader;

    public void load_kernel() {
        boolean enable_client;
        boolean enable_server = this.getBooleanProperty("openorb.server.enable", true);
        if (enable_server) {
            java.lang.Object[] args = new java.lang.Object[1];
            Class[] args_t = new Class[1];
            args[0] = this.m_orb;
            args_t[0] = class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = DefaultLoader.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB;
            try {
                java.lang.Object serverManager = this.constructClass("openorb.server.ServerManagerClass", "org.openorb.orb.net.ServerManagerImpl", args, args_t);
                this.m_orb.setFeature("ServerCPCManager", serverManager);
            }
            catch (Exception ex) {
                Logger logger = this.m_orb.getLogger();
                logger.error("Unable to initialize CPC server manager", (Throwable)ex);
                throw ExceptionTool.initCause((SystemException)new INITIALIZE("Unable to initialize CPC server manager (" + ex + ")"), (Throwable)ex);
            }
        }
        if (enable_client = this.getBooleanProperty("openorb.client.enable", true)) {
            java.lang.Object[] args = new java.lang.Object[1];
            Class[] args_t = new Class[1];
            args[0] = this.m_orb;
            args_t[0] = class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = DefaultLoader.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB;
            try {
                java.lang.Object clientManager = this.constructClass("openorb.client.ClientManagerClass", "org.openorb.orb.net.ClientManagerImpl", args, args_t);
                this.m_orb.setFeature("ClientCPCManager", clientManager);
            }
            catch (Exception ex) {
                Logger logger = this.m_orb.getLogger();
                logger.error("Unable to initialize CPC client manager", (Throwable)ex);
                throw ExceptionTool.initCause((SystemException)new INITIALIZE("Unable to initialize CPC client manager (" + ex + ")"), (Throwable)ex);
            }
        }
        if (this.getBooleanProperty("openorb.dynany.enable", true)) {
            DynAnyFactoryImpl dfac = new DynAnyFactoryImpl((org.omg.CORBA.ORB)this.m_orb);
            this.m_orb.addInitialReference("DynAnyFactory", (Object)dfac);
        }
        this.m_orb.addInitialReference("TypeCodeFactory", (Object)TypeCodeFactoryImpl.getInstance());
        ORBPolicyManagerImpl policymanagerimpl = new ORBPolicyManagerImpl();
        this.m_orb.setFeature("PolicyReconciler", policymanagerimpl);
        this.m_orb.setFeature("PolicySetManager", policymanagerimpl);
        this.m_orb.setFeature("PolicyFactory", policymanagerimpl);
        this.m_orb.setFeature("PolicyFactoryManager", policymanagerimpl);
        if (enable_client) {
            this.m_orb.addInitialReference("ORBPolicyManager", policymanagerimpl);
            PolicyCurrentImpl policycurrent = new PolicyCurrentImpl(policymanagerimpl);
            this.m_orb.addInitialReference("PolicyCurrent", (Object)policycurrent);
        }
        new OpenORBPolicyFactoryImpl((org.omg.CORBA.ORB)this.m_orb, policymanagerimpl, enable_server, enable_client);
    }

    public void init(String[] args, Properties props, ORB orb) {
        String dbglvl;
        if (this.m_orb != null) {
            throw new INITIALIZE("Illegal attempt to reinitialize the ORB.");
        }
        this.m_orb = orb;
        try {
            System.setProperty(ORB_SINGLETON_CLASS_KEY, ORB_SINGLETON_KEY);
        }
        catch (SecurityException ex) {
            System.err.println("Unable to set System properties: " + ex);
        }
        org.omg.CORBA.ORB singleton = org.omg.CORBA.ORB.init();
        if (!(singleton instanceof ORBSingleton)) {
            throw new INITIALIZE("Unable to complete init orb singleton is not openorbsingleton .\nPlease use: System.setProperty(\"org.omg.CORBA.ORBSingletonClass\", \"org.openorb.orb.core.ORBSingleton\");\nAs the first statement in your application.");
        }
        try {
            if (s_defaults == null) {
                s_defaults = DefaultLoader.loadDefaultConfiguration();
            }
        }
        catch (Throwable e) {
            throw new CascadingRuntimeException("Internal error while attempting to resolve default configuration.", e);
        }
        Configuration config = null;
        if (props != null) {
            config = (Configuration)((Hashtable)props).get("CONFIGURATION");
        }
        if (config == null) {
            config = new DefaultConfiguration("default", null);
        }
        this.m_config = new CascadingConfiguration(config, s_defaults);
        Configuration[] inits = this.m_config.getChildren("initializer");
        try {
            int i = 0;
            while (i < inits.length) {
                this.m_table.put(inits[i].getAttribute("class"), inits[i]);
                ++i;
            }
        }
        catch (Throwable e) {
            throw new CascadingRuntimeException("Internal error while attempt to read initalizer configurations.", e);
        }
        if (props != null) {
            this.m_context = (Context)((Hashtable)props).get("CONTEXT");
        }
        try {
            this.m_context.get((java.lang.Object)"APP_DIR");
        }
        catch (Throwable e) {
            DefaultContext context = new DefaultContext(this.m_context);
            context.put((java.lang.Object)"APP_DIR", (java.lang.Object)new File(System.getProperty("user.dir")));
            context.makeReadOnly();
            this.m_context = context;
        }
        try {
            this.m_base = (File)this.m_context.get((java.lang.Object)"APP_DIR");
        }
        catch (Throwable e) {
            String error = "Unresolved base directory.";
            throw new CascadingRuntimeException("Unresolved base directory.", e);
        }
        if (s_defaultProperties == null) {
            s_defaultProperties = DefaultLoader.getDefaultProperties();
        }
        Properties properties = new Properties(s_defaultProperties);
        Enumeration names = this.m_table.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String pname = "org.omg.PortableInterceptor.ORBInitializerClass." + name;
            properties.setProperty(pname, "");
        }
        try {
            this.mergeProperties(this.m_base, this.m_config, properties);
        }
        catch (Throwable e) {
            String error = "Unexpected exception while attempting to merge properties.";
            throw new CascadingRuntimeException("Unexpected exception while attempting to merge properties.", e);
        }
        if (props != null) {
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                properties.setProperty(name, props.getProperty(name, ""));
            }
        }
        try {
            if (props != null) {
                this.m_logger = (Logger)((Hashtable)props).get("LOGGER");
            }
        }
        catch (Throwable e) {
            throw new CascadingRuntimeException("Unexpected exception while attempting to resolve logger.", e);
        }
        if (this.m_logger == null) {
            this.m_logger = Trace.getLogger(props);
        }
        if (this.m_logger.isWarnEnabled() && (((Hashtable)properties).get("openorb.debug") != null || ((Hashtable)properties).get("debug") != null || ((Hashtable)properties).get("verbose") != null || System.getProperty("openorb.debug") != null || System.getProperty("debug") != null || System.getProperty("verbose") != null)) {
            this.m_logger.warn("The properties \"openorb.debug\", \"debug\", and \"verbose\" have been deprecated and will be ignored. Please use \"openorb.debug.trace\" and \"openorb.debug.level\" instead.");
        }
        if ((dbglvl = (String)((Hashtable)properties).get("openorb.debug.level")) == null) {
            dbglvl = System.getProperty("openorb.debug.level");
        }
        Trace.setDebugLevel(Trace.getDebugLevelFromName(dbglvl));
        this.m_orb.enableLogging(this.m_logger);
        this.m_orb.setFeature("ORBLoader", this);
        this.m_orb.setFeature("CONTEXT", this.m_context);
        this.m_orb.setFeature("CONFIGURATION", this.m_config);
        try {
            java.lang.Object[] cargs = new java.lang.Object[4];
            Class[] targs = new Class[4];
            cargs[0] = args == null ? new String[]{} : args;
            targs[0] = array$Ljava$lang$String == null ? (array$Ljava$lang$String = DefaultLoader.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
            cargs[1] = orb;
            targs[1] = class$org$openorb$orb$core$ORB == null ? (class$org$openorb$orb$core$ORB = DefaultLoader.class$("org.openorb.orb.core.ORB")) : class$org$openorb$orb$core$ORB;
            Configurator conf = new Configurator(args, properties, this.m_logger.getChildLogger("configurator"));
            this.m_properties = conf.getProperties();
            if (this.m_logger.isDebugEnabled() && Trace.isMedium()) {
                this.m_logger.debug("\n-----------------------------------------------------------------\nOpenORB\nopenorb.debug.level=" + dbglvl + " (OFF(0)/LOW(1)/MEDIUM(2)/HIGH(3))\n" + "-----------------------------------------------------------------\n");
                this.display_configuration(this.m_logger);
                this.m_logger.debug("\n-----------------------------------------------------------------");
            }
            this.load_initializers(cargs, conf.getInitializers());
            targs[2] = array$Lorg$omg$PortableInterceptor$ORBInitializer == null ? (array$Lorg$omg$PortableInterceptor$ORBInitializer = DefaultLoader.class$("[Lorg.omg.PortableInterceptor.ORBInitializer;")) : array$Lorg$omg$PortableInterceptor$ORBInitializer;
            targs[3] = array$Lorg$openorb$orb$pi$FeatureInitializer == null ? (array$Lorg$openorb$orb$pi$FeatureInitializer = DefaultLoader.class$("[Lorg.openorb.orb.pi.FeatureInitializer;")) : array$Lorg$openorb$orb$pi$FeatureInitializer;
            this.m_init_info = (ORBInitInfo)this.constructClass("openorb.pi.ORBInitInfoClass", "org.openorb.orb.pi.OpenORBInitInfo", cargs, targs);
            if (this.m_init_info instanceof LogEnabled) {
                ((LogEnabled)this.m_init_info).enableLogging(this.m_logger);
            }
        }
        catch (Throwable ex) {
            throw new CascadingRuntimeException("Internal exception while attempting to create ORBInitInfo", ex);
        }
        this.m_init_info.pre_init();
        try {
            this.load_kernel();
        }
        catch (Throwable ex) {
            throw new CascadingRuntimeException("Exception during load_kernel() call", ex);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.m_config != null) {
            try {
                Configuration[] values = this.m_config.getChildren("value");
                int i = 0;
                while (i < values.length) {
                    Configuration vconfig = values[i];
                    String idl = vconfig.getAttribute("idl");
                    String factory = vconfig.getAttribute("factory");
                    try {
                        ValueFactory instance = (ValueFactory)loader.loadClass(factory).newInstance();
                        this.m_orb.register_value_factory(idl, instance, vconfig);
                    }
                    catch (Throwable ex) {
                        String error = "Unable to load value factory: " + factory + ", for: " + idl;
                        throw new CascadingRuntimeException(error, ex);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                String error = "ORB initialization - could not load a valuetype factory.";
                throw new CascadingRuntimeException("ORB initialization - could not load a valuetype factory.", e);
            }
        }
        if (this.m_logger.isDebugEnabled() && Trace.isLow()) {
            this.m_logger.debug("loading orb");
        }
        this.m_init_info.post_init();
    }

    public void display_configuration() {
        this.m_properties.display(this.m_logger);
    }

    public void display_configuration(Logger logger) {
        this.m_properties.display(logger);
    }

    public Iterator properties(String name) {
        return this.m_properties.properties(name);
    }

    public Property getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    public String getStringProperty(String name, String defl) {
        return this.m_properties.getStringProperty(name, defl);
    }

    public String getStringProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getStringProperty(name);
    }

    public int getIntProperty(String name, int defl) {
        return this.m_properties.getIntProperty(name, defl);
    }

    public int getIntProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getIntProperty(name);
    }

    public boolean getBooleanProperty(String name, boolean defl) {
        return this.m_properties.getBooleanProperty(name, defl);
    }

    public boolean getBooleanProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getBooleanProperty(name);
    }

    public URL getURLProperty(String name, URL defl) {
        return this.m_properties.getURLProperty(name, defl);
    }

    public URL getURLProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getURLProperty(name);
    }

    public Class getClassProperty(String name, Class defl) {
        return this.m_properties.getClassProperty(name, defl);
    }

    public Class getClassProperty(String name, String defl) {
        return this.m_properties.getClassProperty(name, defl);
    }

    public Class getClassProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getClassProperty(name);
    }

    public java.lang.Object constructClass(String prop_key, String defl, java.lang.Object[] args) throws InvocationTargetException {
        return this.constructClass(prop_key, defl, args, null);
    }

    public java.lang.Object constructClass(String prop_key, String defl, java.lang.Object[] args, Class[] args_t) throws InvocationTargetException {
        if (args != null) {
            if (args_t == null) {
                args_t = new Class[args.length];
            } else if (args.length != args_t.length) {
                throw new IllegalArgumentException("Length of args and args_t do not match");
            }
            int i = 0;
            while (i < args.length) {
                if (args_t[i] == null) {
                    args_t[i] = args[i] == null ? Void.TYPE : args[i].getClass();
                }
                ++i;
            }
        }
        try {
            return this.classConstructor(prop_key, defl, args_t).newInstance(args);
        }
        catch (InstantiationException ex) {
            throw ExceptionTool.initCause((RuntimeException)new IllegalArgumentException("Illegal argument when constructing a class (" + ex + ")"), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw ExceptionTool.initCause((RuntimeException)new IllegalArgumentException("Illegal access when constructing a class (" + ex + ")"), (Throwable)ex);
        }
    }

    public Constructor classConstructor(String key, String defl, Class[] args) {
        Class clz = this.getClassProperty(key, defl);
        try {
            return clz.getConstructor(args);
        }
        catch (NoSuchMethodException ex) {
            throw ExceptionTool.initCause((RuntimeException)new IllegalArgumentException("No constructor found in " + clz.getName() + " (" + ex + ")"), (Throwable)ex);
        }
    }

    private void load_initializers(java.lang.Object[] args, String[] cls_names) {
        ArrayList orbInits = new ArrayList(cls_names.length);
        ArrayList openOrbInits = new ArrayList(cls_names.length);
        if (this.m_logger.isDebugEnabled() && Trace.isLow()) {
            this.m_logger.debug("handling " + cls_names.length + " initializers");
        }
        int i = 0;
        while (i < cls_names.length) {
            java.lang.Object instance;
            try {
                instance = Thread.currentThread().getContextClassLoader().loadClass(cls_names[i]).newInstance();
            }
            catch (Throwable ex) {
                String error = "Unable to load initializer class: " + cls_names[i];
                throw new CascadingRuntimeException(error, ex);
            }
            boolean ok = false;
            Configuration config = (Configuration)this.m_table.get(cls_names[i]);
            if (config == null) {
                config = new DefaultConfiguration("-", null);
            }
            String name = config.getAttribute("name", "initializer-" + System.identityHashCode(instance));
            if (this.m_logger.isDebugEnabled() && Trace.isMedium()) {
                this.m_logger.debug("loading initializer: " + cls_names[i] + " (catagory: " + name + ")");
            }
            if (instance instanceof LogEnabled) {
                if (name != null) {
                    ((LogEnabled)instance).enableLogging(this.m_logger.getChildLogger(name));
                } else {
                    ((LogEnabled)instance).enableLogging(this.m_logger);
                }
            }
            if (instance instanceof Contextualizable) {
                try {
                    ((Contextualizable)instance).contextualize(this.m_context);
                }
                catch (Throwable e) {
                    String error = "Unexpected exeption while contextualizing interceptor.";
                    throw new CascadingRuntimeException("Unexpected exeption while contextualizing interceptor.", e);
                }
            }
            if (instance instanceof Configurable) {
                try {
                    ((Configurable)instance).configure(config);
                }
                catch (Throwable e) {
                    String error = "Unexpected exeption while configuring interceptor.";
                    throw new CascadingRuntimeException("Unexpected exeption while configuring interceptor.", e);
                }
            }
            if (instance instanceof ORBInitializer) {
                orbInits.add(instance);
                ok = true;
            }
            if (instance instanceof FeatureInitializer) {
                openOrbInits.add(instance);
                ok = true;
            }
            if (!ok) {
                String error = "Unknown initalizer type: '" + cls_names[i] + "'.";
                throw new IllegalStateException(error);
            }
            ++i;
        }
        args[2] = new ORBInitializer[orbInits.size()];
        orbInits.toArray((java.lang.Object[])args[2]);
        args[3] = new FeatureInitializer[openOrbInits.size()];
        openOrbInits.toArray((java.lang.Object[])args[3]);
    }

    public static Properties getDefaultProperties() {
        String path = "org/apache/orb/config/orb.properties";
        Properties properties = new Properties();
        try {
            InputStream is = (class$org$apache$orb$config$DefaultLoader == null ? (class$org$apache$orb$config$DefaultLoader = DefaultLoader.class$("org.apache.orb.config.DefaultLoader")) : class$org$apache$orb$config$DefaultLoader).getClassLoader().getResourceAsStream("org/apache/orb/config/orb.properties");
            if (is == null) {
                throw new RuntimeException("Could not find the default 'orb.properties' resource from path: org/apache/orb/config/orb.properties");
            }
            properties.load(is);
        }
        catch (Throwable e) {
            throw new CascadingRuntimeException("Unexpected exception while loading configration.", e);
        }
        return properties;
    }

    private static Configuration loadDefaultConfiguration() throws MissingResourceException, ConfigurationException {
        try {
            InputStream is = (class$org$apache$orb$config$DefaultLoader == null ? (class$org$apache$orb$config$DefaultLoader = DefaultLoader.class$("org.apache.orb.config.DefaultLoader")) : class$org$apache$orb$config$DefaultLoader).getClassLoader().getResourceAsStream("org/apache/orb/config/DefaultLoader.xml");
            if (is != null) {
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                return builder.build(is);
            }
            return new DefaultConfiguration("default", "DefaultLoader");
        }
        catch (SAXException e) {
            throw new ConfigurationException("Internal SAX exception while attempting to load configuration.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Internal IO exception while attempting to load configuration.", (Throwable)e);
        }
    }

    public void mergeProperties(File root, Configuration config, Properties properties) throws Exception {
        Configuration[] props = config.getChildren("property");
        int i = 0;
        while (i < props.length) {
            String value;
            String name;
            block14: {
                Configuration child = props[i];
                name = "";
                try {
                    name = child.getAttribute("name");
                }
                catch (ConfigurationException noName) {
                    String error = "encountered a property without a name";
                    throw new CascadingException("encountered a property without a name", (Throwable)noName);
                }
                value = "";
                try {
                    value = child.getAttribute("value");
                }
                catch (ConfigurationException noValueAttribute) {
                    try {
                        String s = child.getAttribute("file");
                        File f = new File(root, s);
                        value = f.getAbsolutePath();
                    }
                    catch (ConfigurationException noFileAttribute) {
                        String error;
                        String s = null;
                        try {
                            s = child.getAttribute("url");
                        }
                        catch (Exception noURL) {
                            error = "Found a property without a 'value', 'file' or 'url' attribute";
                            throw new CascadingException("Found a property without a 'value', 'file' or 'url' attribute", (Throwable)noURL);
                        }
                        if (s.startsWith("file:")) {
                            try {
                                URL base = root.toURL();
                                URL url = new URL(base, s);
                                value = url.toString();
                                break block14;
                            }
                            catch (Exception unknown) {
                                error = "Unexpected exception while creating file:// URL value.";
                                throw new CascadingException("Unexpected exception while creating file:// URL value.", (Throwable)unknown);
                            }
                        }
                        try {
                            URL url = new URL(s);
                            value = url.toString();
                        }
                        catch (Exception unknown) {
                            error = "Unexpected exception while creating URL value.";
                            throw new CascadingException("Unexpected exception while creating URL value.", (Throwable)unknown);
                        }
                    }
                }
            }
            properties.setProperty(name, value);
            ++i;
        }
    }

    public void dispose() {
        if (this.m_logger.isDebugEnabled() && Trace.isLow()) {
            this.m_logger.debug("ORB Loader disposal");
        }
        try {
            block5: {
                try {
                    if (!(this.m_init_info instanceof Disposable)) break block5;
                    ((Disposable)this.m_init_info).dispose();
                }
                catch (Throwable e) {
                    String warning = "Ignoring error during initializer disposal.";
                    this.m_logger.warn("Ignoring error during initializer disposal.", e);
                    java.lang.Object var4_2 = null;
                    this.m_config = null;
                    this.m_context = null;
                    this.m_table = null;
                    this.m_properties = null;
                    this.m_base = null;
                    this.m_orb = null;
                    this.m_init_info = null;
                }
            }
            java.lang.Object var4_1 = null;
            this.m_config = null;
            this.m_context = null;
            this.m_table = null;
            this.m_properties = null;
            this.m_base = null;
            this.m_orb = null;
            this.m_init_info = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_3 = null;
            this.m_config = null;
            this.m_context = null;
            this.m_table = null;
            this.m_properties = null;
            this.m_base = null;
            this.m_orb = null;
            this.m_init_info = null;
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

