/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.adapter.poa;

import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.openorb.orb.Initializer;
import org.openorb.orb.adapter.poa.CurrentImpl;
import org.openorb.orb.adapter.poa.DelegateImpl;
import org.openorb.orb.adapter.poa.POA;
import org.openorb.orb.adapter.poa.PolicyFactoryImpl;
import org.openorb.orb.adapter.poa.RootPOA;
import org.openorb.orb.net.ServerManager;
import org.openorb.orb.pi.FeatureInitInfo;
import org.openorb.orb.pi.FeatureInitializer;
import org.openorb.orb.util.Trace;

public class POAInitializer
extends AbstractLogEnabled
implements FeatureInitializer,
Initializer {
    public String getName() {
        return "poa";
    }

    public void init(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        block9: {
            ServerManager svrmgr;
            if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
                this.getLogger().debug("init");
            }
            if ((svrmgr = (ServerManager)featureinfo.getFeature("ServerCPCManager")) != null) {
                try {
                    orbinfo.resolve_initial_references("RootPOA");
                    return;
                }
                catch (InvalidName ex) {
                    String error;
                    block8: {
                        try {
                            CurrentImpl curr = new CurrentImpl();
                            curr.enableLogging(featureinfo.orb().getLogger());
                            orbinfo.register_initial_reference("POACurrent", (Object)curr);
                        }
                        catch (InvalidName ex2) {
                            error = "Unable to register initial reference POACurrent.";
                            if (!this.getLogger().isErrorEnabled()) break block8;
                            this.getLogger().error("Unable to register initial reference POACurrent.", (Throwable)ex2);
                        }
                    }
                    try {
                        DelegateImpl deleg = new DelegateImpl((ORB)featureinfo.orb());
                        featureinfo.setFeature("POADelegate", deleg);
                        POA root = RootPOA.create_root_poa(svrmgr, new Policy[0]);
                        orbinfo.register_initial_reference("RootPOA", (Object)root);
                        deleg.init();
                        PolicyFactoryImpl pf = PolicyFactoryImpl.getInstance();
                        orbinfo.register_policy_factory(16, (PolicyFactory)pf);
                        orbinfo.register_policy_factory(17, (PolicyFactory)pf);
                        orbinfo.register_policy_factory(18, (PolicyFactory)pf);
                        orbinfo.register_policy_factory(19, (PolicyFactory)pf);
                        orbinfo.register_policy_factory(21, (PolicyFactory)pf);
                        orbinfo.register_policy_factory(22, (PolicyFactory)pf);
                        orbinfo.register_policy_factory(20, (PolicyFactory)pf);
                    }
                    catch (InvalidName ex3) {
                        error = "Illegal attempt to initialize two root POAs.";
                        if (!this.getLogger().isErrorEnabled()) break block9;
                        this.getLogger().error("Illegal attempt to initialize two root POAs.", (Throwable)ex3);
                    }
                }
            }
        }
    }
}

