/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.openorb.orb.config.Properties;
import org.openorb.util.ExceptionTool;
import org.openorb.util.urlhandler.resource.Handler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configurator {
    private Properties m_props = new Properties();
    private static final String[] SPECIAL_PROPS = new String[]{"openorb.home", "openorb.config", "openorb.profile", "OpenORB", "openorb.dir", "Config", "Profile"};
    private boolean m_ignoreXML = false;
    private URL m_currDoc = null;
    private HashMap m_initializedModules = new HashMap();
    private HashMap m_parsedFiles = new HashMap();
    private HashMap m_cmdLineAlias = new HashMap();
    private Set m_initializers = new HashSet();
    private static final String CONFIG_PUBLIC = "-//openorb.sf.net//OpenORB Config//EN";
    private Logger m_logger;
    private DocumentBuilder m_parser;
    private static final String ORB_INITIALIZER_PATTERN = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String FEATURE_INITIALIZER_PATTERN = "org.openorb.PI.FeatureInitializerClass.";

    public Configurator(String[] args, java.util.Properties props, Logger logger) {
        this.m_logger = logger;
        this.m_props.enableLogging(this.getLogger());
        this.setupHandler(logger);
        java.util.Properties orbProps = this.getORBProperties();
        java.util.Properties sysProps = null;
        try {
            sysProps = System.getProperties();
        }
        catch (SecurityException ex) {
            logger.warn("Security settings do not allow reading system properties.The ORB may not work properly in this case.");
        }
        this.m_ignoreXML = this.getIgnoreXMLPropertySetting(orbProps, sysProps, props);
        this.parseSpecialArgs(args, props, orbProps);
        if (!this.m_ignoreXML) {
            this.m_currDoc = this.findRootConfig();
            this.handleXMLImport(this.m_currDoc);
        }
        if (orbProps != null) {
            this.addProperties("", orbProps);
        }
        if (sysProps != null) {
            this.addProperties("", sysProps);
        }
        if (props != null) {
            this.addProperties("", props);
        }
        if (args != null) {
            this.m_cmdLineAlias.put("DefaultInitialReference", "openorb.defaultInitialReference");
            this.m_cmdLineAlias.put("SrvName", "openorb.server.alias");
            this.m_cmdLineAlias.put("Debug", "openorb.debug.level");
            this.m_cmdLineAlias.put("Trace", "openorb.debug.trace");
            this.m_cmdLineAlias.put("CSIv2", "ImportModule.CSIv2");
            this.m_cmdLineAlias.put("CSIv2Realm", "csiv2.tss.realm");
            this.m_cmdLineAlias.put("GSSClientUser", "csiv2.css.user");
            this.m_cmdLineAlias.put("ClientIdentity", "csiv2.css.identity");
            this.parseArgs(args);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    public Properties getProperties() {
        return this.m_props;
    }

    public String[] getInitializers() {
        String[] ret = new String[this.m_initializers.size()];
        this.m_initializers.toArray(ret);
        return ret;
    }

    public URL addFragment(URL base, String fragment) throws MalformedURLException {
        String oldurl = base.toString();
        int idx = oldurl.indexOf(35);
        if (idx > 0) {
            oldurl = oldurl.substring(0, idx);
        }
        if (fragment == null) {
            return new URL(oldurl);
        }
        return new URL(oldurl + '#' + fragment.toLowerCase());
    }

    private void addProperty(String name, String value, boolean processImportsFlag, boolean processNonImportsFlag) {
        if (name.equals("ImportModule.CSIv2")) {
            value = "${openorb.home}config/CSIv2.xml#csiv2";
        }
        String lc = name.toLowerCase();
        int i = 0;
        while (i < SPECIAL_PROPS.length) {
            if (lc.startsWith(SPECIAL_PROPS[i])) {
                return;
            }
            ++i;
        }
        if (processImportsFlag && name.startsWith("ImportModule") && !this.m_ignoreXML) {
            URL url;
            try {
                url = new URL(this.m_props.formatString(value));
            }
            catch (MalformedURLException ex) {
                try {
                    url = new URL(this.m_props.formatString("${openorb.config}#" + value));
                }
                catch (MalformedURLException ex1) {
                    this.getLogger().error("Malformed URL in ImportModule", (Throwable)ex1);
                    throw ExceptionTool.initCause((SystemException)new INITIALIZE("Malformed URL in ImportModule (" + ex1 + ")"), (Throwable)ex);
                }
            }
            this.handleURLImport(url);
            return;
        }
        if (processNonImportsFlag) {
            if (name.startsWith("org.openorb.")) {
                if (name.startsWith("org.openorb.messaging.MessagingInitializerClass.")) {
                    System.err.println("Non-standard initializer specification is deprecated: org.openorb.messaging.MessagingInitializerClass.");
                    if (name.length() >= "org.openorb.messaging.MessagingInitializerClass.".length()) {
                        if (this.m_initializedModules.containsKey(name)) {
                            this.m_initializers.remove(this.m_initializedModules.get(name));
                        }
                        this.m_initializedModules.put(name, value);
                    }
                    this.m_initializers.add(value);
                } else if (name.startsWith("org.openorb.rmi.InitializerClass.")) {
                    System.err.println("Non-standard initializer specification is deprecated: org.openorb.rmi.InitializerClass.");
                    if (name.length() >= "org.openorb.rmi.InitializerClass.".length()) {
                        if (this.m_initializedModules.containsKey(name)) {
                            this.m_initializers.remove(this.m_initializedModules.get(name));
                        }
                        this.m_initializedModules.put(name, value);
                    }
                    this.m_initializers.add(value);
                } else if (name.startsWith("org.openorb.iiop.IIOPProtocolInitializerClass.")) {
                    System.err.println("Non-standard initializer specification is deprecated: org.openorb.iiop.IIOPProtocolInitializerClass.");
                    if (name.length() >= "org.openorb.iiop.IIOPProtocolInitializerClass.".length()) {
                        if (this.m_initializedModules.containsKey(name)) {
                            this.m_initializers.remove(this.m_initializedModules.get(name));
                        }
                        this.m_initializedModules.put(name, value);
                    }
                    this.m_initializers.add(value);
                } else if (name.startsWith("org.openorb.adapter.fwd.ForwardInitializerClass.")) {
                    System.err.println("Non-standard initializer specification is deprecated: org.openorb.adapter.fwd.ForwardInitializerClass.");
                    if (name.length() >= "org.openorb.adapter.fwd.ForwardInitializerClass.".length()) {
                        if (this.m_initializedModules.containsKey(name)) {
                            this.m_initializers.remove(this.m_initializedModules.get(name));
                        }
                        this.m_initializedModules.put(name, value);
                    }
                    this.m_initializers.add(value);
                } else if (name.startsWith("org.openorb.adapter.boa.BOAInitializerClass.")) {
                    System.err.println("Non-standard initializer specification is deprecated: org.openorb.adapter.boa.BOAInitializerClass.");
                    if (name.length() >= "org.openorb.adapter.boa.BOAInitializerClass.".length()) {
                        if (this.m_initializedModules.containsKey(name)) {
                            this.m_initializers.remove(this.m_initializedModules.get(name));
                        }
                        this.m_initializedModules.put(name, value);
                    }
                    this.m_initializers.add(value);
                } else if (name.startsWith("org.openorb.adapter.poa.POAInitializerClass.")) {
                    System.err.println("Non-standard initializer specification is deprecated: org.openorb.adapter.poa.POAInitializerClass.");
                    if (name.length() >= "org.openorb.adapter.poa.POAInitializerClass.".length()) {
                        if (this.m_initializedModules.containsKey(name)) {
                            this.m_initializers.remove(this.m_initializedModules.get(name));
                        }
                        this.m_initializedModules.put(name, value);
                    }
                    this.m_initializers.add(value);
                } else if (name.startsWith(FEATURE_INITIALIZER_PATTERN)) {
                    String className = name.substring(FEATURE_INITIALIZER_PATTERN.length());
                    this.m_initializers.add(className);
                }
            } else if (name.startsWith(ORB_INITIALIZER_PATTERN)) {
                String className = name.substring(ORB_INITIALIZER_PATTERN.length());
                this.m_initializers.add(className);
            } else if (!name.startsWith("ImportModule") || this.m_ignoreXML) {
                this.getProperties().addProperty(name, value);
            }
        }
    }

    private void addProperty(String name, String value) {
        this.addProperty(name, value, true, true);
    }

    private void addProperties(String prefix, java.util.Properties props) {
        if (props == null) {
            return;
        }
        int count = 0;
        while (count < 2) {
            boolean processNonImportsFlag;
            boolean processImportsFlag;
            Enumeration<?> enumeration;
            try {
                enumeration = props.propertyNames();
            }
            catch (SecurityException ex) {
                return;
            }
            if (count == 0) {
                processImportsFlag = true;
                processNonImportsFlag = false;
            } else {
                processImportsFlag = false;
                processNonImportsFlag = true;
            }
            while (enumeration.hasMoreElements()) {
                String key = null;
                try {
                    key = (String)enumeration.nextElement();
                    if (key.startsWith("sun.") || key.startsWith("os.") || key.startsWith("awt.") || key.startsWith("java.")) continue;
                    this.addProperty(prefix + key, props.getProperty(key), processImportsFlag, processNonImportsFlag);
                }
                catch (SecurityException ex) {
                    this.getLogger().warn("The property '" + key + "' could not be added to the internal" + " property set due to security reasons. (" + ex + ")");
                }
            }
            ++count;
        }
    }

    private void setupHandler(Logger logger) {
        block5: {
            try {
                String oldPkgs = System.getProperty("java.protocol.handler.pkgs");
                if (oldPkgs == null) {
                    System.setProperty("java.protocol.handler.pkgs", "org.openorb.util.urlhandler");
                } else if (oldPkgs.indexOf("java.protocol.handler.pkgs") < 0) {
                    System.setProperty("java.protocol.handler.pkgs", oldPkgs + "|" + "org.openorb.util.urlhandler");
                }
            }
            catch (SecurityException ex) {
                if (logger == null) break block5;
                logger.warn("The URLHandler could not be set! The security settings do not allow system properties to be set! (" + ex + ")");
            }
        }
    }

    private java.util.Properties getORBProperties() {
        String javaHome;
        java.util.Properties fileProps = new java.util.Properties();
        try {
            javaHome = System.getProperty("java.home");
        }
        catch (SecurityException ex) {
            return null;
        }
        File propFile = new File(javaHome + File.separator + "lib" + File.separator + "orb.properties");
        if (!propFile.exists()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(propFile);
            try {
                fileProps.load(fis);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                fis.close();
                throw throwable;
            }
            fis.close();
            return fileProps;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private URL parseURL(String str) {
        int i = (str = this.m_props.formatString(str)).lastIndexOf(35);
        if (i >= 0) {
            str = str.substring(0, i) + str.substring(i).toLowerCase();
        }
        try {
            return new URL(this.m_currDoc, str);
        }
        catch (MalformedURLException ex) {
            File f = new File(str);
            if (f.exists()) {
                try {
                    return f.toURL();
                }
                catch (MalformedURLException ex1) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private String parseSpecialArg(String module, String name, String alias, String[] args, java.util.Properties props, java.util.Properties orbProps) {
        String val;
        if (args != null) {
            int i = args.length - 1;
            while (i >= 0) {
                if (args[i] != null && args[i].startsWith("-ORB")) {
                    String expProp;
                    int idx = args[i].indexOf(61);
                    if (idx >= 0) {
                        expProp = args[i].substring(4, idx);
                        if (expProp.equals(alias) || expProp.equalsIgnoreCase(module + "." + name)) {
                            return args[i].substring(idx + 1);
                        }
                    } else if (i + 1 < args.length) {
                        idx = args[i + 1].indexOf(61);
                        if (idx >= 0) {
                            if (args[i].substring(4).equalsIgnoreCase(module) && args[i + 1].substring(0, idx).equalsIgnoreCase(name)) {
                                return args[i + 1].substring(idx + 1);
                            }
                        } else {
                            expProp = args[i].substring(4);
                            if (expProp.equals(alias) || expProp.equalsIgnoreCase(module + "." + name)) {
                                return args[i + 1];
                            }
                        }
                    }
                }
                --i;
            }
        }
        String expProp = module + "." + name;
        if (props != null && (val = props.getProperty(expProp)) != null) {
            return val;
        }
        try {
            val = System.getProperty(expProp);
            if (val != null) {
                return val;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (orbProps != null) {
            return orbProps.getProperty(expProp);
        }
        return null;
    }

    private void parseSpecialArgs(String[] args, java.util.Properties props, java.util.Properties orbProps) {
        URL url = null;
        String val = this.parseSpecialArg("openorb", "home", "OpenORB", args, props, orbProps);
        if (val != null) {
            url = this.parseURL(val);
            if (url == null) {
                throw new INITIALIZE("Can't parse openorb.home property as a URL");
            }
            this.m_props.addProperty("openorb.home", url);
        } else {
            try {
                URL u = null;
                u = props != null ? new URL(props.getProperty("openorb.home.urn", "resource:") + "/org/openorb/") : new URL("resource", "", -1, "/org/openorb/", (URLStreamHandler)new Handler(Thread.currentThread().getContextClassLoader()));
                this.m_props.addProperty("openorb.home", u);
            }
            catch (MalformedURLException ex) {
                if (url != null) {
                    this.m_props.addProperty("openorb.home", url);
                }
                throw ExceptionTool.initCause((SystemException)new INITIALIZE("Can't determine openorb.home property (" + ex + ")"), (Throwable)ex);
            }
        }
        val = this.parseSpecialArg("openorb", "config", "Config", args, props, orbProps);
        if (val != null) {
            url = this.parseURL(val);
            if (url == null) {
                throw new INITIALIZE("Can't parse openorb.config property as a URL");
            }
            this.m_props.addProperty("openorb.config", url);
        }
        if ((val = this.parseSpecialArg("openorb", "profile", "Profile", args, props, orbProps)) != null) {
            this.m_props.addProperty("openorb.profile", val);
        }
    }

    private URL findRootConfigIn(String prop, String file, String profile) {
        File confFile = null;
        try {
            confFile = new File(System.getProperty(prop), file);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (confFile != null && confFile.exists()) {
            try {
                URL config = confFile.toURL();
                this.m_props.addProperty("openorb.config", config);
                if (profile != null) {
                    config = this.addFragment(config, profile);
                }
                return config;
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private URL findRootConfig() {
        String profile = this.m_props.getStringProperty("openorb.profile", null);
        URL config = this.m_props.getURLProperty("openorb.config", null);
        if (config != null) {
            if (config.getRef() == null && profile != null) {
                try {
                    config = this.addFragment(config, profile);
                }
                catch (MalformedURLException ex) {
                    this.getLogger().error("Invalid URL in property openorb.config.", (Throwable)ex);
                    throw ExceptionTool.initCause((SystemException)new INITIALIZE("Unable to parse profile from openorb.profile (" + ex + ")"), (Throwable)ex);
                }
            }
            return config;
        }
        config = this.findRootConfigIn("user.dir", "OpenORB.xml", profile);
        if (config != null) {
            return config;
        }
        config = this.findRootConfigIn("user.home", "OpenORB.xml", profile);
        if (config != null) {
            return config;
        }
        config = this.findRootConfigIn("user.home", ".OpenORB.xml", profile);
        if (config != null) {
            return config;
        }
        config = this.findRootConfigIn("java.home", "OpenORB.xml", profile);
        if (config != null) {
            return config;
        }
        config = this.m_props.getURLProperty("openorb.home", null);
        if (config != null) {
            try {
                config = new URL(config, "config/OpenORB.xml");
                this.m_props.addProperty("openorb.config", config);
                if (profile != null) {
                    config = this.addFragment(config, profile);
                }
                return config;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        throw new INITIALIZE("Unable to locate OpenORB.xml");
    }

    private String handleURLImport(URL url) {
        String file = url.getFile();
        if (file.endsWith(".properties")) {
            return this.handlePropertiesImport(url);
        }
        if (!this.m_ignoreXML && file.indexOf(".xml") > 0) {
            return this.handleXMLImport(url);
        }
        throw new INITIALIZE("Unknown type for URL \"" + url + "\"");
    }

    private String handlePropertiesImport(URL url) {
        if (this.m_initializedModules.containsKey(url)) {
            return url.getRef();
        }
        try {
            java.util.Properties props = new java.util.Properties();
            props.load(url.openStream());
            this.m_initializedModules.put(url, null);
            String fragment = url.getRef();
            if (fragment == null) {
                this.addProperties("", props);
            } else {
                this.addProperties(fragment + ".", props);
            }
            return fragment;
        }
        catch (IOException ex) {
            String msg = "Unable to read properties file from URL \"" + url + "\"";
            this.getLogger().error(msg, (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(msg + " (" + ex + ")"), (Throwable)ex);
        }
    }

    private Document parseXML(URL url) {
        try {
            Document ret = (Document)this.m_parsedFiles.get(url);
            if (ret != null) {
                return ret;
            }
            if (this.m_parser == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                this.m_parser = dbf.newDocumentBuilder();
                this.m_parser.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) {
                        if (Configurator.CONFIG_PUBLIC.equals(publicId)) {
                            URL dtdurl = Configurator.this.parseURL("${openorb.home}config/OpenORB.dtd");
                            InputSource is = new InputSource(dtdurl.toString());
                            try {
                                is.setByteStream(dtdurl.openStream());
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            return is;
                        }
                        return null;
                    }
                });
            }
            ret = this.m_parser.parse(url.toString());
            this.m_parsedFiles.put(url, ret);
            return ret;
        }
        catch (ParserConfigurationException ex) {
            String msg = "ParserConfigurationException while parsing XML File \"" + url + "\"";
            this.getLogger().error(msg, (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(msg + " (" + ex + ")"), (Throwable)ex);
        }
        catch (SAXException ex) {
            String msg = "SAXException while parsing XML File \"" + url + "\"";
            this.getLogger().error(msg, (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(msg + " (" + ex + ")"), (Throwable)ex);
        }
        catch (IOException ex) {
            String msg = "IOException while parsing XML File \"" + url + "\"";
            this.getLogger().error(msg, (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(msg + " (" + ex + ")"), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleXMLImport(URL url) {
        String string;
        URL prevDoc;
        block37: {
            String ex4;
            block36: {
                block35: {
                    String string2;
                    block34: {
                        prevDoc = this.m_currDoc;
                        try {
                            String type;
                            Element impElem;
                            NodeList list;
                            this.m_currDoc = url;
                            String fragment = url.getRef();
                            if (fragment != null) {
                                if (this.m_initializedModules.containsKey(url)) {
                                    if (this.m_initializedModules.get(url) == null) {
                                        String string3 = null;
                                        Object var12_8 = null;
                                        this.m_currDoc = prevDoc;
                                        return string3;
                                    }
                                    string2 = fragment;
                                    break block34;
                                }
                                try {
                                    this.m_currDoc = this.addFragment(url, null);
                                }
                                catch (MalformedURLException ex2) {
                                    String msg = "Invalid URL : " + url;
                                    this.getLogger().error(msg, (Throwable)ex2);
                                    throw ExceptionTool.initCause((SystemException)new INTERNAL(msg), (Throwable)ex2);
                                }
                            }
                            Document docRoot = this.parseXML(this.m_currDoc);
                            Element rootElem = docRoot.getDocumentElement();
                            if (fragment == null) {
                                String username = null;
                                try {
                                    username = System.getProperty("user.name");
                                }
                                catch (SecurityException ex3) {
                                    // empty catch block
                                }
                                if (username != null) {
                                    list = rootElem.getElementsByTagName("associations");
                                    switch (list.getLength()) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            list = ((Element)list.item(0)).getElementsByTagName("association");
                                            int i = 0;
                                            while (i < list.getLength() && fragment == null) {
                                                Element assoc = (Element)list.item(i);
                                                if (!assoc.hasAttribute("profile")) {
                                                    throw new INITIALIZE("Association in \"" + this.m_currDoc + "\" is missing profile.");
                                                }
                                                StringTokenizer strtok = new StringTokenizer(assoc.getAttribute("user"));
                                                while (strtok.hasMoreTokens()) {
                                                    if (!strtok.nextToken().equals(username)) continue;
                                                    fragment = assoc.getAttribute("profile");
                                                    break;
                                                }
                                                ++i;
                                            }
                                            break;
                                        }
                                        default: {
                                            throw new INITIALIZE("Document \"" + this.m_currDoc + "\" has multiple associaton elements");
                                        }
                                    }
                                }
                                if (fragment == null) {
                                    fragment = rootElem.hasAttribute("profile") ? rootElem.getAttribute("profile") : "default";
                                }
                                try {
                                    url = this.addFragment(url, fragment);
                                }
                                catch (MalformedURLException ex4) {
                                    String msg = "Unable to parse default profile name from \"" + this.m_currDoc + "\"";
                                    this.getLogger().error(msg, (Throwable)ex4);
                                    throw ExceptionTool.initCause((SystemException)new INITIALIZE(msg), (Throwable)ex4);
                                }
                                if (this.m_initializedModules.containsKey(url)) {
                                    if (this.m_initializedModules.get(url) == null) {
                                        ex4 = null;
                                        break block35;
                                    }
                                    ex4 = fragment;
                                    break block36;
                                }
                            }
                            if (rootElem.hasAttribute("xml:base")) {
                                try {
                                    this.m_currDoc = new URL(this.m_currDoc, this.m_props.formatString(rootElem.getAttribute("xml:base")));
                                }
                                catch (MalformedURLException ex5) {
                                    String msg = "The xml:base attribute of the xml file \"" + this.m_currDoc + "\" cannot be parsed";
                                    this.getLogger().error(msg, (Throwable)ex5);
                                    throw ExceptionTool.initCause((SystemException)new INITIALIZE(msg), (Throwable)ex5);
                                }
                            }
                            if ((impElem = docRoot.getElementById(fragment)) == null) {
                                list = rootElem.getChildNodes();
                                int i = 0;
                                while (i < list.getLength()) {
                                    Element elem;
                                    Node node = list.item(i);
                                    if (node.getNodeType() == 1 && fragment.equalsIgnoreCase((elem = (Element)node).getAttribute("name"))) {
                                        impElem = elem;
                                        break;
                                    }
                                    ++i;
                                }
                                if (impElem == null) {
                                    throw new INITIALIZE("Cannot find element \"" + url + "\"");
                                }
                            }
                            if ((type = impElem.getTagName()).equals("profile")) {
                                this.handleImportElem(impElem, url, true);
                                this.m_initializedModules.put(url, null);
                                fragment = null;
                            } else if (type.equals("module")) {
                                if (impElem.hasAttribute("initializer")) {
                                    this.m_initializers.add(impElem.getAttribute("initializer"));
                                }
                                this.m_initializedModules.put(url, fragment);
                            }
                            this.handleProperties(impElem, fragment, url);
                            string = fragment;
                            break block37;
                        }
                        catch (Throwable throwable) {
                            Object var12_13 = null;
                            this.m_currDoc = prevDoc;
                            throw throwable;
                        }
                    }
                    Object var12_9 = null;
                    this.m_currDoc = prevDoc;
                    return string2;
                }
                Object var12_10 = null;
                this.m_currDoc = prevDoc;
                return ex4;
            }
            Object var12_11 = null;
            this.m_currDoc = prevDoc;
            return ex4;
        }
        Object var12_12 = null;
        this.m_currDoc = prevDoc;
        return string;
    }

    private boolean handleProperties(Element docRoot, String module, URL url) {
        NodeList list = docRoot.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element nextElem = (Element)node;
                String subtype = nextElem.getTagName();
                if (subtype.equals("import")) {
                    if (url == null) {
                        return false;
                    }
                    String impModule = this.handleImportElem(nextElem, url, false);
                    if (!this.handleProperties(nextElem, impModule, null)) {
                        if (impModule == null) {
                            throw new INITIALIZE("Attempt to set properties from import of profile in \"" + url + "\"");
                        }
                        throw new INITIALIZE("Import statment in \"" + url + "\" has child import");
                    }
                } else if (subtype.equals("property") || subtype.equals("rootproperty")) {
                    if (module == null) {
                        if (url == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + url + "\" defines properties, disallowed");
                    }
                    this.handlePropertyElem(nextElem, module, url);
                } else if (subtype.equals("propalias")) {
                    if (module == null) {
                        if (url == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + url + "\" defines propaliases, disallowed");
                    }
                    this.handlePropaliasElem(nextElem, module, url);
                } else if (subtype.equals("propertyset")) {
                    if (module == null) {
                        if (url == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + url + "\" defines propertyset, disallowed");
                    }
                    this.handlePropertySet(nextElem, module);
                } else if (!subtype.equals("description")) {
                    throw new INITIALIZE("Unknown element type " + subtype + " in \"" + url + "\"");
                }
            }
            ++i;
        }
        return true;
    }

    private Element nextElement(Node prev) {
        while (prev != null && prev.getNodeType() != 1) {
            prev = prev.getNextSibling();
        }
        return (Element)prev;
    }

    private String handleImportElem(Element impElem, URL url, boolean profile) {
        URL importURL;
        boolean hasExtends = impElem.hasAttribute("extends");
        boolean hasModule = impElem.hasAttribute("module");
        boolean hasProfile = impElem.hasAttribute("profile");
        boolean hasLink = impElem.hasAttribute("xlink:href");
        switch ((hasExtends ? 1 : 0) + (hasModule ? 1 : 0) + (hasProfile ? 1 : 0) + (hasLink ? 1 : 0)) {
            case 0: {
                if (!profile) {
                    throw new INITIALIZE("Import from \"" + url + "\" does not specify a target");
                }
                return null;
            }
            case 1: {
                if (hasLink || (profile ? hasExtends : hasProfile || hasModule)) break;
                throw new INITIALIZE("Atribute " + (profile ? (hasProfile ? "profile" : "module") : "extends") + " found when " + (profile ? "extends" : "profile or module") + " attribute is expected in \"" + url + "\"");
            }
            default: {
                throw new INITIALIZE("Multiple " + (profile ? "extends present in profile" : "import targets in module") + " at \"" + url + "\"");
            }
        }
        if (!hasLink) {
            try {
                if (hasExtends) {
                    importURL = this.addFragment(url, impElem.getAttribute("extends"));
                }
                if (hasModule) {
                    importURL = this.addFragment(url, impElem.getAttribute("module"));
                }
                if (hasProfile) {
                    importURL = this.addFragment(url, impElem.getAttribute("profile"));
                }
                throw new Error("Impossible state");
            }
            catch (MalformedURLException ex) {
                String msg = "Unable to parse " + (profile ? "extends" : "module") + " for " + (profile ? "profile" : "module import in") + " \"" + url + "\"";
                this.getLogger().error(msg, (Throwable)ex);
                throw ExceptionTool.initCause((SystemException)new INITIALIZE(msg), (Throwable)ex);
            }
        } else if (impElem.hasAttribute("xlink:href")) {
            String ref = impElem.getAttribute("xlink:href");
            importURL = this.parseURL(ref);
            if (importURL == null) {
                throw new INITIALIZE("Unable to parse URL \"" + ref + "\" from " + (profile ? "profile" : "module import in") + " \"" + url + "\"");
            }
        } else {
            if (!profile) {
                throw new INITIALIZE("Import from \"" + url + "\" does not specify a target");
            }
            return null;
        }
        String ret = this.handleURLImport(importURL);
        if (profile) {
            if (ret != null) {
                throw new INITIALIZE("Attempted to extend module \"" + importURL + "\" from profile \"" + url + "\"");
            }
        } else if (!hasLink && (ret == null ? hasModule : hasProfile)) {
            throw new INITIALIZE("Attempted to import " + (ret == null ? "profile" : "module") + "  \"" + importURL + "\" from " + (ret == null ? "module" : "profile") + " \"" + url + "\"");
        }
        return ret;
    }

    private void handlePropaliasElem(Element impElem, String module, URL url) {
        String name = impElem.getAttribute("name");
        if (name.length() == 0) {
            throw new INITIALIZE("Propalias in \"" + url + "\" does not have a name");
        }
        String alias = impElem.getAttribute("alias");
        if (alias.length() == 0) {
            throw new INITIALIZE("Propalias in \"" + url + "\" does not have an alias");
        }
        name = module + "." + name;
        this.m_cmdLineAlias.put(alias, name);
    }

    private void handlePropertyElem(Element impElem, String module, URL url) {
        String name = impElem.getAttribute("name");
        if (name.length() == 0) {
            throw new INITIALIZE("Property in \"" + url + "\" does not have a name");
        }
        String value = impElem.hasAttribute("value") ? impElem.getAttribute("value") : "true";
        if (impElem.hasAttribute("root")) {
            String isRoot = impElem.getAttribute("root");
            if (isRoot.equals("false")) {
                name = module + "." + name;
            } else if (!isRoot.equals("true")) {
                throw new INITIALIZE("Property " + name + " in \"" + url + "\" has illegal value for root attribute");
            }
        } else if (!impElem.getTagName().equals("rootproperty")) {
            name = module + "." + name;
        }
        this.addProperty(name, value);
    }

    private void handlePropertySet(Element element, String moduleName) {
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element elem;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && !(elem = (Element)node).getTagName().equals("description")) {
                this.m_props.addProperty(moduleName + "." + element.getAttribute("prefix") + "." + elem.getAttribute("name"), elem.getAttribute("value"));
            }
            ++i;
        }
    }

    private void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && args[i].startsWith("-ORB")) {
                String value;
                String name;
                int keyIdx = args[i].indexOf(61);
                if (keyIdx < 0) {
                    if (args.length <= i + 1 || args[i + 1] == null || args[i + 1].startsWith("-")) {
                        name = args[i].substring(4);
                        value = "true";
                    } else {
                        keyIdx = args[i + 1].indexOf(61);
                        if (keyIdx < 0) {
                            name = args[i].substring(4);
                            value = args[i + 1];
                        } else {
                            name = args[i].substring(4) + "." + args[i + 1].substring(0, keyIdx);
                            value = args[i + 1].substring(keyIdx + 1);
                        }
                        ++i;
                    }
                } else {
                    name = args[i].substring(4, keyIdx);
                    value = args[i].substring(keyIdx + 1);
                }
                if (this.m_cmdLineAlias.containsKey(name)) {
                    name = (String)this.m_cmdLineAlias.get(name);
                }
                this.addProperty(name, value);
            }
            ++i;
        }
    }

    private boolean getIgnoreXMLPropertySetting(java.util.Properties orbProps, java.util.Properties sysProps, java.util.Properties props) {
        String value;
        boolean ignoreXML = false;
        String key = "openorb.ignoreXML";
        if (orbProps != null) {
            value = orbProps.getProperty(key);
            ignoreXML = this.getValue(value, ignoreXML);
        }
        if (sysProps != null) {
            value = sysProps.getProperty(key);
            ignoreXML = this.getValue(value, ignoreXML);
        }
        if (props != null) {
            value = props.getProperty(key);
            ignoreXML = this.getValue(value, ignoreXML);
        }
        if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(key + "=" + ignoreXML);
        }
        return ignoreXML;
    }

    private boolean getValue(String value, boolean fallback) {
        if (value != null) {
            return Boolean.valueOf(value.toLowerCase());
        }
        return fallback;
    }
}

