/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.config;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log.Priority;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ORBInitializer;
import org.openorb.orb.Initializer;
import org.openorb.orb.config.Configurator;
import org.openorb.orb.config.ORBConnector;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.Properties;
import org.openorb.orb.config.Property;
import org.openorb.orb.config.PropertyNotFoundException;
import org.openorb.orb.core.ORB;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.pi.FeatureInitializer;
import org.openorb.orb.pi.ORBInitInfo;
import org.openorb.orb.rmi.DefaultORB;
import org.openorb.orb.rmi.DeserializationKernelFactory;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;
import org.openorb.util.urlhandler.HandlerLoader;

public class OpenORBLoader
implements ORBLoader {
    private static final String ORBSINGLETON_CLASSKEY = "org.omg.CORBA.ORBSingletonClass";
    private static final String DEFAULT_ORBSINGLETON = "org.openorb.orb.core.ORBSingleton";
    private Properties m_properties = null;
    private ORB m_orb;
    private Logger m_logger;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$openorb$orb$core$ORB;
    static /* synthetic */ Class array$Lorg$omg$PortableInterceptor$ORBInitializer;
    static /* synthetic */ Class array$Lorg$openorb$orb$pi$FeatureInitializer;

    public void init(String[] args, java.util.Properties properties, ORB orb) {
        ORBInitInfo init_info;
        OutputStream os;
        boolean useUserSuppliedLogger;
        if (this.m_orb != null) {
            throw new INITIALIZE("Multiple initialize for orb");
        }
        this.m_orb = orb;
        try {
            System.setProperty(ORBSINGLETON_CLASSKEY, DEFAULT_ORBSINGLETON);
        }
        catch (SecurityException ex) {
            System.out.println("Warning: Security settings do not allow this process to set system properties (org.omg.CORBA.ORBSingletonClass).");
        }
        org.omg.CORBA.ORB singleton = org.omg.CORBA.ORB.init();
        if (!(singleton instanceof ORBSingleton)) {
            throw new INITIALIZE("Unable to complete init orb singleton is either not an OpenORB singleton\nor it has been loaded by another classloader and thus causes the instanceof\ncheck to fail. In the first case use:\nSystem.setProperty(\"org.omg.CORBA.ORBSingletonClass\", \"org.openorb.orb.core.ORBSingleton\");\nAs the first statement in your application.\nIn the second case make sure that the OpenORB jars are placed on the system\nor on a parent classloader instead of the apllication classloader. E.g. this\nhas most likely been caused by putting the OpenORB jars on the classpath of\nyour web application instead of the container's classpath.\nBut because there can only be one ORBSingleton instance per VM putting the\nOpenORB jars on the web application classpath is not possible because the\nweb container creates a new classloader for each web application and thus\ncreates different incarnations of the same class for each classloader.\nThis leads, sooner or later, to a ClassCastException from which this check\nis meant to protect you from!");
        }
        if (properties != null) {
            this.m_logger = (Logger)((Hashtable)properties).get("LOGGER");
        }
        boolean bl = useUserSuppliedLogger = this.m_logger != null;
        if (properties != null && (os = (OutputStream)((Hashtable)properties).get("openorb.debug.outputstream")) != null) {
            Trace.setLoggerOutputStream(os);
        }
        if (this.m_logger == null) {
            this.m_logger = Trace.getLogger(properties);
        }
        this.m_orb.enableLogging(this.m_logger.getChildLogger("ldr#" + System.identityHashCode(this)));
        Configurator conf = new Configurator(args, properties, this.getLogger());
        this.m_properties = conf.getProperties();
        String deserializationEngine = "lazy:auto";
        try {
            deserializationEngine = this.m_properties.getStringProperty("iiop.deserializationEngine");
        }
        catch (PropertyNotFoundException ex) {
            // empty catch block
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("DeserializationKernel: iiop.deserializationEngine=" + deserializationEngine);
        }
        DeserializationKernelFactory.setDeserializationEngine(deserializationEngine);
        if ((this.m_properties.getProperty("openorb.debug") != null || this.m_properties.getProperty("debug") != null || this.m_properties.getProperty("verbose") != null) && this.m_logger.isWarnEnabled()) {
            this.m_logger.warn("The properties \"openorb.debug\", \"debug\", and \"verbose\" have been deprecated and will be ignored. Please use \"openorb.debug.trace\" and \"openorb.debug.level\" instead.");
        }
        if (!useUserSuppliedLogger) {
            try {
                String trclvl = this.m_properties.getStringProperty("openorb.debug.trace");
                this.m_logger = Trace.getNewLogger(Trace.getPriorityFromName(trclvl));
            }
            catch (PropertyNotFoundException ex) {
                this.m_logger = Trace.getNewLogger(Priority.ERROR);
            }
        }
        String dbglvl = null;
        try {
            dbglvl = this.m_properties.getStringProperty("openorb.debug.level");
        }
        catch (PropertyNotFoundException ex) {
            this.m_logger.warn("openorb.debug.level not specified, using default OFF.");
        }
        Trace.setDebugLevel(Trace.getDebugLevelFromName(dbglvl));
        if (this.m_logger.isDebugEnabled() && Trace.isMedium()) {
            this.m_logger.debug("\n-----------------------------------------------------------------\nOpenORB\nopenorb.debug.level=" + dbglvl + " (OFF(0)/LOW(1)/MEDIUM(2)/HIGH(3))\n" + "-----------------------------------------------------------------\n");
            this.display_configuration(this.m_logger);
            this.m_logger.debug("\n-----------------------------------------------------------------");
        }
        if (this.m_logger.isDebugEnabled() && Trace.isLow()) {
            this.m_logger.debug("ORB loading.");
        }
        this.m_orb.setFeature("ORBLoader", this);
        boolean defaultorb_singleton = this.m_properties.getBooleanProperty("rmi.defaultorbSingleton", false);
        if (defaultorb_singleton) {
            if (this.m_logger.isDebugEnabled() && Trace.isLow()) {
                this.m_logger.debug("Setting RMI-IIOP DefaultORB.");
            }
            DefaultORB.setORB((org.omg.CORBA.ORB)this.m_orb);
        }
        try {
            Object[] cargs = new Object[4];
            Class[] targs = new Class[4];
            cargs[0] = args == null ? new String[]{} : args;
            targs[0] = array$Ljava$lang$String == null ? (array$Ljava$lang$String = OpenORBLoader.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
            cargs[1] = orb;
            targs[1] = class$org$openorb$orb$core$ORB == null ? (class$org$openorb$orb$core$ORB = OpenORBLoader.class$("org.openorb.orb.core.ORB")) : class$org$openorb$orb$core$ORB;
            this.load_initializers(cargs, conf.getInitializers());
            targs[2] = array$Lorg$omg$PortableInterceptor$ORBInitializer == null ? (array$Lorg$omg$PortableInterceptor$ORBInitializer = OpenORBLoader.class$("[Lorg.omg.PortableInterceptor.ORBInitializer;")) : array$Lorg$omg$PortableInterceptor$ORBInitializer;
            targs[3] = array$Lorg$openorb$orb$pi$FeatureInitializer == null ? (array$Lorg$openorb$orb$pi$FeatureInitializer = OpenORBLoader.class$("[Lorg.openorb.orb.pi.FeatureInitializer;")) : array$Lorg$openorb$orb$pi$FeatureInitializer;
            init_info = (ORBInitInfo)this.constructClass("openorb.pi.ORBInitInfoClass", "org.openorb.orb.pi.OpenORBInitInfo", cargs, targs);
            if (init_info instanceof LogEnabled) {
                ((LogEnabled)init_info).enableLogging(this.m_logger.getChildLogger("pi"));
            }
        }
        catch (InvocationTargetException ex) {
            String msg = "Exception during construction of class openorb.pi.ORBInitInfoClass";
            this.getLogger().error("Exception during construction of class openorb.pi.ORBInitInfoClass", (Throwable)ex);
            if (ex.getTargetException() instanceof SystemException) {
                throw (SystemException)ex.getTargetException();
            }
            throw ExceptionTool.initCause((SystemException)new INITIALIZE("Exception during construction of class openorb.pi.ORBInitInfoClass (" + ex + ")"), (Throwable)ex);
        }
        init_info.pre_init();
        try {
            ORBConnector orb_connector = (ORBConnector)this.constructClass("openorb.kernel.ORBConnectorClass", "org.openorb.orb.config.OpenORBConnector", null);
            orb_connector.enableLogging(this.m_logger.getChildLogger("connector"));
            orb_connector.load_kernel(this.m_orb, this);
        }
        catch (InvocationTargetException ex) {
            String msg = "Exception during construction of class openorb.kernel.ORBConnectorClass";
            this.getLogger().error("Exception during construction of class openorb.kernel.ORBConnectorClass", ex.getTargetException());
            if (ex.getTargetException() instanceof SystemException) {
                throw (SystemException)ex.getTargetException();
            }
            throw ExceptionTool.initCause((SystemException)new INITIALIZE("Exception during construction of class openorb.kernel.ORBConnectorClass (" + ex + ")"), (Throwable)ex);
        }
        init_info.post_init();
    }

    public void display_configuration() {
        this.m_properties.display();
    }

    public void display_configuration(Logger logger) {
        this.m_properties.display(logger);
    }

    public Iterator properties(String name) {
        return this.m_properties.properties(name);
    }

    public Property getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    public String getStringProperty(String name, String defl) {
        return this.m_properties.getStringProperty(name, defl);
    }

    public String getStringProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getStringProperty(name);
    }

    public int getIntProperty(String name, int defl) {
        return this.m_properties.getIntProperty(name, defl);
    }

    public int getIntProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getIntProperty(name);
    }

    public boolean getBooleanProperty(String name, boolean defl) {
        return this.m_properties.getBooleanProperty(name, defl);
    }

    public boolean getBooleanProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getBooleanProperty(name);
    }

    public URL getURLProperty(String name, URL defl) {
        return this.m_properties.getURLProperty(name, defl);
    }

    public URL getURLProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getURLProperty(name);
    }

    public Class getClassProperty(String name, Class defl) {
        return this.m_properties.getClassProperty(name, defl);
    }

    public Class getClassProperty(String name, String defl) {
        return this.m_properties.getClassProperty(name, defl);
    }

    public Class getClassProperty(String name) throws PropertyNotFoundException {
        return this.m_properties.getClassProperty(name);
    }

    public Object constructClass(String prop_key, String defl, Object[] args) throws InvocationTargetException {
        return this.constructClass(prop_key, defl, args, null);
    }

    public Object constructClass(String prop_key, String defl, Object[] args, Class[] args_t) throws InvocationTargetException {
        if (args != null) {
            if (args_t == null) {
                args_t = new Class[args.length];
            } else if (args.length != args_t.length) {
                throw new IllegalArgumentException("Length of args and args_t do not match");
            }
            int i = 0;
            while (i < args.length) {
                if (args_t[i] == null) {
                    args_t[i] = args[i] == null ? Void.TYPE : args[i].getClass();
                }
                ++i;
            }
        }
        try {
            return this.classConstructor(prop_key, defl, args_t).newInstance(args);
        }
        catch (InstantiationException ex) {
            String msg = "Illegal argument when constructing a class";
            this.getLogger().error("Illegal argument when constructing a class", (Throwable)ex);
            throw ExceptionTool.initCause((RuntimeException)new IllegalArgumentException("Illegal argument when constructing a class (" + ex + ")"), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            String msg = "Illegal access when constructing a class";
            this.getLogger().error("Illegal access when constructing a class", (Throwable)ex);
            throw ExceptionTool.initCause((RuntimeException)new IllegalArgumentException("Illegal access when constructing a class (" + ex + ")"), (Throwable)ex);
        }
    }

    public Constructor classConstructor(String prop_key, String defl, Class[] args_t) {
        Class clz = this.getClassProperty(prop_key, defl);
        try {
            return clz.getConstructor(args_t);
        }
        catch (NoSuchMethodException ex) {
            String msg = "No constructor found in " + clz.getName();
            this.getLogger().error(msg, (Throwable)ex);
            throw ExceptionTool.initCause((RuntimeException)new IllegalArgumentException(msg + " (" + ex + ")"), (Throwable)ex);
        }
    }

    private void load_initializers(Object[] args, String[] cls_names) {
        ArrayList orbInits = new ArrayList(cls_names.length);
        ArrayList openOrbInits = new ArrayList(cls_names.length);
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("Creating initializers now...");
        }
        int i = 0;
        while (i < cls_names.length) {
            Object instance;
            try {
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("Creating initializer " + cls_names[i] + ".");
                }
                instance = Thread.currentThread().getContextClassLoader().loadClass(cls_names[i]).newInstance();
            }
            catch (Exception ex) {
                String error = "Unable to load initializer class: " + cls_names[i];
                throw new CascadingRuntimeException(error, (Throwable)ex);
            }
            String logger_name = null;
            if (instance instanceof Initializer) {
                Initializer init = (Initializer)instance;
                logger_name = init.getName();
            } else {
                int dot = cls_names[i].lastIndexOf(46);
                if (dot != -1) {
                    logger_name = cls_names[i].substring(dot + 1);
                }
            }
            if (instance instanceof LogEnabled) {
                ((LogEnabled)instance).enableLogging(this.m_logger.getChildLogger(logger_name));
            }
            boolean ok = false;
            if (instance instanceof ORBInitializer) {
                orbInits.add(instance);
                ok = true;
            }
            if (instance instanceof FeatureInitializer) {
                openOrbInits.add(instance);
                ok = true;
            }
            if (!ok) {
                String error = "Unknown initalizer type: '" + cls_names[i] + "'.";
                throw new IllegalStateException(error);
            }
            ++i;
        }
        args[2] = new ORBInitializer[orbInits.size()];
        orbInits.toArray((Object[])args[2]);
        args[3] = new FeatureInitializer[openOrbInits.size()];
        openOrbInits.toArray((Object[])args[3]);
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            HandlerLoader.loadHandlers((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw ExceptionTool.initCause((Error)new NoClassDefFoundError(e.getMessage()), (Throwable)e);
        }
    }
}

