/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UNKNOWNHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.openorb.orb.core.Any;
import org.openorb.orb.util.Trace;

public abstract class SystemExceptionHelper {
    private static final String[] SYSTEM_EXCEPTIONS;
    private static final Map FINDER;
    private static final MapEntry UNKNOWN;
    static /* synthetic */ Class class$org$openorb$orb$core$SystemExceptionHelper;
    static /* synthetic */ Class class$org$omg$CORBA$UNKNOWN;
    static /* synthetic */ Class class$org$omg$CORBA$UNKNOWNHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$Any;

    private SystemExceptionHelper() {
    }

    public static TypeCode type(String repo_id) {
        MapEntry entry = (MapEntry)FINDER.get(repo_id);
        if (entry == null) {
            entry = UNKNOWN;
        }
        return entry.m_type;
    }

    public static TypeCode type(SystemException ex) {
        MapEntry entry = (MapEntry)FINDER.get(((Object)((Object)ex)).getClass());
        if (entry == null) {
            entry = UNKNOWN;
        }
        return entry.m_type;
    }

    public static String id(SystemException ex) {
        MapEntry entry = (MapEntry)FINDER.get(((Object)((Object)ex)).getClass());
        if (entry == null) {
            entry = UNKNOWN;
        }
        return entry.m_id;
    }

    public static void insert(org.omg.CORBA.Any any, SystemException sysex) {
        block9: {
            MapEntry entry = (MapEntry)FINDER.get(((Object)((Object)sysex)).getClass());
            Logger logger = ((Any)any).getLogger();
            if (entry == null) {
                if (sysex instanceof UnknownException && any instanceof Any) {
                    ((Any)any).setUnknownException(sysex);
                }
                sysex = new UNKNOWN(sysex.minor, sysex.completed);
                entry = UNKNOWN;
            }
            Class[] arg_clz = new Class[2];
            Object[] args = new Object[2];
            arg_clz[0] = class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = SystemExceptionHelper.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any;
            args[0] = any;
            arg_clz[1] = ((Object)((Object)sysex)).getClass();
            args[1] = sysex;
            try {
                entry.m_hClz.getMethod("insert", arg_clz).invoke(null, args);
                return;
            }
            catch (InvocationTargetException ex) {
                Throwable tex;
                if (logger.isErrorEnabled()) {
                    logger.error("Invalid insert operation", (Throwable)ex);
                }
                if ((tex = ex.getTargetException()) instanceof RuntimeException) {
                    throw (RuntimeException)tex;
                }
                if (tex instanceof Error) {
                    throw (Error)tex;
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (!logger.isErrorEnabled()) break block9;
                logger.error("Unexpected exception", (Throwable)ex);
            }
        }
    }

    public static SystemException extract(org.omg.CORBA.Any any) {
        block12: {
            Logger logger;
            MapEntry entry;
            block11: {
                entry = null;
                logger = ((Any)any).getLogger();
                try {
                    entry = (MapEntry)FINDER.get(any.type().id());
                }
                catch (BadKind ex) {
                    if (!logger.isErrorEnabled()) break block11;
                    logger.error("Unknown TCKind", (Throwable)ex);
                }
            }
            if (entry == null) {
                throw new BAD_OPERATION("Wrong type for extraction", 1146056710, CompletionStatus.COMPLETED_MAYBE);
            }
            Class[] arg_clz = new Class[1];
            Object[] args = new Object[1];
            arg_clz[0] = class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = SystemExceptionHelper.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any;
            args[0] = any;
            try {
                SystemException ret = (SystemException)((Object)entry.m_hClz.getMethod("extract", arg_clz).invoke(null, args));
                if (ret instanceof UNKNOWN && any instanceof Any) {
                    UnknownException tmp = new UnknownException(((Any)any).getUnknownException());
                    tmp.minor = ret.minor;
                    tmp.completed = ret.completed;
                    ret = tmp;
                }
                return ret;
            }
            catch (InvocationTargetException ex) {
                Throwable tex;
                if (logger.isErrorEnabled()) {
                    logger.error("Invalid extract operation", (Throwable)ex);
                }
                if ((tex = ex.getTargetException()) instanceof RuntimeException) {
                    throw (RuntimeException)tex;
                }
                if (tex instanceof Error) {
                    throw (Error)tex;
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (!logger.isErrorEnabled()) break block12;
                logger.error("Unexpected exception", (Throwable)ex);
            }
        }
        throw new BAD_OPERATION("Wrong type for extraction", 1146056710, CompletionStatus.COMPLETED_MAYBE);
    }

    public static SystemException read(InputStream is) {
        return SystemExceptionHelper.create(is.read_string(), null, is.read_ulong(), CompletionStatus.from_int((int)is.read_ulong()));
    }

    public static SystemException read(String reasonPrefix, InputStream is) {
        return SystemExceptionHelper.create(is.read_string(), reasonPrefix, is.read_ulong(), CompletionStatus.from_int((int)is.read_ulong()));
    }

    public static SystemException create(String repo_id, int minor, CompletionStatus completed) {
        return SystemExceptionHelper.create(repo_id, null, minor, completed);
    }

    public static SystemException create(String repo_id, String reasonPrefix, int minor, CompletionStatus completed) {
        MapEntry entry = (MapEntry)FINDER.get(repo_id);
        if (entry == null) {
            entry = UNKNOWN;
        }
        String reason = SystemExceptionHelper.getReasonString(entry, minor);
        if (reasonPrefix != null) {
            reason = reasonPrefix + ": " + reason;
        }
        try {
            SystemException ret = (SystemException)((Object)entry.m_strCons.newInstance(reason));
            ret.minor = minor;
            ret.completed = completed;
            return ret;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static void write(OutputStream out, SystemException val) {
        out.write_string(SystemExceptionHelper.id(val));
        out.write_ulong(val.minor);
        out.write_ulong(val.completed.value());
    }

    private static String getReasonString(MapEntry entry, int minor) {
        int vendorID = minor & 0xFFFFF000;
        int minorCode = minor & 0xFFF;
        switch (vendorID) {
            case 1330446336: {
                return "OMG Minor Code: " + minorCode;
            }
            case 1146056704: {
                return "OpenORB Minor Code: " + minorCode;
            }
            case 0: {
                return "Unregistered vendor Minor Code: " + minorCode;
            }
            case 0x4F4F0000: {
                return "ORBacus Minor Code: " + minorCode;
            }
            case 1245904896: {
                return "JacORB Minor Code: " + minorCode;
            }
            case 0x53550000: {
                return "Sun ORB Minor Code: " + minorCode;
            }
        }
        return "Unknown vendor (0x" + Integer.toString(vendorID, 16) + ")  Minor Code: " + minorCode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader ctxClassLoader;
        SYSTEM_EXCEPTIONS = new String[]{"UNKNOWN", "BAD_PARAM", "NO_MEMORY", "IMP_LIMIT", "COMM_FAILURE", "INV_OBJREF", "NO_PERMISSION", "INTERNAL", "MARSHAL", "INITIALIZE", "NO_IMPLEMENT", "BAD_TYPECODE", "BAD_OPERATION", "NO_RESOURCES", "NO_RESPONSE", "PERSIST_STORE", "BAD_INV_ORDER", "TRANSIENT", "FREE_MEM", "INV_IDENT", "INV_FLAG", "INTF_REPOS", "BAD_CONTEXT", "OBJ_ADAPTER", "DATA_CONVERSION", "OBJECT_NOT_EXIST", "TRANSACTION_REQUIRED", "TRANSACTION_ROLLEDBACK", "INVALID_TRANSACTION", "INV_POLICY", "CODESET_INCOMPATIBLE", "REBIND", "TIMEOUT", "TRANSACTION_UNAVAILABLE", "TRANSACTION_MODE", "BAD_QOS"};
        FINDER = new HashMap(SYSTEM_EXCEPTIONS.length * 2);
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = ctxClassLoader = currentThread.getContextClassLoader();
        if (ctxClassLoader == null) {
            ctxClassLoader = (class$org$openorb$orb$core$SystemExceptionHelper == null ? (class$org$openorb$orb$core$SystemExceptionHelper = SystemExceptionHelper.class$("org.openorb.orb.core.SystemExceptionHelper")) : class$org$openorb$orb$core$SystemExceptionHelper).getClassLoader();
            currentThread.setContextClassLoader(ctxClassLoader);
        }
        try {
            try {
                UNKNOWN = new MapEntry(UNKNOWNHelper.id(), UNKNOWNHelper.type(), class$org$omg$CORBA$UNKNOWN == null ? (class$org$omg$CORBA$UNKNOWN = SystemExceptionHelper.class$("org.omg.CORBA.UNKNOWN")) : class$org$omg$CORBA$UNKNOWN, class$org$omg$CORBA$UNKNOWNHelper == null ? (class$org$omg$CORBA$UNKNOWNHelper = SystemExceptionHelper.class$("org.omg.CORBA.UNKNOWNHelper")) : class$org$omg$CORBA$UNKNOWNHelper, (class$org$omg$CORBA$UNKNOWN == null ? (class$org$omg$CORBA$UNKNOWN = SystemExceptionHelper.class$("org.omg.CORBA.UNKNOWN")) : class$org$omg$CORBA$UNKNOWN).getConstructor(class$java$lang$String == null ? (class$java$lang$String = SystemExceptionHelper.class$("java.lang.String")) : class$java$lang$String));
                FINDER.put(UNKNOWN.m_id, UNKNOWN);
                FINDER.put(UNKNOWN.m_clz, UNKNOWN);
            }
            catch (NoSuchMethodException ex) {
                throw Trace.signalIllegalCondition(null, "Unable to find String constructor of org.omg.CORBA.UNKNOWN class (" + ex + ")");
            }
            int i = 1;
            while (i < SYSTEM_EXCEPTIONS.length) {
                block13: {
                    try {
                        Class<?> hclz;
                        Class<?> clz;
                        try {
                            clz = ctxClassLoader.loadClass("org.omg.CORBA." + SYSTEM_EXCEPTIONS[i]);
                            hclz = ctxClassLoader.loadClass("org.omg.CORBA." + SYSTEM_EXCEPTIONS[i] + "Helper");
                        }
                        catch (ClassNotFoundException ex) {
                            System.err.println("Warning: missing system exception class " + SYSTEM_EXCEPTIONS[i]);
                            break block13;
                        }
                        String id = (String)hclz.getMethod("id", new Class[0]).invoke(null, new Object[0]);
                        TypeCode type = (TypeCode)hclz.getMethod("type", new Class[0]).invoke(null, new Object[0]);
                        Constructor<?> strCons = clz.getConstructor(class$java$lang$String == null ? SystemExceptionHelper.class$("java.lang.String") : class$java$lang$String);
                        MapEntry entry = new MapEntry(id, type, clz, hclz, strCons);
                        FINDER.put(entry.m_id, entry);
                        FINDER.put(entry.m_clz, entry);
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (InvocationTargetException ex) {
                        throw Trace.signalIllegalCondition(null, "An exception occured while invoking the 'id' or the 'type' method in 'org.omg.CORBA." + SYSTEM_EXCEPTIONS[i] + "'!");
                    }
                    catch (NoSuchMethodException ex) {
                        throw Trace.signalIllegalCondition(null, "Unable to find 'id' or 'type' method in 'org.omg.CORBA." + SYSTEM_EXCEPTIONS[i] + "'!");
                    }
                    catch (IllegalAccessException ex) {
                        throw Trace.signalIllegalCondition(null, "Unable to access 'id' or 'type' method in 'org.omg.CORBA." + SYSTEM_EXCEPTIONS[i] + "'!");
                    }
                }
                ++i;
            }
            Object var11_16 = null;
            currentThread.setContextClassLoader(originalClassLoader);
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            currentThread.setContextClassLoader(originalClassLoader);
            throw throwable;
        }
    }

    private static class MapEntry {
        private final String m_id;
        private final TypeCode m_type;
        private final Class m_clz;
        private final Class m_hClz;
        private final Constructor m_strCons;

        public MapEntry(String id, TypeCode type, Class clz, Class hclz, Constructor strCons) {
            this.m_id = id;
            this.m_type = type;
            this.m_clz = clz;
            this.m_hClz = hclz;
            this.m_strCons = strCons;
        }
    }
}

