/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.core.dii;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.ORB;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.core.dii.NVList;
import org.openorb.orb.core.dii.NamedValue;
import org.openorb.util.ExceptionTool;

public class Context
extends org.omg.CORBA.Context {
    private final org.omg.CORBA.NVList m_liste;
    private final String m_name;
    private final Vector m_child;
    private final Context m_parent;
    private final ORB m_orb;
    private final Logger m_logger;

    public Context(String name, Context parent, ORB orb) {
        this.m_name = name;
        this.m_parent = parent;
        this.m_liste = orb.create_list(0);
        this.m_child = new Vector();
        this.m_orb = orb;
        this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
    }

    public String context_name() {
        return this.m_name;
    }

    public org.omg.CORBA.Context parent() {
        return this.m_parent;
    }

    public org.omg.CORBA.Context create_child(String child_ctx_name) {
        Context child = new Context(child_ctx_name, this, this.m_orb);
        this.m_child.addElement(child);
        return child;
    }

    public void set_one_value(String propname, Any propvalue) {
        int index = this.propertyIndex(propname);
        if (index == -1) {
            this.m_liste.add_value(propname, propvalue, 0);
        } else {
            try {
                ((NamedValue)this.m_liste.item(index)).setNewValue(propvalue);
            }
            catch (Bounds ex) {
                this.getLogger().error("index out of bounds for property: " + propname + ".", (Throwable)ex);
                throw ExceptionTool.initCause((RuntimeException)new IndexOutOfBoundsException(), (Throwable)ex);
            }
        }
    }

    public void set_values(org.omg.CORBA.NVList values) {
        int i = 0;
        while (i < values.count()) {
            try {
                int index = this.propertyIndex(values.item(i).name());
                if (index == -1) {
                    this.m_liste.add_value(values.item(i).name(), values.item(i).value(), 0);
                } else {
                    ((NamedValue)this.m_liste.item(index)).setNewValue(values.item(i).value());
                }
            }
            catch (Bounds e) {
                // empty catch block
            }
            ++i;
        }
    }

    public void delete_values(String propname) {
        try {
            int i = 0;
            while (i < this.m_liste.count()) {
                if (this.matching_pattern(this.m_liste.item(i).name(), propname)) {
                    this.m_liste.remove(i);
                    i = 0;
                }
                ++i;
            }
        }
        catch (Bounds bounds) {
            // empty catch block
        }
    }

    public org.omg.CORBA.NVList get_values(String start_scope, int op_flags, String pattern) {
        org.omg.CORBA.NVList nv = null;
        nv = !start_scope.equals(this.m_name) ? (this.m_parent == null ? this.m_orb.create_list(0) : this.m_parent.get_values(start_scope, op_flags, pattern)) : this.m_orb.create_list(0);
        try {
            int i = 0;
            while (i < this.m_liste.count()) {
                if (this.matching_pattern(this.m_liste.item(i).name(), pattern)) {
                    ((NVList)nv).add(this.m_liste.item(i));
                }
                ++i;
            }
        }
        catch (Bounds ex) {
            // empty catch block
        }
        int i = 0;
        while (i < this.m_child.size()) {
            nv = ((Context)((Object)this.m_child.elementAt(i))).add_all_values(nv, pattern);
            ++i;
        }
        return nv;
    }

    private org.omg.CORBA.NVList add_all_values(org.omg.CORBA.NVList nv, String pattern) {
        try {
            int i = 0;
            while (i < this.m_liste.count()) {
                if (this.matching_pattern(this.m_liste.item(i).name(), pattern)) {
                    org.omg.CORBA.NamedValue val = this.m_liste.item(i);
                    nv.add_value(val.name(), val.value(), val.flags());
                }
                ++i;
            }
        }
        catch (Bounds ex) {
            // empty catch block
        }
        int i = 0;
        while (i < this.m_child.size()) {
            nv = ((Context)((Object)this.m_child.elementAt(i))).add_all_values(nv, pattern);
            ++i;
        }
        return nv;
    }

    private boolean matching_pattern(String src, String ptn) {
        if (ptn.equals("*")) {
            return true;
        }
        int idx = ptn.indexOf("*", 0);
        if (idx == -1) {
            return src.equals(ptn);
        }
        if (idx > src.length()) {
            return false;
        }
        String s1 = src.substring(0, idx);
        String s2 = ptn.substring(0, idx);
        return s1.equals(s2);
    }

    protected int propertyIndex(String name) {
        int i = 0;
        while (i < this.m_liste.count()) {
            try {
                if (this.m_liste.item(i).name().equals(name)) {
                    return i;
                }
            }
            catch (Bounds ex) {
                this.getLogger().error("Index out of bounds for property: " + name + ".", (Throwable)ex);
                throw ExceptionTool.initCause((RuntimeException)new IndexOutOfBoundsException(), (Throwable)ex);
            }
            ++i;
        }
        return -1;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

