/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.core.dynany;

import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynValueBox;
import org.openorb.orb.core.dynany.DynAnyImpl;
import org.openorb.orb.io.TypeCodeValueBoxHelper;

public class DynValueBoxImpl
extends DynAnyImpl
implements DynValueBox {
    private boolean m_null;
    private DynAny m_boxed;

    public DynValueBoxImpl(DynAnyFactory factory, ORB orb, TypeCode type) {
        super(factory, orb);
        this.m_type = type;
        this.m_null = false;
        try {
            this.m_boxed = this.create_dyn_any(type.content_type());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void assign(DynAny dynm_any) throws TypeMismatch {
        if (!dynm_any.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        this.m_boxed = ((DynValueBoxImpl)dynm_any).m_boxed;
    }

    public void from_any(Any value) throws InvalidValue, TypeMismatch {
        if (!value.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        try {
            TypeCodeValueBoxHelper box = new TypeCodeValueBoxHelper(this.m_orb, this.m_type);
            OutputStream output = this.m_orb.create_output_stream();
            box.write_value(output, (Serializable)value);
            ((DynAnyImpl)this.m_boxed).stream_to_dyn_any(this.m_boxed.type(), output.create_input_stream());
        }
        catch (BadKind ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Any BadKind exception.", (Throwable)ex);
            }
            throw new InvalidValue();
        }
    }

    public Any to_any() {
        try {
            TypeCodeValueBoxHelper box = new TypeCodeValueBoxHelper(this.m_orb, this.m_type);
            OutputStream output = this.m_orb.create_output_stream();
            ((DynAnyImpl)this.m_boxed).dyn_any_to_stream(this.m_boxed.type(), output);
            InputStream input = output.create_input_stream();
            return (Any)box.read_value(input);
        }
        catch (BadKind ex) {
            return null;
        }
    }

    public void destroy() {
    }

    public DynAny copy() {
        DynValueBoxImpl dyn_val = new DynValueBoxImpl(this.m_factory, this.m_orb, this.m_type);
        this.m_boxed = dyn_val.m_boxed.copy();
        return dyn_val;
    }

    public DynAny current_component() {
        return this;
    }

    public boolean next() {
        return false;
    }

    public boolean seek(int index) {
        return index == 0;
    }

    public void rewind() {
    }

    public int component_count() {
        return 0;
    }

    public boolean is_null() {
        return this.m_null;
    }

    public void set_to_null() {
        this.m_null = true;
    }

    public void set_to_value() {
        this.m_null = false;
    }

    public Any get_boxed_value() throws InvalidValue {
        if (this.m_null) {
            throw new InvalidValue();
        }
        return this.m_boxed.to_any();
    }

    public void set_boxed_value(Any boxed) throws TypeMismatch {
        try {
            if (!this.m_type.content_type().equal(boxed.type())) {
                throw new TypeMismatch();
            }
            this.m_boxed.from_any(boxed);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DynAny get_boxed_value_as_dyn_any() throws InvalidValue {
        if (this.m_null) {
            throw new InvalidValue();
        }
        return this.m_boxed;
    }

    public void set_boxed_value_as_dyn_any(DynAny boxed) throws TypeMismatch {
        try {
            if (!this.m_type.content_type().equal(boxed.type())) {
                throw new TypeMismatch();
            }
            this.m_boxed = boxed;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

