/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.core.typecode;

import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.openorb.orb.core.typecode.TypeCodeBase;
import org.openorb.orb.core.typecode.TypeCodeRecursive;

public class TypeCodeAlias
extends TypeCodeBase {
    private TCKind m_kind;
    private String m_id;
    private String m_name = null;
    private TypeCodeBase m_content;
    private TypeCodeAlias m_compact = null;
    private TypeCodeBase m_base = null;
    private boolean m_fixed = false;

    TypeCodeAlias(TCKind kind, String id, String name, TypeCode content) {
        this.m_kind = kind;
        this.m_id = id;
        this.m_content = (TypeCodeBase)content;
        if (name != null && name.length() > 0) {
            this.m_name = name;
        } else if (this.m_content._is_compact()) {
            this.m_compact = this;
        }
        if (kind != TCKind.tk_alias) {
            this.m_base = this;
        }
    }

    boolean _is_recursive() {
        return false;
    }

    boolean _fix_recursive(Map recursive) {
        recursive.put(this.m_id, this);
        if (this.m_fixed) {
            return true;
        }
        this.m_fixed = true;
        if (this.m_content._is_recursive()) {
            TypeCodeRecursive tmp = (TypeCodeRecursive)this.m_content;
            String id = "";
            try {
                id = tmp.id();
            }
            catch (BadKind ex) {
                // empty catch block
            }
            this.m_content = (TypeCodeBase)((Object)recursive.get(id));
            if (this.m_content == null) {
                this.m_fixed = false;
                this.m_content = tmp;
            }
        } else {
            this.m_fixed = this.m_content._fix_recursive(recursive);
        }
        return this.m_fixed;
    }

    public boolean _is_compact() {
        return this.m_compact == this;
    }

    public TypeCodeBase _base_type() {
        if (this.m_base == null) {
            this.m_base = this.m_content._base_type();
        }
        return this.m_base;
    }

    public TCKind kind() {
        return this.m_kind;
    }

    public boolean equivalent(TypeCode tc) {
        return this._base_type().equal(((TypeCodeBase)tc)._base_type());
    }

    public boolean equal(TypeCode tc) {
        if (this == tc) {
            return true;
        }
        if (tc.kind() != this.m_kind) {
            return false;
        }
        TypeCodeAlias tc2 = (TypeCodeAlias)tc;
        if (this.m_id.length() > 0 && tc2.m_id.length() > 0) {
            return this.m_id.equals(tc2.m_id);
        }
        return this.m_content.equal(tc2.m_content);
    }

    public int hashCode() {
        if (this.m_id == null || this.m_id.length() == 0) {
            return super.hashCode();
        }
        return this.m_id.hashCode();
    }

    public TypeCode get_compact_typecode() {
        if (this.m_name == null) {
            return this;
        }
        if (this.m_compact == null) {
            this.m_compact.m_compact = this.m_compact = new TypeCodeAlias(this.m_kind, this.m_id, null, this.m_content);
            this.m_compact.m_content = (TypeCodeBase)this.m_content.get_compact_typecode();
        }
        return this.m_compact;
    }

    public String id() throws BadKind {
        return this.m_id;
    }

    public String name() throws BadKind {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public TypeCode content_type() throws BadKind {
        return this.m_content;
    }

    public int length() throws BadKind {
        throw new BadKind();
    }

    public int member_count() throws BadKind {
        throw new BadKind();
    }

    public TypeCode member_type(int index) throws BadKind, Bounds {
        throw new BadKind();
    }

    public Any member_label(int index) throws BadKind, Bounds {
        throw new BadKind();
    }

    public int default_index() throws BadKind {
        throw new BadKind();
    }

    public String member_name(int index) throws BadKind, Bounds {
        throw new BadKind();
    }

    public TypeCode discriminator_type() throws BadKind {
        throw new BadKind();
    }

    public short fixed_digits() throws BadKind {
        throw new BadKind();
    }

    public short fixed_scale() throws BadKind {
        throw new BadKind();
    }

    public short member_visibility(int index) throws BadKind, Bounds {
        throw new BadKind();
    }

    public short type_modifier() throws BadKind {
        throw new BadKind();
    }

    public TypeCode concrete_base_type() throws BadKind {
        throw new BadKind();
    }
}

