/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

public class AbstractTagData {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int DIGIT_MASK = 15;
    private final int m_componentId;
    private String m_msg;

    protected AbstractTagData(int componentId) {
        this.m_componentId = componentId;
    }

    protected StringBuffer createMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append("    ComponentID = ");
        buf.append(this.m_componentId);
        return buf;
    }

    protected final void appendIntAsHex(StringBuffer buf, int value) {
        buf.ensureCapacity(buf.length() + 10);
        buf.append("0x");
        int i = 28;
        while (i >= 0) {
            buf.append(HEX_DIGITS[value >> i & 0xF]);
            i -= 4;
        }
    }

    public synchronized String toString() {
        if (null == this.m_msg) {
            this.m_msg = new String(this.createMessage().toString());
        }
        return this.m_msg;
    }
}

