/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.openorb.orb.iiop.CodeSet;
import org.openorb.orb.iiop.CodeSetDatabase;
import org.openorb.orb.util.Trace;
import org.openorb.util.HexPrintStream;
import org.openorb.util.NumberCache;

public class CodeSetDatabaseInitializer
implements LogEnabled,
Initializable,
Disposable {
    private static Object s_sync_table = new Object();
    private static HashMap s_name_to_id = null;
    private CodeSetComponentInfo m_clientCodeSets;
    private CodeSetComponentInfo m_serverCodeSets;
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public void initialize() {
        if (s_name_to_id == null) {
            Object object = s_sync_table;
            synchronized (object) {
                s_name_to_id = new HashMap();
                CodeSetDatabase.populateNameToIdMap(s_name_to_id);
            }
        }
        this.m_serverCodeSets = this.initCodeSets(true);
        this.m_clientCodeSets = this.initCodeSets(false);
    }

    public void dispose() {
        this.m_clientCodeSets = null;
        this.m_serverCodeSets = null;
        this.m_logger = null;
    }

    public CodeSetComponentInfo getClientCodeSets() {
        return this.m_clientCodeSets;
    }

    public CodeSetComponentInfo getServerCodeSets() {
        return this.m_serverCodeSets;
    }

    private CodeSetComponentInfo initCodeSets(boolean server) {
        int asciics;
        int align;
        int csid;
        String sysenc;
        block21: {
            sysenc = System.getProperty("file.encoding");
            csid = 0;
            align = 0;
            try {
                String canenc = CodeSetDatabase.canonicalize(sysenc);
                ArrayList al = (ArrayList)s_name_to_id.get(canenc.toUpperCase());
                if (al == null) {
                    if (this.getLogger() != null && this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("No codesets found for system encoding '" + sysenc + "' (canonicalized to '" + canenc + "').");
                    }
                } else {
                    csid = (Integer)al.get(0);
                    align = CodeSetDatabase.getAlignmentFromId(csid);
                    if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                        this.getLogger().debug((server ? "Server" : "Client") + "NativeCodeSet=" + sysenc + " ( id=0x" + HexPrintStream.toHex((int)csid) + ", align=" + align + " )");
                    }
                }
            }
            catch (UnsupportedEncodingException ex) {
                if (this.getLogger() == null) break block21;
                String msg = "Error while canonicalizing the system encoding '" + sysenc + "'.";
                this.getLogger().error(msg);
            }
        }
        if (csid == 0 || align > 1) {
            csid = 0x5010001;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Can't find '" + sysenc + "' in codeset database. Using fallback char data codeset " + CodeSetDatabase.getNameFromId(csid) + ".");
            }
        } else if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("Using char data codeset '" + CodeSetDatabase.getNameFromId(csid) + "'.");
        }
        CodeSetComponent csc_char = new CodeSetComponent(csid, this.allCompatCodeSets(csid, true, server));
        int iso88591cs = 65537;
        if (csc_char.native_code_set != iso88591cs) {
            int i = 0;
            while (i < csc_char.conversion_code_sets.length) {
                if (iso88591cs == csc_char.conversion_code_sets[i]) {
                    iso88591cs = 0;
                    break;
                }
                ++i;
            }
            if (iso88591cs != 0) {
                if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("Adding '" + CodeSetDatabase.getNameFromId(iso88591cs) + "' to the list of conversion codesets for char data.");
                }
                int[] tmp = new int[csc_char.conversion_code_sets.length + 1];
                System.arraycopy(csc_char.conversion_code_sets, 0, tmp, 0, csc_char.conversion_code_sets.length);
                tmp[csc_char.conversion_code_sets.length] = iso88591cs;
                csc_char.conversion_code_sets = tmp;
            }
        }
        if (csc_char.native_code_set != (asciics = 65568)) {
            int i = 0;
            while (i < csc_char.conversion_code_sets.length) {
                if (asciics == csc_char.conversion_code_sets[i]) {
                    asciics = 0;
                    break;
                }
                ++i;
            }
            if (asciics != 0) {
                if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("Adding '" + CodeSetDatabase.getNameFromId(asciics) + "' to the list of conversion codesets for char data.");
                }
                int[] tmp = new int[csc_char.conversion_code_sets.length + 1];
                System.arraycopy(csc_char.conversion_code_sets, 0, tmp, 0, csc_char.conversion_code_sets.length);
                tmp[csc_char.conversion_code_sets.length] = asciics;
                csc_char.conversion_code_sets = tmp;
            }
        }
        csid = 65801;
        if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("Using wchar data codeset '" + CodeSetDatabase.getNameFromId(csid) + "'.");
        }
        CodeSetComponent csc_wchar = new CodeSetComponent(csid, this.allCompatCodeSets(csid, false, server));
        return new CodeSetComponentInfo(csc_char, csc_wchar);
    }

    private int[] allCompatCodeSets(int codesetID, boolean singleByte, boolean server) {
        CodeSet entry = CodeSetDatabase.getCodeSetFromId(codesetID);
        if (entry == null) {
            return new int[0];
        }
        short[] charsetIDs = entry.getCharsets();
        if (charsetIDs.length == 1) {
            int[] list = CodeSetDatabase.getCodeSetsFromCharset(charsetIDs[0]);
            int[] ret = new int[list.length];
            int upto = 0;
            int i = 0;
            while (i < list.length) {
                CodeSet cs = CodeSetDatabase.getCodeSetFromId(list[i]);
                if (!(server && !cs.forServer() || cs.getName() == null || cs.getCharsets().length != 1 || singleByte && cs.getAlignment() > 1 || cs.getId() == codesetID)) {
                    ret[upto++] = cs.getId();
                }
                ++i;
            }
            if (upto < ret.length) {
                int[] tmp = new int[upto];
                System.arraycopy(ret, 0, tmp, 0, upto);
                return tmp;
            }
            return ret;
        }
        ArrayList[] cp = new ArrayList[charsetIDs.length - 1];
        int i = 0;
        while (i < cp.length) {
            cp[i] = new ArrayList();
            ++i;
        }
        HashSet<CodeSet> examined = new HashSet<CodeSet>();
        examined.add(entry);
        int total = 0;
        int i2 = 0;
        while (i2 < charsetIDs.length) {
            int[] list = CodeSetDatabase.getCodeSetsFromCharset(charsetIDs[0]);
            CodeSet csi = CodeSetDatabase.getCodeSetFromId(list[i2]);
            int j = 0;
            while (j < list.length) {
                CodeSet csj = CodeSetDatabase.getCodeSetFromId(list[j]);
                if (!(server && !csi.forServer() || csi.getName() == null || singleByte && csj.getAlignment() > 1 || !examined.add(csj))) {
                    int count = 0;
                    int k = 0;
                    int l = 0;
                    while (k < entry.getCharsets().length && k < csi.getCharsets().length) {
                        if (entry.getCharsets()[k] == csi.getCharsets()[l]) {
                            ++count;
                            ++l;
                        } else if (entry.getCharsets()[k] < csi.getCharsets()[l]) {
                            ++i2;
                        } else {
                            ++j;
                        }
                        ++k;
                    }
                    if (count >= 2) {
                        cp[cp.length - count + 2].add(NumberCache.getInteger((int)csj.getId()));
                        ++total;
                    }
                }
                ++j;
            }
            ++i2;
        }
        int[] ret = new int[total];
        int upto = 0;
        int i3 = 0;
        while (i3 < cp.length) {
            Iterator itt = ((AbstractList)cp[i3]).iterator();
            while (itt.hasNext()) {
                ret[upto++] = (Integer)itt.next();
            }
            ++i3;
        }
        return ret;
    }

    private static void usage() {
        System.err.println("usage: java org.openorb.orb.iiop.CodeSetDatabase <database file> [-i]");
        System.err.println();
        System.err.println("  This program converts a codeset registry obtained from");
        System.err.println("  ftp://ftp.opengroup.org/pub/code_set_registry into a class");
        System.err.println("  org.openorb.orb.iiop.CodeSetDatabase, which is used to initialize the");
        System.err.println("  codeset database.");
        System.err.println("  <database file>   OSF registry file.");
        System.err.println("  -i                turns on interactive mode.");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        File fo;
        if (args.length < 1 && args.length > 2) {
            CodeSetDatabaseInitializer.usage();
            return;
        }
        boolean bInteractive = false;
        if (args.length == 2) {
            System.out.println("Starting in interactive mode...");
            bInteractive = true;
        } else {
            System.out.println("Starting in bulk mode...");
        }
        File fi = new File(args[0]);
        if (!fi.isFile() || !fi.canRead()) {
            System.err.println("Cannot open \"" + args[0] + "\" for reading.");
            System.exit(1);
        }
        if ((fo = new File("CodeSetDatabase.java")).exists() && !fo.isFile()) {
            System.err.println("Unable to overwrite non-file CodeSetDatabase.java");
            return;
        }
        try {
            String line;
            BufferedReader usr = new BufferedReader(new InputStreamReader(System.in));
            if (fo.isFile() && bInteractive) {
                System.out.print("Overwrite CodeSetDatabase.java? (yes): ");
                System.out.flush();
                if (usr.readLine().length() != 0) {
                    return;
                }
            }
            BufferedReader in = new BufferedReader(new FileReader(fi));
            Hashtable<Integer, CodeSet> codesetIDDB = new Hashtable<Integer, CodeSet>();
            Hashtable<String, ArrayList<Integer>> encodingToCodesetID = new Hashtable<String, ArrayList<Integer>>();
            Hashtable<Short, ArrayList<Integer>> charsetIDToCodesetID = new Hashtable<Short, ArrayList<Integer>>();
            Hashtable<Integer, Boolean> useCodeset = new Hashtable<Integer, Boolean>();
            while ((line = in.readLine()) != null) {
                boolean bUseCS;
                void var10_11;
                if (!var10_11.equals("start")) continue;
                System.out.println();
                System.out.println("-----------------------------------------------------------------------");
                line = in.readLine();
                System.out.println(line);
                String strDescription = line.substring("Short Description\t".length());
                line = in.readLine();
                System.out.println(line);
                int codesetID = Integer.parseInt(line.substring("Registered Value\t0x".length()), 16);
                line = in.readLine();
                System.out.println(line);
                ArrayList<Short> arrayList = new ArrayList<Short>();
                int lidx = line.indexOf("0x") - 1;
                int idx = line.indexOf(58, lidx);
                while (idx >= 0) {
                    arrayList.add(Short.decode(line.substring(lidx + 1, idx)));
                    lidx = idx;
                    idx = line.indexOf(58, lidx + 1);
                }
                arrayList.add(Short.decode(line.substring(lidx + 1)));
                short[] charsetIDs = new short[arrayList.size()];
                int i = 0;
                while (i < arrayList.size()) {
                    charsetIDs[i] = (Short)arrayList.get(i);
                    ++i;
                }
                line = in.readLine();
                System.out.println(line);
                int iMaxSize = Integer.parseInt(line.substring("Max Bytes per Character\t".length()));
                while (!(line = in.readLine()).equals("end")) {
                    System.out.println(line);
                }
                System.out.println();
                CodeSet entry = CodeSetDatabase.getCodeSetFromId(codesetID);
                boolean bServer = false;
                String strEncoding = null;
                String strCanonical = null;
                int iAlignment = -1;
                if (entry != null && entry.getAlignment() >= 0) {
                    block33: {
                        strEncoding = entry.getName();
                        iAlignment = entry.getAlignment();
                        try {
                            strCanonical = CodeSetDatabase.canonicalize(entry.getName());
                            if (bInteractive) {
                                System.out.print("Reuse old? encoding=\"" + entry.getName() + "\" align=" + entry.getAlignment() + " (yes): ");
                                if (usr.readLine().length() == 0) {
                                    useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.TRUE);
                                } else {
                                    useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.FALSE);
                                }
                            } else {
                                useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.TRUE);
                            }
                        }
                        catch (UnsupportedEncodingException ex) {
                            if (!bInteractive) break block33;
                            System.out.print("Reuse old? unknown encoding=\"" + entry.getName() + "\" align=" + entry.getAlignment() + " (yes): ");
                            if (usr.readLine().length() == 0) {
                                useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.TRUE);
                            }
                            useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.FALSE);
                        }
                    }
                    System.out.flush();
                }
                Boolean useCS = (Boolean)useCodeset.get(NumberCache.getInteger((int)codesetID));
                if (bInteractive && useCS == null) {
                    block34: {
                        while (true) {
                            System.out.print("Encoding name (blank to skip): ");
                            System.out.flush();
                            strEncoding = usr.readLine();
                            if (strEncoding.length() == 0) break block34;
                            try {
                                strCanonical = CodeSetDatabase.canonicalize(strEncoding);
                                System.out.println("Canonical name: \"" + strCanonical + "\"");
                                System.out.print("Store encoding? (yes): ");
                                System.out.flush();
                                iAlignment = CodeSetDatabaseInitializer.discoverWidth(iMaxSize, strEncoding, -1, usr);
                                if (usr.readLine().length() == 0 && iAlignment != 0) break;
                                useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.TRUE);
                            }
                            catch (UnsupportedEncodingException ex) {
                                System.out.print("Unsupported encoding.Use anyhow? (yes),(a)gain,no: ");
                                System.out.flush();
                                line = usr.readLine();
                                if (line.startsWith("a")) continue;
                                iAlignment = CodeSetDatabaseInitializer.discoverWidth(iMaxSize, strEncoding, -1, usr);
                                if (usr.readLine().length() != 0 || iAlignment == 0) {
                                    useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.TRUE);
                                    break;
                                }
                                useCodeset.put(NumberCache.getInteger((int)codesetID), Boolean.FALSE);
                            }
                            break;
                        }
                        System.out.print("Use encoding in server profiles? (no): ");
                        System.out.flush();
                        bServer = usr.readLine().length() != 0;
                    }
                    System.out.println();
                    entry = new CodeSet(strDescription, codesetID, charsetIDs, iMaxSize, CodeSetDatabase.canonicalize(strEncoding), strEncoding, iAlignment, bServer);
                }
                boolean bl = bUseCS = useCS != null ? useCS : false;
                if (bUseCS) {
                    System.out.println("##### Adding the entry...");
                    codesetIDDB.put(NumberCache.getInteger((int)codesetID), entry);
                    ArrayList al = null;
                    int i2 = 0;
                    while (i2 < charsetIDs.length) {
                        al = (ArrayList)charsetIDToCodesetID.get(NumberCache.getShort((short)charsetIDs[i2]));
                        if (al != null) {
                            al.add(NumberCache.getInteger((int)codesetID));
                        } else {
                            al = new ArrayList();
                            al.add(NumberCache.getInteger((int)codesetID));
                            charsetIDToCodesetID.put(NumberCache.getShort((short)charsetIDs[i2]), al);
                        }
                        ++i2;
                    }
                    al = (ArrayList)encodingToCodesetID.get(strCanonical);
                    if (al != null) {
                        al.add(NumberCache.getInteger((int)codesetID));
                    } else {
                        al = new ArrayList();
                        al.add(NumberCache.getInteger((int)codesetID));
                        encodingToCodesetID.put(strCanonical, al);
                    }
                } else {
                    System.out.println("##### Skipping the entry...");
                }
                System.out.println("-----------------------------------------------------------------------");
                System.out.println();
            }
            PrintWriter pw = new PrintWriter(new FileWriter(fo));
            CodeSetDatabaseInitializer.printDBToFile(pw, codesetIDDB, encodingToCodesetID, charsetIDToCodesetID);
        }
        catch (IOException ex) {
            System.err.println("IO Exception occoured");
        }
    }

    private static void printDBToFile(PrintWriter pw, Hashtable codesetIDDB, Hashtable encodingToCodesetID, Hashtable charsetIDToCodesetID) throws UnsupportedEncodingException {
        Comparator rev_comp = Collections.reverseOrder();
        pw.println("/*");
        pw.println("* Copyright (C) The Community OpenORB Project. All rights reserved.");
        pw.println("*");
        pw.println("* This software is published under the terms of The OpenORB Community Software");
        pw.println("* License version 1.0, a copy of which has been included with this distribution");
        pw.println("* in the LICENSE.txt file.");
        pw.println("*/");
        pw.println();
        pw.println("package org.openorb.orb.iiop;");
        pw.println();
        pw.println("import org.openorb.util.NumberCache;");
        pw.println();
        pw.println("/** CodeSetDatabase.java");
        pw.println(" * This class has been automatically generated on " + new Date() + ".");
        pw.println(" * Use 'java org.openorb.iiop.CodeSetDatabaseInitializer src/main/org/openorb/orb/iiop/cs_registry1_2h.txt'");
        pw.println(" * to generate it. DO NOT MODIFY MANUALLY !!!");
        pw.println(" *");
        pw.println(" * @author The CodeSetDatabaseInitializer tool.");
        pw.println(" */");
        pw.println("public class CodeSetDatabase");
        pw.println("{");
        pw.println();
        pw.println("    /**");
        pw.println("     * Convert an encoding name into it's canonical Java name.");
        pw.println("     */");
        pw.println("    public static String canonicalize( String encoding )");
        pw.println("        throws java.io.UnsupportedEncodingException");
        pw.println("    {");
        pw.println("        // Use this way to get the canonical encoding name.");
        pw.println("        // Internally the sun.io.Converters and");
        pw.println("        // sun.io.CharacterEncoding are used to convert the");
        pw.println("        // name. If we use these classes directly");
        pw.println("        // we would limit the number of supported JDKs to the");
        pw.println("        // Sun JDKs only. It isn't the most efficient way to");
        pw.println("        // create an OutputStreamWriter just for doing a String");
        pw.println("        // conversion, but JDKs before 1.4 provide no other ");
        pw.println("        // to get the canonical name.");
        pw.println("        java.io.OutputStreamWriter osw = new java.io.OutputStreamWriter( System.out, encoding );");
        pw.println("        return osw.getEncoding();");
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("     * Populates the map between canonical codeset names");
        pw.println("     * and an ArrayList of codeset ids.");
        pw.println("     */");
        pw.println("    public static void populateNameToIdMap( java.util.HashMap map )");
        pw.println("    {");
        pw.println("        java.util.ArrayList al = null;");
        Enumeration e = encodingToCodesetID.keys();
        while (e.hasMoreElements()) {
            String strEnc = (String)e.nextElement();
            pw.println();
            ArrayList al = (ArrayList)encodingToCodesetID.get(strEnc);
            Collections.sort(al, rev_comp);
            ListIterator li = ((AbstractList)al).listIterator();
            pw.println("        al = new java.util.ArrayList();");
            while (li.hasNext()) {
                pw.println("        al.add( NumberCache.getInteger( 0x" + HexPrintStream.toHex((int)((Integer)li.next())) + " ) );");
            }
            pw.println("        map.put( \"" + CodeSetDatabase.canonicalize(strEnc).toUpperCase() + "\", al );");
        }
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("     * Return a CodeSet object for an OSF registry codeset id.");
        pw.println("     *");
        pw.println("     * @param id An OSF charset and codeset registry id.");
        pw.println("     * @return A CodeSet object.");
        pw.println("     */");
        pw.println("    public static CodeSet getCodeSetFromId( int id )");
        pw.println("    {");
        pw.println("        switch( id )");
        pw.println("        {");
        Enumeration e2 = codesetIDDB.keys();
        while (e2.hasMoreElements()) {
            Integer codesetID = (Integer)e2.nextElement();
            CodeSet de = (CodeSet)codesetIDDB.get(codesetID);
            pw.println("            case 0x" + HexPrintStream.toHex((int)codesetID) + ":");
            pw.println("              return new CodeSet( " + de + " );");
        }
        pw.println("            default:");
        pw.println("                return null;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("     * Return the alignment for an OSF registry codeset id.");
        pw.println("     * This method replaces the method CodeSet.getAlignmentFromId()");
        pw.println("     * and moves the functionality to the time when the class");
        pw.println("     * CodeSetDatabase is created from the OSF charset and");
        pw.println("     * codeset registry file.");
        pw.println("     *");
        pw.println("     * @param id An OSF charset and codeset registry id.");
        pw.println("     * @return The aligment for the specified codeset");
        pw.println("     * <ul>");
        pw.println("     * <li><code>-1</code>When the codeset id doesn't exist or the");
        pw.println("     * maximum size is 1, i.e.");
        pw.println("     * the codeset is a byte-oriented single-byte codeset</li>");
        pw.println("     * <li><code>0</code> When it is a byte-oriented multi-byte");
        pw.println("     * codeset</li>");
        pw.println("     * <li><code>&gt;= 1</code> When it is a fixed-length");
        pw.println("     * non-byte-oriented codeset (e.g. 2 for UCS codesets)</li>");
        pw.println("     * </ul>");
        pw.println("     */");
        pw.println("    public static int getAlignmentFromId( int id )");
        pw.println("    {");
        pw.println("        switch( id )");
        pw.println("        {");
        Enumeration e3 = codesetIDDB.keys();
        while (e3.hasMoreElements()) {
            Integer codesetID = (Integer)e3.nextElement();
            CodeSet de = (CodeSet)codesetIDDB.get(codesetID);
            pw.println("            case 0x" + HexPrintStream.toHex((int)codesetID) + ":");
            pw.println("                return " + de.getAlignment() + ";");
        }
        pw.println("            default:");
        pw.println("                return -1;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("     * Returns the name of a OSF charset and codeset registry entry.");
        pw.println("     *");
        pw.println("     * @param id An OSF charset and codeset registry id.");
        pw.println("     * @return The name of the codeset.");
        pw.println("     */");
        pw.println("    public static String getNameFromId( int id )");
        pw.println("    {");
        pw.println("        switch( id )");
        pw.println("        {");
        Enumeration e4 = codesetIDDB.keys();
        while (e4.hasMoreElements()) {
            Integer codesetID = (Integer)e4.nextElement();
            CodeSet de = (CodeSet)codesetIDDB.get(codesetID);
            pw.println("            case 0x" + HexPrintStream.toHex((int)codesetID) + ":");
            pw.println("                return \"" + de.getName() + "\";");
        }
        pw.println("            default:");
        pw.println("                return null;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("     * Returns the canonical Java name of a OSF charset");
        pw.println("     * and codeset registry entry.");
        pw.println("     *");
        pw.println("     * @param id An OSF charset and codeset registry id.");
        pw.println("     * @return The name of the codeset.");
        pw.println("     */");
        pw.println("    public static String getCanonicalNameFromId( int id )");
        pw.println("    {");
        pw.println("        switch( id )");
        pw.println("        {");
        Enumeration e5 = codesetIDDB.keys();
        while (e5.hasMoreElements()) {
            Integer codesetID = (Integer)e5.nextElement();
            CodeSet de = (CodeSet)codesetIDDB.get(codesetID);
            pw.println("            case 0x" + HexPrintStream.toHex((int)codesetID) + ":");
            pw.println("                return \"" + CodeSetDatabase.canonicalize(de.getName()) + "\";");
        }
        pw.println("            default:");
        pw.println("                return null;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("     * Returns the description of a OSF charset and codeset");
        pw.println("     * registry entry.");
        pw.println("     *");
        pw.println("     * @param id An OSF charset and codeset registry id.");
        pw.println("     * @return The OSF description of the codeset.");
        pw.println("     */");
        pw.println("    public static String getDescriptionFromId( int id )");
        pw.println("    {");
        pw.println("        switch( id )");
        pw.println("        {");
        Enumeration e6 = codesetIDDB.keys();
        while (e6.hasMoreElements()) {
            Integer codesetID = (Integer)e6.nextElement();
            CodeSet de = (CodeSet)codesetIDDB.get(codesetID);
            pw.println("            case 0x" + HexPrintStream.toHex((int)codesetID) + ":");
            pw.println("                return \"" + de.getDescription() + "\";");
        }
        pw.println("            default:");
        pw.println("                return null;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("     * Return an array of CodeSet objects that support the");
        pw.println("     * specified charset.");
        pw.println("     *");
        pw.println("     * @param id An OSF charset registry id.");
        pw.println("     * @return An array of codeset ids supporting the charset.");
        pw.println("     */");
        pw.println("    public static int[] getCodeSetsFromCharset( short charset )");
        pw.println("    {");
        pw.println("        switch( charset )");
        pw.println("        {");
        Enumeration e7 = charsetIDToCodesetID.keys();
        while (e7.hasMoreElements()) {
            Short charsetID = (Short)e7.nextElement();
            ArrayList al = (ArrayList)charsetIDToCodesetID.get(charsetID);
            Collections.sort(al, rev_comp);
            ListIterator li = ((AbstractList)al).listIterator();
            pw.println("            case 0x" + HexPrintStream.toHex((short)charsetID) + ":");
            pw.println("                return new int[] {");
            while (li.hasNext()) {
                Integer codesetID = (Integer)li.next();
                pw.println("                    0x" + HexPrintStream.toHex((int)codesetID) + (li.hasNext() ? ", " : ""));
            }
            pw.println("                };");
        }
        pw.println("            default:");
        pw.println("                return null;");
        pw.println("        }");
        pw.println("    }");
        pw.println("}");
        pw.flush();
    }

    private static int discoverWidth(int maxSize, String encoding, int prev, BufferedReader usr) throws IOException {
        if (maxSize == 1) {
            return 1;
        }
        if (encoding == null) {
            System.out.print("Codeset width? 1, 2, 4, prefixed, (cancel): ");
            System.out.flush();
            String line = usr.readLine();
            if (line.equals("1")) {
                return 1;
            }
            if (line.equals("2")) {
                return 2;
            }
            if (line.equals("4")) {
                return 4;
            }
            if (line.startsWith("p")) {
                return 0;
            }
            return -1;
        }
        while (true) {
            switch (prev) {
                case 0: {
                    System.out.print("Codeset width? 1, 2, 4, (prefixed), guess, RETURN: ");
                    break;
                }
                case 1: {
                    System.out.print("Codeset width? (1), 2, 4, prefixed, guess, RETURN: ");
                    break;
                }
                case 2: {
                    System.out.print("Codeset width? 1, (2), 4, prefixed, guess, RETURN: ");
                    break;
                }
                case 4: {
                    System.out.print("Codeset width? 1, 2, (4), prefixed, guess, RETURN: ");
                    break;
                }
                default: {
                    System.out.print("Codeset width? 1, 2, 4, prefixed, (guess), RETURN: ");
                }
            }
            String line = usr.readLine();
            if (line.length() == 0) {
                if (prev != -1) {
                    return prev;
                }
            } else {
                if (line.equals("1")) {
                    return 1;
                }
                if (line.equals("2")) {
                    return 2;
                }
                if (line.equals("4")) {
                    return 4;
                }
                if (line.startsWith("p")) {
                    return 0;
                }
                if (!line.startsWith("g")) {
                    return -1;
                }
            }
            System.out.println("Guessing char width");
            int[] len = new int[maxSize * 2 + 1];
            char c = '\u0000';
            while (c < '\uffff') {
                try {
                    int n = String.valueOf(c).getBytes(encoding).length;
                    len[n] = len[n] + 1;
                }
                catch (Error ex) {
                    len[0] = len[0] + 1;
                }
                c = (char)(c + '\u0001');
            }
            int i = 0;
            while (i < len.length) {
                if (i == 0) {
                    System.out.println("" + len[i] + " Errors.");
                } else if (len[i] > 0) {
                    System.out.println(len[i] + " of length " + i);
                }
                ++i;
            }
            System.out.println("String \"aa\" is length " + "aa".getBytes(encoding).length);
            if (len[1] == 0) continue;
            prev = len[2] != 0 ? 0 : 1;
        }
    }
}

