/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.SystemException;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ListenPointHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.orb.Initializer;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.Property;
import org.openorb.orb.core.ORB;
import org.openorb.orb.iiop.CDRCodecFactory;
import org.openorb.orb.iiop.CodeSetDatabaseInitializer;
import org.openorb.orb.iiop.IIOPClientProtocol;
import org.openorb.orb.iiop.IIOPServerChannel;
import org.openorb.orb.iiop.IIOPServerProtocol;
import org.openorb.orb.iiop.IIOPServerRequest;
import org.openorb.orb.iiop.IIOPTransportClientInitializer;
import org.openorb.orb.iiop.IIOPTransportServerInitializer;
import org.openorb.orb.net.ClientManager;
import org.openorb.orb.net.ConfiguredSocketFactory;
import org.openorb.orb.net.ServerManager;
import org.openorb.orb.pi.CodecFactoryManager;
import org.openorb.orb.pi.FeatureInitInfo;
import org.openorb.orb.pi.FeatureInitializer;
import org.openorb.orb.pi.SimpleIORInterceptor;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;
import org.openorb.util.ReflectionUtils;
import org.openorb.util.logger.ControllableLogger;
import org.openorb.util.logger.DiagnosticsLoggerTeam;
import org.openorb.util.logger.LoggerTeam;

public class IIOPProtocolInitializer
extends AbstractLogEnabled
implements FeatureInitializer,
Initializer {
    private static final ServerRequestInterceptor BIDIR_INTERCEPTOR = new BiDirServerInterceptor();
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ORBInitInfo;
    static /* synthetic */ Class class$org$openorb$orb$pi$FeatureInitInfo;

    public String getName() {
        return "iiop";
    }

    public void init(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        ServerManager svrmgr;
        if (this.getLogger().isErrorEnabled() && Trace.isLow()) {
            this.getLogger().debug("init");
        }
        CodeSetDatabaseInitializer csdb = new CodeSetDatabaseInitializer();
        csdb.enableLogging(this.getLogger().getChildLogger("csdb"));
        csdb.initialize();
        featureinfo.setFeature("CodeSetDatabase", csdb);
        ORB orb = featureinfo.orb();
        CDRCodecFactory codec_factory = new CDRCodecFactory((org.omg.CORBA.ORB)orb);
        Codec codec = null;
        CodecFactoryManager cfm = (CodecFactoryManager)featureinfo.getFeature("CodecFactoryManager");
        if (cfm != null) {
            cfm.register_codec_factory(new Encoding(0, 1, 0), codec_factory);
            cfm.register_codec_factory(new Encoding(0, 1, 1), codec_factory);
            Encoding enc = new Encoding(0, 1, 2);
            cfm.register_codec_factory(enc, codec_factory);
            try {
                codec = codec_factory.create_codec(enc);
                if ((class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = IIOPProtocolInitializer.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled).isAssignableFrom(codec.getClass())) {
                    ((LogEnabled)codec).enableLogging(this.getLogger().getChildLogger("codec"));
                }
            }
            catch (Exception ex) {
                this.getLogger().error("Error during create_codec().", (Throwable)ex);
                return;
            }
        }
        ListenPoint[] biDirListenPoints = null;
        ORBLoader loader = featureinfo.getLoader();
        IIOPServerProtocol svrproto = null;
        if (null == featureinfo.getFeature("IIOP.SocketFactory")) {
            LoggerTeam socketLogger = DiagnosticsLoggerTeam.narrow((Logger)this.getLogger(), (Logger)new ControllableLogger(this.getLogger(), Trace.LOGGER_CONTROL), (String)"diagnostics").createChildLoggerTeam("socket-factory");
            ConfiguredSocketFactory socketFactory = new ConfiguredSocketFactory(socketLogger, loader, "iiop");
            featureinfo.setFeature("IIOP.SocketFactory", socketFactory);
        }
        if ((svrmgr = (ServerManager)featureinfo.getFeature("ServerCPCManager")) != null) {
            IIOPTransportServerInitializer svrInit;
            Any any = orb.create_any();
            CodeSetComponentInfo codesetInfo = csdb.getServerCodeSets();
            CodeSetComponentInfoHelper.insert((Any)any, (CodeSetComponentInfo)codesetInfo);
            ArrayList<TaggedComponent> iorComponents = new ArrayList<TaggedComponent>();
            try {
                byte[] buf = codec.encode_value(any);
                if (buf != null) {
                    iorComponents.add(new TaggedComponent(1, buf));
                }
            }
            catch (InvalidTypeForEncoding ex) {
                String error = "Unable to encode code set component.";
                this.getLogger().error("Unable to encode code set component.", (Throwable)ex);
                throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to encode code set component.")), (Throwable)ex);
            }
            Iterator itt = loader.properties("iiop.alternateAddr");
            while (itt.hasNext()) {
                int port;
                String hostport = ((Property)itt.next()).getValue();
                int idx = hostport.indexOf(58);
                if (idx < 0) continue;
                String host = hostport.substring(0, idx);
                try {
                    port = Integer.parseInt(hostport.substring(idx + 1));
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (port > 65535) continue;
                ListenPoint lp = new ListenPoint(host, (short)port);
                ListenPointHelper.insert((Any)any, (ListenPoint)lp);
                try {
                    byte[] buf = codec.encode_value(any);
                    if (buf == null) continue;
                    iorComponents.add(new TaggedComponent(3, buf));
                }
                catch (InvalidTypeForEncoding ex) {
                    String error = "Unable to encode alternate endpoint component.";
                    this.getLogger().error("Unable to encode alternate endpoint component.", (Throwable)ex);
                    throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to encode alternate endpoint component.")), (Throwable)ex);
                }
            }
            if (!iorComponents.isEmpty()) {
                TaggedComponent[] altAddrComponents = new TaggedComponent[iorComponents.size()];
                iorComponents.toArray(altAddrComponents);
                try {
                    orbinfo.add_ior_interceptor((IORInterceptor)new SimpleIORInterceptor("codesets and alts", 0, altAddrComponents));
                }
                catch (DuplicateName ex) {
                    // empty catch block
                }
            }
            boolean listen = true;
            if (loader.getBooleanProperty("iiop.allowBiDir", true)) {
                try {
                    orbinfo.add_server_request_interceptor(BIDIR_INTERCEPTOR);
                }
                catch (DuplicateName ex) {
                    // empty catch block
                }
                listen = !loader.getBooleanProperty("iiop.biDirOnlyServer", false);
            }
            try {
                Class clz = loader.getClassProperty("iiop.TransportServerInitializerClass", "org.openorb.orb.iiop.IIOPTransportServerInitializer");
                svrInit = (IIOPTransportServerInitializer)clz.newInstance();
            }
            catch (Exception ex) {
                throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to create TransportServerInitializer instance (" + ex + ")", 0, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
            }
            if ((class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = IIOPProtocolInitializer.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled).isAssignableFrom(svrInit.getClass())) {
                String logger_name = "iioptsi";
                if (svrInit instanceof Initializer) {
                    IIOPTransportServerInitializer init = svrInit;
                    logger_name = init.getName();
                }
                svrInit.enableLogging(this.getLogger().getChildLogger(logger_name));
            }
            ReflectionUtils.invokeMethod((Object)svrInit, (String)"init", (Class[])new Class[]{class$org$omg$PortableInterceptor$ORBInitInfo == null ? (class$org$omg$PortableInterceptor$ORBInitInfo = IIOPProtocolInitializer.class$("org.omg.PortableInterceptor.ORBInitInfo")) : class$org$omg$PortableInterceptor$ORBInitInfo, class$org$openorb$orb$pi$FeatureInitInfo == null ? (class$org$openorb$orb$pi$FeatureInitInfo = IIOPProtocolInitializer.class$("org.openorb.orb.pi.FeatureInitInfo")) : class$org$openorb$orb$pi$FeatureInitInfo}, (Object[])new Object[]{orbinfo, featureinfo});
            if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
                this.getLogger().debug("IIOP transport server initializer started: " + svrInit);
            }
            if (listen) {
                svrInit.open();
            }
            svrproto = new IIOPServerProtocol(svrmgr, codec_factory, svrInit);
            svrmgr.register_protocol(0, svrproto);
            if (listen) {
                svrproto.open();
            }
            biDirListenPoints = svrInit.getBiDirEndpoints();
        }
        IIOPClientProtocol cltproto = null;
        ClientManager cltmgr = (ClientManager)featureinfo.getFeature("ClientCPCManager");
        if (cltmgr != null) {
            IIOPTransportClientInitializer cltInit;
            try {
                Class clz = loader.getClassProperty("iiop.TransportClientInitializerClass", "org.openorb.orb.iiop.IIOPTransportClientInitializer");
                cltInit = (IIOPTransportClientInitializer)clz.newInstance();
            }
            catch (Exception ex) {
                throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to create TransportClientInitializer instance (" + ex + ")", 0, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
            }
            if (cltInit instanceof LogEnabled) {
                String logger_name = "iioptci";
                if (cltInit instanceof Initializer) {
                    IIOPTransportClientInitializer init = cltInit;
                    logger_name = init.getName();
                }
                cltInit.enableLogging(this.getLogger().getChildLogger(logger_name));
            }
            ReflectionUtils.invokeMethod((Object)cltInit, (String)"init", (Class[])new Class[]{class$org$omg$PortableInterceptor$ORBInitInfo == null ? (class$org$omg$PortableInterceptor$ORBInitInfo = IIOPProtocolInitializer.class$("org.omg.PortableInterceptor.ORBInitInfo")) : class$org$omg$PortableInterceptor$ORBInitInfo, class$org$openorb$orb$pi$FeatureInitInfo == null ? (class$org$openorb$orb$pi$FeatureInitInfo = IIOPProtocolInitializer.class$("org.openorb.orb.pi.FeatureInitInfo")) : class$org$openorb$orb$pi$FeatureInitInfo}, (Object[])new Object[]{orbinfo, featureinfo});
            if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
                this.getLogger().debug("IIOP transport client initializer started: " + cltInit);
            }
            cltproto = new IIOPClientProtocol(cltmgr, codec_factory, csdb.getClientCodeSets(), cltInit, biDirListenPoints);
            cltmgr.register_protocol(0, cltproto);
            if (svrproto != null) {
                cltproto.setServerProtocol(svrproto);
                svrproto.setClientProtocol(cltproto);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class BiDirServerInterceptor
    extends LocalObject
    implements ServerRequestInterceptor {
        private BiDirServerInterceptor() {
        }

        public String name() {
            return "IIOPBiDirServerInterceptor";
        }

        public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
            if (ri instanceof IIOPServerRequest) {
                IIOPServerRequest request = (IIOPServerRequest)ri;
                IIOPServerChannel channel = (IIOPServerChannel)request.channel();
                channel.checkBiDirActivation(request);
            }
        }

        public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void send_reply(ServerRequestInfo ri) {
        }

        public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void destroy() {
        }
    }
}

