/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.Version;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.openorb.orb.core.ORB;
import org.openorb.orb.iiop.CDRInputStream;
import org.openorb.orb.iiop.CDROutputStream;
import org.openorb.orb.iiop.HeaderBlock;
import org.openorb.orb.iiop.IIOPClientChannel;
import org.openorb.orb.iiop.IIOPClientProtocol;
import org.openorb.orb.iiop.IIOPServerRequest;
import org.openorb.orb.iiop.SocketQueue;
import org.openorb.orb.io.BufferSource;
import org.openorb.orb.io.MarshalBuffer;
import org.openorb.orb.io.StorageBuffer;
import org.openorb.orb.net.ClientRequest;
import org.openorb.orb.net.RequestIDAllocator;
import org.openorb.orb.net.ServerChannel;
import org.openorb.orb.net.ServerManager;
import org.openorb.orb.net.ServerRequest;
import org.openorb.orb.net.Transport;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;

public class IIOPServerChannel
implements ServerChannel {
    public static final int CONN_SC_TOTAL = 2;
    public static final int CONN_SC_CODESETS = 0;
    public static final int CONN_SC_BIDIR = 1;
    private static int s_iiop_server_recv_timeout = 1000;
    private org.omg.CORBA.ORB m_orb;
    private ServerManager m_server_manager;
    private SocketQueue m_socket_queue;
    private java.lang.Object m_sync_state;
    private int m_state = 0;
    private boolean m_pending_close = false;
    private boolean m_codesets = false;
    private int m_tcsc = 0;
    private int m_tcsw = 0;
    private IIOPClientProtocol m_client_protocol = null;
    private IIOPClientChannel m_client_peer = null;
    private boolean m_delegated = false;
    private Map m_active_requests = new HashMap();
    private int m_channel_age;
    private java.lang.Object m_sync_recv = new java.lang.Object();
    private boolean m_in_recv = false;
    private Constructor m_os_ctor;
    private Codec m_codec;
    private ListenPoint[] m_pending_bidir_endpoints;
    private Logger m_logger = null;
    private boolean[] m_recv_connection_service_contexts = new boolean[2];
    private MarshalBuffer.Listener m_marshal_listener = new MarshalListener();
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$orb$io$MarshalBuffer;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;

    public IIOPServerChannel(ServerManager serverManager, Transport transport, IIOPClientProtocol clientProtocol, Codec codec) {
        this.m_server_manager = serverManager;
        this.m_orb = this.m_server_manager.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        try {
            Class[] cargs = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPServerChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPServerChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$orb$io$MarshalBuffer == null ? (class$org$openorb$orb$io$MarshalBuffer = IIOPServerChannel.class$("org.openorb.orb.io.MarshalBuffer")) : class$org$openorb$orb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.orb.iiop.CDROutputStream", cargs);
        }
        catch (Exception ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Unable to initialize output stream constructor.", (Throwable)ex);
            }
            throw ExceptionTool.initCause((SystemException)((java.lang.Object)new INITIALIZE("Unable to initialize output stream constructor (" + ex + ")")), (Throwable)ex);
        }
        this.m_socket_queue = new SocketQueue(transport);
        this.m_socket_queue.enableLogging(this.getLogger().getChildLogger("ssq"));
        this.m_socket_queue.setServerChannel(this);
        this.m_client_protocol = clientProtocol;
        this.m_codec = codec;
        this.m_sync_state = new java.lang.Object();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " created");
        }
        this.m_server_manager.register_channel(this);
    }

    public IIOPServerChannel(ServerManager serverManager, IIOPClientChannel peer, Codec codec) {
        this.m_server_manager = serverManager;
        this.m_orb = this.m_server_manager.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        try {
            Class[] cargs = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPServerChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPServerChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$orb$io$MarshalBuffer == null ? (class$org$openorb$orb$io$MarshalBuffer = IIOPServerChannel.class$("org.openorb.orb.io.MarshalBuffer")) : class$org$openorb$orb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.orb.iiop.CDROutputStream", cargs);
        }
        catch (Exception ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Unable to initialize output stream constructor.", (Throwable)ex);
            }
            throw ExceptionTool.initCause((SystemException)((java.lang.Object)new INITIALIZE("Unable to initialize output stream constructor (" + ex + ")")), (Throwable)ex);
        }
        this.m_client_peer = peer;
        this.m_socket_queue = this.m_client_peer.getSocketQueue();
        this.m_socket_queue.setServerChannel(this);
        this.m_delegated = true;
        this.m_codec = codec;
        this.m_sync_state = this.m_client_peer.getSyncState();
        this.m_codesets = true;
        this.m_tcsc = this.m_client_peer.getTCSC();
        this.m_tcsw = this.m_client_peer.getTCSW();
    }

    public Transport transport() {
        return this.m_socket_queue.getTransport();
    }

    public static void setIIOPServerRecvTimeout(int timeout) {
        s_iiop_server_recv_timeout = timeout;
    }

    public Map getActiveRequestMap() {
        return this.m_active_requests;
    }

    public SocketQueue getSocketQueue() {
        return this.m_socket_queue;
    }

    public ServerManager getServerManager() {
        return this.m_server_manager;
    }

    public java.lang.Object getSyncState() {
        return this.m_sync_state;
    }

    public int getChannelAge() {
        return this.m_channel_age;
    }

    public void setClientPeer(IIOPClientChannel cltchan) {
        this.m_client_peer = cltchan;
    }

    public int getTCSC() {
        return this.m_tcsc;
    }

    public void setTCSC(int tcsc) {
        this.m_tcsc = tcsc;
    }

    public int getTCSW() {
        return this.m_tcsw;
    }

    public void setTCSW(int tcsw) {
        this.m_tcsw = tcsw;
    }

    public void setPendingClose() {
        this.m_pending_close = true;
    }

    public String toString() {
        return "ServerChannel: " + this.m_socket_queue.toString();
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public int state() {
        if (this.m_delegated) {
            java.lang.Object object = this.m_sync_state;
            synchronized (object) {
                if (this.m_client_peer != null) {
                    int n = 0;
                    return n;
                }
                int n = 1;
                return n;
            }
        }
        return this.m_state;
    }

    public void setState(int state) {
        this.m_state = state;
    }

    public int active_requests() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            int n = this.m_active_requests.size() + (this.m_client_peer != null ? this.m_client_peer.getActiveRequestMap().size() : 0);
            return n;
        }
    }

    public int channel_age() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (!this.m_active_requests.isEmpty() || this.m_client_peer != null && !this.m_client_peer.getActiveRequestMap().isEmpty()) {
                int n = RequestIDAllocator.peek_request_id();
                return n;
            }
            if (this.m_client_peer != null && this.m_channel_age < this.m_client_peer.getChannelAge()) {
                int n = this.m_client_peer.getChannelAge();
                return n;
            }
            int n = this.m_channel_age;
            return n;
        }
    }

    public void close() {
        ClientRequest[] clientRequests;
        ServerRequest[] serverRequests;
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " disorderly shutdown");
        }
        if (this.m_delegated) {
            this.m_client_peer.close(true, (SystemException)new BAD_INV_ORDER(0, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 1) {
                return;
            }
            this.m_state = 1;
            this.m_pending_close = false;
            serverRequests = new ServerRequest[this.m_active_requests.values().size()];
            this.m_active_requests.values().toArray(serverRequests);
            this.m_active_requests.clear();
            if (this.m_client_peer != null) {
                Map actreq = this.m_client_peer.getActiveRequestMap();
                clientRequests = new ClientRequest[actreq.values().size()];
                actreq.values().toArray(clientRequests);
                actreq.clear();
                this.m_client_peer.setState(0x13000000);
                this.m_client_peer.setCloseException((SystemException)new BAD_INV_ORDER(0, CompletionStatus.COMPLETED_MAYBE));
                this.m_client_peer.setServerPeer(null);
                this.m_client_peer = null;
            } else {
                clientRequests = null;
            }
        }
        this.m_server_manager.unregister_channel(this);
        this.m_socket_queue.close();
        int i = 0;
        while (i < serverRequests.length) {
            serverRequests[i].client_cancel();
            ++i;
        }
        if (clientRequests != null) {
            int i2 = 0;
            while (i2 < clientRequests.length) {
                clientRequests[i2].cancel((SystemException)new BAD_INV_ORDER("ORB shutdown", 1330446340, CompletionStatus.COMPLETED_MAYBE));
                ++i2;
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " closed");
        }
    }

    public void soft_close(boolean ifActive) {
        if (Trace.isHigh() && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this + " soft close [" + ifActive + "]");
        }
        if (this.m_delegated) {
            if (!ifActive) {
                this.m_client_peer.pause();
            } else {
                this.m_client_peer.close(false, (SystemException)new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_NO));
            }
            return;
        }
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 1) {
                return;
            }
            if (this.active_requests() > 0) {
                if (ifActive) {
                    this.m_pending_close = true;
                    if (this.m_client_peer != null) {
                        this.m_client_peer.setPendingClose();
                    }
                }
                return;
            }
            this.m_state = 1;
            this.m_pending_close = false;
            if (this.m_client_peer != null) {
                this.m_client_peer.setState(0x12000000);
                this.m_client_peer.setServerPeer(null);
                this.m_client_peer = null;
            }
        }
        this.m_server_manager.unregister_channel(this);
        this.m_socket_queue.close();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " closed");
        }
    }

    public boolean recv(int timeout) {
        boolean bl;
        java.lang.Object object;
        boolean bl2;
        if (this.m_delegated) {
            return false;
        }
        java.lang.Object object2 = this.m_sync_recv;
        synchronized (object2) {
            if (this.m_in_recv) {
                boolean bl3 = true;
                return bl3;
            }
            this.m_in_recv = true;
        }
        try {
            if (!this.m_socket_queue.receive(timeout)) break block14;
            bl2 = true;
            java.lang.Object var6_7 = null;
            object = this.m_sync_recv;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_9 = null;
            java.lang.Object object3 = this.m_sync_recv;
            synchronized (object3) {
                this.m_in_recv = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this.m_in_recv = false;
        }
        {
            block14: {
                return bl2;
            }
            this.close();
            bl = false;
        }
        java.lang.Object var6_8 = null;
        java.lang.Object object4 = this.m_sync_recv;
        synchronized (object4) {
            this.m_in_recv = false;
        }
        return bl;
    }

    public void run_recv() {
        java.lang.Object object;
        if (this.m_delegated) {
            return;
        }
        java.lang.Object object2 = this.m_sync_recv;
        synchronized (object2) {
            if (this.m_in_recv) {
                return;
            }
            this.m_in_recv = true;
        }
        try {
            while (!Thread.interrupted()) {
                if (this.m_socket_queue.receive(s_iiop_server_recv_timeout)) continue;
                this.close();
                break;
            }
            java.lang.Object var4_3 = null;
            object = this.m_sync_recv;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            java.lang.Object object3 = this.m_sync_recv;
            synchronized (object3) {
                this.m_in_recv = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this.m_in_recv = false;
        }
    }

    int process_request(byte minor, CDRInputStream is, byte msg_type, BufferSource source) {
        IIOPServerRequest request = null;
        int request_id = 0;
        byte[] object_id = null;
        switch (msg_type) {
            case 0: {
                switch (minor) {
                    case 0: 
                    case 1: {
                        ServiceContext[] request_service_contexts = ServiceContextListHelper.read((InputStream)is);
                        request_id = is.read_ulong();
                        byte sync_scope = is.read_boolean() ? (byte)3 : 2;
                        object_id = OctetSeqHelper.read((InputStream)is);
                        String operation = is.read_string();
                        OctetSeqHelper.read((InputStream)is);
                        request = new IIOPServerRequest(this.m_server_manager, this, request_id, (InputStream)is, object_id, operation, sync_scope, request_service_contexts, new Version(1, minor));
                        this.checkConnectionSCs(request_service_contexts);
                        if (this.m_recv_connection_service_contexts == null || this.m_recv_connection_service_contexts[0]) {
                            is.setCodesets(this.m_tcsc, this.m_tcsw);
                        }
                        if (this.addRequest(request)) break;
                        return 0;
                    }
                    case 2: {
                        request_id = is.read_ulong();
                        request = new IIOPServerRequest(this.m_server_manager, this, request_id, (InputStream)is, new Version(1, minor));
                        request.setRequestSource(source);
                        if (!this.addRequest(request)) {
                            return 0;
                        }
                        byte sync_scope = is.read_octet();
                        is.skip(3L);
                        object_id = this.read_target_address(is.read_short(), is);
                        String operation = is.read_string();
                        ServiceContext[] request_service_contexts = ServiceContextListHelper.read((InputStream)is);
                        try {
                            is.alignment(8);
                        }
                        catch (SystemException ex) {
                            // empty catch block
                        }
                        if (!this.m_delegated) {
                            this.checkConnectionSCs(request_service_contexts);
                        }
                        if (this.m_recv_connection_service_contexts == null || this.m_recv_connection_service_contexts[0]) {
                            is.setCodesets(this.m_tcsc, this.m_tcsw);
                        }
                        request.init(object_id, operation, sync_scope, request_service_contexts);
                    }
                }
                source.removeWaitingForBufferListener(null);
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug(this + " incoming request #" + request_id);
                }
                this.m_server_manager.enqueue_request(request);
                break;
            }
            case 3: {
                switch (minor) {
                    case 0: 
                    case 1: {
                        request_id = is.read_ulong();
                        object_id = OctetSeqHelper.read((InputStream)is);
                        request = new IIOPServerRequest(this.m_server_manager, this, request_id, object_id, new Version(1, minor));
                        if (this.addRequest(request)) break;
                        return 0;
                    }
                    case 2: {
                        request_id = is.read_ulong();
                        request = new IIOPServerRequest(this.m_server_manager, this, request_id, new Version(1, minor));
                        request.setRequestSource(source);
                        if (!this.addRequest(request)) {
                            return 0;
                        }
                        object_id = this.read_target_address(is.read_short(), is);
                        request.init(object_id);
                    }
                }
                source.removeWaitingForBufferListener(null);
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug(this + " incoming locate request #" + request_id);
                }
                this.m_server_manager.enqueue_request(request);
                break;
            }
            case 2: {
                request_id = is.read_ulong();
                java.lang.Object object = this.m_sync_state;
                synchronized (object) {
                    request = (IIOPServerRequest)this.m_active_requests.remove(NumberCache.getInteger((int)request_id));
                }
                if (request == null) break;
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug(this + " request #" + request_id + " canceled by client");
                }
                request.client_cancel();
            }
        }
        return request_id;
    }

    void process_fragment(int req_id, StorageBuffer buf, boolean fragFollows) {
        IIOPServerRequest request;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            request = (IIOPServerRequest)this.m_active_requests.get(NumberCache.getInteger((int)req_id));
        }
        if (request != null) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                if (fragFollows) {
                    this.getLogger().debug(this + " request #" + req_id + " request fragment");
                } else {
                    this.getLogger().debug(this + " request #" + req_id + " last request fragment");
                }
            }
            request.getRequestSource().addLast(buf, !fragFollows);
        }
    }

    protected void checkConnectionSCs(ServiceContext[] request_service_contexts) {
        if (this.m_recv_connection_service_contexts == null) {
            return;
        }
        boolean recv = false;
        boolean readCSFirst = false;
        int i = 0;
        int j = 0;
        while (j < request_service_contexts.length) {
            if (request_service_contexts[j].context_id == 1) {
                readCSFirst = true;
                i = j;
                break;
            }
            ++j;
        }
        while (i < request_service_contexts.length) {
            switch (request_service_contexts[i].context_id) {
                case 1: {
                    if (this.m_recv_connection_service_contexts[0]) break;
                    byte[] cd = request_service_contexts[i].context_data;
                    if (cd[0] == 0) {
                        this.m_tcsc = (cd[4] & 0xFF) << 24 | (cd[5] & 0xFF) << 16 | (cd[6] & 0xFF) << 8 | cd[7] & 0xFF;
                        this.m_tcsw = (cd[8] & 0xFF) << 24 | (cd[9] & 0xFF) << 16 | (cd[10] & 0xFF) << 8 | cd[11] & 0xFF;
                    } else {
                        this.m_tcsc = (cd[7] & 0xFF) << 24 | (cd[6] & 0xFF) << 16 | (cd[5] & 0xFF) << 8 | cd[4] & 0xFF;
                        this.m_tcsw = (cd[11] & 0xFF) << 24 | (cd[10] & 0xFF) << 16 | (cd[9] & 0xFF) << 8 | cd[8] & 0xFF;
                    }
                    if (this.m_client_peer != null) {
                        this.m_client_peer.setTCSC(this.m_tcsc);
                        this.m_client_peer.setTCSW(this.m_tcsw);
                    }
                    this.m_recv_connection_service_contexts[0] = true;
                    recv = true;
                    break;
                }
                case 5: {
                    if (this.m_recv_connection_service_contexts[1]) break;
                    try {
                        if (this.m_client_protocol != null) {
                            Any any = this.m_codec.decode_value(request_service_contexts[i].context_data, BiDirIIOPServiceContextHelper.type());
                            this.m_pending_bidir_endpoints = BiDirIIOPServiceContextHelper.extract((Any)any).listen_points;
                        }
                        this.m_recv_connection_service_contexts[1] = true;
                        recv = true;
                        break;
                    }
                    catch (UserException ex) {
                        if (!this.getLogger().isErrorEnabled()) break;
                        this.getLogger().error("Unexpected UserException.", (Throwable)ex);
                    }
                }
            }
            if (readCSFirst) {
                i = -1;
                readCSFirst = false;
            }
            ++i;
        }
        if (recv) {
            int j2 = 0;
            while (j2 < this.m_recv_connection_service_contexts.length) {
                recv = recv && this.m_recv_connection_service_contexts[j2];
                ++j2;
            }
            if (recv) {
                this.m_recv_connection_service_contexts = null;
            }
        }
    }

    public void checkBiDirActivation(IIOPServerRequest request) {
        if (this.m_pending_bidir_endpoints != null && this.m_client_peer == null) {
            BidirectionalPolicy pol = null;
            try {
                pol = BidirectionalPolicyHelper.narrow((Object)request.get_server_policy(37));
            }
            catch (INV_POLICY iNV_POLICY) {
                // empty catch block
            }
            if (pol != null && pol.value() == 1) {
                java.lang.Object object = this.m_sync_state;
                synchronized (object) {
                    if (this.m_state == 0 && this.m_client_peer == null) {
                        this.m_client_peer = this.m_client_protocol.createBidirDelegate(this, this.m_pending_bidir_endpoints);
                        this.m_pending_bidir_endpoints = null;
                        if (this.m_client_peer != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                            this.getLogger().debug(this + " became bidirectional with peer " + this.m_client_peer.toString());
                        }
                    }
                }
            }
        }
    }

    private boolean addRequest(IIOPServerRequest request) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 1 || this.m_pending_close) {
                boolean bl = false;
                return bl;
            }
            this.m_active_requests.put(NumberCache.getInteger((int)request.request_id()), request);
        }
        return true;
    }

    private byte[] read_target_address(short disposition, CDRInputStream is) {
        byte[] object_id = null;
        switch (disposition) {
            case 0: {
                object_id = OctetSeqHelper.read((InputStream)is);
                break;
            }
            case 1: {
                if (is.read_ulong() != 0) {
                    return null;
                }
                is.begin_encapsulation();
                is.skip(2L);
                is.skip(is.read_long());
                is.skip(2L);
                object_id = OctetSeqHelper.read((InputStream)is);
                is.end_encapsulation();
                break;
            }
            case 2: {
                int offset = is.read_ulong();
                int len = is.read_ulong();
                int i = 0;
                while (i < len) {
                    if (i == offset) {
                        object_id = this.read_target_address((short)1, is);
                    } else {
                        is.skip(4L);
                        is.skip(is.read_ulong());
                    }
                    ++i;
                }
                break;
            }
        }
        return object_id;
    }

    CDROutputStream create_reply_stream(IIOPServerRequest req, int status) {
        CDROutputStream os;
        if (!this.m_socket_queue.isOpen()) {
            throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
        }
        Version vers = req.version();
        int req_id = req.request_id();
        ServiceContext[] reply_service_contexts = req.get_reply_service_contexts();
        MarshalBuffer buf = new MarshalBuffer(this.m_marshal_listener, req);
        buf.enableLogging(this.getLogger().getChildLogger("mb"));
        try {
            os = (CDROutputStream)this.m_os_ctor.newInstance(this.m_orb, vers, buf);
            if ((class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = IIOPServerChannel.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled).isAssignableFrom(os.getClass())) {
                os.enableLogging(this.getLogger().getChildLogger("os"));
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to create CDROutputStream class.", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((java.lang.Object)new INITIALIZE("Unable to create CDROutputStream class (" + ex + ")")), (Throwable)ex);
        }
        if (this.m_recv_connection_service_contexts == null || this.m_recv_connection_service_contexts[0]) {
            os.setCodesets(this.m_tcsc, this.m_tcsw);
        }
        new HeaderBlock(1, req_id, os);
        switch (vers.minor) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write((OutputStream)os, (ServiceContext[])reply_service_contexts);
                os.write_ulong(req_id);
                os.write_ulong(status);
                break;
            }
            case 2: {
                os.write_ulong(req_id);
                os.allowFragment();
                os.write_ulong(status);
                ServiceContextListHelper.write((OutputStream)os, (ServiceContext[])reply_service_contexts);
                os.pending_alignment(8);
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + req_id + " reply stream created. Reply status: " + status);
        }
        return os;
    }

    CDROutputStream create_locate_reply_stream(IIOPServerRequest req, int status) {
        CDROutputStream os;
        if (!this.m_socket_queue.isOpen()) {
            throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
        }
        Version vers = req.version();
        int req_id = req.request_id();
        MarshalBuffer buf = new MarshalBuffer(this.m_marshal_listener, req);
        buf.enableLogging(this.getLogger().getChildLogger("mb"));
        try {
            os = (CDROutputStream)this.m_os_ctor.newInstance(this.m_orb, vers, buf);
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to create CDROutputStream class.", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((java.lang.Object)new INITIALIZE("Unable to create CDROutputStream class (" + ex + ")")), (Throwable)ex);
        }
        new HeaderBlock(4, req_id, os);
        os.write_ulong(req_id);
        if (vers.minor == 2) {
            os.allowFragment();
        }
        os.write_ulong(status);
        if (vers.minor == 2) {
            os.pending_alignment(8);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + req_id + " locate reply stream created. Reply status: " + status);
        }
        return os;
    }

    void release_request(IIOPServerRequest request) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            int req_id = request.request_id();
            this.m_active_requests.remove(NumberCache.getInteger((int)req_id));
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + " request #" + req_id + " completed");
            }
            if (!this.m_active_requests.isEmpty()) {
                return;
            }
            this.m_channel_age = RequestIDAllocator.peek_request_id();
        }
        if (this.m_pending_close) {
            this.soft_close(true);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MarshalListener
    implements MarshalBuffer.Listener {
        private MarshalListener() {
        }

        public void availIncreaced(MarshalBuffer buffer, int available, java.lang.Object cookie) {
            if (available > 120000) {
                IIOPServerRequest req = (IIOPServerRequest)cookie;
                while (buffer.available() > 120000) {
                    if (IIOPServerChannel.this.m_socket_queue.send(buffer.fragment(120000))) continue;
                    throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
                }
                if (IIOPServerChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    IIOPServerChannel.this.getLogger().debug(IIOPServerChannel.this + "request #" + req.request_id() + " last fragment sent");
                }
            }
        }

        public void bufferClosed(MarshalBuffer buffer, int available, java.lang.Object cookie) {
            StorageBuffer buf = buffer.lastFragment();
            IIOPServerRequest req = (IIOPServerRequest)cookie;
            if (!IIOPServerChannel.this.m_socket_queue.send(buf)) {
                throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
            }
            if (IIOPServerChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                IIOPServerChannel.this.getLogger().debug(IIOPServerChannel.this + " request #" + req.request_id() + " last fragment sent after buffer close");
            }
        }

        public void bufferCanceled(MarshalBuffer buffer, SystemException ex, java.lang.Object cookie) {
            ex.completed = CompletionStatus.COMPLETED_YES;
            throw ex;
        }
    }
}

