/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.SystemException;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedProfile;
import org.openorb.orb.core.ORB;
import org.openorb.orb.iiop.CDRCodecFactory;
import org.openorb.orb.iiop.IIOPClientProtocol;
import org.openorb.orb.iiop.IIOPServerChannel;
import org.openorb.orb.iiop.IIOPTransportServerInitializer;
import org.openorb.orb.net.ServerManager;
import org.openorb.orb.net.ServerProtocol;
import org.openorb.orb.net.Transport;
import org.openorb.orb.pi.ComponentSet;
import org.openorb.orb.util.Trace;

public class IIOPServerProtocol
implements ServerProtocol {
    private ServerManager m_server_manager;
    private ListenPoint m_primary_endpoint;
    private Codec m_codec;
    private org.omg.CORBA.ORB m_orb;
    private IIOPClientProtocol m_client_protocol;
    private Object m_sync_state;
    private int m_state;
    private IIOPTransportServerInitializer m_server_transport_init;
    private Logger m_logger;

    public IIOPServerProtocol(ServerManager serverManager, CDRCodecFactory codecFactory, IIOPTransportServerInitializer trans) {
        block3: {
            this.m_client_protocol = null;
            this.m_sync_state = new Object();
            this.m_state = 2;
            this.m_logger = null;
            this.m_server_manager = serverManager;
            this.m_orb = this.m_server_manager.orb();
            this.m_logger = ((ORB)this.orb()).getLogger();
            try {
                this.m_codec = codecFactory.create_codec(new Encoding(0, 1, 2));
            }
            catch (UnknownEncoding ex) {
                if (!this.getLogger().isErrorEnabled()) break block3;
                this.getLogger().error("Could not find codec.", (Throwable)ex);
            }
        }
        this.m_server_transport_init = trans;
        this.m_state = 2;
        this.m_primary_endpoint = this.m_server_transport_init.getPrimaryEndpoint();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " created");
        }
    }

    public String toString() {
        return "ServerProtocol: " + this.m_server_transport_init.toString();
    }

    public void setClientProtocol(IIOPClientProtocol clientProtocol) {
        this.m_client_protocol = clientProtocol;
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public ServerManager getServerManager() {
        return this.m_server_manager;
    }

    public boolean servesAddress(String addr, int port) {
        if ((this.m_primary_endpoint.port & 0xFFFF) == port && addr.equals(this.m_primary_endpoint.host)) {
            return true;
        }
        ListenPoint[] biDirEndpoints = this.m_server_transport_init.getBiDirEndpoints();
        if (biDirEndpoints == null) {
            return false;
        }
        int i = 0;
        while (i < biDirEndpoints.length) {
            if ((biDirEndpoints[i].port & 0xFFFF) == port && addr.equals(biDirEndpoints[i].host)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int state() {
        return this.m_state;
    }

    public boolean open() {
        Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 1: {
                    this.m_state = 0;
                    this.m_sync_state.notifyAll();
                    break;
                }
                case 2: {
                    try {
                        this.m_server_transport_init.open();
                    }
                    catch (SystemException ex) {
                        boolean bl = false;
                        return bl;
                    }
                    this.m_primary_endpoint = this.m_server_transport_init.getPrimaryEndpoint();
                    this.m_state = 0;
                    this.m_server_manager.protocol_listening(this);
                }
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(this + " listening");
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean pause() {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state != 2) {
                this.m_server_manager.protocol_not_listening(this, true);
                this.m_state = 1;
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug(this + " paused");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void close() {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 2) {
                return;
            }
            this.m_state = 2;
            this.m_server_transport_init.close();
            this.m_server_manager.protocol_not_listening(this, false);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(this + " closed");
            }
        }
    }

    public void listen(int timeout) {
        Transport transport = null;
        if (this.m_state != 0) {
            return;
        }
        try {
            transport = this.m_server_transport_init.accept(timeout);
        }
        catch (SystemException ex) {
            Trace.signalIllegalCondition(this.getLogger(), "Fatal error while accepting connection: " + (Object)((Object)ex));
        }
        if (transport != null) {
            new IIOPServerChannel(this.m_server_manager, transport, this.m_client_protocol, this.m_codec);
        }
    }

    public void run_listen() {
        Thread curr = Thread.currentThread();
        while (!curr.isInterrupted() && this.m_state == 0) {
            this.listen(0);
        }
    }

    public TaggedProfile create_profile(int profile_tag, ComponentSet component_set, byte[] object_key) {
        if (profile_tag != 0) {
            return null;
        }
        ProfileBody_1_1 profile_body = new ProfileBody_1_1();
        profile_body.iiop_version = new Version(1, 2);
        profile_body.host = this.m_primary_endpoint.host;
        profile_body.port = this.m_primary_endpoint.port;
        profile_body.object_key = object_key;
        profile_body.components = component_set.getComponents(profile_tag);
        Any any = this.m_orb.create_any();
        ProfileBody_1_1Helper.insert((Any)any, (ProfileBody_1_1)profile_body);
        try {
            byte[] buf = this.m_codec.encode_value(any);
            if (buf != null) {
                return new TaggedProfile(profile_tag, buf);
            }
            return null;
        }
        catch (InvalidTypeForEncoding ex) {
            Trace.signalIllegalCondition(this.getLogger(), "Invalid type for encoding.");
            return null;
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

