/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.openorb.orb.io.StorageBuffer;
import org.openorb.orb.net.Address;
import org.openorb.orb.net.SocketFactory;
import org.openorb.orb.net.Transport;
import org.openorb.util.ExceptionTool;

public class IIOPTransport
implements Transport {
    private final SocketFactory m_socketFactory;
    private final Logger m_logger;
    private InetAddress m_host = null;
    private int m_port = -1;
    private String m_connection_string;
    private Socket m_socket;
    private InputStream m_in_stream;
    private OutputStream m_out_stream;
    private byte[] m_header = null;
    private boolean m_message_error = false;
    private boolean m_remote_close = false;
    private int m_minor_version = 0;
    private boolean m_open = false;
    private static final byte[][] MESSAGE_ERROR = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 6, 0, 0, 0, 0}};
    private static final byte[][] CLOSE_CONNECTION = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 5, 0, 0, 0, 0}};

    public IIOPTransport(InetAddress host, int port, Logger logger) {
        this(host, port, logger, null);
    }

    public IIOPTransport(InetAddress host, int port, Logger logger, SocketFactory socketFactory) {
        this.m_host = host;
        this.m_port = port;
        this.m_logger = logger;
        this.m_connection_string = this.m_host.getHostName() + ":" + this.m_port;
        this.m_socketFactory = socketFactory;
    }

    public IIOPTransport(Socket sock, int serverPort, Logger logger) {
        this.m_socket = sock;
        this.m_port = serverPort;
        this.m_logger = logger;
        this.m_socketFactory = null;
        try {
            this.m_in_stream = this.m_socket.getInputStream();
            this.m_out_stream = this.m_socket.getOutputStream();
        }
        catch (IOException ex) {
            this.getLogger().error("IOException getting input and output streams.", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
        }
        this.m_open = true;
        this.m_connection_string = serverPort + " (" + this.m_socket.getLocalPort() + " <- " + this.m_socket.getInetAddress().getHostName() + ":" + this.m_socket.getPort() + ")";
    }

    public void open() {
        if (this.m_host == null) {
            throw new BAD_INV_ORDER();
        }
        if (this.m_open) {
            return;
        }
        this.m_message_error = false;
        this.m_remote_close = false;
        try {
            this.m_socket = this.createSocket(this.m_host, this.m_port);
            this.m_in_stream = this.m_socket.getInputStream();
            this.m_out_stream = this.m_socket.getOutputStream();
        }
        catch (NoRouteToHostException ex) {
            this.getLogger().error("No route to host '" + this.m_host + "', port " + this.m_port + ". Check your network.", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("No route to host '" + this.m_host + "', port " + this.m_port + ". Check your network (" + ex + ")", 1146056969, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
        }
        catch (ConnectException ex) {
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("Cannot connect to host '" + this.m_host + "', port " + this.m_port + " (" + ex + ")", 1146056970, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
        }
        catch (IOException ex) {
            this.getLogger().error("IOException during connect.", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("IOException during connect to host '" + this.m_host + "', port " + this.m_port + "(" + ex + ")", 0, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
        }
        this.m_open = true;
        this.m_connection_string = this.m_host.getHostName() + ":" + this.m_port + " (" + this.m_socket.getLocalPort() + " -> " + this.m_socket.getPort() + ")";
    }

    protected Socket createSocket(InetAddress host, int port) throws IOException {
        return this.m_socketFactory.createSocket(host, port);
    }

    protected Socket getSocket() {
        return this.m_socket;
    }

    public void close() {
        if (this.m_open) {
            boolean interrupt = Thread.interrupted();
            if (!this.m_remote_close) {
                try {
                    this.writeCloseMessage();
                    try {
                        this.m_socket.getClass().getMethod("shutdownOutput", null).invoke((Object)this.m_socket, null);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (this.m_message_error || this.m_minor_version == 2 || this.m_host == null) {
                        StorageBuffer recv;
                        do {
                            recv = this.recvMessage(1000);
                            boolean bl = interrupt = Thread.interrupted() || interrupt;
                        } while (recv != null);
                    }
                }
                catch (SystemException ex) {
                }
                catch (EOFException ex) {
                    this.getLogger().debug("An EOFException occured during recvMessage() while closing connection!", (Throwable)ex);
                }
            }
            this.m_open = false;
            try {
                this.m_socket.close();
            }
            catch (IOException ex) {
                this.getLogger().warn("An IOException occured during socket close()!", (Throwable)ex);
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
            this.m_connection_string = this.m_host != null ? this.m_host.getHostName() + ":" + this.m_port : Integer.toString(this.m_port);
        }
    }

    protected void writeCloseMessage() {
        if (this.m_message_error) {
            this.write(MESSAGE_ERROR[this.m_minor_version], 0, 12);
        } else if (this.m_minor_version == 2 || this.m_host == null) {
            this.write(CLOSE_CONNECTION[this.m_minor_version], 0, 12);
        }
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void sendMessage(StorageBuffer msg) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            msg.writeTo(this.m_out_stream);
            this.m_out_stream.flush();
        }
        catch (IOException ex) {
            this.getLogger().error("IOException while writing to output stream.", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("IOException while writing to output stream.")), (Throwable)ex);
        }
    }

    protected void write(byte[] buf, int off, int len) {
        InterruptedIOException ex2;
        boolean interrupt = Thread.interrupted();
        do {
            try {
                this.m_out_stream.write(buf, off, len);
                break;
            }
            catch (InterruptedIOException ex2) {
                interrupt = true;
                off += ex2.bytesTransferred;
            }
            catch (IOException ex3) {
                throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE()), (Throwable)ex3);
            }
        } while ((len -= ex2.bytesTransferred) > 0);
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    public StorageBuffer recvMessage(int timeout) throws EOFException {
        Thread thread;
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        if (null == this.m_header) {
            this.m_header = new byte[12];
        }
        if ((thread = Thread.currentThread()).isInterrupted()) {
            return null;
        }
        if (!this.readMagic(timeout, this.m_header, 0)) {
            return null;
        }
        boolean interrupt = Thread.interrupted();
        this.read(this.m_header, 4, 8);
        int bodyLength = this.checkGIOPHeader(this.m_header, 0);
        interrupt = interrupt || Thread.interrupted();
        StorageBuffer ret = this.readBuffer(this.m_header, 0, 12, bodyLength + 12);
        if (interrupt) {
            thread.interrupt();
        }
        return ret;
    }

    public void setMessageError() {
        this.m_message_error = true;
    }

    public boolean isMessageError() {
        return this.m_message_error;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean readMagic(int timeout, byte[] buf, int off) throws EOFException {
        block31: {
            if (!this.m_open) {
                throw new COMM_FAILURE("Transport is closed");
            }
            try {
                block28: {
                    interrupt = false;
                    try {
                        if (timeout > 0) {
                            this.m_socket.setSoTimeout(timeout);
                        }
                        m = this.m_in_stream.read(buf, off, 4);
                        var9_7 = null;
                        ** if (timeout <= 0) goto lbl-1000
                    }
                    catch (Throwable var8_20) {
                        var9_10 = null;
                        if (timeout > 0) {
                            try {
                                this.m_socket.setSoTimeout(0);
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        throw var8_20;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.m_socket.setSoTimeout(0);
                        }
                        catch (IOException ex) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block28;
                        catch (InterruptedIOException ex) {
                            if (timeout > 0 && ex.getMessage().equals("Read timed out")) {
                                var7_17 = false;
                                var9_8 = null;
                                if (timeout > 0) {
                                    try {
                                        this.m_socket.setSoTimeout(0);
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                return var7_17;
                            }
                            m = ex.bytesTransferred;
                            if (m == 0) {
                                Thread.currentThread().interrupt();
                                var7_18 = false;
                                var9_9 = null;
                                if (timeout > 0) {
                                    try {
                                        this.m_socket.setSoTimeout(0);
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                return var7_18;
                            }
                            interrupt = true;
                            var9_7 = null;
                            if (timeout > 0) {
                                try {
                                    this.m_socket.setSoTimeout(0);
                                }
                                catch (IOException ex) {}
                            }
                        }
                    }
                }
                if (m == 0) {
                    return false;
                }
                if (m == 4) {
                    return true;
                }
                if (m <= 0) break block31;
                r = m;
                while (r < 4) {
                    try {
                        m = this.m_in_stream.read(buf, off + r, 4 - r);
                        if (m < 0) {
                            throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                        }
                    }
                    catch (InterruptedIOException ex) {
                        m = ex.bytesTransferred;
                        interrupt = true;
                    }
                    r += m;
                }
                if (interrupt) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            catch (IOException ex) {
                throw ExceptionTool.initCause((SystemException)new COMM_FAILURE("IOException while reading from input stream (" + ex + ")", 1146056972, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
            }
        }
        throw new EOFException("The end of the stream has been reached, no bytes available!");
    }

    protected int checkGIOPHeader(byte[] buf, int off) throws EOFException {
        if (buf[off + 0] != 71 || buf[off + 1] != 73 || buf[off + 2] != 79 || buf[off + 3] != 80 || buf[off + 4] != 1 || buf[off + 5] > 2) {
            this.m_message_error = true;
            throw new COMM_FAILURE("Bad magic", 1146056974, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.m_minor_version < buf[off + 5]) {
            this.m_minor_version = buf[off + 5];
        }
        switch (buf[off + 7]) {
            case 5: {
                this.m_remote_close = true;
                throw new EOFException("CloseConnection message received from peer.");
            }
            case 6: {
                this.m_remote_close = true;
                throw new COMM_FAILURE("Message Error recieved from remote", 1146056974, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        boolean swap = (buf[off + 6] & 1) == 1;
        return (buf[off + 8] & 0xFF) << (swap ? 0 : 24) | (buf[off + 9] & 0xFF) << (swap ? 8 : 16) | (buf[off + 10] & 0xFF) << (swap ? 16 : 8) | (buf[off + 11] & 0xFF) << (swap ? 24 : 0);
    }

    protected final void read(byte[] buf, int off, int len) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            boolean interrupt = false;
            while (len > 0) {
                int r;
                try {
                    r = this.m_in_stream.read(buf, off, len);
                    if (r < 0) {
                        throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                catch (InterruptedIOException ex) {
                    interrupt = true;
                    r = ex.bytesTransferred;
                }
                off += r;
                len -= r;
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException ex) {
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("IOException while reading from input stream", 1146056972, CompletionStatus.COMPLETED_MAYBE)), (Throwable)ex);
        }
    }

    protected StorageBuffer readBuffer(byte[] head, int off, int len, int total_len) {
        if (!this.m_open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            return new StorageBuffer(head, off, len, this.m_in_stream, total_len);
        }
        catch (EOFException ex) {
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("Unexpected end of stream (" + ex + ")", 1146056973, CompletionStatus.COMPLETED_MAYBE)), (Throwable)ex);
        }
        catch (IOException ex) {
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("IOException while reading from input stream (" + ex + ")", 1146056972, CompletionStatus.COMPLETED_MAYBE)), (Throwable)ex);
        }
    }

    public boolean establishAssociation(Address addr) {
        return true;
    }

    public String toString() {
        return "(iiop) " + this.getConnString();
    }

    protected String getConnString() {
        return this.m_connection_string;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

