/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.IIOP.ListenPoint;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.orb.Initializer;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.iiop.IIOPTransport;
import org.openorb.orb.net.SocketFactory;
import org.openorb.orb.net.Transport;
import org.openorb.orb.net.TransportServerInitializer;
import org.openorb.orb.pi.FeatureInitInfo;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;

public class IIOPTransportServerInitializer
extends AbstractLogEnabled
implements TransportServerInitializer,
Initializer {
    private final ListenPoint m_primary_endpoint = new ListenPoint();
    private final ListenPoint[] m_bidir_endpoints = new ListenPoint[]{this.m_primary_endpoint};
    private SocketFactory m_socketFactory;
    private InetAddress m_host;
    private ServerSocket m_svr_socket;
    private volatile boolean m_closed = true;

    public String getName() {
        return "iiop-server-init";
    }

    public void init(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        int port;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("init");
        }
        ORBLoader loader = featureinfo.getLoader();
        this.m_socketFactory = (SocketFactory)featureinfo.getFeature("IIOP.SocketFactory");
        if (null == this.m_socketFactory) {
            throw new INITIALIZE("Feature [IIOP.SocketFactory] not set");
        }
        this.m_primary_endpoint.host = loader.getStringProperty("iiop.hostname", "");
        if (this.m_primary_endpoint.host.length() == 0) {
            try {
                String publishIP = loader.getStringProperty("iiop.publishIP", "auto");
                if (publishIP.equalsIgnoreCase("auto")) {
                    this.m_primary_endpoint.host = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                    if (this.m_primary_endpoint.host.indexOf(46) < 0) {
                        this.m_primary_endpoint.host = InetAddress.getLocalHost().getHostAddress();
                    }
                } else {
                    this.m_primary_endpoint.host = publishIP.equalsIgnoreCase("true") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                }
            }
            catch (UnknownHostException ex) {
                throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to find hostname for local host (" + ex + ")", 0, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
            }
        }
        if ((port = loader.getIntProperty("iiop.port", 0)) > 65535 || port < 0) {
            throw new INITIALIZE("Value for server port " + port + " is out of range");
        }
        this.m_primary_endpoint.port = (short)port;
        try {
            this.m_host = InetAddress.getByName(loader.getStringProperty("iiop.listenAddress", "0.0.0.0"));
        }
        catch (UnknownHostException ex) {
            throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to find address for local listen port (" + ex + ")", 0, CompletionStatus.COMPLETED_NO)), (Throwable)ex);
        }
    }

    public void open() {
        if (this.m_svr_socket != null) {
            return;
        }
        this.open_port();
    }

    private void open_port() {
        try {
            int port = this.m_primary_endpoint.port & 0xFFFF;
            this.m_svr_socket = this.m_socketFactory.createServerSocket(this.m_host, port);
        }
        catch (IOException ex) {
            this.getLogger().error("Unable to listen on " + this.svrString() + " (" + ex + ").", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE("Unable to listen on " + this.svrString() + " (" + ex + ")")), (Throwable)ex);
        }
        catch (SecurityException ex) {
            this.getLogger().error("Access denied for " + this.svrString() + ".", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)new NO_PERMISSION("Access denied for " + this.svrString() + " (" + ex + ")"), (Throwable)ex);
        }
        this.m_closed = false;
        if (this.m_primary_endpoint.port == 0) {
            this.m_primary_endpoint.port = (short)this.m_svr_socket.getLocalPort();
        }
    }

    public ListenPoint getPrimaryEndpoint() {
        return this.m_primary_endpoint;
    }

    public ListenPoint[] getBiDirEndpoints() {
        return this.m_bidir_endpoints;
    }

    protected InetAddress getListenHost() {
        return this.m_host;
    }

    public void close() {
        if (this.m_closed || this.m_svr_socket == null) {
            return;
        }
        this.m_closed = true;
        try {
            this.m_svr_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_svr_socket = null;
    }

    public boolean isOpen() {
        return !this.m_closed;
    }

    public Transport accept(int timeout) {
        try {
            if (this.m_closed) {
                return null;
            }
            this.m_svr_socket.setSoTimeout(timeout);
            try {
                Socket sock = this.m_svr_socket.accept();
                return new IIOPTransport(sock, this.m_primary_endpoint.port & 0xFFFF, this.getLogger());
            }
            catch (InterruptedIOException ex) {
                if ("operation interrupted".equals(ex.getMessage())) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
            catch (SocketException ex) {
                return null;
            }
        }
        catch (IOException ex) {
            if (this.m_closed) {
                return null;
            }
            this.getLogger().error("IOException during accept.", (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)((Object)new COMM_FAILURE()), (Throwable)ex);
        }
    }

    public String toString() {
        return "(iiop) " + this.svrString();
    }

    protected String svrString() {
        return "" + this.m_host + ":" + (this.m_primary_endpoint.port & 0xFFFF);
    }
}

