/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.iiop;

import java.io.EOFException;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.TooManyListenersException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.Version;
import org.openorb.orb.core.ORB;
import org.openorb.orb.iiop.CDRInputStream;
import org.openorb.orb.iiop.IIOPClientChannel;
import org.openorb.orb.iiop.IIOPServerChannel;
import org.openorb.orb.io.BufferSource;
import org.openorb.orb.io.StorageBuffer;
import org.openorb.orb.net.Transport;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;

public final class SocketQueue
implements LogEnabled {
    private Logger m_logger;
    public static final int MAX_FRAG_SIZE = 120000;
    private Transport m_transport;
    private org.omg.CORBA.ORB m_orb;
    private IIOPServerChannel m_server_channel = null;
    private IIOPClientChannel m_client_channel = null;
    private boolean m_connection_originator;
    private boolean m_use_odd_even = false;
    private Object m_sync_send = new Object();
    private boolean m_open = false;
    private Constructor m_os_ctor = null;
    private LinkedList m_incoming_queue = new LinkedList();
    private int m_request_id_1 = -1;
    private boolean m_receive_reply_1 = true;
    private OctetSeqHolder m_tmpBuf = new OctetSeqHolder();
    private IntHolder m_tmpOff = new IntHolder();
    private IntHolder m_tmpLen = new IntHolder();
    private BufferSource.WaitingForBufferListener m_waitingForBufferListener = new BufferSource.WaitingForBufferListener(){

        public boolean waitForBuffer(BufferSource source) {
            SocketQueue.this.process_or_enqueue(false, 0);
            return true;
        }
    };
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$orb$io$BufferSource;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;

    SocketQueue(Transport trans) {
        this.m_transport = trans;
        this.m_open = this.m_transport.isOpen();
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    Transport getTransport() {
        return this.m_transport;
    }

    public String toString() {
        return this.m_transport.toString();
    }

    synchronized void setClientChannel(IIOPClientChannel clientChannel) {
        if (this.m_client_channel == null) {
            this.m_client_channel = clientChannel;
            if (this.m_server_channel == null) {
                this.m_connection_originator = true;
                this.m_orb = this.m_client_channel.orb();
                try {
                    Class[] cargs = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = SocketQueue.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, Boolean.TYPE, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = SocketQueue.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$orb$io$BufferSource == null ? (class$org$openorb$orb$io$BufferSource = SocketQueue.class$("org.openorb.orb.io.BufferSource")) : class$org$openorb$orb$io$BufferSource};
                    this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDRInputStreamClass", "org.openorb.orb.iiop.CDRInputStream", cargs);
                }
                catch (Exception ex) {
                    if (this.getLogger().isErrorEnabled()) {
                        this.getLogger().error("Unable to create CDROutputStream class.", (Throwable)ex);
                    }
                    throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to create CDROutputStream class (" + ex + ")")), (Throwable)ex);
                }
            } else {
                this.m_use_odd_even = true;
            }
        }
    }

    synchronized void setServerChannel(IIOPServerChannel serverChannel) {
        this.m_server_channel = serverChannel;
        if (this.m_client_channel == null) {
            this.m_connection_originator = false;
            this.m_orb = this.m_server_channel.orb();
            try {
                Class[] cargs = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = SocketQueue.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, Boolean.TYPE, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = SocketQueue.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$orb$io$BufferSource == null ? (class$org$openorb$orb$io$BufferSource = SocketQueue.class$("org.openorb.orb.io.BufferSource")) : class$org$openorb$orb$io$BufferSource};
                this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDRInputStreamClass", "org.openorb.orb.iiop.CDRInputStream", cargs);
            }
            catch (Exception ex) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Unable to create CDROutputStream class.", (Throwable)ex);
                }
                throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to create CDROutputStream class (" + ex + ")")), (Throwable)ex);
            }
        } else {
            this.m_use_odd_even = true;
        }
    }

    public synchronized boolean isOpen() {
        return this.m_transport.isOpen();
    }

    public synchronized void open() {
        this.m_transport.open();
        this.m_open = true;
    }

    public synchronized void close() {
        Object object = this.m_sync_send;
        synchronized (object) {
            this.m_open = false;
        }
        this.m_transport.close();
    }

    public boolean send(StorageBuffer buffer) {
        if (!this.m_open) {
            return false;
        }
        Object object = this.m_sync_send;
        synchronized (object) {
            if (!this.m_open) {
                boolean bl = false;
                return bl;
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(Trace.bufferToString("Sending message", buffer));
            }
            this.m_transport.sendMessage(buffer);
            boolean bl = true;
            return bl;
        }
    }

    public boolean receive(int timeout) {
        return this.process_or_enqueue(true, timeout);
    }

    private boolean process_or_enqueue(boolean process, int timeout) {
        CDRInputStream is;
        int req_id = 0;
        if (process && !this.m_incoming_queue.isEmpty()) {
            IncommingToProcess rtp = (IncommingToProcess)this.m_incoming_queue.removeFirst();
            switch (rtp.getMessageType()) {
                case 1: 
                case 4: {
                    req_id = this.m_client_channel.process_reply(rtp.getMinor(), rtp.getInputStream(), rtp.getMessageType(), rtp.getFragmentFollows(), rtp.getSourceBuffer());
                    if (rtp.getMinor() == 1) {
                        this.m_request_id_1 = req_id;
                    }
                    return true;
                }
                case 0: 
                case 2: 
                case 3: {
                    req_id = this.m_server_channel.process_request(rtp.getMinor(), rtp.getInputStream(), rtp.getMessageType(), rtp.getSourceBuffer());
                    if (rtp.getMinor() == 1) {
                        this.m_request_id_1 = req_id;
                    }
                    return true;
                }
                case 7: {
                    if (rtp.getMinor() == 1) {
                        rtp.setRequestId(this.m_request_id_1);
                    }
                    if (rtp.getReplyFragment()) {
                        this.m_client_channel.process_fragment(rtp.getRequestId(), rtp.getFragment(), rtp.getFragmentFollows());
                    } else {
                        this.m_server_channel.process_fragment(rtp.getRequestId(), rtp.getFragment(), rtp.getFragmentFollows());
                    }
                    return true;
                }
            }
        }
        StorageBuffer next_msg = null;
        try {
            next_msg = this.m_transport.recvMessage(timeout);
        }
        catch (EOFException ex) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Error receiving message in process_or_enqueue", (Throwable)ex);
            }
            if (this.m_client_channel != null) {
                this.m_client_channel.server_pause(ExceptionTool.initCause((SystemException)new TRANSIENT(0, CompletionStatus.COMPLETED_NO), (Throwable)ex));
            } else {
                this.m_server_channel.close();
            }
            return false;
        }
        catch (COMM_FAILURE ex) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Error receiving message in process_or_enqueue", (Throwable)ex);
            }
            if (this.m_use_odd_even ? this.m_connection_originator : this.m_client_channel != null) {
                this.m_client_channel.server_pause((SystemException)((Object)ex));
            } else {
                this.m_server_channel.close();
            }
            return false;
        }
        if (next_msg == null) {
            return true;
        }
        if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(Trace.bufferToString("Incoming message", next_msg));
        }
        byte minor = -1;
        byte msg_type = -1;
        boolean swap = false;
        boolean fragFollows = false;
        this.m_tmpLen.value = 8;
        int r = next_msg.next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
        switch (r) {
            case 8: {
                msg_type = this.m_tmpBuf.value[this.m_tmpOff.value + 7];
                swap = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 1) == 1;
                fragFollows = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 2) == 2;
                minor = this.m_tmpBuf.value[this.m_tmpOff.value + 5];
                break;
            }
            case 7: {
                swap = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 1) == 1;
                fragFollows = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 2) == 2;
            }
            case 6: {
                minor = this.m_tmpBuf.value[this.m_tmpOff.value + 5];
            }
            default: {
                while (r < 5) {
                    this.m_tmpLen.value = 5 - r;
                    r += next_msg.next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
                }
                while (r < 8) {
                    this.m_tmpLen.value = 1;
                    switch (r += next_msg.next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen)) {
                        case 6: {
                            minor = this.m_tmpBuf.value[this.m_tmpOff.value];
                            break;
                        }
                        case 7: {
                            swap = (this.m_tmpBuf.value[this.m_tmpOff.value] & 1) == 1;
                            fragFollows = (this.m_tmpBuf.value[this.m_tmpOff.value] & 2) == 2;
                            break;
                        }
                        case 8: {
                            msg_type = this.m_tmpBuf.value[this.m_tmpOff.value];
                        }
                    }
                }
                break block8;
            }
        }
        if (msg_type == 7) {
            this.m_tmpLen.value = 4;
            if (next_msg.skip(this.m_tmpLen) != 4) {
                Trace.signalIllegalCondition(this.getLogger(), "Unable to read header from buffer.");
            }
            boolean replyFrag = true;
            switch (minor) {
                case 1: {
                    req_id = this.m_request_id_1;
                    replyFrag = this.m_receive_reply_1;
                    break;
                }
                case 2: {
                    boolean bl;
                    this.m_tmpLen.value = 4;
                    int got = next_msg.next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
                    if (got == 4) {
                        req_id = (this.m_tmpBuf.value[this.m_tmpOff.value] & 0xFF) << (swap ? 0 : 24) | (this.m_tmpBuf.value[this.m_tmpOff.value + 1] & 0xFF) << (swap ? 8 : 16) | (this.m_tmpBuf.value[this.m_tmpOff.value + 2] & 0xFF) << (swap ? 16 : 8) | (this.m_tmpBuf.value[this.m_tmpOff.value + 3] & 0xFF) << (swap ? 24 : 0);
                    } else {
                        req_id = 0;
                        int shf = swap ? 0 : 24;
                        while (true) {
                            int i = 0;
                            while (i < got) {
                                req_id |= (this.m_tmpBuf.value[this.m_tmpOff.value + i] & 0xFF) << shf;
                                shf += swap ? 8 : -8;
                                ++i;
                            }
                            boolean bl2 = swap ? shf < 24 : shf > 0;
                            if (!bl2) break;
                            got = next_msg.next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
                        }
                    }
                    if (this.m_use_odd_even) {
                        if (req_id % 2 == 0 == this.m_connection_originator) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = replyFrag = this.m_client_channel != null;
                }
            }
            if (process) {
                if (replyFrag) {
                    this.m_client_channel.process_fragment(req_id, next_msg, fragFollows);
                } else {
                    this.m_server_channel.process_fragment(req_id, next_msg, fragFollows);
                }
            } else {
                this.m_incoming_queue.addLast(new IncommingToProcess(req_id, fragFollows, replyFrag, next_msg));
            }
            return true;
        }
        BufferSource source = new BufferSource(next_msg, !fragFollows);
        if (fragFollows) {
            try {
                source.addWaitingForBufferListener(this.m_waitingForBufferListener);
            }
            catch (TooManyListenersException ex) {
                this.getLogger().error("Unable to handle too many Listeners.", (Throwable)ex);
            }
        }
        try {
            is = (CDRInputStream)this.m_os_ctor.newInstance(this.m_orb, swap ? Boolean.FALSE : Boolean.TRUE, new Version(1, minor), source);
            if ((class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = SocketQueue.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled).isAssignableFrom(is.getClass())) {
                is.enableLogging(this.getLogger().getChildLogger("is"));
            }
        }
        catch (Exception ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Unable to create input stream class.", (Throwable)ex);
            }
            throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Unable to create input stream class (" + ex + ")")), (Throwable)ex);
        }
        if (is.skip(4L) != 4L) {
            Trace.signalIllegalCondition(this.getLogger(), "Unable to read header from buffer.");
        }
        switch (msg_type) {
            case 1: 
            case 4: {
                if (minor == 1 && fragFollows) {
                    this.m_receive_reply_1 = true;
                }
                if (process) {
                    if (this.m_client_channel == null) break;
                    req_id = this.m_client_channel.process_reply(minor, is, msg_type, fragFollows, source);
                    if (minor != 1 || !fragFollows) break;
                    this.m_request_id_1 = req_id;
                    break;
                }
                this.m_incoming_queue.addLast(new IncommingToProcess(msg_type, minor, fragFollows, is, source));
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                if (minor == 1 && fragFollows) {
                    this.m_receive_reply_1 = false;
                }
                if (process) {
                    if (this.m_server_channel == null) break;
                    req_id = this.m_server_channel.process_request(minor, is, msg_type, source);
                    if (minor != 1 || !fragFollows) break;
                    this.m_request_id_1 = req_id;
                    break;
                }
                this.m_incoming_queue.addLast(new IncommingToProcess(msg_type, minor, fragFollows, is, source));
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IncommingToProcess {
        private byte m_minor;
        private CDRInputStream m_in_stream;
        private byte m_message_type;
        private BufferSource m_source_buffer;
        private boolean m_fragment_follows;
        private int m_request_id;
        private StorageBuffer m_fragment;
        private boolean m_reply_fragment;

        public IncommingToProcess(byte msg_type) {
            this.m_message_type = msg_type;
        }

        public IncommingToProcess(byte msg_type, byte minor, boolean fragFollows, CDRInputStream is, BufferSource source) {
            this.m_minor = minor;
            this.m_in_stream = is;
            this.m_message_type = msg_type;
            this.m_source_buffer = source;
            this.m_fragment_follows = fragFollows;
        }

        public IncommingToProcess(int req_id, boolean fragFollows, boolean replyFrag, StorageBuffer frag) {
            this.m_message_type = (byte)7;
            this.m_request_id = req_id;
            this.m_fragment_follows = fragFollows;
            this.m_reply_fragment = replyFrag;
            this.m_fragment = frag;
        }

        public byte getMinor() {
            return this.m_minor;
        }

        public byte getMessageType() {
            return this.m_message_type;
        }

        public boolean getFragmentFollows() {
            return this.m_fragment_follows;
        }

        public StorageBuffer getFragment() {
            return this.m_fragment;
        }

        public int getRequestId() {
            return this.m_request_id;
        }

        public void setRequestId(int request_id) {
            this.m_request_id = request_id;
        }

        public BufferSource getSourceBuffer() {
            return this.m_source_buffer;
        }

        public CDRInputStream getInputStream() {
            return this.m_in_stream;
        }

        public boolean getReplyFragment() {
            return this.m_reply_fragment;
        }
    }
}

