/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.io;

import java.util.EventListener;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.openorb.orb.io.Scrap;
import org.openorb.orb.io.StorageBuffer;
import org.openorb.orb.util.Trace;

public class MarshalBuffer {
    private static final boolean DEBUG_ENABLED = Boolean.getBoolean("openorb.debug.enabled");
    private Logger m_logger;
    private SystemException m_cancel_exception = null;
    private Scrap m_head = this.m_tail = new Scrap();
    private Scrap m_tail;
    private OctetSeqHolder m_last_buffer = null;
    private boolean m_allow_fragment = false;
    private boolean m_in_fragment = false;
    private boolean m_header_fragment = true;
    private HeaderData m_last_header = null;
    private boolean m_block_fragment = true;
    private BlockData m_last_block = null;
    private Listener m_listener = null;
    private Object m_listener_cookie = null;
    private boolean m_in_listener = false;
    private byte[] m_ignore_buffer = null;

    public MarshalBuffer() {
        this.m_tail.m_fBuffer = new byte[2048];
        this.m_tail.m_fOffset = 0;
        this.m_tail.m_fLength = 0;
        this.m_tail.m_fMode = 0;
        this.m_tail.m_fPosition = 0;
    }

    public MarshalBuffer(Listener listener, Object listenerCookie) {
        this();
        this.m_listener = listener;
        this.m_listener_cookie = listenerCookie;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected Logger getLogger() {
        if (null == this.m_logger) {
            Trace.signalIllegalCondition(null, "The logger has not been set!");
        }
        return this.m_logger;
    }

    public boolean isStandalone() {
        return this.m_listener == null;
    }

    public int size() {
        if (!this.prealloc()) {
            return -1;
        }
        return this.m_tail.m_fPosition;
    }

    public int available() {
        if (!this.prealloc()) {
            return -1;
        }
        return this.m_tail.m_fPosition - this.m_head.m_fPosition + this.m_head.m_fLength;
    }

    public void setAllowFragment(boolean allowFragment) {
        this.m_allow_fragment = allowFragment;
    }

    public boolean getAllowFragment() {
        return this.m_allow_fragment && this.m_header_fragment && this.m_block_fragment && !this.m_in_fragment;
    }

    public void alloc(OctetSeqHolder buf, IntHolder off, int len) {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'alloc(" + buf.value + ", " + off.value + ", " + len + ")'...");
        }
        if (!this.prealloc()) {
            if (this.m_ignore_buffer == null || this.m_ignore_buffer.length < len) {
                this.m_ignore_buffer = new byte[len];
            }
            buf.value = this.m_ignore_buffer;
            off.value = 0;
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this.m_tail.m_fBuffer.length - this.m_tail.m_fLength - this.m_tail.m_fOffset >= len) {
            buf.value = this.m_tail.m_fBuffer;
            off.value = this.m_tail.m_fOffset + this.m_tail.m_fLength;
            this.m_tail.m_fLength += len;
            this.m_tail.m_fPosition += len;
            if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Found space in tail element: " + this.m_tail);
            }
        } else {
            Scrap nex = new Scrap();
            nex.m_fBuffer = len > 2048 ? new byte[len] : new byte[2048];
            nex.m_fOffset = 0;
            nex.m_fLength = len;
            nex.m_fMode = 0;
            nex.m_fPosition = this.m_tail.m_fPosition + len;
            buf.value = nex.m_fBuffer;
            off.value = 0;
            this.m_tail.m_fNext = nex;
            this.m_tail = nex;
            if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Added new element: " + nex);
            }
        }
        this.m_last_buffer = buf;
    }

    public void append(byte[] buf, int off, int len) {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'append(" + buf + ", " + off + ", " + len + ")'...");
        }
        if (!this.prealloc()) {
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len == 0) {
            return;
        }
        if (len < 2048) {
            if (this.m_tail.m_fBuffer.length - this.m_tail.m_fLength - this.m_tail.m_fOffset >= len) {
                System.arraycopy(buf, off, this.m_tail.m_fBuffer, this.m_tail.m_fOffset + this.m_tail.m_fLength, len);
                this.m_tail.m_fLength += len;
                this.m_tail.m_fPosition += len;
                if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("Found space in tail element: " + this.m_tail);
                }
            } else {
                int rem = this.m_tail.m_fBuffer.length - this.m_tail.m_fLength - this.m_tail.m_fOffset;
                System.arraycopy(buf, off, this.m_tail.m_fBuffer, this.m_tail.m_fOffset + this.m_tail.m_fLength, rem);
                this.m_tail.m_fLength += rem;
                this.m_tail.m_fPosition += rem;
                Scrap nex = new Scrap();
                nex.m_fBuffer = new byte[2048];
                nex.m_fOffset = 0;
                nex.m_fLength = len - rem;
                nex.m_fMode = 0;
                nex.m_fPosition = this.m_tail.m_fPosition + len - rem;
                System.arraycopy(buf, off + rem, nex.m_fBuffer, 0, len - rem);
                this.m_tail.m_fNext = nex;
                this.m_tail = nex;
                if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("Added new element: " + nex);
                }
            }
            return;
        }
        if (this.m_tail.m_fLength == 0) {
            Scrap nex = new Scrap();
            nex.m_fBuffer = this.m_tail.m_fBuffer;
            nex.m_fOffset = this.m_tail.m_fOffset;
            nex.m_fLength = 0;
            nex.m_fMode = 0;
            nex.m_fPosition = this.m_tail.m_fPosition + len;
            this.m_tail.m_fBuffer = buf;
            this.m_tail.m_fOffset = off;
            this.m_tail.m_fLength = len;
            this.m_tail.m_fMode = 3;
            this.m_tail.m_fPosition = nex.m_fPosition;
            this.m_tail.m_fNext = nex;
            this.m_tail = nex;
            if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Added new element before 0-length tail: " + nex);
            }
        } else {
            this.m_tail.m_fMode = 1;
            Scrap ro = new Scrap();
            ro.m_fBuffer = buf;
            ro.m_fOffset = off;
            ro.m_fLength = len;
            ro.m_fMode = 3;
            ro.m_fPosition = this.m_tail.m_fPosition + len;
            Scrap nex = new Scrap();
            nex.m_fBuffer = this.m_tail.m_fBuffer;
            nex.m_fOffset = this.m_tail.m_fOffset + this.m_tail.m_fLength;
            nex.m_fLength = 0;
            nex.m_fPosition = ro.m_fPosition;
            nex.m_fMode = 0;
            this.m_tail.m_fNext = ro;
            ro.m_fNext = nex;
            this.m_tail = nex;
            if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Added two elements (RO, SHARED) to tail: " + ro + ", " + nex);
            }
        }
        this.postalloc();
    }

    public void pad(int len) {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'pad(" + len + ")'...");
        }
        if (!this.prealloc()) {
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len == 0) {
            return;
        }
        int rem = this.m_tail.m_fBuffer.length - this.m_tail.m_fLength - this.m_tail.m_fOffset;
        if (rem >= len) {
            this.m_tail.m_fLength += len;
            this.m_tail.m_fPosition += len;
            if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Found space in tail element: " + this.m_tail);
            }
        } else {
            this.m_tail.m_fLength += rem;
            this.m_tail.m_fPosition += rem;
            Scrap nex = new Scrap();
            nex.m_fBuffer = new byte[2048];
            nex.m_fOffset = 0;
            nex.m_fLength = len - rem;
            nex.m_fMode = 0;
            nex.m_fPosition = this.m_tail.m_fPosition + nex.m_fLength;
            this.m_tail.m_fNext = nex;
            this.m_tail = nex;
            if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Added new element: " + nex);
            }
        }
        this.postalloc();
    }

    public void addHeader(HeaderGenerator gen, int len, boolean frag, Object cookie) {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'addHeader(" + gen + ", " + len + ", " + frag + ", " + cookie + ")'...");
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (gen == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        HeaderData hd = new HeaderData();
        hd.m_previous = this.m_last_header;
        this.m_last_header = hd;
        hd.m_lastHeaderFragment = this.m_header_fragment;
        hd.m_position = this.m_tail.m_fPosition;
        hd.m_generator = gen;
        hd.m_cookie = cookie;
        if (len != 0) {
            this.m_header_fragment = false;
            OctetSeqHolder bufh = new OctetSeqHolder();
            IntHolder offh = new IntHolder();
            this.alloc(bufh, offh, len);
            HeaderData.access$602(hd, bufh.value);
            hd.m_offset = offh.value;
            hd.m_length = len;
        }
        this.m_header_fragment = hd.m_lastHeaderFragment && frag;
    }

    public void beginBlock(BlockGenerator gen, int len, boolean frag, Object cookie) {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'beginBlock(" + gen + ", " + len + ", " + frag + ", " + cookie + ")'...");
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (gen == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        BlockData bd = new BlockData();
        bd.m_previous = this.m_last_block;
        bd.m_isFragment = this.m_last_block == null ? frag : false;
        this.m_last_block = bd;
        bd.m_position = this.m_tail.m_fPosition;
        bd.m_generator = gen;
        bd.m_cookie = cookie;
        if (len != 0) {
            this.m_block_fragment = false;
            OctetSeqHolder bufh = new OctetSeqHolder();
            IntHolder offh = new IntHolder();
            this.alloc(bufh, offh, len);
            BlockData.access$1502(bd, bufh.value);
            bd.m_offset = offh.value;
            bd.m_length = len;
        }
        this.m_block_fragment = bd.m_isFragment;
    }

    public void endBlock() {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'endBlock()'...");
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this.m_last_block == null) {
            throw new IllegalStateException("End block without begin block");
        }
        this.m_last_block.m_generator.endBlock(this.m_last_block.m_buffer, this.m_last_block.m_offset, this.m_last_block.m_length, this.size() - this.m_last_block.m_position, this.m_last_block.m_cookie);
        this.m_last_block = this.m_last_block.m_previous;
        this.m_block_fragment = this.m_last_block == null ? true : this.m_last_block.m_isFragment;
    }

    public void close() {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'close()'...");
        }
        if (this.m_in_listener) {
            throw new IllegalStateException("Cannot close buffer while calling listener.");
        }
        if (this.m_last_block != null) {
            throw new IllegalStateException("All blocks must be closed before closing buffer");
        }
        if (!this.prealloc()) {
            return;
        }
        if (this.m_listener != null) {
            this.m_in_listener = true;
            try {
                this.m_listener.bufferClosed(this, this.m_tail.m_fPosition, this.m_listener_cookie);
                Object var2_1 = null;
                this.m_in_listener = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.m_in_listener = false;
                throw throwable;
            }
        }
        this.m_head = null;
        this.m_tail = null;
        this.m_last_header = null;
    }

    public void cancel(SystemException ex) {
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'cancel(" + (Object)((Object)ex) + ")'...");
        }
        if (!this.prealloc()) {
            return;
        }
        if (this.m_listener != null) {
            this.m_in_listener = true;
            try {
                try {
                    this.m_listener.bufferCanceled(this, ex, this.m_listener_cookie);
                }
                catch (SystemException sex) {
                    this.m_cancel_exception = sex;
                    Object var4_3 = null;
                    this.m_in_listener = false;
                }
                Object var4_2 = null;
                this.m_in_listener = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_in_listener = false;
                throw throwable;
            }
        } else {
            this.m_cancel_exception = ex;
        }
        this.m_head = null;
        this.m_tail = null;
        this.m_last_header = null;
        this.m_last_block = null;
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
    }

    public StorageBuffer fragment(int len) {
        Scrap nexthead;
        Scrap mid;
        if (DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'fragment(" + len + ")'...");
        }
        if (!this.prealloc()) {
            return null;
        }
        if (this.m_listener != null && !this.m_in_listener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener");
        }
        if (!this.getAllowFragment()) {
            throw new IllegalStateException("Buffer cannot currently be fragmented");
        }
        if (len > this.m_tail.m_fPosition - this.m_head.m_fPosition + this.m_head.m_fLength) {
            throw new IndexOutOfBoundsException();
        }
        this.m_in_fragment = true;
        if (this.m_last_block != null) {
            BlockData bd = this.m_last_block;
            this.m_last_block = null;
            bd.m_generator.fragmentBlock(bd.m_buffer, bd.m_offset, bd.m_length, this.m_tail.m_fPosition - bd.m_position, this, bd.m_cookie);
        }
        int endpos = len + this.m_head.m_fPosition - this.m_head.m_fLength;
        HeaderData firstHeader = null;
        while (this.m_last_header != null) {
            this.m_last_header.m_generator.endMessage(this.m_last_header.m_buffer, this.m_last_header.m_offset, this.m_last_header.m_length, true, endpos - this.m_last_header.m_position, this.m_last_header.m_cookie);
            HeaderData tmp = this.m_last_header.m_previous;
            this.m_last_header.m_previous = firstHeader;
            firstHeader = this.m_last_header;
            this.m_last_header = tmp;
        }
        if (this.m_tail.m_fPosition - this.m_tail.m_fLength < endpos) {
            mid = this.m_tail;
        } else {
            mid = this.m_head;
            while (mid.m_fPosition < endpos) {
                mid = mid.m_fNext;
            }
        }
        if (mid.m_fPosition == endpos) {
            nexthead = mid.m_fNext;
            mid.m_fNext = null;
        } else {
            int olap = mid.m_fPosition - endpos;
            nexthead = new Scrap();
            nexthead.m_fMode = 1 | mid.m_fMode;
            nexthead.m_fBuffer = mid.m_fBuffer;
            nexthead.m_fPosition = mid.m_fPosition;
            nexthead.m_fOffset = mid.m_fOffset + mid.m_fLength - olap;
            nexthead.m_fLength = olap;
            nexthead.m_fNext = mid.m_fNext;
            mid.m_fLength -= olap;
            mid.m_fPosition = endpos;
            mid.m_fNext = null;
            mid.m_fMode = 1 | mid.m_fMode;
        }
        mid = null;
        StorageBuffer fragment = new StorageBuffer(this.m_head, len);
        this.m_head = this.m_tail = new Scrap();
        this.m_tail.m_fBuffer = new byte[2048];
        this.m_tail.m_fOffset = 0;
        this.m_tail.m_fLength = 0;
        this.m_tail.m_fMode = 0;
        this.m_tail.m_fPosition = endpos;
        while (firstHeader != null) {
            firstHeader.m_generator.beginMessage(this, firstHeader.m_cookie);
            firstHeader = firstHeader.m_previous;
        }
        this.prealloc();
        int addHeader = 0;
        if (nexthead != null) {
            addHeader = this.m_tail.m_fPosition + nexthead.m_fLength - nexthead.m_fPosition;
            if (this.m_tail.m_fLength == 0) {
                this.m_tail.m_fBuffer = nexthead.m_fBuffer;
                this.m_tail.m_fLength = nexthead.m_fLength;
                this.m_tail.m_fOffset = nexthead.m_fOffset;
                this.m_tail.m_fMode = nexthead.m_fMode;
                this.m_tail.m_fNext = nexthead.m_fNext;
                this.m_tail.m_fPosition += nexthead.m_fLength;
                nexthead = nexthead.m_fNext;
            } else {
                this.m_tail.m_fNext = nexthead;
            }
            while (nexthead != null) {
                nexthead.m_fPosition += addHeader;
                this.m_tail = nexthead;
                nexthead = nexthead.m_fNext;
            }
        }
        BlockData bd = this.m_last_block;
        while (bd != null) {
            bd.m_position += addHeader;
            bd = bd.m_previous;
        }
        this.m_in_fragment = false;
        return fragment;
    }

    /*
     * Unable to fully structure code
     */
    public StorageBuffer lastFragment() {
        if (MarshalBuffer.DEBUG_ENABLED && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("Entering method 'lastFragment()'...");
        }
        if (!this.prealloc()) {
            return null;
        }
        if (this.m_listener != null && !this.m_in_listener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener. Call close operation");
        }
        if (this.m_last_block == null) ** GOTO lbl11
        throw new IllegalStateException("Attempt to close buffer without closing all blocks");
lbl-1000:
        // 1 sources

        {
            HeaderData.access$400(this.m_last_header).endMessage(HeaderData.access$600(this.m_last_header), HeaderData.access$700(this.m_last_header), HeaderData.access$800(this.m_last_header), false, this.m_tail.m_fPosition - HeaderData.access$300(this.m_last_header), HeaderData.access$500(this.m_last_header));
            this.m_last_header = HeaderData.access$100(this.m_last_header);
lbl11:
            // 2 sources

            ** while (this.m_last_header != null)
        }
lbl12:
        // 1 sources

        msghead = this.m_head;
        len = this.m_tail.m_fPosition - this.m_head.m_fPosition + this.m_head.m_fLength;
        this.m_tail = null;
        this.m_head = null;
        return new StorageBuffer(msghead, len);
    }

    private boolean prealloc() {
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        if (this.m_head == null) {
            return false;
        }
        if (this.m_last_buffer != null) {
            this.m_last_buffer.value = null;
            this.m_last_buffer = null;
            this.postalloc();
        }
        return true;
    }

    private void postalloc() {
        if (this.m_listener != null && this.m_allow_fragment && this.m_header_fragment && this.m_block_fragment && !this.m_in_fragment) {
            this.m_in_listener = true;
            try {
                this.m_listener.availIncreaced(this, this.m_tail.m_fPosition - this.m_head.m_fPosition + this.m_head.m_fLength, this.m_listener_cookie);
                Object var2_1 = null;
                this.m_in_listener = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.m_in_listener = false;
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        MarshalBuffer mbuf = new MarshalBuffer();
        OctetSeqHolder buf = new OctetSeqHolder();
        IntHolder pos = new IntHolder();
        int len = 1;
        int i = 0;
        while (i < 3000) {
            mbuf.alloc(buf, pos, len);
            int j = 0;
            while (j < len) {
                buf.value[pos.value + j] = (byte)((i + j) % 121);
                ++j;
            }
            i += len;
        }
        StorageBuffer sbuf = mbuf.lastFragment();
        System.out.println("available = " + sbuf.available());
        System.out.println("available = " + sbuf.available());
        byte[] lin = sbuf.linearize();
        int i2 = 0;
        while (i2 < lin.length) {
            if (lin[i2] != (byte)(i2 % 121)) {
                System.out.println("Error at index " + i2);
            }
            ++i2;
        }
    }

    private static class BlockData {
        private BlockData m_previous;
        private boolean m_isFragment;
        private int m_position;
        private BlockGenerator m_generator;
        private Object m_cookie;
        private byte[] m_buffer;
        private int m_offset;
        private int m_length;

        private BlockData() {
        }

        static /* synthetic */ byte[] access$1502(BlockData x0, byte[] x1) {
            x0.m_buffer = x1;
            return x1;
        }
    }

    private static class HeaderData {
        private HeaderData m_previous;
        private boolean m_lastHeaderFragment;
        private int m_position;
        private HeaderGenerator m_generator;
        private Object m_cookie;
        private byte[] m_buffer;
        private int m_offset;
        private int m_length;

        private HeaderData() {
        }

        static /* synthetic */ byte[] access$602(HeaderData x0, byte[] x1) {
            x0.m_buffer = x1;
            return x1;
        }
    }

    public static interface Listener
    extends EventListener {
        public void availIncreaced(MarshalBuffer var1, int var2, Object var3);

        public void bufferClosed(MarshalBuffer var1, int var2, Object var3);

        public void bufferCanceled(MarshalBuffer var1, SystemException var2, Object var3);
    }

    public static interface BlockGenerator {
        public void endBlock(byte[] var1, int var2, int var3, int var4, Object var5);

        public void fragmentBlock(byte[] var1, int var2, int var3, int var4, MarshalBuffer var5, Object var6);
    }

    public static interface HeaderGenerator {
        public void endMessage(byte[] var1, int var2, int var3, boolean var4, int var5, Object var6);

        public void beginMessage(MarshalBuffer var1, Object var2);
    }
}

