/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.io;

import java.math.BigDecimal;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.orb.core.typecode.TypeCodeBase;
import org.openorb.orb.io.ExtendedInputStream;
import org.openorb.orb.io.ExtendedOutputStream;
import org.openorb.orb.io.TypeCodeValueBoxHelper;
import org.openorb.orb.util.Trace;
import org.openorb.util.RepoIDHelper;

public final class StreamHelper {
    private StreamHelper() {
    }

    public static void copy_stream(TypeCode type, InputStream is, OutputStream os) {
        try {
            type = TypeCodeBase._base_type(type);
            switch (type.kind().value()) {
                case 0: 
                case 1: {
                    return;
                }
                case 2: {
                    os.write_short(is.read_short());
                    return;
                }
                case 3: {
                    os.write_long(is.read_long());
                    return;
                }
                case 4: {
                    os.write_ushort(is.read_ushort());
                    return;
                }
                case 5: {
                    os.write_ulong(is.read_ulong());
                    return;
                }
                case 6: {
                    os.write_float(is.read_float());
                    return;
                }
                case 7: {
                    os.write_double(is.read_double());
                    return;
                }
                case 8: {
                    os.write_boolean(is.read_boolean());
                    return;
                }
                case 9: {
                    os.write_char(is.read_char());
                    return;
                }
                case 10: {
                    os.write_octet(is.read_octet());
                    return;
                }
                case 11: {
                    os.write_any(is.read_any());
                    return;
                }
                case 12: {
                    os.write_TypeCode(is.read_TypeCode());
                    return;
                }
                case 13: {
                    os.write_Principal(is.read_Principal());
                    return;
                }
                case 14: {
                    os.write_Object(is.read_Object());
                    return;
                }
                case 22: {
                    os.write_string(is.read_string());
                }
                case 15: {
                    int i = 0;
                    while (i < type.member_count()) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        ++i;
                    }
                    return;
                }
                case 17: {
                    os.write_ulong(is.read_ulong());
                    return;
                }
                case 18: {
                    os.write_string(is.read_string());
                    return;
                }
                case 23: {
                    os.write_longlong(is.read_longlong());
                    return;
                }
                case 24: {
                    os.write_ulonglong(is.read_ulonglong());
                    return;
                }
                case 25: {
                    throw new NO_IMPLEMENT();
                }
                case 26: {
                    os.write_wchar(is.read_wchar());
                    return;
                }
                case 27: {
                    os.write_wstring(is.read_wstring());
                    return;
                }
                case 28: {
                    BigDecimal val = is instanceof ExtendedInputStream ? ((ExtendedInputStream)is).read_fixed(type) : is.read_fixed();
                    if (os instanceof ExtendedOutputStream) {
                        ((ExtendedOutputStream)os).write_fixed(val, type);
                    } else {
                        os.write_fixed(val);
                    }
                    return;
                }
                case 29: {
                    os.write_value(is.read_value(type.id()));
                    return;
                }
                case 30: {
                    TypeCodeValueBoxHelper boxhelp = null;
                    String repo_id = type.id();
                    try {
                        String boxname = RepoIDHelper.idToClass((String)repo_id, (int)2);
                        boxhelp = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(boxname).newInstance();
                    }
                    catch (Exception ex) {
                        boxhelp = new TypeCodeValueBoxHelper(os.orb(), type);
                    }
                    os.write_value(is.read_value((BoxedValueHelper)boxhelp), (BoxedValueHelper)boxhelp);
                    return;
                }
                case 32: {
                    os.write_abstract_interface(is.read_abstract_interface());
                    return;
                }
                case 19: 
                case 20: {
                    int length = type.length();
                    if (type.kind() == TCKind.tk_sequence) {
                        int truelen = is.read_ulong();
                        if (length != 0 && truelen > length) {
                            throw new MARSHAL("Sequence length out of bounds", 1146056722, CompletionStatus.COMPLETED_MAYBE);
                        }
                        length = truelen;
                        os.write_ulong(length);
                    }
                    TypeCode content = TypeCodeBase._base_type(type.content_type());
                    StreamHelper.handleArrayContent(is, os, content, length);
                    return;
                }
                case 16: {
                    TypeCode dsct = TypeCodeBase._base_type(type.discriminator_type());
                    StreamHelper.handleUnionContent(is, os, type, dsct);
                    return;
                }
            }
            Trace.signalIllegalCondition(null, "Unexpected type kind().value()==" + type.kind().value() + ".");
        }
        catch (BadKind ex) {
            throw new CascadingRuntimeException("Unexpected BadKind exception during value copy", (Throwable)ex);
        }
        catch (Bounds ex) {
            throw new CascadingRuntimeException("Unexpected Bounds exception during value copy", (Throwable)ex);
        }
    }

    private static void handleUnionContent(InputStream is, OutputStream os, TypeCode type, TypeCode dsct) throws BadKind, Bounds {
        switch (dsct.kind().value()) {
            case 8: {
                boolean disc = is.read_boolean();
                os.write_boolean(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_boolean() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 9: {
                char disc = is.read_char();
                os.write_char(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_char() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 26: {
                char disc = is.read_wchar();
                os.write_wchar(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_wchar() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 2: {
                short disc = is.read_short();
                os.write_short(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_short() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 4: {
                short disc = is.read_ushort();
                os.write_ushort(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_ushort() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 3: {
                int disc = is.read_long();
                os.write_long(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_long() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 5: 
            case 17: {
                int disc = is.read_ulong();
                os.write_ulong(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_ulong() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 23: {
                long disc = is.read_longlong();
                os.write_longlong(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_longlong() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
            case 24: {
                long disc = is.read_ulonglong();
                os.write_ulonglong(disc);
                int defl = type.default_index();
                int i = 0;
                while (i < type.member_count()) {
                    if (i != defl && type.member_label(i).extract_ulonglong() == disc) {
                        StreamHelper.copy_stream(type.member_type(i), is, os);
                        return;
                    }
                    ++i;
                }
                if (defl < 0) {
                    throw new MARSHAL("Union discriminator out of range", 1146056730, CompletionStatus.COMPLETED_NO);
                }
                StreamHelper.copy_stream(type.member_type(defl), is, os);
                return;
            }
        }
        Trace.signalIllegalCondition(null, "Unexpected union discriminator type kind().value()==" + dsct.kind().value() + ".");
    }

    private static void handleArrayContent(InputStream is, OutputStream os, TypeCode content, int length) throws BadKind, Bounds {
        switch (content.kind().value()) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                short[] tmp = new short[length];
                is.read_short_array(tmp, 0, length);
                os.write_short_array(tmp, 0, length);
                return;
            }
            case 4: {
                short[] tmp = new short[length];
                is.read_ushort_array(tmp, 0, length);
                os.write_ushort_array(tmp, 0, length);
                return;
            }
            case 3: {
                int[] tmp = new int[length];
                is.read_long_array(tmp, 0, length);
                os.write_long_array(tmp, 0, length);
                return;
            }
            case 5: {
                int[] tmp = new int[length];
                is.read_ulong_array(tmp, 0, length);
                os.write_ulong_array(tmp, 0, length);
                return;
            }
            case 6: {
                float[] tmp = new float[length];
                is.read_float_array(tmp, 0, length);
                os.write_float_array(tmp, 0, length);
                return;
            }
            case 7: {
                double[] tmp = new double[length];
                is.read_double_array(tmp, 0, length);
                os.write_double_array(tmp, 0, length);
                return;
            }
            case 8: {
                boolean[] tmp = new boolean[length];
                is.read_boolean_array(tmp, 0, length);
                os.write_boolean_array(tmp, 0, length);
                return;
            }
            case 9: {
                char[] tmp = new char[length];
                is.read_char_array(tmp, 0, length);
                os.write_char_array(tmp, 0, length);
                return;
            }
            case 10: {
                byte[] tmp = new byte[length];
                is.read_octet_array(tmp, 0, length);
                os.write_octet_array(tmp, 0, length);
                return;
            }
            case 11: {
                int i = 0;
                while (i < length) {
                    os.write_any(is.read_any());
                    ++i;
                }
                return;
            }
            case 12: {
                int i = 0;
                while (i < length) {
                    os.write_TypeCode(is.read_TypeCode());
                    ++i;
                }
                return;
            }
            case 13: {
                int i = 0;
                while (i < length) {
                    os.write_Principal(is.read_Principal());
                    ++i;
                }
                return;
            }
            case 14: {
                int i = 0;
                while (i < length) {
                    os.write_Object(is.read_Object());
                    ++i;
                }
                return;
            }
            case 17: {
                int i = 0;
                while (i < length) {
                    os.write_ulong(is.read_ulong());
                    ++i;
                }
                return;
            }
            case 18: {
                int i = 0;
                while (i < length) {
                    os.write_string(is.read_string());
                    ++i;
                }
                return;
            }
            case 23: {
                long[] tmp = new long[length];
                is.read_longlong_array(tmp, 0, length);
                os.write_longlong_array(tmp, 0, length);
                return;
            }
            case 24: {
                long[] tmp = new long[length];
                is.read_ulonglong_array(tmp, 0, length);
                os.write_ulonglong_array(tmp, 0, length);
                return;
            }
            case 25: {
                throw new NO_IMPLEMENT();
            }
            case 26: {
                char[] tmp = new char[length];
                is.read_wchar_array(tmp, 0, length);
                os.write_wchar_array(tmp, 0, length);
                return;
            }
            case 27: {
                int i = 0;
                while (i < length) {
                    os.write_wstring(is.read_wstring());
                    ++i;
                }
                return;
            }
            case 28: {
                int i = 0;
                while (i < length) {
                    os.write_fixed(is.read_fixed());
                    ++i;
                }
                return;
            }
            case 29: 
            case 30: {
                int i = 0;
                while (i < length) {
                    os.write_value(is.read_value());
                    ++i;
                }
                return;
            }
            case 32: {
                int i = 0;
                while (i < length) {
                    os.write_abstract_interface(is.read_abstract_interface());
                    ++i;
                }
                return;
            }
            case 15: 
            case 22: {
                int i = 0;
                while (i < length) {
                    int j = 0;
                    while (j < content.member_count()) {
                        StreamHelper.copy_stream(content.member_type(j), is, os);
                        ++j;
                    }
                    ++i;
                }
                return;
            }
            case 16: 
            case 19: 
            case 20: {
                int i = 0;
                while (i < length) {
                    StreamHelper.copy_stream(content, is, os);
                    ++i;
                }
                return;
            }
        }
        Trace.signalIllegalCondition(null, "Unexpected array content type kind().value()==" + content.kind().value() + ".");
    }
}

