/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.io;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.io.ListOutputStream;
import org.openorb.orb.io.StreamHelper;

public class TypeCodeStreamableValue
implements StreamableValue {
    private TypeCode m_tc;
    private ORB m_orb;
    private ListOutputStream m_os;
    private String[] m_truncatable_ids = null;
    private Logger m_logger = null;

    public TypeCodeStreamableValue(ORB orb, TypeCode tc) throws BadKind {
        if (this.m_tc.kind() != TCKind.tk_value) {
            throw new BadKind();
        }
        this.m_orb = orb;
        this.m_tc = tc;
    }

    public TypeCode getTypeCode() {
        return this.m_tc;
    }

    public OutputStream create_output_stream() {
        this.m_os = (ListOutputStream)this.m_orb.create_output_stream();
        return this.m_os;
    }

    public InputStream create_input_stream() {
        if (this.m_os == null) {
            return null;
        }
        return (InputStream)this.m_os.create_input_stream();
    }

    public void _read(org.omg.CORBA.portable.InputStream is) {
        this.m_os = (ListOutputStream)this.m_orb.create_output_stream();
        TypeCodeStreamableValue.copyState(this.m_tc, (InputStream)is, this.m_os, this.getLogger());
    }

    public void _write(org.omg.CORBA.portable.OutputStream os) {
        TypeCodeStreamableValue.copyState(this.m_tc, (InputStream)this.m_os.create_input_stream(), (OutputStream)os, this.getLogger());
    }

    public TypeCode _type() {
        return this.m_tc;
    }

    public String[] _truncatable_ids() {
        block5: {
            if (this.m_truncatable_ids == null) {
                try {
                    int count = 1;
                    TypeCode base = this.m_tc;
                    while (base != null && base.type_modifier() == 3) {
                        ++count;
                        base = base.concrete_base_type();
                    }
                    this.m_truncatable_ids = new String[count];
                    count = 0;
                    base = this.m_tc;
                    do {
                        this.m_truncatable_ids[count++] = base.id();
                    } while ((base = base.concrete_base_type()) != null && base.type_modifier() == 3);
                }
                catch (BadKind ex) {
                    if (!this.getLogger().isErrorEnabled()) break block5;
                    this.getLogger().error("BadKind exception should be impossible here.", (Throwable)ex);
                }
            }
        }
        return this.m_truncatable_ids;
    }

    private static void copyState(TypeCode tc, InputStream is, OutputStream os, Logger logger) {
        block6: {
            try {
                TypeCode base = tc.concrete_base_type();
                if (base != null) {
                    TypeCodeStreamableValue.copyState(base, is, os, logger);
                }
                int i = 0;
                while (i < tc.member_count()) {
                    StreamHelper.copy_stream(tc.member_type(i), is, os);
                    ++i;
                }
            }
            catch (BadKind ex) {
                if (logger.isErrorEnabled()) {
                    logger.error("BadKind exception should be impossible here.", (Throwable)ex);
                }
            }
            catch (Bounds ex) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error("BadKind exception should be impossible here.", (Throwable)ex);
            }
        }
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

