/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.messaging;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.TCKind;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.SyncScopeHelper;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcTHelper;

final class PolicyFactoryImpl
extends LocalObject
implements PolicyFactory {
    private static PolicyFactoryImpl s_instance = null;
    private SyncScopePolicy m_syncScope_none;
    private SyncScopePolicy m_syncScope_transport;
    private SyncScopePolicy m_syncScope_server;
    private SyncScopePolicy m_syncScope_target;

    private PolicyFactoryImpl() {
    }

    static PolicyFactoryImpl getInstance() {
        if (s_instance == null) {
            s_instance = new PolicyFactoryImpl();
        }
        return s_instance;
    }

    public synchronized Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 24: {
                if (!value.type().equal(SyncScopeHelper.type()) && value.type().kind() != TCKind.tk_short && value.type().kind() != TCKind.tk_ushort) {
                    throw new PolicyError(2);
                }
                return this.createSyncScopePolicy(value.extract_short());
            }
            case 31: {
                if (!value.type().equal(TimeTHelper.type())) {
                    throw new PolicyError(2);
                }
                throw new PolicyError(1);
            }
            case 32: {
                if (!value.type().equal(TimeTHelper.type())) {
                    throw new PolicyError(2);
                }
                return new RelativeRoundtripTimeoutPolicyImpl(TimeTHelper.extract((Any)value));
            }
            case 30: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
                throw new PolicyError(1);
            }
            case 29: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
                throw new PolicyError(1);
            }
            case 28: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
                throw new PolicyError(1);
            }
            case 27: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
                throw new PolicyError(1);
            }
        }
        throw new PolicyError(0);
    }

    private SyncScopePolicy createSyncScopePolicy(short polValue) throws PolicyError {
        switch (polValue) {
            case 0: {
                if (this.m_syncScope_none == null) {
                    this.m_syncScope_none = new SyncScopePolicyImpl(polValue);
                }
                return this.m_syncScope_none;
            }
            case 1: {
                if (this.m_syncScope_transport == null) {
                    this.m_syncScope_transport = new SyncScopePolicyImpl(polValue);
                }
                return this.m_syncScope_transport;
            }
            case 2: {
                if (this.m_syncScope_server == null) {
                    this.m_syncScope_server = new SyncScopePolicyImpl(polValue);
                }
                return this.m_syncScope_server;
            }
            case 3: {
                if (this.m_syncScope_target == null) {
                    this.m_syncScope_target = new SyncScopePolicyImpl(polValue);
                }
                return this.m_syncScope_target;
            }
        }
        throw new PolicyError(3);
    }

    private static class RelativeRoundtripTimeoutPolicyImpl
    extends LocalObject
    implements RelativeRoundtripTimeoutPolicy {
        private long m_relative_expiry;

        RelativeRoundtripTimeoutPolicyImpl(long val) {
            this.m_relative_expiry = val;
        }

        public long relative_expiry() {
            return this.m_relative_expiry;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 32;
        }
    }

    private static class SyncScopePolicyImpl
    extends LocalObject
    implements SyncScopePolicy {
        private short m_sync_scope;

        SyncScopePolicyImpl(short val) {
            this.m_sync_scope = val;
        }

        public short synchronization() {
            return this.m_sync_scope;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 24;
        }
    }
}

