/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.InvalidSlot;
import org.openorb.orb.core.Delegate;
import org.openorb.orb.core.ORB;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.core.ObjectStub;
import org.openorb.orb.net.Address;
import org.openorb.orb.net.ClientChannel;
import org.openorb.orb.net.ClientRequest;
import org.openorb.orb.pi.CurrentImpl;
import org.openorb.orb.policy.PolicyReconciler;
import org.openorb.util.NumberCache;

public abstract class AbstractClientRequest
extends LocalObject
implements ClientRequest {
    private org.omg.CORBA.ORB m_orb;
    private Object m_target;
    private Delegate m_target_deleg;
    private IOR m_target_ior;
    private Object m_effective_target;
    private IOR m_effective_target_ior;
    private ClientChannel m_channel;
    private Address m_address;
    private CurrentImpl m_pi_current;
    private CurrentOperations m_pi_curr_entry;
    private PolicyReconciler m_orb_reconciler = null;
    private Map m_service_contexts = new HashMap();
    private int m_request_id;
    private Logger m_logger = null;

    public AbstractClientRequest(int request_id, Object target, Address address, ClientChannel channel) {
        this.m_address = address;
        this.m_channel = channel;
        this.m_target = target;
        this.m_request_id = request_id;
        this.m_target_deleg = (Delegate)((ObjectImpl)target)._get_delegate();
        this.m_target_ior = this.m_target_deleg.ior();
        this.m_orb = ((ObjectImpl)target)._orb();
        this.m_pi_current = ((ORB)this.m_orb).getPICurrent();
        this.m_pi_curr_entry = this.m_pi_current.copy(this.m_pi_current.get());
    }

    public ClientChannel channel() {
        return this.m_channel;
    }

    public Address address() {
        return this.m_address;
    }

    public int request_id() {
        return this.m_request_id;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof ClientRequest) {
            return this.m_request_id == ((ClientRequest)obj).request_id();
        }
        return false;
    }

    public int hashCode() {
        return this.m_request_id;
    }

    public IOR target_ior() {
        return this.m_target_ior;
    }

    public Object target() {
        return this.m_target;
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public IOR effective_target_ior() {
        if (this.m_effective_target_ior == null) {
            this.m_effective_target_ior = this.m_address.getTargetAddress((short)2).ior().ior;
        }
        return this.m_effective_target_ior;
    }

    public Object effective_target() {
        if (this.m_effective_target == null) {
            this.m_effective_target = new ObjectStub(this.m_orb, this.effective_target_ior());
        }
        return this.m_effective_target;
    }

    public TaggedProfile effective_profile() {
        return this.m_address.getTargetAddress((short)1).profile();
    }

    public TaggedComponent get_effective_component(int id) {
        return this.get_effective_components(id)[0];
    }

    public TaggedComponent[] get_effective_components(int id) {
        TaggedComponent[] ret = this.m_address.get_components(id);
        if (ret == null || ret.length == 0) {
            throw new BAD_PARAM(1330446361, this.state_completion_status());
        }
        return ret;
    }

    protected boolean requestPolicyExists(int type) {
        Policy clientPolicy = this.m_target_deleg.get_client_policy(this.m_target, type);
        int[] types = new int[]{type};
        Policy[] targetPols = this.m_address.get_target_policies(types);
        Policy targetPolicy = 0 < targetPols.length ? targetPols[0] : null;
        return null != clientPolicy || null != targetPolicy;
    }

    public Policy get_request_policy(int type) {
        Policy client_policy = this.m_target_deleg.get_client_policy(this.m_target, type);
        Policy target_policy = null;
        int[] types = new int[]{type};
        Policy[] target_pols = this.m_address.get_target_policies(types);
        if (target_pols.length > 0) {
            target_policy = target_pols[0];
        }
        if (client_policy == null && target_policy == null) {
            throw new INV_POLICY("Policy type not found", 1330446337, this.state_completion_status());
        }
        if (this.m_orb_reconciler == null) {
            this.m_orb_reconciler = (PolicyReconciler)((ORB)this.m_orb).getFeature("PolicyReconciler");
            if (this.m_orb_reconciler == null) {
                throw new INTERNAL("PolicyReconciler unavailable.");
            }
        }
        return this.m_orb_reconciler.reconcile_policies(type, client_policy, target_policy, null);
    }

    public Parameter[] arguments() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public TypeCode[] exceptions() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public String[] contexts() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public String[] operation_context() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public Any result() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public Any get_slot(int id) throws InvalidSlot {
        Map map = this.m_service_contexts;
        synchronized (map) {
            if (this.m_pi_curr_entry == null) {
                this.m_pi_curr_entry = this.m_pi_current.create();
            }
        }
        return this.m_pi_curr_entry.get_slot(id);
    }

    public void add_request_service_context(ServiceContext service_context, boolean replace) {
        if (this.state() != 0) {
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
        Integer key = NumberCache.getInteger((int)service_context.context_id);
        Map map = this.m_service_contexts;
        synchronized (map) {
            if (!replace && this.m_service_contexts.containsKey(key)) {
                throw new BAD_INV_ORDER(1330446347, this.state_completion_status());
            }
            this.m_service_contexts.put(key, service_context);
        }
    }

    public ServiceContext get_request_service_context(int id) {
        ServiceContext ret = null;
        Map map = this.m_service_contexts;
        synchronized (map) {
            ret = (ServiceContext)this.m_service_contexts.get(NumberCache.getInteger((int)id));
        }
        if (ret == null) {
            throw new BAD_PARAM(1330446359, this.state_completion_status());
        }
        return ret;
    }

    public ServiceContext[] get_request_service_contexts() {
        Map map = this.m_service_contexts;
        synchronized (map) {
            ServiceContext[] serviceContextArray = this.m_service_contexts.values().toArray(new ServiceContext[this.m_service_contexts.size()]);
            return serviceContextArray;
        }
    }

    public CompletionStatus state_completion_status() {
        switch (this.state()) {
            case 0: 
            case 1: {
                return CompletionStatus.COMPLETED_NO;
            }
            case 2: {
                return CompletionStatus.COMPLETED_MAYBE;
            }
            case 3: {
                return CompletionStatus.COMPLETED_YES;
            }
            case 4: {
                switch (this.reply_status()) {
                    case -2: 
                    case -1: 
                    case 0: 
                    case 2: {
                        return CompletionStatus.COMPLETED_YES;
                    }
                    case 1: {
                        return this.received_system_exception().completed;
                    }
                    case 3: 
                    case 4: {
                        return CompletionStatus.COMPLETED_NO;
                    }
                }
            }
        }
        Error e = new Error("Invalid state of the state machine.");
        this.getLogger().fatalError(e.getMessage(), (Throwable)e);
        throw e;
    }

    protected Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.orb()).getLogger();
        }
        return this.m_logger;
    }

    public abstract String received_exception_id();

    public abstract SystemException received_system_exception();

    public abstract IOR forward_reference_ior();

    public abstract InputStream receive_response();

    public abstract int wait_for_response(long var1);

    public abstract boolean poll_response();

    public abstract int send_request();

    public abstract OutputStream begin_marshal();

    public abstract boolean is_locate();

    public abstract boolean is_poll();

    public abstract boolean is_request();

    public abstract boolean cancel(SystemException var1);

    public abstract int state();

    public abstract Any received_exception();

    public abstract ServiceContext get_reply_service_context(int var1);

    public abstract Object forward_reference();

    public abstract short reply_status();

    public abstract short sync_scope();

    public abstract boolean response_expected();

    public abstract String operation();
}

