/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.openorb.orb.adapter.AdapterDestroyedException;
import org.openorb.orb.adapter.ObjectAdapter;
import org.openorb.orb.adapter.TargetInfo;
import org.openorb.orb.core.Delegate;
import org.openorb.orb.core.ORB;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.core.SystemExceptionHelper;
import org.openorb.orb.net.ServerChannel;
import org.openorb.orb.net.ServerManager;
import org.openorb.orb.net.ServerRequest;
import org.openorb.orb.pi.CurrentImpl;
import org.openorb.orb.pi.RequestCallback;
import org.openorb.orb.util.Trace;
import org.openorb.util.NumberCache;

public abstract class AbstractServerRequest
extends LocalObject
implements ServerRequest {
    private org.omg.CORBA.ORB m_orb;
    private ServerManager m_server_manager;
    private ServerChannel m_channel;
    private int m_request_id;
    private byte[] m_object_key;
    private String m_operation;
    private byte m_sync_scope;
    private ServiceContext[] m_request_service_contexts;
    private InputStream m_argument_stream;
    private CurrentImpl m_pi_current;
    private CurrentOperations m_rs_pi_curr_entry;
    private CurrentOperations m_ts_pi_curr_entry;
    private Map m_service_contexts = new HashMap();
    private org.openorb.orb.pi.ServerManager m_interceptor_manager = null;
    private RequestCallback m_callback = null;
    private java.lang.Object m_sync_state = new java.lang.Object();
    private volatile int m_state = -1;
    private short m_reply_status = Short.MIN_VALUE;
    private ObjectAdapter m_adapter = null;
    private TargetInfo m_target;
    private OutputStream m_reply_stream;
    private Object m_forward_reference;
    private IOR m_forward_reference_ior;
    private SystemException m_sending_system_exception;
    private Any m_sending_system_exception_any = null;
    private String m_sending_system_exception_id;
    private Logger m_logger = null;
    private static final short REPLY_STATUS_UNSET = Short.MIN_VALUE;
    private static boolean s_throw_service_context_exceptions = true;

    public AbstractServerRequest(ServerManager serverManager, ServerChannel channel, int request_id, InputStream argument_stream, byte[] object_key, String operation, byte sync_scope, ServiceContext[] request_service_contexts) {
        this.init_one(serverManager, channel, request_id, argument_stream);
        this.init(object_key, operation, sync_scope, request_service_contexts);
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel channel, int request_id, InputStream argument_stream) {
        this.init_one(serverManager, channel, request_id, argument_stream);
    }

    private void init_one(ServerManager serverManager, ServerChannel channel, int request_id, InputStream argument_stream) {
        this.m_server_manager = serverManager;
        this.m_channel = channel;
        this.m_request_id = request_id;
        this.m_argument_stream = argument_stream;
        this.m_orb = this.m_server_manager.orb();
        this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        this.m_pi_current = ((ORB)this.m_orb).getPICurrent();
    }

    public void init(byte[] object_key, String operation, byte sync_scope, ServiceContext[] request_service_contexts) {
        if (this.m_state >= 0) {
            Trace.signalIllegalCondition(this.getLogger(), "Invalid state.");
        }
        this.m_object_key = object_key;
        this.m_operation = operation;
        this.m_sync_scope = sync_scope;
        this.m_request_service_contexts = request_service_contexts;
        if (this.m_operation != null) {
            this.m_interceptor_manager = (org.openorb.orb.pi.ServerManager)((ORB)this.m_orb).getFeature("ServerInterceptorManager");
            if (this.m_interceptor_manager != null) {
                this.m_callback = new RequestCallback(){

                    public void reply_system_exception(SystemException ex) {
                        AbstractServerRequest.this.handle_system_exception(ex);
                    }

                    public void reply_runtime_exception(RuntimeException ex) {
                        AbstractServerRequest.this.handle_runtime_exception(ex);
                    }

                    public void reply_error(Error ex) {
                        AbstractServerRequest.this.handle_error(ex);
                    }

                    public void reply_location_forward(Object forward, boolean permanent) {
                        AbstractServerRequest.this.handle_location_forward(forward, permanent);
                    }
                };
            }
        }
        this.m_state = 0;
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel channel, int request_id, byte[] object_key) {
        this.init_one(serverManager, channel, request_id, null);
        this.init(object_key, null, (byte)3, null);
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel channel, int request_id) {
        this.init_one(serverManager, channel, request_id, null);
    }

    public void init(byte[] object_key) {
        this.init(object_key, null, (byte)3, null);
    }

    public static void disableServiceContextExceptions() {
        s_throw_service_context_exceptions = false;
    }

    public static void enableServiceContextExceptions() {
        s_throw_service_context_exceptions = true;
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public ServerChannel channel() {
        return this.m_channel;
    }

    public int state() {
        return this.m_state;
    }

    protected CompletionStatus state_completion_status() {
        switch (this.m_state) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                return CompletionStatus.COMPLETED_NO;
            }
            case 3: {
                return CompletionStatus.COMPLETED_MAYBE;
            }
            case 4: 
            case 5: {
                return CompletionStatus.COMPLETED_YES;
            }
        }
        Trace.signalIllegalCondition(this.getLogger(), "Wrong state of the state machine.");
        return null;
    }

    public boolean is_locate() {
        return this.m_operation == null;
    }

    public byte[] object_key() {
        return this.m_object_key;
    }

    public int request_id() {
        return this.m_request_id;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof ServerRequest) {
            ServerRequest srq2 = (ServerRequest)obj;
            return this.m_request_id == srq2.request_id() && this.m_channel == srq2.channel();
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_channel != null ? this.m_channel.hashCode() : 0;
        result = 29 * result + this.m_request_id;
        return result;
    }

    public String operation() {
        return this.m_operation;
    }

    public boolean response_expected() {
        return this.m_sync_scope == 3;
    }

    public short sync_scope() {
        return this.m_sync_scope;
    }

    public Parameter[] arguments() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public TypeCode[] exceptions() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public String[] contexts() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public String[] operation_context() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public Any result() {
        throw new NO_RESOURCES(1330446337, this.state_completion_status());
    }

    public Any get_slot(int id) throws InvalidSlot {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_rs_pi_curr_entry == null) {
                this.m_rs_pi_curr_entry = this.m_pi_current.create();
            }
        }
        CurrentOperations currentOperations = this.m_rs_pi_curr_entry;
        synchronized (currentOperations) {
            Any any = this.m_rs_pi_curr_entry.get_slot(id);
            return any;
        }
    }

    public void set_slot(int id, Any data) throws InvalidSlot {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_rs_pi_curr_entry == null) {
                this.m_rs_pi_curr_entry = this.m_pi_current.create();
            }
        }
        CurrentOperations currentOperations = this.m_rs_pi_curr_entry;
        synchronized (currentOperations) {
            this.m_rs_pi_curr_entry.set_slot(id, data);
        }
    }

    public ServiceContext get_request_service_context(int id) {
        int i = 0;
        while (i < this.m_request_service_contexts.length) {
            if (this.m_request_service_contexts[i].context_id == id) {
                return this.m_request_service_contexts[i];
            }
            ++i;
        }
        if (s_throw_service_context_exceptions) {
            throw new BAD_PARAM(1330446359, this.state_completion_status());
        }
        return null;
    }

    public void client_cancel() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 5) {
                return;
            }
            if (this.m_sync_scope != 3) {
                switch (this.m_state) {
                    case 3: 
                    case 4: {
                        return;
                    }
                }
            }
            this.handle_system_exception((SystemException)new TRANSIENT(1330446338, this.state_completion_status()));
            if (this.m_state != 0 && this.m_interceptor_manager != null) {
                this.m_interceptor_manager.send_exception(this, this.m_callback);
                this.m_interceptor_manager = null;
            }
            this.m_state = 5;
            if (this.m_target != null) {
                this.m_adapter.cancel_dispatch(this, this.m_target);
            }
            this.release_request();
        }
    }

    public void server_cancel(Throwable ex) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 5) {
                return;
            }
            if (ex instanceof SystemException) {
                SystemException sex = (SystemException)ex;
                sex.completed = this.state_completion_status();
                this.handle_system_exception(sex);
            } else if (ex instanceof RuntimeException) {
                this.handle_runtime_exception((RuntimeException)ex);
            } else if (ex instanceof Error) {
                this.handle_error((Error)ex);
            } else {
                this.handle_unknown_throwable(ex);
            }
            if (this.m_target != null) {
                this.m_adapter.cancel_dispatch(this, this.m_target);
            }
            this.complete_request();
        }
    }

    public int begin_request() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 0) {
                if (this.m_interceptor_manager != null) {
                    this.m_interceptor_manager.receive_request_service_contexts(this, this.m_callback);
                    if (this.m_reply_status != Short.MIN_VALUE) {
                        this.m_interceptor_manager = null;
                        this.complete_request();
                        int n = this.m_state;
                        return n;
                    }
                }
                this.m_state = 1;
                this.m_ts_pi_curr_entry = this.m_pi_current.copy(this.m_rs_pi_curr_entry);
            }
            this.m_pi_current.set(this.m_ts_pi_curr_entry);
        }
        return this.m_state;
    }

    public int adapter(ObjectAdapter adapter) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 1: {
                    this.m_adapter = adapter;
                    this.m_state = 2;
                }
                case 5: {
                    int n = this.m_state;
                    return n;
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public ObjectAdapter adapter() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_adapter == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            ObjectAdapter objectAdapter = this.m_adapter;
            return objectAdapter;
        }
    }

    public Policy get_server_policy(int type) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_adapter == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            int[] types = new int[]{type};
            Policy[] pols = this.m_adapter.get_server_policies(types);
            if (pols.length >= 1) {
                Policy policy = pols[0];
                return policy;
            }
            throw new INV_POLICY(1330446337, this.state_completion_status());
        }
    }

    public byte[] adapter_id() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            byte[] byArray = this.m_target.getAdapterID();
            return byArray;
        }
    }

    public byte[] object_id() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            byte[] byArray = this.m_target.getObjectID();
            return byArray;
        }
    }

    public String target_most_derived_interface() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            String string = this.m_target.getRepositoryID();
            return string;
        }
    }

    public boolean target_is_a(String id) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_target == null) {
                throw new BAD_INV_ORDER(1330446350, this.state_completion_status());
            }
            boolean bl = this.m_target.targetIsA(id);
            return bl;
        }
    }

    public void dispatch() throws AdapterDestroyedException {
        int ex_type;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 5: {
                    return;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
                }
            }
            try {
                this.m_target = this.m_adapter.predispatch(this);
            }
            catch (AdapterDestroyedException ex) {
                this.m_state = 1;
                throw ex;
            }
            catch (ForwardRequest ex) {
                this.handle_location_forward(ex.forward, false);
            }
            catch (SystemException ex) {
                ex.completed = CompletionStatus.COMPLETED_NO;
                this.handle_system_exception(ex);
            }
            catch (Error ex) {
                this.handle_error(ex);
            }
            catch (RuntimeException ex) {
                this.handle_runtime_exception(ex);
            }
            if (this.m_reply_status != Short.MIN_VALUE) {
                this.complete_request();
                return;
            }
            if (this.m_interceptor_manager != null) {
                this.m_interceptor_manager.receive_request(this, this.m_callback);
                if (this.m_reply_status != Short.MIN_VALUE) {
                    this.m_interceptor_manager = null;
                    this.m_adapter.cancel_dispatch(this, this.m_target);
                    this.complete_request();
                    return;
                }
            }
            this.m_rs_pi_curr_entry = this.m_ts_pi_curr_entry;
            switch (this.m_sync_scope) {
                case 0: {
                    this.release_request();
                    break;
                }
                case 1: 
                case 2: {
                    try {
                        this.m_reply_stream = this.begin_marshal_reply();
                        this.complete_reply(this.m_reply_stream);
                    }
                    catch (SystemException ex) {
                        ex.completed = CompletionStatus.COMPLETED_NO;
                        this.handle_system_exception(ex);
                    }
                    catch (Error ex) {
                        this.handle_error(ex);
                    }
                    catch (RuntimeException ex) {
                        this.handle_runtime_exception(ex);
                    }
                    this.release_request();
                    if (this.m_reply_status == Short.MIN_VALUE) break;
                    this.m_state = 5;
                    this.m_adapter.cancel_dispatch(this, this.m_target);
                    if (this.m_interceptor_manager != null) {
                        this.m_interceptor_manager.send_exception(this, this.m_callback);
                    }
                    return;
                }
            }
            this.m_state = 3;
        }
        Throwable tex = null;
        try {
            this.m_adapter.dispatch(this, this.m_target);
            ex_type = 0;
        }
        catch (SystemException ex) {
            tex = ex;
            ex_type = 1;
        }
        catch (Error ex) {
            tex = ex;
            ex_type = 2;
        }
        catch (RuntimeException ex) {
            tex = ex;
            ex_type = 3;
        }
        java.lang.Object object2 = this.m_sync_state;
        synchronized (object2) {
            if (this.m_state == 5) {
                return;
            }
            switch (ex_type) {
                case 0: {
                    if (this.m_state != 3) break;
                    if (this.is_locate()) {
                        this.m_reply_status = (short)-1;
                        break;
                    }
                    if (this.m_sync_scope == 3) {
                        try {
                            this.createReply();
                        }
                        catch (SystemException ex) {
                            ex.completed = CompletionStatus.COMPLETED_YES;
                            this.handle_system_exception(ex);
                        }
                        catch (Error ex) {
                            this.handle_error(ex);
                        }
                        catch (RuntimeException ex) {
                            this.handle_runtime_exception(ex);
                        }
                        break;
                    }
                    this.m_reply_status = 0;
                    break;
                }
                case 1: {
                    if (this.m_state == 4) {
                        ((SystemException)tex).completed = CompletionStatus.COMPLETED_YES;
                    }
                    this.handle_system_exception((SystemException)tex);
                    break;
                }
                case 2: {
                    this.handle_error((Error)tex);
                    break;
                }
                case 3: {
                    this.handle_runtime_exception((RuntimeException)tex);
                }
            }
            this.complete_request();
        }
    }

    public InputStream argument_stream() {
        return this.m_argument_stream;
    }

    public void add_reply_service_context(ServiceContext service_context, boolean replace) {
        Integer key = NumberCache.getInteger((int)service_context.context_id);
        Map map = this.m_service_contexts;
        synchronized (map) {
            if (!replace && this.m_service_contexts.containsKey(key)) {
                throw new BAD_INV_ORDER(1330446347, this.state_completion_status());
            }
            this.m_service_contexts.put(key, service_context);
        }
    }

    public ServiceContext get_reply_service_context(int id) {
        ServiceContext ret = null;
        Map map = this.m_service_contexts;
        synchronized (map) {
            ret = (ServiceContext)this.m_service_contexts.get(NumberCache.getInteger((int)id));
        }
        if (ret == null) {
            if (s_throw_service_context_exceptions) {
                throw new BAD_PARAM(1330446359, this.state_completion_status());
            }
            return null;
        }
        return ret;
    }

    public ServiceContext[] get_reply_service_contexts() {
        Map map = this.m_service_contexts;
        synchronized (map) {
            ServiceContext[] serviceContextArray = this.m_service_contexts.values().toArray(new ServiceContext[this.m_service_contexts.size()]);
            return serviceContextArray;
        }
    }

    public short reply_status() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_reply_status == Short.MIN_VALUE) {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            short s = this.m_reply_status;
            return s;
        }
    }

    public Object forward_reference() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.reply_status()) {
                case 3: {
                    Object object2 = this.m_forward_reference;
                    return object2;
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public IOR forward_reference_ior() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.reply_status()) {
                case 3: {
                    if (this.m_forward_reference_ior == null) {
                        this.m_forward_reference_ior = ((Delegate)((ObjectImpl)this.m_forward_reference)._get_delegate()).ior();
                    }
                    IOR iOR = this.m_forward_reference_ior;
                    return iOR;
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public Any sending_exception() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.reply_status()) {
                case 1: {
                    if (this.m_sending_system_exception_any == null) {
                        this.m_sending_system_exception_any = this.m_orb.create_any();
                        SystemExceptionHelper.insert(this.m_sending_system_exception_any, this.m_sending_system_exception);
                    }
                    Any any = this.m_sending_system_exception_any;
                    return any;
                }
                case 2: {
                    throw new NO_RESOURCES(1330446337, this.state_completion_status());
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public SystemException sending_system_exception() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.reply_status() == 1) {
                SystemException systemException = this.m_sending_system_exception;
                return systemException;
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    public String sending_system_exception_id() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.reply_status() == 1) {
                String string = this.m_sending_system_exception_id;
                return string;
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    private void handle_system_exception(SystemException ex) {
        this.m_sending_system_exception_any = null;
        this.m_sending_system_exception = ex;
        this.m_sending_system_exception_id = SystemExceptionHelper.id(ex);
        this.m_reply_status = 1;
    }

    private void handle_error(Error ex) {
        if (ex instanceof ThreadDeath) {
            throw ex;
        }
        if (ex instanceof OutOfMemoryError) {
            this.handle_system_exception((SystemException)new NO_MEMORY(0, this.state_completion_status()));
        } else if (ex instanceof StackOverflowError) {
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().warn("Look like ORB has unbounded recursion", (Throwable)ex);
            }
            this.handle_system_exception((SystemException)new NO_RESOURCES(0, this.state_completion_status()));
        } else {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Intercepted in AbstractServerRequest", (Throwable)ex);
            }
            UnknownException uex = new UnknownException((Throwable)ex);
            uex.completed = this.state_completion_status();
            this.handle_system_exception((SystemException)uex);
        }
    }

    private void handle_runtime_exception(RuntimeException ex) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Handle runtime exception", (Throwable)ex);
        }
        UnknownException uex = new UnknownException((Throwable)ex);
        uex.completed = this.state_completion_status();
        this.handle_system_exception((SystemException)uex);
    }

    private void handle_unknown_throwable(Throwable ex) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Handle unknown throwable", ex);
        }
        UnknownException uex = new UnknownException(ex);
        uex.completed = this.state_completion_status();
        this.handle_system_exception((SystemException)uex);
    }

    private void handle_location_forward(Object forward, boolean permanent) {
        this.m_forward_reference = forward;
        this.m_forward_reference_ior = null;
        this.m_reply_status = (short)3;
    }

    public OutputStream createReply() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.is_locate()) {
                throw new BAD_INV_ORDER(1146056709, this.state_completion_status());
            }
            if (this.m_reply_status == 1) {
                throw this.m_sending_system_exception;
            }
            if (this.m_sync_scope != 3) {
                OutputStream outputStream = this.m_orb.create_output_stream();
                return outputStream;
            }
            this.m_reply_status = 0;
            if (this.m_interceptor_manager != null) {
                this.m_interceptor_manager.send_reply(this, this.m_callback);
                this.m_interceptor_manager = null;
                if (this.m_reply_status == 1) {
                    throw this.m_sending_system_exception;
                }
            }
            this.m_state = 4;
            OutputStream outputStream = this.m_reply_stream = this.begin_marshal_reply();
            return outputStream;
        }
    }

    public OutputStream createExceptionReply() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.is_locate()) {
                throw new BAD_INV_ORDER(1146056709, this.state_completion_status());
            }
            if (this.m_state == 5 || this.m_sync_scope != 3) {
                if (this.m_reply_status == 1) {
                    throw this.m_sending_system_exception;
                }
                OutputStream outputStream = this.m_orb.create_output_stream();
                return outputStream;
            }
            this.m_reply_status = (short)2;
            if (this.m_interceptor_manager != null) {
                this.m_interceptor_manager.send_exception(this, this.m_callback);
                this.m_interceptor_manager = null;
                if (this.m_reply_status == 1) {
                    throw this.m_sending_system_exception;
                }
            }
            this.m_state = 4;
            OutputStream outputStream = this.m_reply_stream = this.begin_marshal_user_exception();
            return outputStream;
        }
    }

    private void complete_request() {
        block24: {
            if (this.m_reply_status == Short.MIN_VALUE) {
                Trace.signalIllegalCondition(this.getLogger(), "Completing request without setting reply status.");
            }
            if (this.m_state != 0 && this.m_interceptor_manager != null) {
                switch (this.m_reply_status) {
                    case 0: {
                        this.m_interceptor_manager.send_reply(this, this.m_callback);
                        break;
                    }
                    case 1: {
                        this.m_interceptor_manager.send_exception(this, this.m_callback);
                        break;
                    }
                    case 3: {
                        this.m_interceptor_manager.send_other(this, this.m_callback);
                    }
                }
            }
            switch (this.m_sync_scope) {
                case 1: 
                case 2: {
                    if (this.m_state < 3) break;
                }
                case 0: {
                    this.m_state = 5;
                    return;
                }
            }
            try {
                switch (this.m_reply_status) {
                    case -1: {
                        this.marshal_locate_reply(true);
                        break;
                    }
                    case -2: {
                        this.marshal_locate_reply(false);
                        break;
                    }
                    case 0: 
                    case 2: {
                        this.complete_reply(this.m_reply_stream);
                        break;
                    }
                    case 1: {
                        this.marshal_system_exception(this.m_sending_system_exception_id, this.m_sending_system_exception);
                        break;
                    }
                    case 3: {
                        this.marshal_forward_request(this.m_forward_reference, false);
                    }
                }
            }
            catch (SystemException ex) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Transport failure while replying to request: ", (Throwable)ex);
                }
            }
            catch (Error ex) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Java error while replying to request", (Throwable)ex);
                }
            }
            catch (RuntimeException ex) {
                if (!this.getLogger().isErrorEnabled()) break block24;
                this.getLogger().error("Java runtime exception while replying to request", (Throwable)ex);
            }
        }
        this.m_state = 5;
        this.release_request();
    }

    protected abstract void marshal_system_exception(String var1, SystemException var2);

    protected abstract void marshal_forward_request(Object var1, boolean var2);

    protected abstract void marshal_locate_reply(boolean var1);

    protected abstract OutputStream begin_marshal_reply();

    protected abstract OutputStream begin_marshal_user_exception();

    protected abstract void complete_reply(OutputStream var1);

    protected abstract void release_request();

    protected Logger getLogger() {
        return this.m_logger;
    }

    public String toString() {
        return this.getClass().getName() + ' ' + this.m_request_id + '(' + super.toString() + ')';
    }
}

