/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.openorb.orb.net.SocketStreamDecorationStrategy;

public abstract class AbstractSocketStreamDecorationStrategy
implements SocketStreamDecorationStrategy {
    protected AbstractSocketStreamDecorationStrategy() {
    }

    public final InputStream decorate(Socket socket, InputStream stream) throws IOException {
        try {
            return this.uncheckedDecorate(socket, stream);
        }
        catch (IOException e) {
            this.closeStream(stream);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream(stream);
            throw e;
        }
    }

    public final OutputStream decorate(Socket socket, OutputStream stream) throws IOException {
        try {
            return this.uncheckedDecorate(socket, stream);
        }
        catch (IOException e) {
            this.closeStream(stream);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream(stream);
            throw e;
        }
    }

    protected InputStream uncheckedDecorate(Socket socket, InputStream stream) throws IOException {
        return stream;
    }

    protected OutputStream uncheckedDecorate(Socket socket, OutputStream stream) throws IOException {
        return stream;
    }

    protected void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            try {
                this.exceptionDuringStreamClose(stream, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void closeStream(OutputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            try {
                this.exceptionDuringStreamClose(stream, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void exceptionDuringStreamClose(InputStream stream, Exception e) {
    }

    protected void exceptionDuringStreamClose(OutputStream stream, Exception e) {
    }
}

