/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.net.SocketStreamDecorationStrategy;
import org.openorb.util.ConfigUtils;
import org.openorb.util.logger.LoggerTeam;

public final class BufferingSocketStreamDecorationStrategy
implements SocketStreamDecorationStrategy {
    private final int m_inputBufferSize;
    private final int m_outputBufferSize;

    public BufferingSocketStreamDecorationStrategy(int inputBufferSize, int outputBufferSize) {
        this.m_inputBufferSize = inputBufferSize;
        this.m_outputBufferSize = outputBufferSize;
    }

    public InputStream decorate(Socket socket, InputStream stream) throws IOException {
        if (this.m_inputBufferSize <= 0) {
            return stream;
        }
        return new BufferedInputStream(stream, this.m_inputBufferSize);
    }

    public OutputStream decorate(Socket socket, OutputStream stream) throws IOException {
        if (this.m_outputBufferSize <= 0) {
            return stream;
        }
        return new BufferedOutputStream(stream, this.m_outputBufferSize);
    }

    public static final class Factory
    implements SocketStreamDecorationStrategy.Factory {
        public SocketStreamDecorationStrategy create(LoggerTeam logger, ORBLoader loader, String prefix) {
            String bufferedInputStreamSizeName = ConfigUtils.prefixName((String)prefix, (String)"bufferedInputStreamSize");
            String bufferedOutputStreamSizeName = ConfigUtils.prefixName((String)prefix, (String)"bufferedOutputStreamSize");
            int inputBufferSize = loader.getIntProperty(bufferedInputStreamSizeName, 0);
            int outputBufferSize = loader.getIntProperty(bufferedOutputStreamSizeName, 0);
            if (0 < inputBufferSize || 0 < outputBufferSize) {
                return new BufferingSocketStreamDecorationStrategy(inputBufferSize, outputBufferSize);
            }
            return null;
        }
    }
}

