/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.util.Comparator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.orb.adapter.AdapterDestroyedException;
import org.openorb.orb.adapter.ObjectAdapter;
import org.openorb.orb.net.Address;
import org.openorb.orb.net.ClientChannel;
import org.openorb.orb.net.ClientRequest;
import org.openorb.orb.net.LocalClientRequest;
import org.openorb.orb.net.RebindChannelException;
import org.openorb.orb.net.RequestIDAllocator;
import org.openorb.orb.net.ServerManager;

public class ClientBinding {
    public static final int DEAD_PRIORITY = Integer.MAX_VALUE;
    public static final int FORCE_UNSET = -1;
    public static final int FORCE_FALSE = 0;
    public static final int FORCE_TRUE = 1;
    private Address m_address;
    private ClientChannel m_channel;
    private ObjectAdapter m_adapter = null;
    private SystemException m_exception;
    private int m_priority = 0;
    private byte[] m_oid = null;
    private int m_forced_marshal;
    private ServerManager m_server_manager;
    public static final int MASK_ADDRESS_PRIORITY = 4095;
    public static final int MASK_PROFILE_PRIORITY = 61440;
    public static final int MASK_IOR_PRIORITY = 0xFF0000;
    public static final Comparator PRIORITY_COMP = new PriorityComparator();

    protected ClientBinding(Address address) {
        this.m_address = address;
        this.m_forced_marshal = -1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel channel) {
        this.m_address = address;
        this.m_channel = channel;
        this.m_forced_marshal = 1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel channel, ServerManager serverManager) {
        this.m_address = address;
        this.m_channel = channel;
        this.m_server_manager = serverManager;
        this.m_forced_marshal = -1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, SystemException ex) {
        this.m_address = address;
        this.m_exception = ex;
        this.m_priority = Integer.MAX_VALUE;
        this.m_forced_marshal = 0;
    }

    public Address getAddress() {
        return this.m_address;
    }

    public ClientChannel getClientChannel() {
        return this.m_channel;
    }

    public ObjectAdapter getObjectAdapter() {
        if (this.m_server_manager == null) {
            return null;
        }
        if (this.m_oid == null) {
            this.m_oid = this.m_address.getTargetAddress((short)0).object_key();
            this.m_adapter = this.m_server_manager.find_adapter(this.m_oid);
        }
        if (this.m_adapter == null) {
            return null;
        }
        this.m_forced_marshal = -1;
        return this.m_adapter;
    }

    public int getPriority() {
        if (this.m_exception != null) {
            return Integer.MAX_VALUE;
        }
        if (this.m_adapter != null) {
            return this.m_priority | this.m_adapter.cache_priority() & 0xFF000000;
        }
        return this.m_priority | this.m_channel.state();
    }

    public void setPriority(int priority) {
        this.m_priority = priority > 0 ? priority & 0xFFF000 | this.m_priority & 0xFF000FFF : priority;
    }

    public int hashCode() {
        return this.m_address.hashCode();
    }

    public boolean equals(java.lang.Object obj) {
        if (!(obj instanceof ClientBinding)) {
            return false;
        }
        return this.m_address.equals(((ClientBinding)obj).m_address);
    }

    public boolean local_invoke() {
        if (this.m_forced_marshal == -1) {
            while (true) {
                this.getObjectAdapter();
                if (this.m_adapter == null) {
                    this.m_forced_marshal = 1;
                    break;
                }
                try {
                    this.m_forced_marshal = this.m_adapter.forced_marshal(this.m_oid) ? 1 : 0;
                }
                catch (AdapterDestroyedException ex) {
                    this.m_adapter = null;
                    continue;
                }
                break;
            }
        }
        return this.m_forced_marshal == 0;
    }

    public ClientRequest create_request(Object target, String operation, boolean response_expected) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        while (this.m_channel != null) {
            try {
                return this.m_channel.create_request(target, this.m_address, operation, response_expected);
            }
            catch (RebindChannelException ex) {
                this.m_channel = ex.getClientChannel();
                continue;
            }
            break;
        }
        return null;
    }

    public LocalClientRequest create_request_local(ORB orb, Object target, String operation, boolean response_expected, Address[] adresses) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        int request_id = RequestIDAllocator.get_request_id() << 1;
        LocalClientRequest lcr = new LocalClientRequest(orb, request_id, target, operation, response_expected, adresses);
        return lcr;
    }

    public ClientRequest create_locate_request(Object target) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        while (this.m_channel != null) {
            try {
                return this.m_channel.create_locate_request(target, this.m_address);
            }
            catch (RebindChannelException ex) {
                this.m_channel = ex.getClientChannel();
                continue;
            }
            break;
        }
        return null;
    }

    public ServantObject servant_preinvoke(String operation, Class expectedType) throws ForwardRequest {
        ServantObject servObj;
        ObjectAdapter adapter;
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            if ((adapter = this.getObjectAdapter()) == null) {
                return null;
            }
            try {
                servObj = adapter.servant_preinvoke(this.m_oid, operation, expectedType);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
        if (servObj == null) {
            this.m_forced_marshal = -1;
            return null;
        }
        LocalServant ret = new LocalServant();
        ret.m_adapter = adapter;
        ret.m_originalServant = servObj;
        ret.servant = servObj.servant;
        return ret;
    }

    public void servant_postinvoke(ServantObject srvObject) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (!(srvObject instanceof LocalServant)) {
            throw new INTERNAL("Servant is not a LocalObject");
        }
        LocalServant sobj = (LocalServant)srvObject;
        sobj.m_adapter.servant_postinvoke(this.m_oid, sobj.m_originalServant);
    }

    public boolean locate() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        ObjectAdapter adapter;
        while ((adapter = this.getObjectAdapter()) != null) {
            try {
                return adapter.locate(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
        return false;
    }

    public boolean is_a(String repository_id) throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.is_a(this.m_oid, repository_id);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_interface_def() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.get_interface_def(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    public DomainManager[] get_domain_managers() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.get_domain_managers(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_component() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.get_component(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    private static class PriorityComparator
    implements Comparator {
        private PriorityComparator() {
        }

        public int compare(java.lang.Object obj1, java.lang.Object obj2) {
            if (obj1 == null) {
                if (obj2 == null) {
                    return 0;
                }
                return 1;
            }
            if (obj2 == null) {
                return -1;
            }
            int pri1 = ((ClientBinding)obj1).getPriority();
            int pri2 = ((ClientBinding)obj2).getPriority();
            if (pri1 < 0) {
                if (pri2 < 0) {
                    return 0;
                }
                return -1;
            }
            if (pri2 < 0) {
                return 1;
            }
            return pri1 > pri2 ? 1 : (pri1 < pri2 ? -1 : 0);
        }
    }

    private static class LocalServant
    extends ServantObject {
        private ObjectAdapter m_adapter;
        private ServantObject m_originalServant;

        private LocalServant() {
        }
    }
}

