/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IOP.IOR;
import org.openorb.orb.core.Delegate;
import org.openorb.orb.core.ORB;
import org.openorb.orb.net.Address;
import org.openorb.orb.net.ClientBinding;
import org.openorb.orb.net.ClientChannel;
import org.openorb.orb.net.ClientManager;
import org.openorb.orb.net.ClientProtocol;
import org.openorb.orb.net.RequestIDAllocator;
import org.openorb.orb.net.ServerManager;
import org.openorb.orb.policy.ProfilePriorityPolicy;
import org.openorb.orb.policy.ProfilePriorityPolicyHelper;
import org.openorb.util.NumberCache;

public class ClientManagerImpl
implements ClientManager {
    private static final int DEFAULT_PAUSE_TIME = 120000;
    private static ThreadGroup s_static_work_threads;
    private org.omg.CORBA.ORB m_orb;
    private Map m_protocols = new HashMap();
    private Map m_channels = new HashMap();
    private ServerManager m_server_manager;
    private java.lang.Object m_sync_state = new java.lang.Object();
    private boolean m_shutdown = false;
    private int m_pause;
    private ThreadGroup m_root_group;
    private boolean m_use_static_thread_group = false;
    private ThreadGroup m_work_threads;
    private Thread m_channel_reaper;

    public ClientManagerImpl(org.omg.CORBA.ORB orb) {
        this(orb, null);
    }

    public ClientManagerImpl(org.omg.CORBA.ORB orb, ServerManager serverManager) {
        this.m_orb = orb;
        this.m_server_manager = serverManager;
        this.m_root_group = Thread.currentThread().getThreadGroup();
        this.m_pause = ((ORB)orb).getLoader().getIntProperty("openorb.client.reapPauseDelay", 120000);
        this.m_use_static_thread_group = ((ORB)orb).getLoader().getBooleanProperty("openorb.useStaticThreadGroup", false);
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public ServerManager getServerManager() {
        return this.m_server_manager;
    }

    public ClientBinding[] create_bindings(Object obj, IOR ior) {
        int profiles = ior.profiles.length;
        IORAddressingInfo info = new IORAddressingInfo(0, ior);
        Delegate delegate = (Delegate)((ObjectImpl)obj)._get_delegate();
        ProfilePriorityPolicy policy = ProfilePriorityPolicyHelper.narrow((Object)delegate.get_client_policy(obj, 1146057217));
        ArrayList<ClientBinding> allbindings = new ArrayList<ClientBinding>(8);
        int i = 0;
        while (i < profiles) {
            ClientProtocol protocol;
            int priority;
            int profile_tag = ior.profiles[i].tag;
            int n = priority = policy == null ? 8 : (int)policy.find_priority(profile_tag);
            if (priority != -1 && (protocol = (ClientProtocol)this.m_protocols.get(NumberCache.getInteger((int)profile_tag))) != null) {
                info.selected_profile_index = i;
                Address[] addresses = protocol.createAddresses(info);
                int j = 0;
                while (j < addresses.length) {
                    ClientBinding binding = protocol.createBinding(addresses[j]);
                    binding.setPriority(binding.getPriority() & 0xFFFF0FFF | priority << 12 & 0xF000);
                    allbindings.add(binding);
                    ++j;
                }
            }
            ++i;
        }
        if (allbindings.isEmpty()) {
            throw new INV_OBJREF();
        }
        ClientBinding[] ret = new ClientBinding[allbindings.size()];
        ret = allbindings.toArray(ret);
        return ret;
    }

    public void register_protocol(int profile_tag, ClientProtocol protocol) {
        this.m_protocols.put(NumberCache.getInteger((int)profile_tag), protocol);
    }

    public boolean register_channel(ClientChannel channel) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_shutdown) {
                boolean bl = false;
                return bl;
            }
            Map map = this.m_channels;
            synchronized (map) {
                if (this.m_channels.containsKey(channel)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.m_work_threads == null || this.m_work_threads.isDestroyed()) {
                    if (this.m_use_static_thread_group) {
                        if (s_static_work_threads == null || s_static_work_threads.isDestroyed()) {
                            s_static_work_threads = new ThreadGroup(this.m_root_group, "Client IO");
                        }
                        this.m_work_threads = s_static_work_threads;
                    } else {
                        this.m_work_threads = new ThreadGroup(this.m_root_group, "Client IO");
                    }
                }
                if (this.m_channel_reaper == null && this.m_pause > 0) {
                    this.m_channel_reaper = new Thread(this.m_work_threads, new Runnable(){

                        public void run() {
                            ClientManagerImpl.this.channel_reaper();
                        }
                    }, "Channel Reaper");
                    this.m_channel_reaper.setDaemon(true);
                    this.m_channel_reaper.start();
                }
                Thread thread = new Thread(this.m_work_threads, new ChannelRecvRunnable(channel), "Receive Worker for " + channel.toString());
                thread.setDaemon(true);
                thread.start();
                this.m_channels.put(channel, thread);
                boolean bl = true;
                return bl;
            }
        }
    }

    public void unregister_channel(ClientChannel channel) {
        Thread thread;
        Map map = this.m_channels;
        synchronized (map) {
            thread = (Thread)this.m_channels.remove(channel);
        }
        if (thread != null) {
            Thread curr = Thread.currentThread();
            thread.interrupt();
            while (thread != curr && thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown(boolean wait_for_complete, boolean kill_requests) {
        boolean shut = false;
        Thread chanReap = null;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (!this.m_shutdown) {
                this.m_shutdown = true;
                shut = true;
                if (this.m_channel_reaper != null) {
                    this.m_channel_reaper.interrupt();
                    chanReap = this.m_channel_reaper;
                }
            }
        }
        if (chanReap != null) {
            try {
                chanReap.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (shut) {
            ClientChannel[] cchans;
            Map map = this.m_channels;
            synchronized (map) {
                cchans = new ClientChannel[this.m_channels.size()];
                this.m_channels.keySet().toArray(cchans);
            }
            int i = 0;
            while (i < cchans.length) {
                cchans[i].close(kill_requests, (SystemException)new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_MAYBE));
                ++i;
            }
        }
        if (!this.m_use_static_thread_group && this.m_work_threads != null) {
            this.m_work_threads.setDaemon(true);
            try {
                this.m_work_threads.destroy();
            }
            catch (IllegalThreadStateException ex) {
                // empty catch block
            }
        }
    }

    private void channel_reaper() {
        int lasttime = RequestIDAllocator.get_request_id();
        ClientChannel[] chans = null;
        while (!this.m_shutdown) {
            try {
                Thread.sleep(this.m_pause);
            }
            catch (InterruptedException ex) {
                break;
            }
            Map map = this.m_channels;
            synchronized (map) {
                if (this.m_channels.isEmpty()) {
                    this.m_channel_reaper = null;
                    break;
                }
                if (chans == null || chans.length < this.m_channels.size()) {
                    chans = new ClientChannel[this.m_channels.size()];
                }
                chans = this.m_channels.keySet().toArray(chans);
            }
            int i = 0;
            while (i < chans.length && chans[i] != null) {
                if (chans[i].state() == 0x11000000 && chans[i].channel_age() < lasttime) {
                    chans[i].pause();
                }
                chans[i] = null;
                ++i;
            }
            lasttime = RequestIDAllocator.get_request_id();
        }
    }

    private class ChannelRecvRunnable
    implements Runnable {
        private ClientChannel m_chan;

        public ChannelRecvRunnable(ClientChannel chan) {
            this.m_chan = chan;
        }

        public void run() {
            this.m_chan.run_recv();
        }
    }
}

