/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.SystemException;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.Property;
import org.openorb.orb.net.CompositeSocketStreamDecorationStrategy;
import org.openorb.orb.net.NullSocketStreamDecorationStrategy;
import org.openorb.orb.net.SocketFactory;
import org.openorb.orb.net.SocketStreamDecorationStrategy;
import org.openorb.orb.util.Trace;
import org.openorb.util.ConfigUtils;
import org.openorb.util.ExceptionTool;
import org.openorb.util.logger.LoggerTeam;

public final class ConfiguredSocketFactory
implements SocketFactory {
    private static final int MAX_PORT = 65535;
    private static final int INVALID_PORT = -1;
    private final Random m_random = new Random();
    private final Map m_addressMap = new HashMap();
    private final LoggerTeam m_logger;
    private final Logger m_diagnosticsLogger;
    private final boolean m_noDelay;
    private final boolean m_keepAlive;
    private final int m_backlogQueueLength;
    private final int m_maxSocketTimeout;
    private final int m_minSocketTimeout;
    private final int m_overrideSocketTimeout;
    private final int m_sendBufferSize;
    private final int m_receiveBufferSize;
    private final int m_localPortMin;
    private final int m_localPortMax;
    private final boolean m_localPortConstrained;
    private final SocketStreamDecorationStrategy m_streamDecorationStrategy;
    static /* synthetic */ Class class$org$openorb$orb$net$PriorityBoostingSocketStreamDecorationStrategy$Factory;
    static /* synthetic */ Class class$org$openorb$orb$net$BufferingSocketStreamDecorationStrategy$Factory;
    static /* synthetic */ Class class$org$openorb$orb$net$LegacySocketStreamDecorationStrategy$Factory;

    public ConfiguredSocketFactory(LoggerTeam logger, ORBLoader loader, String prefix) {
        this.m_logger = logger;
        this.m_diagnosticsLogger = ConfiguredSocketFactory.getDiagnosticsLogger(logger);
        String keepAliveName = ConfiguredSocketFactory.prefixName(prefix, "keepAlive");
        String noDelayName = ConfiguredSocketFactory.prefixName(prefix, "noDelay");
        String clientNoDelayName = ConfiguredSocketFactory.prefixName(prefix, "clientNoDelay");
        String serverNoDelayName = ConfiguredSocketFactory.prefixName(prefix, "serverNoDelay");
        String serverBacklogQueueLengthName = ConfiguredSocketFactory.prefixName(prefix, "serverBacklogQueueLength");
        String serverMaxSocketAcceptTimeoutName = ConfiguredSocketFactory.prefixName(prefix, "serverMaxSocketAcceptTimeout");
        String serverMinSocketAcceptTimeoutName = ConfiguredSocketFactory.prefixName(prefix, "serverMinSocketAcceptTimeout");
        String serverOverrideSocketTimeoutName = ConfiguredSocketFactory.prefixName(prefix, "serverOverrideSocketTimeout");
        String sendBufferSizeName = ConfiguredSocketFactory.prefixName(prefix, "sendBufferSize");
        String receiveBufferSizeName = ConfiguredSocketFactory.prefixName(prefix, "receiveBufferSize");
        String clientPortMinName = ConfiguredSocketFactory.prefixName(prefix, "clientPortMin");
        String clientPortMaxName = ConfiguredSocketFactory.prefixName(prefix, "clientPortMax");
        Property noDelayProperty = loader.getProperty(noDelayName);
        Property clientNoDelayProperty = loader.getProperty(clientNoDelayName);
        Property serverNoDelayProperty = loader.getProperty(serverNoDelayName);
        if (null != clientNoDelayProperty) {
            logger.warn("Property [" + clientNoDelayName + "] has been deprecated. Please used [" + noDelayName + "] instead.");
        }
        if (null != serverNoDelayProperty) {
            logger.warn("Property [" + serverNoDelayName + "] has been deprecated. Please used [" + noDelayName + "] instead.");
        }
        if (null != noDelayProperty) {
            this.m_noDelay = noDelayProperty.getBooleanValue();
            if (null != clientNoDelayProperty) {
                this.logOverride(clientNoDelayName, noDelayName);
            }
            if (null != serverNoDelayProperty) {
                this.logOverride(serverNoDelayName, noDelayName);
            }
        } else {
            boolean serverNoDelay;
            boolean clientNoDelay = null == clientNoDelayProperty ? true : clientNoDelayProperty.getBooleanValue();
            boolean bl = serverNoDelay = null == serverNoDelayProperty ? true : serverNoDelayProperty.getBooleanValue();
            if (clientNoDelay != serverNoDelay) {
                logger.warn("Properties [" + clientNoDelayName + "] and [" + serverNoDelayName + "] differ, defaulting to [true]");
                this.m_noDelay = true;
            } else {
                this.m_noDelay = clientNoDelay;
            }
        }
        this.m_keepAlive = loader.getBooleanProperty(keepAliveName, false);
        this.m_backlogQueueLength = loader.getIntProperty(serverBacklogQueueLengthName, 50);
        this.m_maxSocketTimeout = loader.getIntProperty(serverMaxSocketAcceptTimeoutName, 250);
        this.m_minSocketTimeout = loader.getIntProperty(serverMinSocketAcceptTimeoutName, 0);
        this.m_overrideSocketTimeout = loader.getIntProperty(serverOverrideSocketTimeoutName, 250);
        this.m_sendBufferSize = loader.getIntProperty(sendBufferSizeName, 0);
        this.m_receiveBufferSize = loader.getIntProperty(receiveBufferSizeName, 0);
        this.m_localPortMin = loader.getIntProperty(clientPortMinName, -1);
        this.m_localPortMax = loader.getIntProperty(clientPortMaxName, -1);
        if (ConfiguredSocketFactory.isPortInvalid(this.m_localPortMin)) {
            logger.warn("Property [" + clientPortMinName + "]=[" + this.m_localPortMin + "] is invalid.");
            this.m_localPortConstrained = false;
        } else if (ConfiguredSocketFactory.isPortInvalid(this.m_localPortMax)) {
            logger.warn("Property [" + clientPortMaxName + "]=[" + this.m_localPortMax + "] is invalid.");
            this.m_localPortConstrained = false;
        } else if (this.m_localPortMax < this.m_localPortMin) {
            logger.warn("Properties [" + clientPortMinName + "]=[" + this.m_localPortMin + "] and [" + clientPortMaxName + "]=[" + this.m_localPortMax + "] are invalid.");
            this.m_localPortConstrained = false;
        } else {
            this.m_localPortConstrained = -1 != this.m_localPortMin && -1 != this.m_localPortMax;
        }
        try {
            this.m_streamDecorationStrategy = ConfiguredSocketFactory.createStreamDecorationStrategy(logger, loader, prefix);
        }
        catch (INITIALIZE e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Problems creating stream decoration strategy")), (Throwable)e);
        }
        try {
            this.configureAddressMap(loader, prefix);
        }
        catch (INITIALIZE e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionTool.initCause((SystemException)((Object)new INITIALIZE("Problems configuring address map")), (Throwable)e);
        }
        this.logConstruction(this.getDiagnosticsLogger());
    }

    private static boolean isPortInvalid(int port) {
        return 0 == port || port < -1 || 65535 < port;
    }

    private void logOverride(String name, String overridingName) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Property [" + name + "] overridden by property [" + overridingName + "]");
        }
    }

    private static Logger getDiagnosticsLogger(LoggerTeam logger) {
        return logger.getMember(LoggerTeam.StandardTags.DIAGNOSTIC_LOGGER_TAG);
    }

    private static String prefixName(String prefix, String name) {
        return ConfigUtils.prefixName((String)prefix, (String)name);
    }

    private static SocketStreamDecorationStrategy createStreamDecorationStrategy(LoggerTeam logger, ORBLoader loader, String prefix) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String namePrefix = ConfiguredSocketFactory.prefixName(prefix, "stream-decoration");
        TreeMap<String, Class> sortedFactories = new TreeMap<String, Class>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator it = loader.properties(namePrefix);
        while (it.hasNext()) {
            Property property = (Property)it.next();
            Class<?> factoryClass = classLoader.loadClass(property.getValue());
            sortedFactories.put(property.getName(), factoryClass);
        }
        if (sortedFactories.isEmpty()) {
            sortedFactories.put("1", class$org$openorb$orb$net$PriorityBoostingSocketStreamDecorationStrategy$Factory == null ? (class$org$openorb$orb$net$PriorityBoostingSocketStreamDecorationStrategy$Factory = ConfiguredSocketFactory.class$("org.openorb.orb.net.PriorityBoostingSocketStreamDecorationStrategy$Factory")) : class$org$openorb$orb$net$PriorityBoostingSocketStreamDecorationStrategy$Factory);
            sortedFactories.put("2", class$org$openorb$orb$net$BufferingSocketStreamDecorationStrategy$Factory == null ? (class$org$openorb$orb$net$BufferingSocketStreamDecorationStrategy$Factory = ConfiguredSocketFactory.class$("org.openorb.orb.net.BufferingSocketStreamDecorationStrategy$Factory")) : class$org$openorb$orb$net$BufferingSocketStreamDecorationStrategy$Factory);
            sortedFactories.put("3", class$org$openorb$orb$net$LegacySocketStreamDecorationStrategy$Factory == null ? (class$org$openorb$orb$net$LegacySocketStreamDecorationStrategy$Factory = ConfiguredSocketFactory.class$("org.openorb.orb.net.LegacySocketStreamDecorationStrategy$Factory")) : class$org$openorb$orb$net$LegacySocketStreamDecorationStrategy$Factory);
        }
        SocketStreamDecorationStrategy masterStrategy = null;
        Iterator it2 = sortedFactories.values().iterator();
        while (it2.hasNext()) {
            Class factoryClass = (Class)it2.next();
            SocketStreamDecorationStrategy.Factory factory = (SocketStreamDecorationStrategy.Factory)factoryClass.newInstance();
            SocketStreamDecorationStrategy strategy = factory.create(logger, loader, prefix);
            if (null == strategy) continue;
            masterStrategy = null == masterStrategy ? strategy : new CompositeSocketStreamDecorationStrategy(masterStrategy, strategy);
        }
        if (null == masterStrategy) {
            return NullSocketStreamDecorationStrategy.getInstance();
        }
        return masterStrategy;
    }

    private void configureAddressMap(ORBLoader loader, String prefix) throws IOException {
        String namePrefix = ConfiguredSocketFactory.prefixName(prefix, "address-mapping");
        Iterator it = loader.properties(namePrefix);
        while (it.hasNext()) {
            Property mapping = (Property)it.next();
            this.addToAddressMap(mapping.getName().substring(namePrefix.length() + 1), mapping.getValue());
        }
    }

    private void addToAddressMap(String keyAddress, String valueAddress) throws IOException {
        InetAddress keyHost = ConfiguredSocketFactory.getHost(keyAddress);
        int keyPort = ConfiguredSocketFactory.getPort(keyAddress);
        InetAddress valueHost = ConfiguredSocketFactory.getHost(valueAddress);
        int valuePort = ConfiguredSocketFactory.getPort(valueAddress);
        Object key = 0 == keyPort ? keyHost : new InetSocketAddress(keyHost, keyPort);
        Object value = 0 == valuePort ? valueHost : new InetSocketAddress(valueHost, valuePort);
        this.m_addressMap.put(key, value);
    }

    private static InetAddress getHost(String address) throws IOException {
        int i = address.indexOf(":");
        if (-1 == i) {
            return InetAddress.getByName(address);
        }
        return InetAddress.getByName(address.substring(0, i));
    }

    private static int getPort(String address) {
        int i = address.indexOf(":");
        if (-1 == i) {
            return 0;
        }
        String portString = address.substring(i + 1);
        if (0 == portString.length()) {
            return 0;
        }
        int port = Integer.parseInt(portString);
        if (port <= 0 || 65535 < port) {
            throw new IllegalArgumentException("Port [" + port + "] of address [" + address + "] is outside of range 1-" + 65535);
        }
        return port;
    }

    private void logConstruction(Logger logger) {
        logger.fatalError("Constructed [ConfiguredSocketFactory]");
        if (!logger.isErrorEnabled()) {
            return;
        }
        logger.error("Start details...");
        logger.error("keepAlive=[" + this.m_keepAlive + "]");
        logger.error("noDelay=[" + this.m_noDelay + "]");
        logger.error("sendBufferSize=[" + this.m_sendBufferSize + "]");
        logger.error("receiveBufferSize=[" + this.m_receiveBufferSize + "]");
        logger.error("localPortMin=[" + this.m_localPortMin + "]");
        logger.error("localPortMax=[" + this.m_localPortMax + "]");
        logger.error("localPortConstrained=[" + this.m_localPortConstrained + "]");
        logger.error("addressMap.size()=[" + this.m_addressMap.size() + "]");
        Iterator it = this.m_addressMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            logger.error("addressMap[" + entry.getKey() + "]=[" + entry.getValue() + "]");
        }
        logger.error("backlogQueueLength=[" + this.m_backlogQueueLength + "]");
        logger.error("maxSocketTimeout=[" + this.m_maxSocketTimeout + "]");
        logger.error("minSocketTimeout=[" + this.m_minSocketTimeout + "]");
        logger.error("overrideSocketTimeout=[" + this.m_overrideSocketTimeout + "]");
        logger.error("...End details.");
    }

    private LoggerTeam getLogger() {
        return this.m_logger;
    }

    private Logger getDiagnosticsLogger() {
        return this.m_diagnosticsLogger;
    }

    public ServerSocket createServerSocket(InetAddress host, int port) throws IOException {
        return new ConfiguredServerSocket(port, this.m_backlogQueueLength, host);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        InetSocketAddress address = this.createAddress(host, port);
        Socket socket = this.isLocalPortConstrained() ? this.createConstrainedSocket(address) : new ConfiguredSocket(address);
        return socket;
    }

    private InetSocketAddress createAddress(InetAddress host, int port) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        Object mapping = this.m_addressMap.get(address);
        if (null == mapping) {
            mapping = this.m_addressMap.get(host);
        }
        if (null != mapping) {
            InetSocketAddress hostPortMapping;
            if (mapping instanceof InetSocketAddress) {
                hostPortMapping = (InetSocketAddress)mapping;
            } else if (mapping instanceof InetAddress) {
                hostPortMapping = new InetSocketAddress((InetAddress)mapping, port);
            } else {
                throw Trace.signalIllegalCondition((Logger)this.getLogger(), "Address map corrupted with mapping [" + mapping + "]");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Mapped [" + address + "]->[" + hostPortMapping + "]");
            }
            return hostPortMapping;
        }
        return address;
    }

    private boolean isLocalPortConstrained() {
        return this.m_localPortConstrained;
    }

    private Socket createConstrainedSocket(InetSocketAddress address) throws IOException {
        InetAddress localHost = InetAddress.getLocalHost();
        int portCount = this.m_localPortMax - this.m_localPortMin + 1;
        int startPort = this.m_localPortMin + this.m_random.nextInt(portCount);
        int i = 0;
        while (i < portCount) {
            try {
                return new ConfiguredSocket(address, localHost, (startPort + i) % portCount);
            }
            catch (NoRouteToHostException e) {
                throw e;
            }
            catch (IOException ex) {
                ++i;
            }
        }
        throw new IOException("No port available in specified range");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class InetSocketAddress {
        private final InetAddress m_address;
        private final int m_port;
        private String m_string;

        public InetSocketAddress(InetAddress address, int port) {
            this.m_address = address;
            this.m_port = port;
        }

        public InetAddress getAddress() {
            return this.m_address;
        }

        public int getPort() {
            return this.m_port;
        }

        public int hashCode() {
            return this.m_address.hashCode() ^ this.getPort();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof InetSocketAddress && this.equals((InetSocketAddress)obj);
        }

        private boolean equals(InetSocketAddress rhs) {
            return this.getAddress().equals(rhs.getAddress()) && this.getPort() == rhs.getPort();
        }

        public synchronized String toString() {
            if (null == this.m_string) {
                this.m_string = this.getAddress() + ":" + this.getPort();
            }
            return this.m_string;
        }
    }

    private final class ConfiguredSocket
    extends Socket {
        private final Object m_closeSync = new byte[0];
        private boolean m_closed;
        private final Object m_outLock = new byte[0];
        private OutputStream m_out;
        private boolean m_outputShutdown;
        private boolean m_shuttingDownOutput;
        private final Object m_inLock = new byte[0];
        private InputStream m_in;

        public ConfiguredSocket() throws IOException {
            this.preConnectConfig();
        }

        public ConfiguredSocket(InetSocketAddress address) throws IOException {
            super(address.getAddress(), address.getPort());
            this.preConnectConfig();
            this.postConnectConfig();
        }

        public ConfiguredSocket(InetSocketAddress address, InetSocketAddress localAddress) throws IOException {
            super(address.getAddress(), address.getPort(), localAddress.getAddress(), localAddress.getPort());
            this.preConnectConfig();
            this.postConnectConfig();
        }

        public ConfiguredSocket(InetSocketAddress address, InetAddress localAddress, int localPort) throws IOException {
            super(address.getAddress(), address.getPort(), localAddress, localPort);
            this.preConnectConfig();
            this.postConnectConfig();
        }

        protected void preConnectConfig() throws IOException {
            try {
                if (0 < ConfiguredSocketFactory.this.m_sendBufferSize) {
                    this.setSendBufferSize(ConfiguredSocketFactory.this.m_sendBufferSize);
                }
                if (0 < ConfiguredSocketFactory.this.m_receiveBufferSize) {
                    this.setReceiveBufferSize(ConfiguredSocketFactory.this.m_receiveBufferSize);
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }

        protected void postConnectConfig() throws IOException {
            try {
                this.setTcpNoDelay(ConfiguredSocketFactory.this.m_noDelay);
                this.setKeepAlive(ConfiguredSocketFactory.this.m_keepAlive);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }

        public void shutdownOutput() throws IOException {
            Object object = this.m_closeSync;
            synchronized (object) {
                if (this.m_closed) {
                    super.shutdownOutput();
                    return;
                }
            }
            Object object2 = this.m_outLock;
            synchronized (object2) {
                if (!this.m_outputShutdown) {
                    if (null != this.m_out) {
                        this.m_shuttingDownOutput = true;
                        this.m_out.flush();
                        this.m_out.close();
                        this.m_shuttingDownOutput = false;
                    }
                    this.m_outputShutdown = true;
                }
            }
            super.shutdownOutput();
        }

        private void interceptedOutputStreamClose(OutputStream out) throws IOException {
            Object object = this.m_outLock;
            synchronized (object) {
                if (!this.m_shuttingDownOutput) {
                    out.close();
                }
            }
        }

        public void close() throws IOException {
            if (null == this.m_closeSync) {
                super.close();
                return;
            }
            Object object = this.m_closeSync;
            synchronized (object) {
                if (this.m_closed) {
                    return;
                }
                this.m_closed = true;
            }
            Object object2 = this.m_outLock;
            synchronized (object2) {
                if (!this.m_outputShutdown && null != this.m_out) {
                    this.m_out.flush();
                    this.m_out.close();
                }
            }
            Object object3 = this.m_inLock;
            synchronized (object3) {
                if (null != this.m_in) {
                    this.m_in.close();
                }
            }
            super.close();
        }

        public OutputStream getOutputStream() throws IOException {
            OutputStream parent = super.getOutputStream();
            Object object = this.m_outLock;
            synchronized (object) {
                if (null != this.m_out) {
                    OutputStream outputStream = this.m_out;
                    return outputStream;
                }
                OutputStream outputStream = this.m_out = ConfiguredSocketFactory.this.m_streamDecorationStrategy.decorate((Socket)this, parent);
                return outputStream;
            }
        }

        public InputStream getInputStream() throws IOException {
            InputStream parent = super.getInputStream();
            Object object = this.m_inLock;
            synchronized (object) {
                if (null != this.m_in) {
                    InputStream inputStream = this.m_in;
                    return inputStream;
                }
                InputStream inputStream = this.m_in = ConfiguredSocketFactory.this.m_streamDecorationStrategy.decorate((Socket)this, parent);
                return inputStream;
            }
        }

        private final class CloseInterceptOutputStream
        extends OutputStream {
            private final OutputStream m_out;

            private CloseInterceptOutputStream(OutputStream out) {
                this.m_out = out;
            }

            public void write(int b) throws IOException {
                this.m_out.write(b);
            }

            public void write(byte[] buf) throws IOException {
                this.m_out.write(buf);
            }

            public void write(byte[] buf, int offset, int len) throws IOException {
                this.m_out.write(buf, offset, len);
            }

            public void flush() throws IOException {
                this.m_out.flush();
            }

            public void close() throws IOException {
                ConfiguredSocket.this.interceptedOutputStreamClose(this.m_out);
            }
        }
    }

    private final class ConfiguredServerSocket
    extends ServerSocket {
        private final Object m_optionSync = new byte[0];
        private final Object m_closeSync = new byte[0];
        private boolean m_closed;
        private int m_currentSocketTimeout;

        public ConfiguredServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
            super(port, backlog, bindAddress);
        }

        public Socket accept() throws IOException {
            this.assertNotClosed();
            ConfiguredSocket socket = new ConfiguredSocket();
            this.implAccept(socket);
            socket.postConnectConfig();
            return socket;
        }

        public void setSoTimeout(int timeout) throws SocketException {
            Object object = this.m_optionSync;
            synchronized (object) {
                int n = timeout = ConfiguredSocketFactory.this.m_minSocketTimeout < timeout && timeout < ConfiguredSocketFactory.this.m_maxSocketTimeout ? timeout : ConfiguredSocketFactory.this.m_overrideSocketTimeout;
                if (timeout == this.m_currentSocketTimeout) {
                    return;
                }
                super.setSoTimeout(timeout);
                this.m_currentSocketTimeout = timeout;
            }
        }

        public void close() throws IOException {
            super.close();
            if (null == this.m_closeSync) {
                this.m_closed = true;
                return;
            }
            Object object = this.m_closeSync;
            synchronized (object) {
                this.m_closed = true;
            }
        }

        private void assertNotClosed() throws SocketException {
            Object object = this.m_closeSync;
            synchronized (object) {
                if (this.m_closed) {
                    throw new SocketException("Socket is closed");
                }
            }
        }
    }
}

