/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.SystemException;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.net.SocketStreamDecorationStrategy;
import org.openorb.util.ConfigUtils;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.logger.LoggerTeam;

public final class LegacySocketStreamDecorationStrategy
implements SocketStreamDecorationStrategy {
    private static final Long TIMESTAMP = NumberCache.getLong((long)System.currentTimeMillis());
    private final LoggerTeam m_logger;
    private final Constructor m_inputStreamConstructor;
    private final Constructor m_outputStreamConstructor;

    private LegacySocketStreamDecorationStrategy(LoggerTeam logger, Constructor inputStreamConstructor, Constructor outputStreamConstructor) {
        this.m_logger = logger;
        this.m_inputStreamConstructor = inputStreamConstructor;
        this.m_outputStreamConstructor = outputStreamConstructor;
    }

    public InputStream decorate(Socket socket, InputStream stream) throws IOException {
        if (null == this.m_inputStreamConstructor) {
            return stream;
        }
        try {
            Object[] params = new Object[]{stream, TIMESTAMP, this.createSocketDescription(socket)};
            return (InputStream)this.m_inputStreamConstructor.newInstance(params);
        }
        catch (Exception e) {
            this.m_logger.warn("Couldn't create decorator for socket input stream", (Throwable)e);
            return stream;
        }
    }

    public OutputStream decorate(Socket socket, OutputStream stream) throws IOException {
        if (null == this.m_outputStreamConstructor) {
            return stream;
        }
        try {
            Object[] params = new Object[]{stream, TIMESTAMP, this.createSocketDescription(socket)};
            return (OutputStream)this.m_outputStreamConstructor.newInstance(params);
        }
        catch (Exception e) {
            this.m_logger.warn("Couldn't create decorator for socket output stream", (Throwable)e);
            return stream;
        }
    }

    private String createSocketDescription(Socket socket) {
        return "[" + socket.getLocalAddress().getHostName() + "].[" + socket.getLocalPort() + "]-[" + socket.getInetAddress().getHostName() + "].[" + socket.getPort() + "]";
    }

    public static final class Factory
    implements SocketStreamDecorationStrategy.Factory {
        private static final Class[] INPUT_PARAM_TYPES = new Class[]{class$java$io$InputStream == null ? (class$java$io$InputStream = Factory.class$("java.io.InputStream")) : class$java$io$InputStream, Long.TYPE, class$java$lang$String == null ? (class$java$lang$String = Factory.class$("java.lang.String")) : class$java$lang$String};
        private static final Class[] OUTPUT_PARAM_TYPES = new Class[]{class$java$io$OutputStream == null ? (class$java$io$OutputStream = Factory.class$("java.io.OutputStream")) : class$java$io$OutputStream, Long.TYPE, class$java$lang$String == null ? (class$java$lang$String = Factory.class$("java.lang.String")) : class$java$lang$String};
        static /* synthetic */ Class class$java$io$InputStream;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$io$OutputStream;

        public SocketStreamDecorationStrategy create(LoggerTeam logger, ORBLoader loader, String prefix) {
            String socketInputStreamClassName = ConfigUtils.prefixName((String)prefix, (String)"SocketInputStreamClass");
            String socketOutputStreamClassName = ConfigUtils.prefixName((String)prefix, (String)"SocketOutputStreamClass");
            String inputStreamClassName = loader.getStringProperty(socketInputStreamClassName, null);
            String outputStreamClassName = loader.getStringProperty(socketOutputStreamClassName, null);
            if ("".equals(inputStreamClassName)) {
                inputStreamClassName = null;
            }
            if ("".equals(outputStreamClassName)) {
                outputStreamClassName = null;
            }
            if (null == inputStreamClassName && null == outputStreamClassName) {
                return null;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            logger.warn("Using using deprecated legacy stream decorator");
            logger.warn("Using socket input stream : " + inputStreamClassName);
            logger.warn("Using socket output stream: " + outputStreamClassName);
            Constructor inputStreamConstructor = this.getConstructor(logger, classLoader, inputStreamClassName, INPUT_PARAM_TYPES);
            Constructor outputStreamConstructor = this.getConstructor(logger, classLoader, outputStreamClassName, OUTPUT_PARAM_TYPES);
            return new LegacySocketStreamDecorationStrategy(logger, inputStreamConstructor, outputStreamConstructor);
        }

        private Constructor getConstructor(LoggerTeam logger, ClassLoader loader, String className, Class[] paramTypes) {
            if (null == className) {
                return null;
            }
            try {
                Class<?> clazz = loader.loadClass(className);
                return clazz.getConstructor(paramTypes);
            }
            catch (ClassNotFoundException cause) {
                String msg = "Class [" + className + "] could not be found";
                logger.error(msg, (Throwable)cause);
                INITIALIZE e = new INITIALIZE(msg);
                ExceptionTool.initCause((SystemException)((Object)e), (Throwable)cause);
                throw e;
            }
            catch (NoSuchMethodException cause) {
                String msg = "Class [" + className + "] did not have required constructor";
                logger.error(msg, (Throwable)cause);
                INITIALIZE e = new INITIALIZE(msg);
                ExceptionTool.initCause((SystemException)((Object)e), (Throwable)cause);
                throw e;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

